#include "CRTSPClient.h"
#include "CRTSPEnv.h"
#include "rtspendpoint.h"

using namespace std;

   CRTSPClient::CRTSPClient(unsigned short ipmRxAudioPort, unsigned short ipmRxVideoPort, RTSPEndpoint* pRTSPEndpoint) {
      Reset();
      m_ipmRxVideoPort = ipmRxVideoPort;
      m_ipmRxAudioPort = ipmRxAudioPort;
      m_pRTSPEnv = CRTSPEnv::Instance();  
      m_pEnv = m_pRTSPEnv->GetEnv();
      m_ourClient = RTSPClient::createNew(*m_pEnv, 0, m_pRTSPEnv->GetAppName(), 0);
      m_pRTSPEndpoint = pRTSPEndpoint;
   }

   int CRTSPClient::Pause() {
      RTSPClient* rtspClient = (RTSPClient*)m_ourClient;
      if (rtspClient) {
        if (session) {
                rtspClient->pauseMediaSession (*session);
        }
      }
      return 0;
   }

   int CRTSPClient::Teardown() {
      RTSPClient* rtspClient = (RTSPClient*)m_ourClient;
      if (rtspClient) {
        if (session) {
		rtspClient->teardownMediaSession(*session);
        }
      }
      return 0;  
   }

   int CRTSPClient::CreateRTSPSession(const char* url, bool startPlayAlso) {
      m_state = RTSP_INIT;

      m_url.assign(url);
      if ( RTSPClient::parseRTSPURL (*m_pEnv, m_url.c_str(), m_unRtspAddress, m_rtspPortNum, &m_urlSuffix) == False) 
      {
         *m_pEnv << "Invalid URL\n";
         return -1;
      }
  
      unsigned x = *((unsigned*)m_unRtspAddress.data());
      char temp[16];
      sprintf(temp, "%d.%d.%d.%d", x & 0xff, (x>>8)& 0xff, (x>>16) & 0xff, (x>>24) & 0xff);
      m_RTSPAddr.assign(temp);

      char* optionsResponse = SendOptionsCmdAndGetResponse(m_url.c_str());
      if (optionsResponse == NULL) {
         *m_pEnv << "NULL options response \n";
         return -1;
      }
      else
         delete [] optionsResponse;

      char* sdpDescription = getSDPDescriptionFromURL(m_url.c_str());
      if (sdpDescription == NULL) {
         // *m_pEnv << "NULL sdp description response \n";
         return -1;
      }
      m_state = RTSP_OPTIONS_SENT_RCVD;

      session = MediaSession::createNew(*m_pEnv, sdpDescription);
      delete[] sdpDescription;

      if (session == NULL) {
          *m_pEnv << "Failed to create a MediaSession object from the SDP description: " << m_pEnv->getResultMsg() << "\n";
          return -1;
      } else if (!session->hasSubsessions()) {
          *m_pEnv << "This session has no media subsessions (i.e., \"m=\" lines)\n";
          return -1;
      }

      // Then, setup the "RTPSource"s for the session:
      MediaSubsessionIterator iter(*session);
      MediaSubsession *subsession;
      while ((subsession = iter.next()) != NULL) {
         if (strstr(subsession->mediumName(), "audio") || strstr(subsession->mediumName(), "AUDIO"))
            subsession->setClientPortNum(m_ipmRxAudioPort);
         if (strstr(subsession->mediumName(), "video") || strstr(subsession->mediumName(), "VIDEO"))
            subsession->setClientPortNum(m_ipmRxVideoPort);
      }

      // Now, send the SETUPs
      iter.reset(); // go to head 
      while ((subsession = iter.next()) != NULL) {
#if PRINT_RTSP_OUTPUT
         *m_pEnv << "Subsession name: " << subsession->mediumName() << "\n";
#endif
         if (subsession->clientPortNum() == 0) continue; // port # was not set

         if (!((RTSPClient*)m_ourClient)->setupMediaSubsession(*subsession,
                                          False, False)) {
            *m_pEnv << "Failed to setup \"" << subsession->mediumName()
		<< "/" << subsession->codecName()
		<< "\" subsession: " << m_pEnv->getResultMsg() << "\n";
	 } else {
#if PRINT_RTSP_OUTPUT
            *m_pEnv << "Setup \"" << subsession->mediumName()
		<< "/" << subsession->codecName()
		<< "\" subsession (client ports " << subsession->clientPortNum()
		<< "-" << subsession->clientPortNum()+1 << ")\n";
#endif
	    if (strstr(subsession->mediumName(), "audio") || strstr(subsession->mediumName(), "AUDIO"))
	    {
               m_rtspServerAudioPort = subsession->serverPortNum; 
	       m_audioPayloadType = subsession->rtpPayloadFormat();
	       m_audioCodecName.assign( subsession->codecName());
               m_pAudSubSession = subsession;

               struct sockaddr_in serverAddr;
               serverAddr.sin_addr.s_addr =m_pAudSubSession->connectionEndpointAddress ();
               if (serverAddr.sin_addr.s_addr)
                  m_RTSPAudioIP.assign(inet_ntoa(serverAddr.sin_addr));
               else {
                  m_RTSPAudioIP.assign(m_RTSPAddr);
               }
	    }
	    if (strstr(subsession->mediumName(), "video") || strstr(subsession->mediumName(), "VIDEO"))
	    {
               m_rtspServerVideoPort = subsession->serverPortNum; 
	       m_videoPayloadType = subsession->rtpPayloadFormat(); 
	       m_videoCodecName.assign(subsession->codecName());
               m_pVidSubSession = subsession;
               struct sockaddr_in serverAddr;
               serverAddr.sin_addr.s_addr =m_pVidSubSession->connectionEndpointAddress ();
               if (serverAddr.sin_addr.s_addr)
                  m_RTSPVideoIP.assign(inet_ntoa(serverAddr.sin_addr));
	       else {
                  m_RTSPVideoIP.assign(m_RTSPAddr);
               }

	    }
	 }
      }
     
      if (m_pVidSubSession == NULL || m_pAudSubSession == NULL) {
         return -1;
      } 

      if (startPlayAlso) {
         printf("not playing yet\n");
         Play();
      }
      return 0;
   }

   int CRTSPClient::Play() {
      double startTime = 0.0;
      double endTime = m_pVidSubSession->playEndTime();
      double scale = 1.0;


      if (m_ourClient == NULL || session == NULL) return False;
      RTSPClient* rtspClient = (RTSPClient*)m_ourClient;
      rtspClient->playMediaSession(*session, (float)startTime, (float)endTime, (float)scale);
      // armDroppedConnection(endTime); Does not work yet
      return 0;
   }

   const char* CRTSPClient::decoder_config_info() {
     return m_pVidSubSession->fmtp_config();
   }

   void CRTSPClient::SessionTerminated() {
      m_pRTSPEndpoint->StopMedia();
   }

   void CRTSPClient::armDroppedConnection(double timer) {
      m_pRTSPEnv->armDroppedConnection(timer, this);
   }

   void CRTSPClient::armKeepAlive() {
      int secondsToDelay = 19;
      int uSecsToDelay = (int)(secondsToDelay*1000000.0);
      m_pEnv->taskScheduler().scheduleDelayedTask(uSecsToDelay, keepAliveHandler, this);
   }

   void CRTSPClient::SendKeepAlive() {
      printf("keep alive fcn fired\n");
      int secondsToDelay = 19;
      int uSecsToDelay = (int)(secondsToDelay*1000000.0);
      m_pEnv->taskScheduler().scheduleDelayedTask(uSecsToDelay, keepAliveHandler, this);

   }

   void CRTSPClient::timeoutHandler(void * clientData) {
      CRTSPClient* pRTSPClient = (CRTSPClient*)clientData;
      pRTSPClient->SendKeepAlive();
      printf("timer done.\n");
   }

   void CRTSPClient::keepAliveHandler(void * clientData) {
      CRTSPClient* pRTSPClient = (CRTSPClient*)clientData;
      printf("keep alive timer fired for %p.\n", pRTSPClient);
   }

   int CRTSPClient::Reset() {
      m_audioPayloadType = -1;
      m_videoPayloadType = -1;
      m_rtspServerAudioPort = 65535;
      m_rtspServerVideoPort = 65535;
      m_videoCodecName.assign("") ;
      m_audioCodecName.assign("") ;
      m_duration = 0;
      m_durationSlop = -1.0; // extra seconds to play at the end
      m_initialSeekTime = 0.0f;
      m_scale = 1.0f;
      m_pAudSubSession = NULL;
      m_pVidSubSession = NULL;
      return 0;
   }
   int CRTSPClient::PrintSDP() {
      *m_pEnv << m_pAudSubSession->savedSDPLines() << "\n";
      *m_pEnv << m_pVidSubSession->savedSDPLines() << "\n";
      return 0;
   }

   int CRTSPClient::PrintAudioSessionInfo() {
      struct timeval t = {0};
      
      *m_pEnv << "------\n";
      *m_pEnv << " clientPortNum: " << m_pAudSubSession->clientPortNum() << "\n";     
      *m_pEnv << " rtpPayloadFormat: " << m_pAudSubSession->rtpPayloadFormat () << "\n";     
      *m_pEnv << " mediumName: " << m_pAudSubSession->mediumName () << "\n";     
      *m_pEnv << " codecName : " << m_pAudSubSession->codecName  () << "\n";     
      *m_pEnv << " protocolName  : " << m_pAudSubSession->protocolName () << "\n";     
      *m_pEnv << " controlPath: " << m_pAudSubSession->controlPath () << "\n";     
      *m_pEnv << " fmtp_objecttype : " << m_pAudSubSession->fmtp_objecttype  () << "\n";     
      *m_pEnv << " fmtp_octetalign : " << m_pAudSubSession->fmtp_octetalign  () << "\n";     
      *m_pEnv << " fmtp_robustsorting : " << m_pAudSubSession->fmtp_robustsorting () << "\n";     
      *m_pEnv << " playStartTime : " << m_pAudSubSession->playStartTime () << "\n";
      *m_pEnv << " playEndTime : " << m_pAudSubSession->playEndTime () << "\n";
      *m_pEnv << " getNormalPlayTime : " << m_pAudSubSession->getNormalPlayTime (t) << "\n";
      printf("%u sec, %u micro seconds\n", (unsigned int)t.tv_sec, (unsigned)t.tv_usec);
      *m_pEnv << "------\n";
      return 0;
   }

   int CRTSPClient::PrintVideoSessionInfo() {
      struct timeval t = {0};
      *m_pEnv << "------\n";
      *m_pEnv << " clientPortNum: " << m_pVidSubSession->clientPortNum() << "\n";     
      *m_pEnv << " rtpPayloadFormat: " << m_pVidSubSession->rtpPayloadFormat () << "\n";     
      *m_pEnv << " mediumName: " << m_pVidSubSession->mediumName () << "\n";     
      *m_pEnv << " codecName : " << m_pVidSubSession->codecName  () << "\n";     
      *m_pEnv << " fmtp_objecttype : " << m_pVidSubSession->fmtp_objecttype  () << "\n";     
      *m_pEnv << " protocolName  : " << m_pVidSubSession->protocolName () << "\n";     
      *m_pEnv << " controlPath: " << m_pVidSubSession->controlPath () << "\n";     
      *m_pEnv << " videoWidth: " << m_pVidSubSession->videoWidth () << "\n";     
      *m_pEnv << " videoHeight: " << m_pVidSubSession->videoHeight () << "\n";     
      *m_pEnv << " videoFPS: " << m_pVidSubSession->videoFPS () << "\n";     
      *m_pEnv << " fmtp_profile_level_id: " << m_pVidSubSession->fmtp_profile_level_id() << "\n";
      *m_pEnv << " fmtp_sizelength: " << m_pVidSubSession->fmtp_sizelength() << "\n";
      *m_pEnv << " fmtp_streamtype: " << m_pVidSubSession->fmtp_streamtype() << "\n";
      *m_pEnv << " fmtp_config: " << m_pVidSubSession->fmtp_config() << "\n";
      *m_pEnv << " fmtp_mode: " << m_pVidSubSession->fmtp_mode() << "\n";
      *m_pEnv << " fmtp_spropparametersets: " << m_pVidSubSession->fmtp_spropparametersets() << "\n";
      *m_pEnv << " playStartTime : " << m_pVidSubSession->playStartTime () << "\n";
      *m_pEnv << " playEndTime : " << m_pVidSubSession->playEndTime () << "\n";
      *m_pEnv << " getNormalPlayTime : " << m_pVidSubSession->getNormalPlayTime (t) << "\n";
      printf("%u sec, %u micro seconds\n", (unsigned int)t.tv_sec, (unsigned)t.tv_usec);
      *m_pEnv << "------\n";

      return 0;
   }

   
   int CRTSPClient::GetAudioPayloadType() { return m_audioPayloadType; }
   int CRTSPClient::GetVideoPayloadType() { return m_videoPayloadType; }
   const char* CRTSPClient::GetAudioCodecName() { return m_audioCodecName.c_str(); }
   const char* CRTSPClient::GetVideoCodecName() { return m_videoCodecName.c_str(); }
   unsigned short CRTSPClient::GetRTSPAudioPort() { return m_rtspServerAudioPort; }
   unsigned short CRTSPClient::GetRTSPVideoPort() { return m_rtspServerVideoPort; }
   const char* CRTSPClient::GetRTSPAudioIP() { return m_RTSPAudioIP.c_str(); }
   const char* CRTSPClient::GetRTSPVideoIP() { return m_RTSPVideoIP.c_str(); }
   unsigned CRTSPClient::GetRTSPVideoProfile() {
      return m_pVidSubSession->fmtp_profile_level_id();
   }
   int CRTSPClient::socketNum() {
     return ((RTSPClient*)m_ourClient)->socketNum();
   }

   char* CRTSPClient::SendOptionsCmdAndGetResponse(const char* url) {
      RTSPClient* rtspClient = (RTSPClient*)m_ourClient;
      return rtspClient->sendOptionsCmd(url, NULL, NULL);
   }

   char* CRTSPClient::getSDPDescriptionFromURL(const char* url, char const* username , char const* password ,
                               char const* proxyServerName ,
                               unsigned short proxyServerPortNum ,
                               unsigned short clientStartPort ) 
   {
      RTSPClient* rtspClient = (RTSPClient*)m_ourClient;
      char* result;
      if (username != NULL && password != NULL) {
	      result = rtspClient->describeWithPassword(url, username, password);
      } else {
	      result = rtspClient->describeURL(url);
      }

      unsigned statusCode;
      statusCode = rtspClient->describeStatus();
      return result;
   }
