/**
* @file bridgedcall.h
* @brief Declaration of BridgedCall class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BRIDGEDCALL_H
#define  _BRIDGEDCALL_H

#include "defines.h"
#include "locker.h"
#include "bridgedcallopening_state.h"
#include "bridgedcallidle_state.h"
#include "bridgedcallconnecting_state.h"
#include "bridgedcallconnected_state.h"
#include "bridgedcalldisconnecting_state.h"


//*****************************************************************************
// Class: ::BridgedCall
// Description: Class to cordinate activities of a SIP endpoint and a M3G endpoint
//*****************************************************************************
class BridgedCall
{
public:
   BridgedCall(int index, int m3gIndex, int sipIndex);
   ~BridgedCall();

   BridgedCallState::E_BRIDGEDCALLSTATE GetState();
   char *GetStateString();
   void ChangeState(BridgedCallState::E_BRIDGEDCALLSTATE eNewCallState);
   void SetLastMessageString(const char *pMessageStr);
   int Index() { return m_Index;}
   int M3gIndex() { return m_m3gIndex;}
   int SipIndex() { return m_sipIndex;}
   void ProcessEvent(METAEVENT metaevent);
   void Open();

private:
   //BridgedCall::BridgedCall();
   BridgedCall();
   char                          m_StateBuffer[MAX_STATE_STRING];
   char                          m_CurrentStateStr[MAX_CURRENT_STATE_STR];
   BridgedCallOpeningState       *m_pBridgeCallOpeningState;
   BridgedCallIdleState          *m_pBridgedCallIdleState;
   BridgedCallConnectingState    *m_pBridgedCallConnectingState;
   BridgedCallConnectedState     *m_pBridgeCallConnectedState;
   BridgedCallDisconnectingState *m_pBridgedCallDisconnectingState;
   BridgedCallState              *m_pCurrentState;
   CLocker                       m_StateLock;
   char                          m_LastMessageBuff[MAX_LAST_MSG_STRING];
   int                           m_Index;
   int                           m_m3gIndex;
   int 				 m_sipIndex;
};

#endif

