/**
* @file bridgedhairp.h
* @brief Declaration of BridgedHairp class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BRIDGEDHAIRP_H
#define  _BRIDGEDHAIRP_H

#include "defines.h"
#include "locker.h"
#include "bridgedhairpopening_state.h"
#include "bridgedhairpidle_state.h"
#include "bridgedhairpconnecting_state.h"
#include "bridgedhairpconnected_state.h"
#include "bridgedhairpdisconnecting_state.h"


//*****************************************************************************
// Class: ::BridgedHairp
// Description: Class to cordinate activities of 2 M3G endpoints
//*****************************************************************************
class BridgedHairp
{
public:
   static const int BRG_CALL_IDX_NOT_SET;   // -1;

   BridgedHairp(int index, int m3gIndex1, int m3gIndex2);
   ~BridgedHairp();

   BridgedHairpState::E_BRIDGEDHAIRPSTATE GetState();
   char *GetStateString();
   void ChangeState(BridgedHairpState::E_BRIDGEDHAIRPSTATE eNewCallState);
   void SetLastMessageString(const char *pMessageStr);
   int Index() { return m_Index;}
   int M3gIndex1() { return m_m3gIndex1;}
   int M3gIndex2() { return m_m3gIndex2;}
   int CallerIndex() { return m_CallerIndex;}
   int CalleeIndex() { return m_CalleeIndex;}
   void SetCallRoles(int connenctionIndex);
   void ClearCallerIndex() {m_CallerIndex = BRG_CALL_IDX_NOT_SET;}
   void ClearCalleeIndex() {m_CalleeIndex = BRG_CALL_IDX_NOT_SET;}
   bool IsHairPinDisconnected() 
        {return ((BRG_CALL_IDX_NOT_SET == m_CallerIndex) && 
                 (BRG_CALL_IDX_NOT_SET == m_CalleeIndex));}

   bool isIndex1(int index) { return (index == m_m3gIndex1);}
   bool isIndex2(int index) { return (index == m_m3gIndex2);}
   void ProcessEvent(METAEVENT metaevent);
   void Open();

private:
   //BridgedHairp::BridgedHairp();
   BridgedHairp();
   char                          m_StateBuffer[MAX_STATE_STRING];
   char                          m_CurrentStateStr[MAX_CURRENT_STATE_STR];
   BridgedHairpOpeningState       *m_pBridgeCallOpeningState;
   BridgedHairpIdleState          *m_pBridgedHairpIdleState;
   BridgedHairpConnectingState    *m_pBridgedHairpConnectingState;
   BridgedHairpConnectedState     *m_pBridgeCallConnectedState;
   BridgedHairpDisconnectingState *m_pBridgedHairpDisconnectingState;
   BridgedHairpState              *m_pCurrentState;
   CLocker                       m_StateLock;
   char                          m_LastMessageBuff[MAX_LAST_MSG_STRING];
   int                           m_Index;
   int                           m_m3gIndex1;
   int                           m_m3gIndex2;
   int                           m_CallerIndex;
   int                           m_CalleeIndex;
   unsigned short                m_endpointConnectCnt;
   unsigned short                m_endpointDisconnectCnt;
};

#endif

