/**
* @file bridgedhairpconnected_state.h
* @brief Declaration of BridgedHairpConnectedState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BRIDGEDHAIRPCONNECTED_STATE_H
#define  _BRIDGEDHAIRPCONNECTED_STATE_H

#include "bridgedhairpstate.h"


//*****************************************************************************
// Class: ::BridgedHairpConnectedState
// Description:  This BridgedHairpState subclass is for when a BridgedHairp
//               object is connected and waiting for a disconnect.
//*****************************************************************************
class BridgedHairpConnectedState : public BridgedHairpState
{
public:
   BridgedHairpConnectedState(BridgedHairp* pBridgedHairp);
   virtual ~BridgedHairpConnectedState();
   const char *GetStateStr() { return "CONNECTED      ";}
   E_BRIDGEDHAIRPSTATE GetState() { return CONNECTED_STATE;}
   void ProcessEvent(METAEVENT metaevent);

private:
   void ProcessDisconnect(METAEVENT metaevent);
   void ProcessStartOutbound(METAEVENT metaevent);

};

#endif






