/**
* @file bridgedmediastate.h
* @brief Declaration of BridgedMediaState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BRIDGEDMEDIASTATE_H
#define  _BRIDGEDMEDIASTATE_H

#include "gclib.h"
#include "statusbitmask.h"

class BridgedMedia;

//*****************************************************************************
// Class: ::BridgedMediaState
// Description: Abstract state class for BridgedMedia objects
//*****************************************************************************
class BridgedMediaState : public StatusBitmask
{
public:
   typedef enum
   {
      OPENING_STATE,
      IDLE_STATE,
      PLAYING_STATE,
      RECORDING_STATE,
      NUM_BRIDGEDMEDIA_STATES
   }  E_BRIDGEDMEDIASTATE;

   BridgedMediaState(BridgedMedia* pBridgedMedia);
   virtual ~BridgedMediaState();
   virtual E_BRIDGEDMEDIASTATE GetState() = 0;
   virtual void ProcessEvent(METAEVENT metaevent) = 0;

protected:
   BridgedMedia *m_pBridgedMedia;
};

#endif



