/**
* @file bridgedrtspopening_state.h
* @brief Declaration of BridgedRtspOpeningState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _BRIDGEDRTSPOPENING_STATE_H
#define  _BRIDGEDRTSPOPENING_STATE_H

#include "bridgedrtspstate.h"


//*****************************************************************************
// Class: ::BridgedRtspOpeningState
// Description: This BridgedRtspState subclass handles the opening of 
//              BridgedRtsp objects
//*****************************************************************************
class BridgedRtspOpeningState : public BridgedRtspState
{
public:
   BridgedRtspOpeningState(BridgedRtsp* pBridgedRtsp);
   virtual ~BridgedRtspOpeningState();
   const char *GetStateStr() { return "OPENING        ";}
   E_BRIDGEDRTSPSTATE GetState() { return OPENING_STATE;}
   void ProcessEvent(METAEVENT metaevent);

private:
   static const int RTSP_OPENED;
   static const int M3G_OPENED;
   static const int RTSP_CONNECTED;
   static const int M3G_CONNECTED;
   static const int BOTH_OPENED;
   static const int BOTH_CONNECTED;

   bool IsBridgedRtspOpened() { return (BOTH_OPENED == (BOTH_OPENED & m_StatusBitmask));}
   bool IsBridgedRtspConnected() { return (BOTH_CONNECTED == (BOTH_CONNECTED & m_StatusBitmask));}
   void ProcessEndpointOpened(METAEVENT metaevent);
   void ProcessEndpointConnected(METAEVENT metaevent);
};

#endif



