/**
* @file closinglcs_state.h
* @brief Declaration of ClosingLCsState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _CLOSINGLCS_STATE_H
#define  _CLOSINGLCS_STATE_H

#include "epstate.h"



//*****************************************************************************
// Class: ::ClosingLCsState
// Description: This EPState subclass initiates the sending and processing of
//              incoming CloseLogicalChannels and ChannelCloseRequests
//*****************************************************************************
class ClosingLCsState : public EPState
{
public:
   ClosingLCsState(Endpoint* pEndpoint);
   virtual ~ClosingLCsState();
   virtual void ProcessEvent(long  evtType, void *pEvtData, long  evtLen, long  evtDev);
   virtual void ProcessUserPrompt(EPState::E_USER_PROMPT_TYPE eUserPrompt);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "CLOSING_LCS    ";}
   virtual E_EPSTATE GetState() { return CLOSING_LCS_STATE;}

private:
   static const int AUDIO_TX_LCN_CLOSED;   // 0x01
   static const int AUDIO_RX_LCN_CLOSED;   // 0x02
   static const int VIDEO_TX_LCN_CLOSED;   // 0x04
   static const int VIDEO_RX_LCN_CLOSED;   // 0x08
   static const int H245_STOPPING;         // 0x10
   static const int TX_LCNS_CLOSED;        // 0x05

   void CheckAllLCNsClosed();
   void StopH245();
   void H245Terminated();
   void ProcessResetComplete();
};

#endif


