/**
* @file config.h
* @brief Declaration of DemoConfig class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _CONFIG_H
#define  _CONFIG_H

#include <string>

using namespace std;

const int MAX_ENDPOINTS = 20;
const int MAX_FILE_NAME = 50;
const int LINE_BUFFER_SIZE = 256;
const int TOKEN_SIZE = 20;
const int SIP_ADDR_SIZE = 32;
const int MAX_PARAMETERS = 9;


unsigned char AsciiOctetToHex(const char* pOctet);
void Capitalize(string& str);
void Capitalize(char *c_str);


class EndpointMngr;

//*****************************************************************************
// Class: ::DemoConfig
// Description: Configures demo parameters as defined in the specified input 
//              configuration file
//*****************************************************************************
class DemoConfig
{
public:
   DemoConfig();
   ~DemoConfig();
   int SetConfigFile(const char* fileName);
   int SetLogFile(const char* fileName);
   void SetLoggingEnabled(bool enabled) { m_LoggingEnabled = enabled;}
   bool GetLoggingEnabled() { return m_LoggingEnabled;}
   void SetSipInfoDtmfEnabled(bool enabled) { m_SipInfoDtmfEnabled = enabled;}
   bool GetSipInfoDtmfEnabled() { return m_SipInfoDtmfEnabled;}
   const char* GetConfigFile() { return m_ConfigFile;}
   const char* GetLogFile() 
   {
      return (true == GetLoggingEnabled()) ? m_LogFile : NULL;
   }
   int ParseConfigFile();

private:
   int ParseLine(string& lineStr);
   int ParseLogging(istringstream& istrLine);
   int ParseMode(istringstream& istrLine);
   int ParseEP(istringstream& istrLine);
   int ParseParms(istringstream& istrLine);
   int ParseEvents(istringstream& istrLine, bool isEnableEv = false);
   int ParseH223Defaults(istringstream& istrLine);
   int ParseH223Caps(istringstream& istrLine);
   int ParseMediaCaps(istringstream& istrLine);
   int ParseH223OLCParms(istringstream& istrLine);
   int ParseH264Parms(istringstream& istrLine);
   int ParseEPTracing(istringstream& istrLine);
   int ParseLogRotate(istringstream& istrLine);
   int ParseBrdTracing(istringstream& istrLine);
   int ParseDCI(istringstream& istrLine);
   int ParseVendorId(istringstream& istrLine);
   int ParseSIPInfoDTMF(istringstream& istrLine);
   int ParseAudTranscode(istringstream& istrLine);
   int ParseVidTranscode(istringstream& istrLine);
   int ParseSIPVideo(istringstream& istrLine);
   int ParseSIPAudio(istringstream& istrLine);
   int ParseSIPInfo(istringstream& istrLine);
   int ParseCmdInfo(istringstream& istrLine);
   int ParseMMInfo(istringstream& istrLine);
   int ParseNbUPInfo(istringstream& istrLine);
   int ParseRTSPInfo(string& lineStr);

   char  m_ConfigFile[MAX_FILE_NAME];
   char  m_LogFile[MAX_FILE_NAME];
   bool  m_LoggingEnabled;
   bool  m_SipInfoDtmfEnabled;
};

#endif


