/**
* @file defines.h
* @brief Global application definitions
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/
#ifndef DEFINES_H
#define DEFINES_H

#define DEV_NAME_SIZE         20
#define MAX_MEDIA_STR         6
#define MAX_STATE_STRING      256
#define MAX_CURRENT_STATE_STR 40
#define MAX_LAST_MSG_STRING   128
#define MAX_TRACE_FILE_NAME   64

typedef enum
{
   AUD_CODER_NONE,
   AUD_CODER_AMR,
   AUD_CODER_G723,
   AUD_CODER_G711U,
   AUD_CODER_G711A,
   AUD_CODER_G729,
   AUD_CODER_PCM,
   AUD_CODER_LAST
} E_SEL_AUD_CODER;

typedef enum
{
   VID_CODER_NONE,
   VID_CODER_H263,
   VID_CODER_MPEG4,
   VID_CODER_H263_1998,
   VID_CODER_H264,
   VID_CODER_LAST 
} E_SEL_VID_CODER;

typedef enum
{
   VID_RES_NONE,
   VID_RES_SQCIF,
   VID_RES_QCIF,
   VID_RES_CIF,
   VID_RES_LAST 
} E_SEL_VID_RES;


typedef enum
{
   MM_FILE_TYPE_DMF,
   MM_FILE_TYPE_3GP,
   MM_FILE_TYPE_LAST 
} E_SEL_MM_FILE_TYPE;

#endif
