/**
* @file h245inactive_state.h
* @brief Declaration of H245InactiveState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _H245INACTIVE_STATE_H
#define  _H245INACTIVE_STATE_H


#include "epstate.h"

//*****************************************************************************
// Class: ::H245InactiveState
// Description: This EPState subclass sits idle after the timeslot and media 
//              ports are connected pending to either initiate the H.223 and 
//              H.245 layers
//*****************************************************************************
class H245InactiveState : public EPState
{
public:
   H245InactiveState(Endpoint* pEndpoint);
   ~H245InactiveState();
   virtual void ProcessEvent(long  evtType, void *pEvtData, long  evtLen, long  evtDev);
   virtual void ProcessUserPrompt(EPState::E_USER_PROMPT_TYPE eUserPrompt);
   virtual void Shutdown();
   virtual const char *GetStateStr() { return "H245_INACTIVE  ";}
   virtual E_EPSTATE GetState() { return H245_INACTIVE_STATE;}

 private:
   void ProcessResetComplete();
   void ProcessPortDisconnect(int evtDev);
   
   int m_PortDiscState;

   static const int AUDIO_PORT_DISCONNECTED;
   static const int VIDEO_PORT_DISCONNECTED;

};

#endif


