/**
*
* DIALOGIC CONFIDENTIAL
* Copyright � 2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "isdnalarm_state.h"
#include "isdnendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

// Temp here
#include "appevents.h"



//*****************************************************************************
// Function: ISDNAlarmState::ISDNAlarmState(ISDNEndpoint *pISDNEndpoint)
// Description: Initializing constructor
// Return:  ISDNAlarmState*
// Parameters: ISDNEndpoint *pISDNEndpoint 
//*****************************************************************************
ISDNAlarmState::ISDNAlarmState(ISDNEndpoint* pISDNEndpoint) :
   ISDNEPState(pISDNEndpoint)
{
}


//*****************************************************************************
// Function: ISDNAlarmState::~ISDNAlarmState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
ISDNAlarmState::~ISDNAlarmState()
{
}

//*****************************************************************************
// Function: bool ISDNAlarmState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: bool 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void ISDNAlarmState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      case GCEV_UNBLOCKED:
         LOG_ENTRY(metaevent.evtdev, "ISDNAlarm state: GCEV_UNBLOCKED received\n");
         if (m_pISDNEndpoint->ResetLineDev() != true)
         {
	   
         }
         break;
      case GCEV_RESETLINEDEV:
          LOG_ENTRY(metaevent.evtdev, "ISDNAlarm state: GCEV_RESETLINEDEV received\n");    	  
          m_pISDNEndpoint->WaitCall();
          m_pISDNEndpoint->ChangeState(WAITCALL_STATE);    	  
    	 break;
      default:
         LOG_ERROR(metaevent.evtdev,"ISDNAlarm state: Unexpected event type:%d\n",metaevent.evttype);
         break;
   }
   return;
}


//*****************************************************************************
// Function: void ISDNAlarmState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void ISDNAlarmState::Shutdown()
{
  LOG_ENTRY(m_pISDNEndpoint->GetGCISDNHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
  //m_pISDNEndpoint->CloseSubDevs();
}


