/**
* @file mmendpoint.h
* @brief Declaration of SIPEndpoint class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _MMENDPOINT_H
#define  _MMENDPOINT_H

#include "port_connect.h"

// Device management and Multimedia include files
#include <devmgmt.h>
#include <mmlib.h>
#include <mmevts.h>
#include "baseendpoint.h"
#include "mmepstate.h"

#include "mmopening_state.h"
#include "mmportconnecting_state.h"
#include "mmidle_state.h"
#include "mmplaying_state.h"
#include "mmrecording_state.h"

#include <time.h>
#include "locker.h"
#include "port_connect.h"


// Info to be passed through to dev_PortConnect completion events
//#define IPM_AUDIO_PORTCONNECT  0
//#define IPM_VIDEO_PORTCONNECT  1


class Endpoint;

//*****************************************************************************
// Class: ::MMEndpoint
// Description: This is the MM endpoint class
//*****************************************************************************
class MMEndpoint : public BaseEndpoint
{
public:
   MMEndpoint(int numEP, const char *MMName, const char *mapID);
   ~MMEndpoint();

   void Shutdown();  

   void ProcessEvent(METAEVENT metavent);
   char *GetStateString();
   void OpenSubDevs();
   void ReserveResources();
   void ReleaseResources();
   void LogGlobalCallError();
   void CloseSubDevs();
   SRL_DEVICE_HANDLE GetMMHandle() { return m_MMHandle;}

   // Port connect related  
   void SetRxPortInfoList(DM_PORT_INFO_LIST *pRxPortInfoList) { m_RxPortList = *pRxPortInfoList;}
   void SetTxPortInfoList(DM_PORT_INFO_LIST *pTxPortInfoList) { m_TxPortList = *pTxPortInfoList;}

   // Get first element of Tx and Rx lists.
   // Not sure if this is needed for IPM
   //DM_PORT_INFO& GetRxPortInfo() { return m_RxPortList.port_info[0];}
   //DM_PORT_INFO& GetTxPortInfo() { return m_TxPortList.port_info[0];}

   DM_PORT_INFO& GetAudioRxPortInfo() { return m_audioPortRxInfo;}
   DM_PORT_INFO& GetAudioTxPortInfo() { return m_audioPortTxInfo;}
   DM_PORT_INFO& GetVideoRxPortInfo() { return m_videoPortRxInfo;}
   DM_PORT_INFO& GetVideoTxPortInfo() { return m_videoPortTxInfo;}

   void ConnectToPeer(DM_PORT_INFO& a_audioPortRxInfo, 
                      DM_PORT_INFO& a_videoPortRxInfo); 
   void DisconnectFromPeer();
   void ChangeState(MMEPState::E_MMEPSTATE e_NewState);
   void SetLastMessageString(const char *pMessageStr);
   void LogDevError();
   void RecordPortInfoList(METAEVENT metaevent, DM_PORT_INFO_LIST* pPortInfoList);
   void GetMMPortInfo();
   void PlayVideoFile(const char m_mmPlayAudioFileName[128], const char m_mmPlayVideoFileName[128]);

   void RecordVideoFile();
   void StopMMPlay();
   void StopMMRecord();
   char *MapIP() { return m_mapID;}
   int GetIndex() { return m_Index;}
   void ProcessH245UII(char UII);

   void SetVideoToH263();
   void SetVideoToMPEG4();
   void SetVideoToH264();
   void SetAudioToAMR();
   void SetAudioToPCM();
   
   void SetLastDigitRcvd(char dtmf) {m_LastDigitRcvd = dtmf;}
   char  GetLastDigitRcvd() {return m_LastDigitRcvd;}
   void SetCoderSelection();
   
   //JM - DCI
   void SetRecDCIStr(char *pDciStr)
   {
      strcpy(m_RecDciStr, pDciStr);
   }
   char *GetRecDCIStr()
   {
      return m_RecDciStr;
   }
   void SetRecDCILen(unsigned char DciLen) {m_RecDciLen=DciLen;}
   unsigned char GetRecDCILen() {return m_RecDciLen;}
private:

   int                        m_Index;
   time_t                     m_ConnectionTime;
   MMOpeningState             *m_pMMOpeningState;
   MMPortConnectingState      *m_pMMPortConnectingState;
   MMIdleState                *m_pMMIdleState;
   MMPlayingState             *m_pMMPlayingState;
   MMRecordingState           *m_pMMRecordingState;
   MMEPState                  *m_pCurrentState;
   char                       m_MMName[DEV_NAME_SIZE];
   char                       m_mapID[DEV_NAME_SIZE];

   SRL_DEVICE_HANDLE          m_MMHandle;
   char                       m_StateBuffer[MAX_STATE_STRING];
   char                       m_LastMessageBuff[MAX_LAST_MSG_STRING];
   DEV_RESOURCE_LIST          m_resourceList;

   // Port connect related
   // Ptrs to PORT_INFO_LISTs returned
   DM_PORT_INFO_LIST          m_RxPortList;
   DM_PORT_INFO_LIST          m_TxPortList;

   // PORT_INFO structs themselves
   DM_PORT_INFO               m_audioPortTxInfo;
   DM_PORT_INFO               m_audioPortRxInfo;
   DM_PORT_INFO               m_videoPortTxInfo;
   DM_PORT_INFO               m_videoPortRxInfo;

   void ProcessRxPortInfo(METAEVENT metaevent);
   void ProcessTxPortInfo(METAEVENT metaevent);
   void ProcessPortConnect(METAEVENT metaevent);

   unsigned short GetMMPortConnectCompletionCnt() { return m_MMPortConnectCompletionCnt;};
   void ZeroMMPortConnectCompletionCnt() { m_MMPortConnectCompletionCnt = 0;};
   void IncrementMMPortConnectCompletionCnt() { m_MMPortConnectCompletionCnt++;};
  
  unsigned short m_MMPortConnectCompletionCnt;

  char                       m_CurrentStateStr[MAX_CURRENT_STATE_STR];
  CLocker                    m_StateLock;

  eVIDEO_FRAMESPERSEC		m_VideoCoderFPS;
  eVIDEO_IMAGE_HEIGHT		m_VideoCoderImageHeight;
  eVIDEO_IMAGE_WIDTH 		m_VideoCoderImageWidth;
  eVIDEO_CODING			m_VideoCoderCoding;
  eVIDEO_LEVEL			m_VideoCoderLevel;
  eVIDEO_PROFILE 		m_VideoCoderProfile;
  eVIDEO_BITRATE		m_VideoCoderBitRate;
  eMM_FILE_FORMAT		m_VideoCoderFileFormat;
  
  char                          m_RecDciStr[128];	
  unsigned char                 m_RecDciLen;
  unsigned char                 m_RecDciValue[128];

  unsigned int     		m_AudioCoderCoding;
  unsigned int 			m_AudioCoderSampleRate;
  unsigned int			m_AudioCoderMode;
  eMM_FILE_FORMAT		m_AudioCoderFileFormat;
  
  char                          m_LastDigitRcvd;
};

#endif


