/**
* @file mmendpoint.h
* @brief Declaration of SIPEndpoint class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef  _RTSPENDPOINT_H
#define  _RTSPENDPOINT_H

#include "port_connect.h"
#include "CRTSPClient.h"

// Device management and Multimedia include files
#include <devmgmt.h>
#include <ipmlib.h>
#include <m3glib.h>
#include "baseendpoint.h"
#include "rtspepstate.h"

#include "rtspopening_state.h"
#include "rtspportconnecting_state.h"
#include "rtspidle_state.h"
#include "rtspplaying_state.h"
#include "rtsprecording_state.h"

#include <time.h>
#include "locker.h"
#include "port_connect.h"

#include <map>
#include <queue>
#include <string>

// Info to be passed through to dev_PortConnect completion events
//#define RTSP_AUDIO_PORTCONNECT  0
//#define RTSP_VIDEO_PORTCONNECT  1

typedef std::map<char, std::string> RTSP_URLS;
typedef std::queue<char> DTMF_QUEUE;

class Endpoint;

//*****************************************************************************
// Class: ::RTSPEndpoint
// Description: This is the RTSP endpoint class
//*****************************************************************************
class RTSPEndpoint : public BaseEndpoint
{
public:
   RTSPEndpoint::RTSPEndpoint(int numEP, const char *RTSPName, const char *mapID);
   ~RTSPEndpoint();

   void Shutdown();  

   void ProcessEvent(METAEVENT metavent);
   char *GetStateString();
   void OpenSubDevs();
   void CloseSubDevs();
   SRL_DEVICE_HANDLE GetIPMHandle() { return m_IPMHandle;}

   // Port connect related  
   void SetRxPortInfoList(DM_PORT_INFO_LIST *pRxPortInfoList) { m_RxPortList = *pRxPortInfoList;}
   void SetTxPortInfoList(DM_PORT_INFO_LIST *pTxPortInfoList) { m_TxPortList = *pTxPortInfoList;}

   DM_PORT_INFO& GetAudioRxPortInfo() { return m_audioPortRxInfo;}
   DM_PORT_INFO& GetAudioTxPortInfo() { return m_audioPortTxInfo;}
   DM_PORT_INFO& GetVideoRxPortInfo() { return m_videoPortRxInfo;}
   DM_PORT_INFO& GetVideoTxPortInfo() { return m_videoPortTxInfo;}

   void ConnectToPeer(DM_PORT_INFO& a_audioPortRxInfo, DM_PORT_INFO& a_videoPortRxInfo);
   void DisconnectFromPeer();
   void ChangeState(RTSPEPState::E_RTSPEPSTATE e_NewState);
   void SetLastMessageString(const char *pMessageStr);
   void LogDevError();
   void RecordPortInfoList(METAEVENT metaevent, DM_PORT_INFO_LIST* pPortInfoList);
   void RecordLocalMediaInfo(METAEVENT metaevent, IPM_MEDIA_INFO* pLocalMediaInfo);
   void GetIPMPortInfo();
   void GetLocalMediaInfo();
   void PlayVideoFile(char dtmf='0');
   void RTSPServerPlay();
   void RecordVideoFile();
   void StopRTSPPlay();
   void StopRTSPRecord();
   void ProcessH245UII(char UII);
   void CheckOperationQueue();
   void QueueNextVideo(char dtmf);
   char *MapIP() { return m_mapID;}
   int GetIndex() { return m_Index;}
   void StopMedia();
   void SetDCI(const char* szDCI);

   void SetVideoToH263(bool bQcif);
   void SetVideoToH263_1998(bool bQcif);
   void SetVideoToMPEG4(bool bQcif);
   void SetVideoToH264(bool bQcif);
   void SetAudioToAMR();
   void SetAudioToG711U();
   static void AddUrl(char dtmf, char* url) {
      m_rtspUrls[dtmf] = url;
   }
   static const char* GetUrl(char dtmf, std::string& url) {
      if (m_rtspUrls.find(dtmf) != m_rtspUrls.end()) {
         url.assign(m_rtspUrls[dtmf].c_str());
         return url.c_str();
      }
      else
         return NULL;
   }

   static RTSP_URLS m_rtspUrls;

private:

   int                        m_Index;
   time_t                     m_ConnectionTime;
   RTSPOpeningState             *m_pRTSPOpeningState;
   RTSPPortConnectingState      *m_pRTSPPortConnectingState;
   RTSPIdleState                *m_pRTSPIdleState;
   RTSPPlayingState             *m_pRTSPPlayingState;
   RTSPRecordingState           *m_pRTSPRecordingState;
   RTSPEPState                  *m_pCurrentState;
   char                       m_IPMName[DEV_NAME_SIZE];
   char                       m_mapID[DEV_NAME_SIZE];

   SRL_DEVICE_HANDLE          m_IPMHandle;
   char                       m_StateBuffer[MAX_STATE_STRING];
   char                       m_LastMessageBuff[MAX_LAST_MSG_STRING];
   DEV_RESOURCE_LIST          m_resourceList;

   // Port connect related
   // Ptrs to PORT_INFO_LISTs returned
   DM_PORT_INFO_LIST          m_RxPortList;
   DM_PORT_INFO_LIST          m_TxPortList;

   // PORT_INFO structs themselves
   DM_PORT_INFO               m_audioPortTxInfo;
   DM_PORT_INFO               m_audioPortRxInfo;
   DM_PORT_INFO               m_videoPortTxInfo;
   DM_PORT_INFO               m_videoPortRxInfo;

   void ProcessRxPortInfo(METAEVENT metaevent);
   void ProcessTxPortInfo(METAEVENT metaevent);
   void ProcessPortConnect(METAEVENT metaevent);
   int StartMedia();

   unsigned short GetRTSPPortConnectCompletionCnt() { return m_RTSPPortConnectCompletionCnt;};
   void ZeroRTSPPortConnectCompletionCnt() { m_RTSPPortConnectCompletionCnt = 0;};
   void IncrementRTSPPortConnectCompletionCnt() { m_RTSPPortConnectCompletionCnt++;};

  unsigned short m_RTSPPortConnectCompletionCnt;

  char                       m_CurrentStateStr[MAX_CURRENT_STATE_STR];
  CLocker                    m_StateLock;
/*
  eVIDEO_FRAMESPERSEC		m_VideoCoderFPS;
  eVIDEO_IMAGE_HEIGHT		m_VideoCoderImageHeight;
  eVIDEO_IMAGE_WIDTH 		m_VideoCoderImageWidth;
  eVIDEO_CODING			m_VideoCoderCoding;
  eVIDEO_LEVEL			m_VideoCoderLevel;
  eVIDEO_PROFILE 		m_VideoCoderProfile;
  eVIDEO_BITRATE		m_VideoCoderBitRate;

  unsigned int     		m_AudioCoderCoding;
  unsigned int 			m_AudioCoderSampleRate;
  unsigned int			m_AudioCoderMode;
*/

  CRTSPClient * m_pRTSPClient;

   // Values for local media interfaces.  Needed for Oceanville, as media
   // NICS may change
   unsigned int               m_localVideoRTPPort;
   char                       m_localVideoRTPIPAddress[IP_ADDR_SIZE];
   unsigned int               m_localVideoRTCPPort;
   char                       m_localVideoRTCPIPAddress[IP_ADDR_SIZE];
   unsigned int               m_localAudioRTPPort;
   char                       m_localAudioRTPIPAddress[IP_ADDR_SIZE];
   unsigned int               m_localAudioRTCPPort;
   char                       m_localAudioRTCPIPAddress[IP_ADDR_SIZE];

   // Holders for remote IP addresses and RTP ports parsed out of SDPs
   unsigned int               m_remoteAudioRTPPort;
   unsigned int               m_remoteVideoRTPPort;
   char                       m_remoteAudioIPAddress[IP_ADDR_SIZE];
   char                       m_remoteVideoIPAddress[IP_ADDR_SIZE];

   IPM_MEDIA_INFO             m_mediaInfo;

   eIPM_CODER_TYPE            m_remoteAudioCoderType;
   eIPM_CODER_FRAMESIZE       m_remoteAudioCoderFramesize;
   int                        m_remoteAudioFramesPerPkt; 
   eIPM_CODER_VAD             m_remoteAudioVadEnable;
   int                        m_remoteAudioCoderPayloadType;
   int                        m_remoteAudioRedPayloadType;

   eIPM_CODER_TYPE            m_localAudioCoderType;
   eIPM_CODER_FRAMESIZE       m_localAudioCoderFramesize;
   int                        m_localAudioFramesPerPkt; 
   eIPM_CODER_VAD             m_localAudioVadEnable;
   int                        m_localAudioCoderPayloadType;
   int                        m_localAudioRedPayloadType;

   eDEV_RESOURCE_TYPE         m_ipmAudioCoderResource;

   char                       m_sdpVideoFormat[30];
   char                       m_sdpVideoRtpmap[30];
   char                       m_sdpVideoFmtp[30];

   eIPM_CODER_TYPE            m_localVideoCoderType;
   int                        m_localVideoCoderPayloadType;
   eVIDEO_PROFILE             m_localImageProfile;
   eVIDEO_LEVEL               m_localImageLevel;

   eVIDEO_IMAGE_WIDTH         m_localImageWidth;
   eVIDEO_IMAGE_HEIGHT        m_localImageHeight;
   eVIDEO_FRAMESPERSEC        m_localFramesPerSec;
   unsigned int               m_localBitRate;
   eVIDEO_SAMPLING_RATE       m_localSamplingRate;

   eIPM_CODER_TYPE            m_remoteVideoCoderType;
   int                        m_remoteVideoCoderPayloadType;
   eVIDEO_PROFILE             m_remoteImageProfile;
   eVIDEO_LEVEL               m_remoteImageLevel;

   eVIDEO_IMAGE_WIDTH         m_remoteImageWidth;
   eVIDEO_IMAGE_HEIGHT        m_remoteImageHeight;
   eVIDEO_FRAMESPERSEC        m_remoteFramesPerSec;
   unsigned int               m_remoteBitRate;
   eVIDEO_SAMPLING_RATE       m_remoteSamplingRate;
   DTMF_QUEUE		      m_qDtmf;   
   unsigned char              m_DciOctetStr[OCTET_STRING_SIZE];
   unsigned char              m_DciOctetStrSize;

};

#endif


