/**
* @file mmopening_state.cpp
* @brief Definition of RTSPOpeningState class
* @date Feb. 20, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "ipmlib.h"
#include "rtspopening_state.h"
#include "rtspendpoint.h"
#include "endpointmgr.h"
#include "logger.h"

#include "appevents.h"

// static constant members:
const int RTSPOpeningState::TX_PORTS_RCVD = (1<<1);
const int RTSPOpeningState::RX_PORTS_RCVD = (1<<2);
const int RTSPOpeningState::RTSPEP_OPENED   = (1<<3);
const int RTSPOpeningState::IPM_LCL_MED_RCVD  = (1<<4);
const int RTSPOpeningState::RTSPEP_READY    = (
                                        RTSPOpeningState::TX_PORTS_RCVD |
                                        RTSPOpeningState::RX_PORTS_RCVD |
                                        RTSPOpeningState::RTSPEP_OPENED |
                                        RTSPOpeningState::IPM_LCL_MED_RCVD );


//*****************************************************************************
// Function: RTSPOpeningState::RTSPOpeningState(RTSPEndpoint *pRTSPEndpoint)
// Description: Initializing constructor
// Return:  RTSPOpeningState*
// Parameters: RTSPEndpoint *pRTSPEndpoint 
//*****************************************************************************
RTSPOpeningState::RTSPOpeningState(RTSPEndpoint* pRTSPEndpoint) :
   RTSPEPState(pRTSPEndpoint)
{
}

//*****************************************************************************
// Function: RTSPOpeningState::~RTSPOpeningState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
RTSPOpeningState::~RTSPOpeningState()
{
}

//*****************************************************************************
// Function: void RTSPOpeningState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void RTSPOpeningState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
    case IPMEV_OPEN:
      LOG_ENTRY(metaevent.evtdev, "Event IPMEV_OPEN received\n");
      m_StatusBitmask |= RTSPEP_OPENED;
      ProcessIPMOpen(metaevent);
        break;
    case DMEV_GET_TX_PORT_INFO:
      LOG_ENTRY(metaevent.evtdev, "Event DMEV_GET_TX_PORT_INFO received\n");
      ProcessTxPortInfo(metaevent);
        break;
    case DMEV_GET_RX_PORT_INFO:
      LOG_ENTRY(metaevent.evtdev, "Event DMEV_GET_RX_PORT_INFO received\n");
      ProcessRxPortInfo(metaevent);
        break;
    case IPMEV_GET_LOCAL_MEDIA_INFO:
      LOG_ENTRY(metaevent.evtdev, "Event IPMEV_GET_LOCAL_MEDIA_INFO received\n");
      ProcessGetLocalInfo(metaevent);
        break;
    default:
      LOG_ERROR(metaevent.evtdev,"RTSPOpening state: Unexpected event type: 0x%x\n",
		metaevent.evttype);
        break;
   }
}

void RTSPOpeningState::ProcessIPMOpen(METAEVENT metaevent)
{
      m_pRTSPEndpoint->GetIPMPortInfo();
}

void RTSPOpeningState::ProcessTxPortInfo(METAEVENT metaevent)
{
   DM_PORT_INFO_LIST* pTxPortInfoList = reinterpret_cast<DM_PORT_INFO_LIST*>(metaevent.evtdatap);
 
   m_pRTSPEndpoint->RecordPortInfoList(metaevent, pTxPortInfoList);
   m_pRTSPEndpoint->SetTxPortInfoList(pTxPortInfoList);
   m_StatusBitmask |= TX_PORTS_RCVD;
 
   if ( IsRTSPEndpointReady() )
   {
      LOG_ENTRY(metaevent.evtdev, "RTSP endpoint ready for port connect\n");
      m_pRTSPEndpoint->ChangeState(PORTCONNECTING_STATE);
      m_pRTSPEndpoint->Notify(APP_RTSP_ENDPOINT_OPENED);
   }
}

void RTSPOpeningState::ProcessGetLocalInfo(METAEVENT metaevent)
{
   IPM_MEDIA_INFO* pMediaList = reinterpret_cast<IPM_MEDIA_INFO*>(metaevent.evtdatap);

   m_pRTSPEndpoint->RecordLocalMediaInfo(metaevent, pMediaList);
   m_StatusBitmask |= IPM_LCL_MED_RCVD;
   if ( IsRTSPEndpointReady() )
   {
      LOG_ENTRY(metaevent.evtdev, "RTSP endpoint ready for port connect\n");
      m_pRTSPEndpoint->ChangeState(PORTCONNECTING_STATE);
      m_pRTSPEndpoint->Notify(APP_RTSP_ENDPOINT_OPENED);
   }
}
 
void RTSPOpeningState::ProcessRxPortInfo(METAEVENT metaevent)
{
   DM_PORT_INFO_LIST* pRxPortInfoList = reinterpret_cast<DM_PORT_INFO_LIST*>(metaevent.evtdatap);
 
   m_pRTSPEndpoint->RecordPortInfoList(metaevent, pRxPortInfoList);
   m_pRTSPEndpoint->SetRxPortInfoList(pRxPortInfoList);
   m_StatusBitmask |= RX_PORTS_RCVD;
 
   if ( IsRTSPEndpointReady() )
   {
      LOG_ENTRY(metaevent.evtdev, "RTSP endpoint ready for port connect\n");
      m_pRTSPEndpoint->ChangeState(PORTCONNECTING_STATE);
      m_pRTSPEndpoint->Notify(APP_RTSP_ENDPOINT_OPENED);
   }
}

//*****************************************************************************
// Function: void RTSPOpeningState::ProcessUserPrompt(RTSPEPState::E_USER_PROMPT_TYPE eUserPrompt)
// Description: Procerss request from user interface
// Return: void 
// Parameters: RTSPEPState::E_USER_PROMPT_TYPE eUserPrompt 
//*****************************************************************************
/*********
void  RTSPOpeningState::ProcessUserPrompt(RTSPEPState::E_USER_PROMPT_TYPE eUserPrompt)
{
   LOG_ERROR(0,"Unexpected user prompt on RTSP endpoint in OPENING state: %d\n",
             static_cast<int>(eUserPrompt));
}
****************/

//*****************************************************************************
// Function: void RTSPOpeningState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void RTSPOpeningState::Shutdown()
{
  LOG_ENTRY(m_pRTSPEndpoint->GetIPMHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
}

//*****************************************************************************
// Function: void RTSPOpeningState::ProcessDeviceOpen(METAEVENT metaevent)
// Description: Process device open completion event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void RTSPOpeningState::ProcessDeviceOpen(METAEVENT metaevent)
{
   LOG_ENTRY(metaevent.evtdev,"ProcessDeviceOpen\n");

   //if ( true == IsEndpointFullyOpened() )
//   {
      LOG_ENTRY(metaevent.evtdev,"RTSPEndpoint -  GC and IPM devices both open, GC Unblocked received, waiting for call on even numbered devices\n");
   //}
}

