/**
* @file sipcalling_state.cpp
* @brief Definition of SIPIdleState class
* @date Feb. 16, 2007
*
* DIALOGIC CONFIDENTIAL
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to
* the source code (Material) are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#include "ipmlib.h"
#include "sipcalling_state.h"
#include "sipendpoint.h"
#include "endpointmgr.h"
#include "appevents.h"
#include "logger.h"

//*****************************************************************************
// Function: SIPCallingState::SIPCallingState(SIPEndpoint *pSIPEndpoint)
// Description: Initializing constructor
// Return:  SIPCallingState*
// Parameters: SIPEndpoint *pSIPEndpoint 
//*****************************************************************************
SIPCallingState::SIPCallingState(SIPEndpoint* pSIPEndpoint):
   SIPEPState(pSIPEndpoint)
{
   m_pSIPEndpoint = pSIPEndpoint;
}


//*****************************************************************************
// Function: SIPCallingState::~SIPCallingState()
// Description: Destructor
// Return:  none
// Parameters: none 
//*****************************************************************************
SIPCallingState::~SIPCallingState()
{
}

//*****************************************************************************
// Function: void SIPCallingState::ProcessEvent(METAEVENT metaevent)
// Description: Process an event
// Return: none
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPCallingState::ProcessEvent(METAEVENT metaevent)
{
   switch ( metaevent.evttype )
   {
      // GC/R4 events
      case GCEV_DIALING:
         LOG_ENTRY(metaevent.evtdev, "SIPCallingState: GCEV_DIALING received\n");
         break;
      case GCEV_PROCEEDING:
         LOG_ENTRY(metaevent.evtdev, "SIPCallingState: GCEV_PROCEEDING received\n");
         break;
      case GCEV_ALERTING:
         LOG_ENTRY(metaevent.evtdev, "SIPCallingState: GCEV_ALERTING received\n");
         break;
      case GCEV_CONNECTED:
         LOG_ENTRY(metaevent.evtdev, "SIPCallingState: GCEV_CONNECTED received\n");
         ProcessFarEndConnected(metaevent);
         break;    
      case GCEV_DISCONNECTED:
         LOG_ENTRY(metaevent.evtdev, "SIPCallingState: GCEV_DISCONNECTED received\n");
         ProcessDisconnect(metaevent);
         break;    
      case GCEV_TASKFAIL:
         LOG_ENTRY(metaevent.evtdev, "SIPCallingState: GCEV_TASKFAIL received\n");
         break;   
      default:
         LOG_ERROR(metaevent.evtdev,"SIPCallingState: Unexpected event type: 0x%x\n", 
                   metaevent.evttype);
         break;
   }
}

//*****************************************************************************
// Function: void SIPCallingState::Shutdown()
// Description: Process shutdown request
// Return: void 
// Parameters: none 
//*****************************************************************************
void SIPCallingState::Shutdown()
{
  LOG_ENTRY(m_pSIPEndpoint->GetGCSIPHandle(), "Shutdown called in %s state.  No Op\n", GetStateStr());
}

//*****************************************************************************
// Function: void SIPCallingState::ProcessFarEndConnected(METAEVENT metaevent)
// Description: Process connected event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPCallingState::ProcessFarEndConnected(METAEVENT metaevent)
{
   LOG_ENTRY(metaevent.evtdev,"ProcessfarEndConnected\n");

   // If SDP is read, and ACK successfully returned, move to
   // connected state
   // Improve here!! Add return to next call.
   m_pSIPEndpoint->ProcessFarEndConnected(metaevent);

   // Advance to connected state
   m_pSIPEndpoint->ChangeState(CONNECTED_STATE);
   m_pSIPEndpoint->Notify(APP_SIP_ENDPOINT_CONNECTED);
}

//*****************************************************************************
// Function: void SIPCallingState::ProcessDisconnect(METAEVENT metaevent)
// Description: Process disconnect event
// Return: void 
// Parameters: METAEVENT metaevent 
//*****************************************************************************
void SIPCallingState::ProcessDisconnect(METAEVENT metaevent)
{
   m_pSIPEndpoint->ProcessDisconnect(metaevent);
   // Advance to dropping state
   m_pSIPEndpoint->ChangeState(DROPPING_STATE);
}


