/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// ConfigFile.h: interface for the ConfigFile class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CPARSER_H__9C41BA06_194F_47C8_AE4E_4BBFDFE239CB__INCLUDED_)
#define AFX_CPARSER_H__9C41BA06_194F_47C8_AE4E_4BBFDFE239CB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "GenLog.h"

//
// Non - specific parser
// provide tokenization functions
//
typedef class CParser * PParser;

class CParser : public CanLog {

 public:
	CParser(CGenLog *pLog);
	virtual ~CParser(){
	}; //	End of destructor()

    // Set buffer to parce
    void inline SetBuffer(const char *buffer){
		ClearBuffer();
	    m_buffer = buffer;
        return;
	}

    // Returns current line number ( in input file )
    size_t GetCurrentLineNumber(){
        return m_current_line; 
    }

    // Sets current line number ( in input file )
    void SetCurrentLineNumber(size_t line){
         m_current_line = line;
    }

    // Restart buffer from the beginning
    bool Rewind();

    // Section is something Enclosed in []
    // returns current section
    const char *GetSection(){
        return m_section_name;
    }

    // Each section has name and optional ID
    // [Conference 12]
    // name is "Conference" id is 12(as number)
    // return current section id
    int GetSectionId(){
        return m_section_id;
    }

    // Determine if current token is inside specific section
    bool IsSection(const char *name) {
        return COMPARE_EQUAL == str_compare(name, m_section_name);
    }

    // Make a step back
    // indicates next time to return same token
    void back(){
        m_back = true;
    }

    // Retrieve Yes or No value
    bool GetYesNo(const char *token, bool *result);

    // Retrieve Numeric values:
    // signed 
    bool GetNumber(const char *token, int *result);
    // and unsigned
    bool GetUNumber(const char *token, unsigned int *result);

 public:
    // Advance to the next token and return in in specified buffer
    bool GotoNextLine();    // advance to the beginning of next line

    bool GotoNextToken();   // advance to the beginning of next token
    bool GetNextToken(char *token_buf, size_t tokenlen);
    void ClearBuffer();         // init internal variables
    bool GetLine(char *token_buf, size_t tokenlen); // get to end of line

 private:    
    bool SkipSpace();       // advance to next non-blank character
    bool SkipComments();    // skip comment line
    bool TrySection();      // try for something enclosed in [] 

    bool SkipMultiLineComment(list<int> * bgn_lines );   // skip multi-line comment


    const char * m_buffer;		// buffer to parse
    size_t m_current_line;      // current line number
    const char *m_current_pos;  // current position in m_file_buf

// Current section    
    int  m_section_id;
    char *m_section_name;
    
// current ip section


// back() implementation
    bool m_back;
    int m_last_line;
    const char * m_last_pos;

protected:
    bool m_is_correct;

}; // class ConfigFile

#endif // !defined(AFX_CPARSER_H__9C41BA06_194F_47C8_AE4E_4BBFDFE239CB__INCLUDED_)
