/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
#include "pdl.h"

// Conference.cpp: implementation of the CConference class.
//
//////////////////////////////////////////////////////////////////////


//
// State machine - specific states
//
enum {
   S_SETATTR,              // Device Open
   S_SETATTR_EXIT,         // Exit while opening

   S_ENABLEEVENTS,         // Enable Events
   S_ENABLEEVENTS_EXIT,    // Exit while enable events in progress

// Conference
   S_OPEN_DX_PARTY,        // ...cnf_PartyOpen  
   S_OPEN_DX_PARTY_EXIT,   // ...cnf_PartyOpen  exiting
   S_ADD_DX_PARTY,         // ...cnf_addParty
   S_ADD_DX_PARTY_EXIT,    // ...cnf_addParty exiting
   S_DEVCONNECT1,          // ...dev_Connect ( first event)
   S_DEVCONNECT2,          // ...dev_Connect ( second event)

   S_DEVCONNECT1_EXIT,     // ...dev_Connect ( first event) exit
   S_DEVCONNECT2_EXIT,     // ...dev_Connect ( second event) exit
   S_DEVCONNECT_EXIT,      // ...dev_Connect exiting
   
   S_REMOVE_DX_PARTY,      // ... remove party 
   S_DEVDISCONNECTDX,      // ... DevDisconect(voice)
   S_DEVDISCONNECTCNF,     // ... DevDisconnect (cnf party)
   S_BEEP,                 //  ... Beep 
   S_BEEP_EXIT,            // ... Exit while beeping 
   S_BEEP_BYE,             // ... Beep before disbanding conference 
};

static NAME_TABLE state_tbl[] ={
    {"S_SETATTR",           S_SETATTR            },
    {"S_SETATTR_EXIT",      S_SETATTR_EXIT       },

    {"S_ENABLEEVENTS",      S_ENABLEEVENTS       },
    {"S_ENABLEEVENTS_EXIT", S_ENABLEEVENTS_EXIT  },

    {"S_OPEN_DX_PARTY",     S_OPEN_DX_PARTY      },
    {"S_ADD_DX_PARTY",      S_ADD_DX_PARTY       },

    {"S_DEVCONNECT1",       S_DEVCONNECT1        },
    {"S_DEVCONNECT2",       S_DEVCONNECT2        },

    {"S_OPEN_DX_PARTY_EXIT",S_OPEN_DX_PARTY_EXIT },
    {"S_ADD_DX_PARTY_EXIT", S_ADD_DX_PARTY_EXIT  },
    {"S_DEVCONNECT1_EXIT",  S_DEVCONNECT1_EXIT   },
    {"S_DEVCONNECT2_EXIT",  S_DEVCONNECT2_EXIT   },


    {"S_REMOVE_DX_PARTY",   S_REMOVE_DX_PARTY    },
    {"S_DEVDISCONNECTDX",   S_DEVDISCONNECTDX    },
    {"S_DEVDISCONNECTCNF",  S_DEVDISCONNECTCNF   },

    {"S_BEEP",              S_BEEP   },
    {"S_BEEP_EXIT",         S_BEEP_EXIT   },
    {"S_BEEP_BYE",          S_BEEP_BYE   },
    
    {0, 0}
};  // End of state_tbl[]

//*****************************************************************************
// Purpose	: 
//    return state name for given value
// Parameters:	
//    [in] state
// Returns:	
//    name 
//*****************************************************************************
const char * CnfConference::state_name(int state){
const char *name;
   if (! str_findname(state,&name,state_tbl) ){
         name = common_state_name(state);
   }
 return name;
} // End of state_name()


enum {
    A_SETATTR,               // set parameters 
    A_ENABLEEVENTS,          // Enable events
    A_TRYCLOSE,              // Close if there are no parties in this conference

    A_OPEN_DX_PARTY,         // cnf_OpenParty (voice)
    A_ADD_DX_PARTY,          // cnf_AddParty 
    A_DEVCONNECT,            // dev_Connect 
    A_MOVE,                  // do nothing, Advance to next state
    A_MOVE_DEVCONNECT2_EXIT, // do nothing, Advance to s_devdisconnect2_exit

    A_DEVDISCONNECTDX,       // dev_DisConnect 
    A_DEVDISCONNECTCNF,      // dev_DisConnect 
    A_REMOVE_DX_PARTY,       // cnf_RemoveParty 
    A_CLOSE_DX_PARTY,        // cnf_CloseParty 
    A_BEEP_IN,               // beep in
    A_BEEP_OUT,              // beep out
    A_BEEP_BYE,              // beep out
    A_DISBAND                // Disband
};

static NAME_TABLE ac_tbl[] = {
    { "A_SETATTR",                A_SETATTR           }, 
    { "A_ENABLEEVENTS",           A_ENABLEEVENTS      }, 
    { "A_TRYCLOSE",               A_TRYCLOSE          }, 

    { "A_OPEN_DX_PARTY",          A_OPEN_DX_PARTY     }, 
    { "A_ADD_DX_PARTY",           A_ADD_DX_PARTY      }, 
    { "A_DEVCONNECT",             A_DEVCONNECT        },    
    { "A_MOVE",                   A_MOVE              },    
    { "A_MOVE_DEVCONNECT2_EXIT",  A_MOVE_DEVCONNECT2_EXIT   },    

    { "A_DEVDISCONNECTDX",        A_DEVDISCONNECTDX   }, 
    { "A_DEVDISCONNECTCNF",       A_DEVDISCONNECTCNF  }, 
    { "A_REMOVE_DX_PARTY",        A_REMOVE_DX_PARTY   }, 
    { "A_CLOSE_DX_PARTY",         A_CLOSE_DX_PARTY    }, 

    { "A_BEEP_IN",                A_BEEP_IN    }, 
    { "A_BEEP_OUT",               A_BEEP_OUT    }, 
    { "A_BEEP_BYE",               A_BEEP_BYE    }, 
    { "A_DISBAND",                A_DISBAND    }, 


    { 0,0 }     
};  // End of ac_tbl[]

//*****************************************************************************
// Purpose	: 
//    return action name for given value
// Parameters:	
//    [in] action
// Returns:	
//    name 
//*****************************************************************************
const char * CnfConference::action_name(int action){
 const char *name;
  if (! str_findname(action, &name, ac_tbl) ){
        name = common_action_name(action);
  }
  return name;
} // End of action_name()

//===========================================================
// OPEN ->  SET_ATTR -> RELAX
// S_OPEN ->S_SETATTR-> S_ADDVOCIE -> S_RELAX
static ACTION_STRU cnf_action_stru[] = {
//  current_state     action          state_if_pass   action_if_fail
    { S_ANY,          A_CLOSE,        S_FINAL,          A_GIVEUP   },
    { S_ANY,          A_GIVEUP,       S_FINAL,          A_NONE     },
    
    { S_ANY,          A_CLOSE_DX_PARTY,   S_WAIT_SUBDEV,        A_TRYCLOSE },
    { S_ANY,          A_REMOVE_DX_PARTY,  S_REMOVE_DX_PARTY,    A_CLOSE_DX_PARTY  },

    { S_ANY,          A_DEVDISCONNECTDX,   S_DEVDISCONNECTDX,   A_DEVDISCONNECTCNF},
    { S_ANY,          A_DEVDISCONNECTCNF,  S_DEVDISCONNECTCNF,  A_REMOVE_DX_PARTY },
    { S_ANY,          A_TRYCLOSE,          S_WAIT_SUBDEV,       A_NONE },



    { S_OPEN,         A_SETATTR,      S_SETATTR,        A_CLOSE    },
    { S_OPEN,         A_EXIT,         S_OPEN_EXIT,      A_CLOSE    },


    { S_SETATTR,      A_ENABLEEVENTS, S_ENABLEEVENTS,   A_CLOSE    },
    { S_SETATTR,      A_EXIT,         S_SETATTR_EXIT,   A_CLOSE    },

    
    { S_ENABLEEVENTS, A_OPEN_DX_PARTY,S_OPEN_DX_PARTY,     A_CLOSE },
    { S_ENABLEEVENTS, A_EXIT,         S_ENABLEEVENTS_EXIT, A_CLOSE },


//Conference
    { S_OPEN_DX_PARTY,  A_EXIT,           S_OPEN_DX_PARTY_EXIT, A_NONE           },
    { S_OPEN_DX_PARTY,  A_ADD_DX_PARTY,   S_ADD_DX_PARTY,       A_CLOSE_DX_PARTY },
    { S_OPEN_DX_PARTY,  A_RELAX,          S_RELAX,              A_NONE },

    { S_OPEN_DX_PARTY,  A_DEVCONNECT,     S_DEVCONNECT1,        A_CLOSE_DX_PARTY },

// Add party
    { S_ADD_DX_PARTY,       A_EXIT,          S_ADD_DX_PARTY_EXIT,   A_NONE        },
    { S_ADD_DX_PARTY,       A_DEVCONNECT,    S_DEVCONNECT1,         A_REMOVE_DX_PARTY },

    { S_ADD_DX_PARTY,       A_RELAX,         S_RELAX,           A_NONE },

    { S_ADD_DX_PARTY,       A_CLOSE_DX_PARTY,  S_WAIT_SUBDEV,      A_TRYCLOSE  },

// Dev connect
    { S_DEVCONNECT1,    A_EXIT,           S_DEVCONNECT1_EXIT,         A_NONE },
    { S_DEVCONNECT1,    A_MOVE,           S_DEVCONNECT2,              A_NONE  },
    { S_DEVCONNECT1,    A_MOVE_DEVCONNECT2_EXIT, S_DEVCONNECT2_EXIT,  A_NONE  },

    { S_DEVCONNECT1_EXIT,A_MOVE,          S_DEVCONNECT2_EXIT,         A_NONE  },


    { S_DEVCONNECT2,    A_EXIT,            S_DEVCONNECT2_EXIT,         A_NONE },
    { S_DEVCONNECT2,    A_DEVDISCONNECTDX, S_DEVDISCONNECTDX,          A_REMOVE_DX_PARTY  },
    { S_DEVCONNECT2,    A_RELAX,           S_RELAX,                    A_NONE  },
    { S_DEVCONNECT2,    A_ADD_DX_PARTY,    S_ADD_DX_PARTY,             A_CLOSE_DX_PARTY },

    { S_DEVCONNECT2,    A_REMOVE_DX_PARTY, S_REMOVE_DX_PARTY,          A_CLOSE_DX_PARTY },

    { S_DEVCONNECT2_EXIT, A_DEVDISCONNECTDX, S_DEVDISCONNECTDX,     A_REMOVE_DX_PARTY  },
    { S_DEVCONNECT2_EXIT, A_REMOVE_DX_PARTY, S_REMOVE_DX_PARTY,     A_CLOSE_DX_PARTY },


    { S_RELAX,           A_TRYCLOSE,     S_WAIT_SUBDEV,             A_NONE     },   


    { S_RELAX,           A_BEEP_OUT,    S_BEEP,         A_MOVE },   
    { S_RELAX,           A_BEEP_IN,     S_BEEP,         A_MOVE },   
    { S_RELAX,           A_BEEP_BYE,    S_BEEP_BYE,     A_DISBAND },

    { S_RELAX,           A_MOVE,        S_RELAX,        A_NONE },   

    { S_RELAX,           A_DISBAND,     S_RELAX,        A_NONE },   

    { S_BEEP,            A_EXIT,        S_BEEP_EXIT,    A_NONE },   
    { S_BEEP,            A_MOVE,        S_RELAX,        A_NONE },   

    { S_BEEP_BYE,        A_DISBAND,     S_RELAX,        A_NONE },
    { S_BEEP_BYE,        A_EXIT,        S_BEEP_EXIT,    A_NONE },

        
    { S_WAIT_SUBDEV,      A_TRYCLOSE,     S_WAIT_SUBDEV,    A_NONE     },   


// No operation
    { S_ANY,          A_NONE,         S_SAME,           A_NONE     },

// State machine error (missing case to handle specified action)
    { S_ANY,          A_ERROR,        S_SAME,           A_CLOSE    },

// Not part of state machine, indicates last line
    { S_END,   0,    0,     0  }   

};  // End of cnf_action_stru[]

//===========================================================
static EVENT_STRU cnf_event_stru[] = {

//  current_state     event                        action           

 // After Open        
    { S_OPEN,         CNFEV_OPEN_CONF,           A_SETATTR   },
    { S_OPEN,         CNFEV_OPEN_CONF_FAIL,      A_CLOSE     },
    { S_OPEN,         USREV_EXIT_REQUEST,        A_EXIT      },
    { S_OPEN,         USREV_TIMEOUT,             A_CLOSE     },
    
    { S_OPEN_EXIT,    CNFEV_OPEN,                A_CLOSE,    },
    { S_OPEN_EXIT,    CNFEV_OPEN_FAIL,           A_CLOSE,    },
    { S_OPEN_EXIT,    USREV_TIMEOUT,             A_CLOSE,    },

// After Set Attributes
    { S_SETATTR,      CNFEV_SET_ATTRIBUTE,       A_ENABLEEVENTS },
    { S_SETATTR,      CNFEV_SET_ATTRIBUTE_FAIL,  A_CLOSE     },
    { S_SETATTR,      USREV_EXIT_REQUEST,        A_EXIT      },
    { S_SETATTR,      USREV_TIMEOUT,             A_CLOSE     },

    { S_SETATTR_EXIT, CNFEV_SET_ATTRIBUTE,       A_CLOSE     },
    { S_SETATTR_EXIT, CNFEV_SET_ATTRIBUTE_FAIL,  A_CLOSE     },
    { S_SETATTR_EXIT, USREV_TIMEOUT,             A_CLOSE     },

// After enable events
    { S_ENABLEEVENTS,      CNFEV_ENABLE_EVENT,        A_OPEN_DX_PARTY },
    { S_ENABLEEVENTS,      CNFEV_ENABLE_EVENT_FAIL,   A_CLOSE     },
    { S_ENABLEEVENTS,      USREV_EXIT_REQUEST,        A_EXIT      },
    { S_ENABLEEVENTS,      USREV_TIMEOUT,             A_CLOSE     },

    { S_ENABLEEVENTS_EXIT, CNFEV_ENABLE_EVENT,        A_CLOSE     },
    { S_ENABLEEVENTS_EXIT, CNFEV_ENABLE_EVENT_FAIL,   A_CLOSE     },
    { S_ENABLEEVENTS_EXIT, USREV_TIMEOUT,             A_CLOSE     },


// Conference
// open party
    { S_OPEN_DX_PARTY,      USREV_EXIT_REQUEST,        A_EXIT        },
    { S_OPEN_DX_PARTY,      CNFEV_OPEN_PARTY_FAIL,     A_CLOSE_DX_PARTY  },
    { S_OPEN_DX_PARTY,      USREV_TIMEOUT,             A_CLOSE_DX_PARTY  },

 // case 2: first add
//  { S_OPEN_DX_PARTY,      CNFEV_OPEN_PARTY,          A_ADD_DX_PARTY    },
 // case 1: first devconnect
    { S_OPEN_DX_PARTY,      CNFEV_OPEN_PARTY,          A_DEVCONNECT    },
 
    { S_OPEN_DX_PARTY,      USREV_SKIP_VOICE,          A_RELAX       },

    { S_OPEN_DX_PARTY_EXIT, CNFEV_OPEN_PARTY_FAIL,     A_CLOSE_DX_PARTY  },
    { S_OPEN_DX_PARTY_EXIT, USREV_TIMEOUT,             A_CLOSE_DX_PARTY  },
    { S_OPEN_DX_PARTY_EXIT, CNFEV_OPEN_PARTY,          A_CLOSE_DX_PARTY  },


// Add party
    { S_ADD_DX_PARTY,       USREV_EXIT_REQUEST,        A_EXIT        },
    { S_ADD_DX_PARTY,       CNFEV_ADD_PARTY_FAIL,      A_CLOSE_DX_PARTY  },
    { S_ADD_DX_PARTY,       USREV_TIMEOUT,             A_CLOSE_DX_PARTY  },

// case 2: first add
//  { S_ADD_DX_PARTY,       CNFEV_ADD_PARTY,           A_DEVCONNECT  },
// case 1: first devconnect
    { S_ADD_DX_PARTY,       CNFEV_ADD_PARTY,           A_RELAX  },

    { S_ADD_DX_PARTY_EXIT,  CNFEV_ADD_PARTY_FAIL,      A_CLOSE_DX_PARTY  },
    { S_ADD_DX_PARTY_EXIT,  USREV_TIMEOUT,             A_CLOSE_DX_PARTY  },
    { S_ADD_DX_PARTY_EXIT,  CNFEV_ADD_PARTY,           A_REMOVE_DX_PARTY },

// Dev connect
    { S_DEVCONNECT1,    USREV_EXIT_REQUEST,        A_EXIT        },
    { S_DEVCONNECT1,    DMEV_CONNECT_FAIL,         A_MOVE_DEVCONNECT2_EXIT },
    { S_DEVCONNECT1,    USREV_TIMEOUT,             A_MOVE_DEVCONNECT2_EXIT },
    { S_DEVCONNECT1,    DMEV_CONNECT,              A_MOVE        },

    { S_DEVCONNECT1_EXIT, DMEV_CONNECT,            A_NONE        },
    { S_DEVCONNECT1_EXIT, DMEV_CONNECT_FAIL,       A_MOVE        },
    { S_DEVCONNECT1_EXIT, USREV_TIMEOUT,           A_MOVE        },

// Dev connect
    { S_DEVCONNECT2,    USREV_EXIT_REQUEST,        A_EXIT        },
    { S_DEVCONNECT2,    DMEV_CONNECT_FAIL,         A_DEVDISCONNECTDX },
    { S_DEVCONNECT2,    USREV_TIMEOUT,             A_DEVDISCONNECTDX },

// case 2: first add
//  { S_DEVCONNECT2,    DMEV_CONNECT,              A_RELAX       },
// case 1: first devconnect
    { S_DEVCONNECT2,    DMEV_CONNECT,              A_ADD_DX_PARTY           },

    { S_DEVCONNECT2_EXIT, DMEV_CONNECT,            A_DEVDISCONNECTDX        },
    { S_DEVCONNECT2_EXIT, DMEV_CONNECT_FAIL,       A_DEVDISCONNECTDX        },
    { S_DEVCONNECT2_EXIT, USREV_TIMEOUT,           A_DEVDISCONNECTDX        },

// Exit Request
    { S_RELAX,           USREV_EXIT_REQUEST,        A_DEVDISCONNECTDX },
    
// Beep in and out
    { S_RELAX,           USREV_BEEP_OUT,     A_BEEP_OUT    },   
    { S_RELAX,           USREV_BEEP_IN,      A_BEEP_IN     },   

// cnf timeouts in Relax state
    { S_RELAX,           USREV_CNF_TIMEOUT,  A_BEEP_BYE       },

    { S_ANY,             USREV_BEEP_OUT,     A_NONE        }, // dont beep in any other state   
    { S_ANY,             USREV_BEEP_IN,      A_NONE        },   

    { S_BEEP,            USREV_TIMEOUT,      A_MOVE     },   
    { S_BEEP,            TDX_ERROR,          A_MOVE     },   
    { S_BEEP,            TDX_PLAYTONE,       A_MOVE     },   
// in case play or record instead beeping
    { S_BEEP,            TDX_PLAY,           A_MOVE     },   
    { S_BEEP,            TDX_RECORD,         A_MOVE     },   

    
    { S_BEEP_EXIT,       TDX_PLAYTONE,       A_DEVDISCONNECTDX     },   
    { S_BEEP_EXIT,       TDX_ERROR,          A_DEVDISCONNECTDX     },   
    { S_BEEP_EXIT,       USREV_TIMEOUT,      A_DEVDISCONNECTDX     },   

    { S_BEEP_BYE,        TDX_PLAYTONE,       A_DISBAND    },   
    { S_BEEP_BYE,        TDX_ERROR,          A_DEVDISCONNECTDX     },   
    { S_BEEP_BYE,        USREV_TIMEOUT,      A_DEVDISCONNECTDX     },   
    { S_BEEP_BYE,        USREV_EXIT_REQUEST, A_EXIT     },   


    { S_WAIT_SUBDEV,   USREV_EXIT_REQUEST,        A_TRYCLOSE         },  
//  { S_WAIT_SUBDEV,   CNFEV_PARTY_REMOVED,       A_TRYCLOSE         },  
    { S_WAIT_SUBDEV,   USREV_PARTY_REMOVED,       A_TRYCLOSE         },  

    { S_WAIT_SUBDEV,   USREV_CNF_TIMEOUT,         A_CLOSE            },  

    { S_ANY,           CNFEV_PARTY_REMOVED,       A_NONE             },
    { S_ANY,           USREV_PARTY_REMOVED,       A_NONE             },

// Dev disconnect    
    { S_DEVDISCONNECTDX, USREV_SKIP_VOICE,         A_TRYCLOSE },
    { S_DEVDISCONNECTDX, DMEV_DISCONNECT_FAIL,     A_DEVDISCONNECTCNF },
    { S_DEVDISCONNECTDX, DMEV_DISCONNECT,          A_DEVDISCONNECTCNF },
    { S_DEVDISCONNECTDX, USREV_TIMEOUT,            A_DEVDISCONNECTCNF },

    { S_DEVDISCONNECTCNF, DMEV_DISCONNECT,         A_REMOVE_DX_PARTY },
    { S_DEVDISCONNECTCNF, DMEV_DISCONNECT_FAIL,    A_REMOVE_DX_PARTY },
    { S_DEVDISCONNECTCNF, USREV_TIMEOUT,           A_REMOVE_DX_PARTY },


    { S_REMOVE_DX_PARTY,     CNFEV_REMOVE_PARTY,       A_TRYCLOSE },
    { S_REMOVE_DX_PARTY,     CNFEV_REMOVE_PARTY_FAIL,  A_TRYCLOSE },
    { S_REMOVE_DX_PARTY,     USREV_TIMEOUT,            A_TRYCLOSE },


    { S_ANY,          CNFEV_PARTY_ADDED,                 A_NONE      },

    //Anything else falls here
    { S_ANY,          EVENT_ANY,                 A_ERROR      },
    { S_END,   0,    0  } 

};  // End of cnf_evemt_stru[]


//*****************************************************************************
// Purpose	: 
//    Execute next step of state machine
// Parameters:	
//    [in] action
// Returns:	
//    true = success
//    false = error
//*****************************************************************************
bool CnfConference::Execute(int action) {
bool brc = true;
  switch(action) {
     case A_ERROR:
          // Indicate error
          StateMachineError();
          break;

     case A_GIVEUP:  // do nothing but advance state machine
          SetSrlState(SRLSTATE_ALL, RESET_SRL_STATE);
          SetCurrentState(S_FINAL);
          break;      

     case A_NONE:                  // do nothing
     case A_EXIT:                  // do nothing but advance state machine
     case A_MOVE:                  // do nothing but advance state machine to next
     case A_MOVE_DEVCONNECT2_EXIT: // do nothing but advance to devdisconnect2_exit
          break;

     case A_CLOSE:
          brc = Close();
          break;

     case A_SETATTR:
          brc = SetAttributes();
          break;

     case A_ENABLEEVENTS:
          brc = EnableEvents();
          break;

     case A_TRYCLOSE:
          brc = TryClose();
          break;  

     case A_RELAX:
          SetSrlState(SRLSTATE_INIT_COMPLETE  );
          LOG(LOG_APP, GetName(), "Initialization complete, password = %s", conf_PassCode);
          break;    

      case A_OPEN_DX_PARTY: 
           brc = TryOpenParty();
           break;

      case A_ADD_DX_PARTY: 
           brc = AddPartyLocal();
           break;

      case A_DEVCONNECT: 
           brc = DevConnect(DEV_DX_PARTY);
           break;

      case A_DEVDISCONNECTDX:
           TryDevDisconnectDx();
           break;

      case A_DEVDISCONNECTCNF: 
           brc = DevDisconnect(DEV_CNF_PARTY);
           break;

      case A_REMOVE_DX_PARTY: 
           brc = RemovePartyLocal();
           break;
   
      case A_CLOSE_DX_PARTY: 
           CloseParty();
           TryClose();
           break;

      case A_BEEP_IN:  
           if (conf_VoiceParty){
               brc = DxBeep(BEEP_IN);
           }else {
               brc = false;
           }
           break;

      case A_BEEP_OUT:  
           if (conf_VoiceParty){
               brc = DxBeep(BEEP_OUT);
           }else {
               brc = false;
           }
           break;

      case A_BEEP_BYE:  
           if ( conf_VoiceParty ){
                DxBeep(BEEP_BYE);
           }else {
               brc = false;
           }
           break;

      case A_DISBAND:
           LOG(LOG_APP,GetName(),"**Conference timed out");
           SignalToMembers(USREV_LEAVE_CNF);
           break;

      default:
          LOG( LOG_ERR1, GetName(),
               "CnfConference: App error. Missing case to handle action #%d %s",
               action, action_name(action) );
          TryClose();
          break;

  } // switch action
  return brc;
} // End Execute()

//*****************************************************************************
// Purpose	: 
//    Handle events
// Parameters:	
//   [in] event
//   [in] event data
//   [in] data length
//   [in] METAEVENT (not used)
// Returns:	
//     none
//*****************************************************************************
void CnfConference::HandleEvent(int event,
                                void *evtdata, int evtlen,
                                METAEVENT *metaeventp ){

    switch (event){
        case USREV_PARTY_REMOVED:
            { PSrlDevice pDev = *(PSrlDevice*)evtdata;
               if (pDev != this){
                   m_CnfList.remove(pDev);
                   DumpMembers();
               }
               if ( cnf_size() == 0) {
                    m_cnf_timer.StopTimer();
                    LOG(LOG_DBG,GetName(),"***Stop cnf timer");
               }
            }

            break;
        case CNFEV_OPEN_CONF_FAIL:
             SetSrlState(SRLSTATE_FAILED_FATAL);
             break;

        case CNFEV_OPEN_CONF:
             { PCNF_OPEN_CONF_RESULT pResult = static_cast<PCNF_OPEN_CONF_RESULT>(evtdata);
               SetName(pResult->szConfName);
               cnf_dump(pResult);
             }
             break;

        default:
             break;

    } // switch event

    CSrlDevice::HandleEvent(event, evtdata, evtlen, metaeventp);

 return;
} // End HandleEvent()



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// Purpose	: 
//    Constructor
// Parameters:	
//    [in ] Cnf Board ( that hosts this conference )
//    [in ] Configuration parameters ( from configuration file )
//    [in ] This Conference parameters ( from configuration file )
// Returns:	
//    none
//*****************************************************************************
CnfConference::CnfConference(PCnfBoard pCnfBoard, 
                             PCommonParams pCommonParams,
                             PCnfParams pCnfParams)
                  : CSrlDevice(DEV_CNFCONFERENCE, pCommonParams, 0) {


    conf_DTMFClamping = pCnfParams->dtmf_clamping ? ECNF_ATTR_STATE_ENABLED:   ECNF_ATTR_STATE_DISABLED;
    conf_DetectDigits = pCnfParams->detect_digits;
    conf_VoiceParty   = pCnfParams->voice_party;
    conf_BeepNotify   = pCnfParams->beep_notify;
    conf_PrivateLog   = pCnfParams->private_log;
    conf_Tmo = pCnfParams->tmo;
	conf_Id  = pCnfParams->cnf_id;
    conf_PassCode = 0;
    str_storestring(&conf_PassCode, pCnfParams->pass_code);
    SetCnfBoard( pCnfBoard );


    char buffer[256];
    snprintf(buffer, sizeof(buffer),"cnf_%d",conf_Id);
    SetName(buffer);        // temp name until CNFEV_OPEN returns actual name 
    OpenPrivateLog(conf_PrivateLog);

   SetDfltTimer(CONF_TMO);
   pCnfParams->Dump(GetLog());

// State Machine
    if (SetStateMachine(cnf_event_stru, cnf_action_stru) ){
       //
       // Open this Conference
          Open();
    }
 return;
} // End of Constructor()

//*****************************************************************************
// Purpose	: 
//    Destructor
// Parameters:	
//    none
// Returns:	
//    none
//*****************************************************************************
CnfConference::~CnfConference() {

 // Close Conference
    Close();

    str_deletestoredstring(&conf_PassCode);
 return;
} // End of Destructor()

//*****************************************************************************
// Purpose	: 
//    Open conference
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CnfConference::Open(){
 bool brc = false;
 int rc;
 
 CNF_ASSERT(GetCnfBoard(), "Missing m_pCnfBoard object");

    rc = cnf_OpenConference(GetCnfBoard()->GetSrlHandle(), 0, 0, this);

    LOG( RCHANDLE(rc), GetName(),
         "0x%x = cnf_OpenConference(0,0,0,0x%x(this))",
         rc,this);

    if ( rc == CNF_ERROR ) {
         process_cnf_error();
         SetCurrentState(S_FINAL);
         SetSrlState(SRLSTATE_FAILED_FATAL);
    }else {
         brc = true;
         m_srl_handle = rc;
         SetSrlState(SRLSTATE_OPENED);
         SetCurrentState(S_OPEN);
         GetCnfBoard()->PutEvent(USREV_CNF_OPEN, GetName());       

         if (conf_VoiceParty){
             open_dx();
             //set_dx_cst(DM_DIGITS);
         }
    }   
 return brc;
} // End of Open()

//*****************************************************************************
// Purpose	: 
//    Close conference
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CnfConference::Close(){
 bool brc = true;
 int rc;
    if( IsSrlState(SRLSTATE_OPENED, true) ){
        if ( IsSrlState(SRLSTATE_WAITEVENT, true) ){
             LOG( LOG_WARNING, GetName(),
                  "cnf_CloseConference() while waiting for event, state = %d %s",
                   GetCurrentState(), state_name(GetCurrentState()));
                   DumpMissingEvents();
        }
        if (cnf_size() > 0 ){
               LOG( LOG_WARNING, GetName(),
                    "cnf_Close() while parties are still in conferences");
        }
        CNF_CLOSE_CONF_INFO CloseInfo;

        // will post CNFEV_CONF_CLOSED to board
        rc = cnf_CloseConference(m_srl_handle, &CloseInfo);


//      This is RFU
//        cnf_dump(&CloseInfo);

        LOG( RC(rc), GetName(),
             "%d = cnf_CloseConference(0x%x)",
              rc, m_srl_handle);

        brc = (rc == 0);
        if (!brc){
            process_cnf_error();
        } else {
            m_srl_handle = INV_SRL_HANDLE;
        } 
        
    } // Is opened

    close_dx();

    SetCurrentState(S_FINAL);
    SetSrlState(SRLSTATE_ALL, RESET_SRL_STATE);
 
 return brc;
} // End of Close()

//*****************************************************************************
// Purpose	: 
//    Close this board if there are no more conferences
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CnfConference::TryClose(){
  if ( cnf_size() > 0 ){
       LOG(LOG_DBG, GetName(), "TryClose: cnf_size = %d", cnf_size());
       SetCurrentState(S_WAIT_SUBDEV);
       return false;
  }
  SetCurrentState(S_FINAL);
  Close();
  return false;
} // End of TryClose()
//*****************************************************************************
// Purpose	: 
//    Set conference attributes according to configuration parameters
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
#define MAX_ATTR 4
#define CHECK_INX   if (inx >= MAX_ATTR) {                  \
                        LOG(LOG_ERR2, GetName(), msg_txt,   \
                        __LINE__, __FILE__);                \
                        return false;                       \
                    }

bool CnfConference::SetAttributes(){
static const char *msg_txt = "Too many conference attributes. Increase MAX_ATTR. Line %d File %s";
    CNF_ATTR CnfAttr[MAX_ATTR];
    CNF_ATTR_INFO CnfAttrInfo;
    int inx = 0;
      CnfAttrInfo.unVersion = CNF_ATTR_INFO_VERSION_0; ///< Structure version
      CnfAttrInfo.pAttrList = CnfAttr;                 ///< Pointer to attribute structure list

      CnfAttr[inx].unVersion   = CNF_ATTR_VERSION_0 ;           ///< Structure version
      CnfAttr[inx].unAttribute = ECNF_CONF_ATTR_TONE_CLAMPING;  ///< Attribute type
      CnfAttr[inx].unValue     = conf_DTMFClamping;             ///< Attribute value
      ++inx;
      
#ifdef _FR2619
      if (conf_BeepNotify){
          CHECK_INX;   
          CnfAttr[inx].unVersion   = CNF_ATTR_VERSION_0 ;        ///< Structure version
          CnfAttr[inx].unAttribute = ECNF_CONF_ATTR_NOTIFY;      ///< Attribute type
          CnfAttr[inx].unValue     = ECNF_ATTR_STATE_ENABLED;    ///< or ECNF_ATTR_STATE_DISABLED
          ++inx;
      }
#endif
      if (conf_DetectDigits) {
          CHECK_INX;
          CnfAttr[inx].unVersion   = CNF_ATTR_VERSION_0 ;           ///< Structure version
          CnfAttr[inx].unAttribute = ECNF_CONF_ATTR_DTMF_MASK;      ///< Attribute type
          CnfAttr[inx].unValue     =   ECNF_DTMF_MASK_OP_SET 
                                     |  ECNF_DTMF_DIGIT_1 | ECNF_DTMF_DIGIT_2
                                     |  ECNF_DTMF_DIGIT_3 | ECNF_DTMF_DIGIT_4
                                     |  ECNF_DTMF_DIGIT_5 | ECNF_DTMF_DIGIT_6
                                     |  ECNF_DTMF_DIGIT_7 | ECNF_DTMF_DIGIT_8
                                     |  ECNF_DTMF_DIGIT_9 | ECNF_DTMF_DIGIT_0
                                     |  ECNF_DTMF_DIGIT_STAR | ECNF_DTMF_DIGIT_POUND
                                     |  ECNF_DTMF_DIGIT_A  |  ECNF_DTMF_DIGIT_B  
                                     |  ECNF_DTMF_DIGIT_C  | ECNF_DTMF_DIGIT_D ;
          ++inx;
      }

      CnfAttrInfo.unAttrCount = inx;   ///< Number of attribute structures in list

      bool brc = false;
      int rc;

      rc = cnf_SetAttributes(m_srl_handle, &CnfAttrInfo, this);

      cnf_dump(&CnfAttrInfo);
      LOG( RC(rc), GetName(),
           "%d = cnf_SetAttributes(0x%x,attr,0x%x(this))",
           rc, m_srl_handle, this);

 
        if (rc == CNF_ERROR) {
            process_cnf_error();
        }else {
            brc = true;
        }

   return brc;
} // End of SetAttributes()


//*****************************************************************************
// Purpose	: 
//    Enable events
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CnfConference::EnableEvents(){

    CNF_EVENT_INFO CnfEventInfo;
    unsigned int EventList[] = { 
         ECNF_CONF_EVT_DTMF_DETECTION,
         //ECNF_CONF_EVT_PARTY_ADDED,
         //ECNF_CONF_EVT_PARTY_REMOVED,
    };
    CnfEventInfo.unVersion = CNF_EVENT_INFO_VERSION_0;  ///< Structure version
    CnfEventInfo.unEventCount = sizeof(EventList)/sizeof(unsigned int);  ///< Number of events in list
    CnfEventInfo.punEventList = EventList;              ///< Pointer to event list

    bool brc = false;
    int rc;

    rc = cnf_EnableEvents(m_srl_handle, &CnfEventInfo, this);

    cnf_dump(&CnfEventInfo);

    LOG(RC(rc), GetName(), "%d = cnf_EnableEvents(0x%x, CNF_EVENT_INFO, 0x%x(this))",
                            rc,m_srl_handle,this);

    if ( rc == CNF_ERROR) {
         process_cnf_error();
    }else {
         brc = true;
    }

   return brc;
} // End of EnableEvents()


//*****************************************************************************
// Purpose	: 
//    Dump members
// Parameters:	
//    none
// Returns:	
//    none
//*****************************************************************************
void CnfConference::Dump(){
    LOG(LOG_APP, GetName(), "--Cnf Conference parameters");
    LOG(LOG_APP, GetName(), "  conf_Id           = %d", conf_Id);
    LOG(LOG_APP, GetName(), "  conf_DTMFClamping = '%s'", YESNO(conf_DTMFClamping));
    LOG(LOG_APP, GetName(), "  conf_DetectDigits = '%s'", YESNO(conf_DetectDigits));
    LOG(LOG_APP, GetName(), "  conf_VoiceParty   = '%s'", YESNO(conf_VoiceParty));
#ifdef _FR2619
    LOG(LOG_APP, GetName(), "  conf_BeepNotify   = '%s'", YESNO(conf_BeepNotify));
#endif
    LOG(LOG_APP, GetName(), "  conf_PassCode     = '%s'", conf_PassCode);
    LOG(LOG_APP, GetName(), "  conf_Tmo          = '%s'", conf_Tmo);
    LOG(LOG_APP, GetName(), "  conf_PrivateLog   = %d '%s'", conf_PrivateLog,log_get_msgtype_name(conf_PrivateLog));
 return;
} // End of Dump()


//*****************************************************************************
// Purpose	: 
//    Add a party to the conference
// Parameters:	
//    [in] party srl handle
//    [in] pointer to srl device that requests this action
// Returns:	
//    true = success
//*****************************************************************************
bool CnfConference::AddParty(SRL_DEVICE_HANDLE PartyHandle, PSrlDevice pDev){
 bool brc = true;
 int rc;
 CNF_PARTY_INFO PartyInfo;
 PartyInfo.unVersion = CNF_PARTY_INFO_VERSION_0;
 PartyInfo.unPartyCount = 1;
 PartyInfo.pPartyList = &PartyHandle;
   
   pDev->cnf_dump(&PartyInfo);
   rc = cnf_AddParty(m_srl_handle, &PartyInfo, pDev);

   pDev->GetLog()->Log(RC(rc), pDev->GetName(),
           "%d = cnf_AddParty(0x%x, party_handle = 0x%x ,0x%x(pDev))",
           rc, m_srl_handle, PartyHandle, pDev);


   if (rc == CNF_ERROR) {
        pDev->process_cnf_error();
   }else {
        brc = true;
        if (pDev != this){
            if ( conf_Tmo && (0 == cnf_size() ) ){
                 m_cnf_timer.StartTimer(conf_Tmo*1000);
                 LOG(LOG_DBG,GetName(),"***Start cnf timer for %d ms", conf_Tmo*1000);
            }
            push_back(pDev);
            DumpMembers();
        }
   }

 return brc;
} // End of AddParty()

//*****************************************************************************
// Purpose	: 
//    Remove a party to the conference
// Parameters:	
//    [in] party srl handle 
//    [in] pointer to srl device that requests this action
// Returns:	
//    true = success
//*****************************************************************************
bool CnfConference::RemoveParty(SRL_DEVICE_HANDLE PartyHandle, PSrlDevice pDev){
 bool brc = true;

	 int rc;
	 CNF_PARTY_INFO PartyInfo;
	 PartyInfo.unVersion = CNF_PARTY_INFO_VERSION_0;
	 PartyInfo.unPartyCount = 1;
	 PartyInfo.pPartyList = &PartyHandle;
   
	   pDev->cnf_dump(&PartyInfo);

	   rc = cnf_RemoveParty(m_srl_handle, &PartyInfo, pDev);


	   pDev->GetLog()->Log( RC(rc), pDev->GetName(),
			   "%d = cnf_RemoveParty(0x%x, party_handle = 0x%x ,0x%x(pDev))",
			   rc, m_srl_handle, PartyHandle, pDev);


	   if (rc == CNF_ERROR) {
			pDev->process_cnf_error();
	   }else {
			brc = true;
	   }
 return brc;

} // End of RemoveParty()

//----------------------------------------------------------------------
//   LOCAL VOICE   C O N F E R E N C E
//-----------------------------------------------------------------------
//*****************************************************************************
// Purpose	: 
//    join conference ( local dx device )
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CnfConference::AddPartyLocal(){

    return AddParty(m_cnf_party_srl_handle,this);
    
}// End of AddPartyLocal()

//*****************************************************************************
// Purpose	: 
//    Remove party from conference (local dx device)
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CnfConference::RemovePartyLocal(){

  return  RemoveParty(m_cnf_party_srl_handle, this);
}// End of RemovePartyLocal()

//*****************************************************************************
// Purpose	: 
//    If conf_VoiceParty, OpenParty, else post USREV_SKIP_VOICE_PARTY
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CnfConference::TryOpenParty(){
    if (conf_VoiceParty){
        return OpenParty();
    }
    PutEvent(USREV_SKIP_VOICE, GetName());
 return true;
}// End of TryOpenParty()
//*****************************************************************************
// Purpose	: 
//    If conf_VoiceParty, DevDisconnect(DX), else post USREV_SKIP_VOICE
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CnfConference::TryDevDisconnectDx(){
    if (conf_VoiceParty){
        return DevDisconnect(DEV_DX_PARTY);
    }
    PutEvent(USREV_SKIP_VOICE, GetName());
 return true;
}// End of TryCloseParty()
//*****************************************************************************
// Purpose	: 
//    Dump all members
// Parameters:	
//    none
// Returns:	
//    none
//*****************************************************************************
void CnfConference::DumpMembers(){
   LOG(LOG_APP, GetName(), "Conference Members: %d ", cnf_size());
   list<PSrlDevice>::iterator pos;
   PSrlDevice pDev;
   for ( pos = m_CnfList.begin(); pos != m_CnfList.end(); ++pos) {
         pDev = *pos;
         LOG(LOG_APP, GetName(), "  %s", pDev->GetName());
   } 
 return;
}

//*****************************************************************************
// Purpose	: 
//    Signal to all members all members
// Parameters:	
//    none
// Returns:	
//    none
//*****************************************************************************

bool CnfConference::SignalToMembers(int event){
   list<PSrlDevice>::iterator pos;
   PSrlDevice pDev;
   for ( pos = m_CnfList.begin(); pos != m_CnfList.end(); ++pos) {
       pDev = *pos;
       pDev->PutEvent(event,GetName());
   } 
 return true;
}
