/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************


// CnfConference.h: interface for the CConference class.
//
//////////////////////////////////////////////////////////////////////

#if !defined AFX_CNFCONFERENCE_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_
#define AFX_CNFCONFERENCE_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_


typedef class CnfConference *PCnfConference;

class CnfConference  : public CSrlDevice {
public:
	CnfConference( class CnfBoard *pBoard,
                   PCommonParams pCommonParams,
                   PCnfParams pCnfParams );

	virtual ~CnfConference();


    // Handle new event
    virtual void HandleEvent(int event,              // event code
                             void *evtdata,          // event data (if any)
                             int evtlen,             // event length    
                             METAEVENT *metaeventp); // metaevent

    virtual bool CheckTmo(){
        if ( m_cnf_timer.CheckTimer() ) {
             PutEvent(USREV_CNF_TIMEOUT, GetName() );
             LOG(LOG_DBG,GetName(),"***StopCnfTimer (Timer expired)");
        }
        return CSrlDevice::CheckTmo();
    }

    CTimer m_cnf_timer;  // measures conference timeout

// Conferencing Local voice device
private:
    bool AddPartyLocal();

    bool RemovePartyLocal();



public:
    virtual const char *action_name(int action);
    virtual const char *state_name(int state);

    virtual bool Execute(int action);

    virtual void dump_notification_data(int event, void *evtdata){
        // forward to cnf version
        cnf_dump_notification_data(event, evtdata);
    }

    void Dump();

    bool IsPassCode(const char *pass_code) {
         return COMPARE_EQUAL == str_compare(pass_code, conf_PassCode);
    }

    bool IsId(int id){
         return conf_Id == id;
    }


//  Conference actions
    bool AddParty(SRL_DEVICE_HANDLE PartyHandle, PSrlDevice pDev);
    bool RemoveParty(SRL_DEVICE_HANDLE PartyHandle, PSrlDevice pDev);

private:
    bool TryOpenParty();
    bool TryDevDisconnectDx();
    bool TryClose();
    bool SetAttributes();
    bool EnableEvents();
    bool Open();

protected:
    virtual bool Close();

public:
    ECNF_ATTR_STATE GetClamping(){
        return conf_DTMFClamping;
    }
private:
    ECNF_ATTR_STATE conf_DTMFClamping;    // DTMF Tone clamping
    bool  conf_DetectDigits;              // Detect digits
    bool  conf_VoiceParty;                // Include voice party
    bool  conf_BeepNotify;                // _FR2619
    MSG_TYPE conf_PrivateLog;
    int   conf_Tmo;                       // Timeout in seconds  
	int   conf_Id;                        // conference id
	char *conf_PassCode;                  // pass code 

public:
    int GetId(){
        return conf_Id;
    }
    const char *GetPasscode(){
        return conf_PassCode;
    }

// List of devices
// Not a container, because AreYouHandle and CheckTmo should not affect members
// Container
public:
    void push_back(PSrlDevice pDev){
        m_CnfList.push_back(pDev);
    }

    void erase(PSrlDevice pDev){
         m_CnfList.remove(pDev);
      return;
    }

    void remove(PSrlDevice pDev){
         m_CnfList.remove(pDev);
      return;
    }

    size_t cnf_size(){
        return m_CnfList.size();
    }
    
    void DumpMembers();


private:
    list <PSrlDevice > m_CnfList;

    bool SignalToMembers(int event);



}; // class CnfConference


#endif //AFX_CNFCONFERENCE_H__CC636419_19FE_40C5_B8F3_169025E4C405__INCLUDED_
