/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
//
// ConsoleLog.cpp: implementation of the ConsoleLog class.
// Log a message to console
//
//////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include "utils.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//*****************************************************************************
// Purpose	: 
//  Advance to the new line and log using console window 
// Parameters:	
//   [in]  message type
//   [in] message to log
// Returns:	
//    success (true / false ) 
//*****************************************************************************
bool ConsoleLog::doLog(MSG_TYPE msg_type, const char *message) {
int rc = 0;
    if (CanOutput(msg_type) ) {
        rc = printf( "\r%s"STR_NEWLINE, message );
    }
 return (rc >= 0);
}  //	End of ConsoleLog()
