/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// Dump structures and data
// Handle errors
//////////////////////////////////////////////////////////////////////

#include "pdl.h"

//////////////////////////////////////////////////////////////////////
//              Handle errors
//////////////////////////////////////////////////////////////////////
// ********************** Conference **********************

//*****************************************************************************
// Purpose	: 
//    log reasons for cnf error
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CSrlDevice::process_cnf_error(){
CNF_ERROR_INFO cnf_error_info;
int rc;
bool brc = true;
    rc = cnf_GetErrorInfo( &cnf_error_info );
    LOG(RC(rc), GetName(), "%d = cnf_Get_ErrorInfo( &cnf_error_info )", rc);
    if (rc == GC_SUCCESS) {
        LOG(LOG_ERR1, GetName(), "unVersion         = 0x%x",cnf_error_info.unVersion);
        LOG(LOG_ERR1, GetName(), "unErrorCode       = 0x%x",cnf_error_info.unErrorCode);
        LOG(LOG_ERR1, GetName(), "szErrorString     = '%s'",cnf_error_info.szErrorString);
        LOG(LOG_ERR1, GetName(), "szAdditionalInfo  = '%s'",cnf_error_info.szAdditionalInfo);    
    }else {
        brc = false;
    }
 return brc;
}  // End process_cnf_error()

//*****************************************************************************
// Purpose	: 
//    log reasons for gc error
// Parameters:	
//    none
// Returns:	
//    true = success
//*****************************************************************************
bool CSrlDevice::process_gc_error(){
GC_INFO gc_error_info;
int rc;
bool brc = true;
 CGenLog *pLog = GetLog();

 bool flag =  pLog->DefineChainLog(glb_pAppLog);
    rc = gc_ErrorInfo( &gc_error_info );
    LOG(RC(rc), GetName(), "%d = gc_ErrorInfo( &gc_error_info )", rc);
    if (rc == GC_SUCCESS) {
        gc_dump(&gc_error_info);
    }else {
        brc = false;
    }
    
 if (flag) {
    pLog->UnlinkChainedLog(glb_pAppLog);
 }
 // route to global function
 // return ::process_gc_error(GetName());
 return brc;
} // End process_gc_error()

//*****************************************************************************
// Purpose	: 
//    process latest devmgmt error
// Parameters:
//    none
// Returns:	
//    bool - false indicates error while processing
//*****************************************************************************
bool CSrlDevice::process_dev_error(){
DEV_ERRINFO ErrInfo;
 int rc = dev_ErrorInfo (&ErrInfo);
 LOG(RC(rc), GetName(), "%d = dev_ErrorInfo(&ErrInfo)");
 if (rc == DEV_SUCCESS){
     dev_dump(&ErrInfo);
 }
 return rc == DEV_SUCCESS;
} // End process_dev_error()

//*****************************************************************************
// Purpose	: 
//    process latest ipml error
// Parameters:
//    [in] ipml handle	
//    [in] object name - used for Log purposes (use device name or module name)
// Returns:	
//    bool - false indicates error while processing
//*****************************************************************************
bool CSrlDevice::process_ipml_error(SRL_DEVICE_HANDLE ipml_handle, const char *ipml_name){
  // process error return as shown
int rc;
const char *msg_txt;
    rc = ATDV_LASTERR( ipml_handle );
    msg_txt = ATDV_ERRMSGP(ipml_handle);

    LOG(LOG_ERR1, ipml_name, "%d = ATDV_LASTERR( 0x%x)", rc, ipml_handle);
    LOG(LOG_ERR1, ipml_name, "ATDV_ERRMSGP( 0x%x) = '%s'", rc, msg_txt);
 return true;
} // End process_dx_error()


//*****************************************************************************
// Purpose	: 
//    process latest voice error
// Parameters:
//    [in] voice handle	
//    [in] object name - used for Log purposes (use device name or module name)
// Returns:	
//    bool - false indicates error while processing
//*****************************************************************************
bool CSrlDevice::process_dx_error(SRL_DEVICE_HANDLE dx_handle, const char *dx_name){
  // process error return as shown
int rc;
const char *msg_txt;
    rc = ATDV_LASTERR( dx_handle );
    msg_txt = ATDV_ERRMSGP(dx_handle);

    LOG(LOG_ERR1, dx_name, "%d = ATDV_LASTERR( 0x%x)", rc, dx_handle);
    LOG(LOG_ERR1, dx_name, "ATDV_ERRMSGP( 0x%x) = '%s'", rc, msg_txt);
 return true;
} // End process_dx_error()

//////////////////////////////////////////////////////////////////////
//              Dump conference structures
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// For all dump Functions 
//    xxx_dump
// Purpose	: 
//    log specific structure
// Parameters:	
//    [in] structure to log
// Returns:	
//    none
//*****************************************************************************
void CSrlDevice::cnf_dump(CPCNF_ATTR pAttr ){
const char *attr_name = "";
    switch(pAttr->unAttribute){
        case ECNF_BRD_ATTR_ACTIVE_TALKER:
             attr_name = "ECNF_BRD_ATTR_ACTIVE_TALKER";
             break;

        case ECNF_BRD_ATTR_TONE_CLAMPING:
             attr_name = "ECNF_BRD_ATTR_TONE_CLAMPING";
             break;

        case ECNF_BRD_ATTR_NOTIFY_INTERVAL:
             attr_name = "ECNF_BRD_ATTR_NOTIFY_INTERVAL";
             break;

        case ECNF_CONF_ATTR_TONE_CLAMPING:
             attr_name = "ECNF_CONF_ATTR_TONE_CLAMPING";
             break;

        case ECNF_CONF_ATTR_DTMF_MASK:
             attr_name = "ECNF_CONF_ATTR_DTMF_MASK";
             break;

#    ifdef _FR2619
        case ECNF_CONF_ATTR_NOTIFY:
             attr_name = "ECNF_CONF_ATTR_NOTIFY";
             break;
#    endif
    }  // switch

    LOG(LOG_API, GetName(), "    CNF_ATTR Structure");
    LOG(LOG_API, GetName(), "      unVersion   = 0x%x",pAttr->unVersion);
    LOG(LOG_API, GetName(), "      unAttribute = 0x%x %s",pAttr->unAttribute, attr_name);
    LOG(LOG_API, GetName(), "      unValue     = 0x%x",pAttr->unValue);
 return;
}  // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump(CPCNF_ATTR_INFO pAttrInfo ){
    LOG(LOG_API, GetName(), "  CNF_ATTR_INFO Structure");
    LOG(LOG_API, GetName(), "    unVersion   = 0x%x",pAttrInfo->unVersion);
    LOG(LOG_API, GetName(), "    unAttrCount = %d",  pAttrInfo->unAttrCount);
    for (unsigned int inx = 0; inx < pAttrInfo->unAttrCount; inx++ ){
         cnf_dump(&(pAttrInfo->pAttrList[inx]));
    }
 return;
} // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump(CPCNF_DEVICE_COUNT_INFO pInfo ) {
    LOG(LOG_API, GetName(), "  CNF_DEVICE_COUNT_INFO Structure");
    LOG(LOG_API, GetName(), "    unVersion        = 0x%x",pInfo->unVersion);
    LOG(LOG_API, GetName(), "    unFreePartyCount = %d",  pInfo->unFreePartyCount);
    LOG(LOG_API, GetName(), "    unMaxPartyCount  = %d",  pInfo->unMaxPartyCount);
    LOG(LOG_API, GetName(), "    unFreeConfCount  = %d",  pInfo->unFreeConfCount);
    LOG(LOG_API, GetName(), "    unMaxConfCount   = %d",  pInfo->unMaxConfCount);
 return;
}  // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump(CPCNF_CLOSE_INFO pInfo ){
    LOG(LOG_API, GetName(), "  CNF_CLOSE_INFO Structure");
    LOG(LOG_API, GetName(), "    unVersion   = 0x%x",pInfo->unVersion);
 return;
}  // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump(CPCNF_PARTY_INFO pInfo ){
    LOG(LOG_API, GetName(), "  CNF_PARTY_INFO Structure");
    LOG(LOG_API, GetName(), "    unVersion    = 0x%x",pInfo->unVersion);
    LOG(LOG_API, GetName(), "    unPartyCount = %d",  pInfo->unPartyCount);
    size_t inx;
    for (inx = 0; inx< pInfo->unPartyCount; inx++){
         LOG(LOG_API, GetName(), "      unParty[%d]  = 0x%x",inx, pInfo->pPartyList[inx]);
    }
 return;
}  // End cnf_dump()

// ---------------------------------------------
static NAME_TABLE evt_table[] = {
    { "ECNF_CONF_EVT_PARTY_ADDED",    ECNF_CONF_EVT_PARTY_ADDED    }, ///< Enable/Disable party added
    { "ECNF_CONF_EVT_PARTY_REMOVED",  ECNF_CONF_EVT_PARTY_REMOVED  }, ///< Enable/Disable party removed
    { "ECNF_CONF_EVT_DTMF_DETECTION", ECNF_CONF_EVT_DTMF_DETECTION }, ///< Enable/Disable DTMF detected
    { "ECNF_CONF_EVT_ACTIVE_TALKER",  ECNF_CONF_EVT_ACTIVE_TALKER  }, ///< Enable/Disable active talker

    { "ECNF_BRD_EVT_CONF_OPENED",     ECNF_BRD_EVT_CONF_OPENED     }, ///< Enable/Disable conference opened
    { "ECNF_BRD_EVT_CONF_CLOSED",     ECNF_BRD_EVT_CONF_CLOSED     }, ///< Enable/Disable conference closed
    { "ECNF_BRD_EVT_PARTY_ADDED",     ECNF_BRD_EVT_PARTY_ADDED     }, ///< Enable/Disable party added 
    { "ECNF_BRD_EVT_PARTY_REMOVED",   ECNF_BRD_EVT_PARTY_REMOVED   }, ///< Enable/Disable party removed
    { "ECNF_BRD_EVT_ACTIVE_TALKER",   ECNF_BRD_EVT_ACTIVE_TALKER   }, ///< Enable/Disable active talker    
    { 0,0}
};
void CSrlDevice::cnf_dump(CPCNF_EVENT_INFO pInfo ){
    LOG(LOG_API, GetName(), "  CNF_EVENT_INFO Structure");
    LOG(LOG_API, GetName(), "    unVersion    = 0x%x",pInfo->unVersion);
    LOG(LOG_API, GetName(), "    unEventCount = %d",  pInfo->unEventCount);
    for (unsigned int inx = 0; inx < pInfo->unEventCount; inx++){
         const char *evt_name;
         str_findname(pInfo->punEventList[inx], &evt_name, evt_table);
         LOG(LOG_API, GetName(), "      unEventList[%d] = %d %s",
                 inx, pInfo->punEventList[inx], evt_name);
    }
  return;
}  // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump( CPCNF_CONF_OPENED_EVENT_INFO pInfo ){
      LOG( LOG_API, GetName(),
           "CNFEV_CONF_OPENED ( %s, handle = 0x%x)",
           pInfo->szConfName, pInfo->ConfHandle );
 return;
}  // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump( CPCNF_CONF_CLOSED_EVENT_INFO pInfo ){
      LOG( LOG_API, GetName(),
           "Event info: Name = %s", pInfo->szConfName);

 return;
}  // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump( CPCNF_PARTY_ADDED_EVENT_INFO pInfo ){
      LOG( LOG_API, GetName(),
           "PCNF_PARTY_ADDED_EVENT_INFO ( conf = {%s, handle = 0x%x}, party={%s handle = 0x%x})",
            pInfo->szConfName, pInfo->ConfHandle,
            pInfo->szPartyName, pInfo->PartyHandle);
 return;
}  // End cnf_dump()


// ---------------------------------------------
void CSrlDevice::cnf_dump( CPCNF_PARTY_REMOVED_EVENT_INFO pInfo ){
      LOG( LOG_API, GetName(),
           "PCNF_PARTY_REMOVED_EVENT_INFO ( conf = {%s, handle = 0x%x}, party={%s handle = 0x%x})",
            pInfo->szConfName, pInfo->ConfHandle,
            pInfo->szPartyName, pInfo->PartyHandle);
 return;
}  // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump(  CPCNF_OPEN_PARTY_RESULT pResult ){
    LOG(LOG_API, GetName(), "  CNF_OPEN_PARTY_RESULT Structure");
    LOG(LOG_API, GetName(), "    PartyName   = %s",pResult->szPartyName);
    LOG(LOG_API, GetName(), "    Partyhandle = 0x%x",pResult->PartyHandle);
 return;
}  // End cnf_dump()

//======================================================================
static NAME_TABLE digit_table[] = {
    { "ECNF_DTMF_DIGIT_1",     ECNF_DTMF_DIGIT_1    },
    { "ECNF_DTMF_DIGIT_2",     ECNF_DTMF_DIGIT_2    },
    { "ECNF_DTMF_DIGIT_3",     ECNF_DTMF_DIGIT_3    },
    { "ECNF_DTMF_DIGIT_4",     ECNF_DTMF_DIGIT_4    },
    { "ECNF_DTMF_DIGIT_5",     ECNF_DTMF_DIGIT_5    },
    { "ECNF_DTMF_DIGIT_6",     ECNF_DTMF_DIGIT_6    },
    { "ECNF_DTMF_DIGIT_7",     ECNF_DTMF_DIGIT_7    },
    { "ECNF_DTMF_DIGIT_8",     ECNF_DTMF_DIGIT_8    },
    { "ECNF_DTMF_DIGIT_9",     ECNF_DTMF_DIGIT_9    },
    { "ECNF_DTMF_DIGIT_0",     ECNF_DTMF_DIGIT_0    },
    { "ECNF_DTMF_DIGIT_STAR",  ECNF_DTMF_DIGIT_STAR },
    { "ECNF_DTMF_DIGIT_POUND", ECNF_DTMF_DIGIT_POUND},
    { "ECNF_DTMF_DIGIT_A",     ECNF_DTMF_DIGIT_A    },
    { "ECNF_DTMF_DIGIT_B",     ECNF_DTMF_DIGIT_B    },
    { "ECNF_DTMF_DIGIT_C",     ECNF_DTMF_DIGIT_C    },
    { "ECNF_DTMF_DIGIT_D",     ECNF_DTMF_DIGIT_D    },
    { 0,0}
};
void CSrlDevice::cnf_dump(CPCNF_DTMF_EVENT_INFO  pInfo ){
  const char *digit_name;
  str_findname(pInfo->eDigit,&digit_name, digit_table);
      LOG( LOG_API, GetName(),
           "CPCNF_DTMF_EVENT_INFO ( digit = %0x%x %s, partyhandle = 0x%x)",
           pInfo->eDigit, digit_name, pInfo->PartyHandle);
 return;
}  // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump(CPCNF_ACTIVE_TALKER_INFO  pInfo ){
      LOG( LOG_API, GetName(),
           "CPCNF_ACTIVE_TALKER_INFO ( party count = %d)",
            pInfo->unPartyCount);
      unsigned int inx;
      for (inx = 0; inx < pInfo->unPartyCount; inx++){
           LOG( LOG_API, GetName(),
                "  party[%d] = (srl_handle = 0x%x)",
                pInfo->pPartyList[inx]);
      }
 return;
}   // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump(CPCNF_CLOSE_CONF_INFO pInfo){
    LOG(LOG_API, GetName(), "  CNF_CLOSE_CONF_INFO Structure");
    LOG(LOG_API, GetName(), "    unVersion   = 0x%x",pInfo->unVersion);
 return;
}  // End cnf_dump()

// ---------------------------------------------
void CSrlDevice::cnf_dump(CPCNF_OPEN_CONF_RESULT pResult){
    LOG(LOG_API, GetName(), "  CNF_OPEN_CONF_RESULT Structure");
    LOG(LOG_API, GetName(), "    unVersion   = 0x%x", pResult->unVersion);
    LOG(LOG_API, GetName(), "    szConfName  = '%s'", pResult->szConfName);
    LOG(LOG_API, GetName(), "    ConfHandle  = %d",   pResult->ConfHandle);
 return;
}  // End cnf_dump()

//*****************************************************************************
// Purpose	: 
//    Dump info related to cnf notification events
// Parameters:	
//    [in] event,
//    [in] event data
// Returns:	
//    none
//*****************************************************************************
void CSrlDevice::cnf_dump_notification_data(int event, void *eventdata){
  switch (event){
        case CNFEV_CONF_OPENED:
             cnf_dump( (CPCNF_CONF_OPENED_EVENT_INFO) eventdata);
             break;

        case CNFEV_CONF_CLOSED:
             cnf_dump( (CPCNF_CONF_CLOSED_EVENT_INFO) eventdata);
             break;

        case CNFEV_PARTY_ADDED:
             cnf_dump( (CPCNF_PARTY_ADDED_EVENT_INFO) eventdata);
             break;

        case CNFEV_PARTY_REMOVED:
             cnf_dump( (CPCNF_PARTY_REMOVED_EVENT_INFO) eventdata);
             break;

        case CNFEV_DTMF_DETECTED:
             cnf_dump( (CPCNF_DTMF_EVENT_INFO) eventdata);
             break;

        case CNFEV_ACTIVE_TALKER:
             cnf_dump( (CPCNF_ACTIVE_TALKER_INFO) eventdata);
             break;
    // --- End Notifications ---
  }
 return;
}  // End cnf_dump_notification_data()

//////////////////////////////////////////////////////////////////////
//              Dump ntwk structures
//////////////////////////////////////////////////////////////////////

//*****************************************************************************
// Purpose	: 
//    Dump info related to gc notification events
// Parameters:	
//    [in] event,
//    [in] event data
// Returns:	
//    none
//*****************************************************************************
void CSrlDevice::gc_dump_notification_data(int event, void *eventdata){
  UNREFERENCED_PARAMETER(event);
  UNREFERENCED_PARAMETER(eventdata);
  // TBD place here code to dump GCEV_EXTENSION, etc
  //switch (event){
  //}
  return;
}  // End gc_dump_notification_data()


//*****************************************************************************
// Purpose	: 
//    log structure SC_TSINFO
// Parameters:	
//    [in] structure to log
// Returns:	
//    none
//*****************************************************************************
void CSrlDevice::gc_dump(SC_TSINFO *pInfo){
  unsigned long inx;
  LOG(LOG_API, GetName(), "  SC_TSINFO Structure");
  LOG(LOG_API, GetName(), "    sc_numts         = %d",pInfo->sc_numts);
  for(inx = 0; inx < pInfo->sc_numts; inx++){
     LOG(LOG_API, GetName(), "      sc_tsarrayp[%d] = %d",  inx, pInfo->sc_tsarrayp[inx]);
  }
 return;
}// End gc_dump()

//*****************************************************************************
// Purpose	: 
//    log structure GC_INFO
// Parameters:	
//    [in] structure to log
// Returns:	
//    none
//*****************************************************************************
void CSrlDevice::gc_dump(GC_INFO *pInfo){
// forward to global version
    ::gc_dump(pInfo, LOG_API, GetLog(), GetName());
 return;
} // End gc_dump()


//////////////////////////////////////////////////////////////////////
//              Dump dev structures
//////////////////////////////////////////////////////////////////////

//*****************************************************************************
// Purpose	: 
//    log structure DEV_ERRINFO
// Parameters:	
//    [in] structure to log
// Returns:	
//    none
//*****************************************************************************
void CSrlDevice::dev_dump(DEV_ERRINFO * pInfo){
  LOG(LOG_API, GetName(), "  DEV_ERRINFO Structure");
  LOG(LOG_API, GetName(), "    dev_ErrValue          = %d",pInfo->dev_ErrValue);
  LOG(LOG_API, GetName(), "    dev_SubSystemErrValue = %d",pInfo->dev_SubSystemErrValue);
  LOG(LOG_API, GetName(), "    dev_Msg               = %s",pInfo->dev_Msg);
 return;
} // End dev_dump()


//////////////////////////////////////////////////////////////////////
//              Dump dx structures
//////////////////////////////////////////////////////////////////////

static NAME_TABLE cst_table[] = {
    { "DE_RINGS",     DE_RINGS     },
    { "DE_SILON",     DE_SILON     },
    { "DE_SILOF",     DE_SILOF     },
    { "DE_LCON",      DE_LCON      },
    { "DE_LCOF",      DE_LCOF      },
    { "DE_WINK",      DE_WINK      },
    { "DE_RNGOFF",    DE_RNGOFF    },
    { "DE_DIGITS",    DE_DIGITS    },
    { "DE_DIGOFF",    DE_DIGOFF    },
    { "DE_LCREV",     DE_LCREV     },
    { "DE_TONEON",    DE_TONEON    },
    { "DE_TONEOFF",   DE_TONEOFF   },
    { "DE_STOPRINGS", DE_STOPRINGS },
    { "DE_VAD",       DE_VAD       },
    { "DE_UNDERRUN",  DE_UNDERRUN  },
    { 0,0 }
};

//*****************************************************************************
// Purpose	: 
//    log structure DX_CST
// Parameters:	
//    [in] structure to log
// Returns:	
//    none
//*****************************************************************************
void CSrlDevice::dx_dump(DX_CST * pCst){
  const char *event_name;
  str_findname(pCst->cst_event,&event_name, cst_table);

  LOG(LOG_API, GetName(), "  DX_CST Structure");
  LOG(LOG_API, GetName(), "    cst_event   = %d %s",    pCst->cst_event, event_name);
  LOG(LOG_API, GetName(), "    cst_data    = %d (0x%x)",pCst->cst_data,pCst->cst_data);
  
  return;
}

