/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// GenLog.cpp: implementation of the CGenLog class.
//
//////////////////////////////////////////////////////////////////////
// ignore MSC2005 vsnprintf/vsnprintf_s security warning

#include <stdarg.h>
#define _CRT_SECURE_NO_WARNINGS
#include "utils.h"
#undef _CRT_SECURE_NO_WARNINGS


//
//  Message  ===> LOG Object =====> Log Object ===> 
//              (check verbosity)   (check verbosity)
//                  |                    |
//                  V                    V
//                 Log                  Log 

// see header file:
// enum { 
//     LOG_DBF = 0,
//     LOG_API,
//     LOG_EVT,
//     LOG_APP,
//     LOG_WARN,
//     LOG_ERR1,
//     LOG_ERR2,
//     LOG_ASSERT,
//     LOG_NONE,
//     MSG_TYPE_MAX
// }; 

// max number of chained logs
#define MAX_CHAINED_LOG 10


static NAME_TABLE log_table_stru[] = {
    {"DBG",     LOG_DBG     },
    {"API",     LOG_API     },
    {"EVT",     LOG_EVT     },
    {"APP",     LOG_APP     },
    {"WARNING", LOG_WARNING },
    {"ERROR",   LOG_ERR1    },
    {"FATAL",   LOG_ERR2    },
    {"ASSERT",  LOG_ASSERT  },
    {"ALL",     LOG_ALL     },
    {"NONE",    LOG_NONE    }, 
    { 0,0}
};
static CNameTable log_table(log_table_stru);

const char *LOG_MODULE_NAME = "LOG";

//////////////////////////////////////////////////////////////////////
// Global functions
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// Purpose	: 
//    Get message name from given type
// Parameters:	
//    [in] type
// Returns:	
//    name ("????" indicates unknown)
//*****************************************************************************
const char *log_get_msgtype_name(MSG_TYPE msg_type){
    return log_table.find_name(msg_type);
}  //	End of log_get_msgtype_name()

//*****************************************************************************
// Purpose	: 
//    Get message type from given name
// Parameters:	
//    [in] char *name
// Returns:	
//    MSG_TYPE  ( returns MSG_TYPE_MAX in case of unresolved value )
//*****************************************************************************
MSG_TYPE log_get_msgtype_value(const char *name){

MSG_TYPE msg_type = (MSG_TYPE)log_table.find_code(name);
  if (msg_type == (MSG_TYPE)-1) {
      msg_type = MSG_TYPE_MAX;
  }
  return  msg_type;
}  //	End of log_get_msgtype_value()

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
//*****************************************************************************
// Purpose	: 
//    Constructor
// Parameters:	
//    no
// Returns:	
//    no
//*****************************************************************************
CGenLog::CGenLog(){
   m_pNextLog = 0;        // no chained log
   m_verbosity = LOG_DBG;     // log all
   m_num_log_records = 0; // Number of lines logged so far
}  //	End of CGenLog()

//*****************************************************************************
// Purpose	: 
//    Destructor
// Parameters:	
//    no
// Returns:	
//    no
//*****************************************************************************
CGenLog::~CGenLog(){
   DeleteNextLog();
   list<char *>::iterator pos;
   char *ptxt;

   for ( pos = m_FatalMessages.begin(); pos != m_FatalMessages.end(); ++pos) {
       ptxt = *pos;  
       str_deletestoredstring(&ptxt);
   } 
}  //	End of ~CGenLog()

//*****************************************************************************
// Purpose	: 
//    Display exit reason messages (anything marked as LOG_ERR2 or LOG_ASSERT)
// Parameters:	
//    [in] pointer to log file to use for output
// Returns:	
//    none
//*****************************************************************************
void CGenLog::Dump(CGenLog *pLog){
    if (pLog == 0){
        pLog = this;
    }
    if (m_FatalMessages.size() > 0 ) {
        pLog->Log(LOG_ALL, LOG_MODULE_NAME, "\n");

        pLog->Log(LOG_ALL, LOG_MODULE_NAME, "Reason:");
        list<char *>::iterator pos;
        char *ptxt;
        for ( pos = m_FatalMessages.begin(); pos != m_FatalMessages.end(); ++pos) {
            ptxt = *pos;
            pLog->Log(LOG_ALL, LOG_MODULE_NAME, "  %s", ptxt);
        } 
    }
 return;
}  //	End of Dump()

//*****************************************************************************
// Purpose	: 
//    Define other log to route log messages
// Parameters:	
//    CGenLog object ptr
// Returns:	
//    true if success
//    false if recursive chain or too many nested logs are detected
//*****************************************************************************
bool CGenLog::DefineChainLog(CGenLog *pNextLog){

  // Check recursive link
   size_t cnt = 0;
   CGenLog *pLog = pNextLog;
   while( pLog ){   // max chained log objects
        if (this == pLog){
            // OOPS ! recursive chain 
            return false;
        }
        pLog = pLog->m_pNextLog;
        if ( cnt++ > MAX_CHAINED_LOG){
             return false;
        }
   } // while
   
   // Chain requested log
   m_pNextLog = pNextLog;
  return true;
}  //	End of DefineChainLog()


//*****************************************************************************
// Purpose	:
//    if requested msg_type is appropriate, add the information to the log 
//    Add same info to chained logs 
//     
// Parameters:	
//    [in] verbosity level
//    [in] string that identifies object that sends log message (such as "dxxxB1C1")
//    [in] format & parameters, printf style
// Returns:	
//    true = success
//    false - at least one output filed
// Limitation: output message is truncated to max 512 bytes  
//*****************************************************************************
bool CGenLog::Log(MSG_TYPE msg_type,
                  const char * source,
                  const char * format, ...) {

// regular format
#define FORMAT_THREAD  "%-15s0x%-6x%-8s%-12s %s"
#define FORMAT         "%-15s%-8s%-12s %s"
// empty line before each event
#define FORMAT_EVT  STR_NEWLINE FORMAT;

char msg_buffer[MAXTOKEN];   
bool brc = true;

 if (WillLog(msg_type) ) { 
     // Make message
       va_list ap;
          va_start(ap,format);
	      vsnprintf(msg_buffer, sizeof(msg_buffer), format, ap);
       va_end(ap);

       char msg_output[MAXTOKEN*2];
       const char *fmt = FORMAT;
       if (msg_type == LOG_EVT) {
           fmt = FORMAT_EVT;
       }
       snprintf(msg_output, sizeof(msg_output),
                            fmt,
                            time_asstring(),
                            //GETTHREADID(),
                            log_get_msgtype_name(msg_type),
                            source, msg_buffer);

     // Log it! using virtual device specific doLog
       brc = doLog(msg_type,msg_output);

       if ( brc ){
           // Count log records
           ++m_num_log_records;
       } 

     // Chain next log
       CGenLog *pNextLog = m_pNextLog;
       while ( pNextLog) {
               brc = pNextLog->doLog(msg_type, msg_output) || brc;
               pNextLog = pNextLog->m_pNextLog;
       } // while

       // Keep fatal messages in order to display reason for exit
       if (   ( msg_type == LOG_ERR2)
           || ( msg_type == LOG_ASSERT) ) {
          char *txt = 0;  
          char buf1[MAXTOKEN];
          snprintf(buf1, sizeof(buf1),"%s %s", source, msg_buffer);
          str_storestring(&txt, buf1);
          m_FatalMessages.push_back(txt);
       }

 } // if WillPrint

 if (   ( msg_type == LOG_ERR2)
     || ( msg_type == LOG_ASSERT) ) {
      // request exit if fatal message is encountered
      glb_exit_request(true, true);
 } // If fatal error

 return brc;
}  //	End of Log()
