/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// IptDevice.h: interface for the CIptDevice class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_IPTDEVICE_H__8F5693B3_2FB3_4FE9_9CF9_9E9C8C004378__INCLUDED_)
#define AFX_IPTDEVICE_H__8F5693B3_2FB3_4FE9_9CF9_9E9C8C004378__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SdpParser.h"

typedef enum {
 DATA_NONE,
 DATA_CHAR,
 DATA_UCHAR,
 DATA_SHORT,
 DATA_USHORT,
 DATA_INT,
 DATA_UINT,
 DATA_STRING,
 DATA_STRUCT,
 DATA_OCTETS, // array of octets
}DATA_TYPE;


bool  ip_get_setid_name( int set_id, int parm_id,
                         const char *setid_name,
                         const char *parmid_name,
                         DATA_TYPE *type);


typedef class CnfDemoResourceList * PCnfDemoResourceList;

class CnfDemoResourceList: public DEV_RESOURCE_LIST {
public:
    CnfDemoResourceList();
    virtual ~CnfDemoResourceList(){};
    void Dump(CGenLog *pLog);
    void Init(IPM_CODER_INFO *pCoder);
    RESERVE_RESOURCE_TYPE m_type;        // Resource reserved
};




typedef class CIptDevice * PIptDevice;

class CIptDevice : public CNtwkDevice{
public:
	CIptDevice( PCommonParams pCommonParams,
                PIptParams pIptParams);
	virtual ~CIptDevice();
    // Handle new event
    virtual void HandleEvent(int event,              // event code
                             void *evtdata,          // event data (if any)
                             int evtlen,             // event length    
                             METAEVENT *metaeventp); // metaevent


    bool Open();

protected:
    virtual bool Close();
    virtual bool AnswerCall();
    virtual bool AcceptCall();
    virtual bool DropCall();
    virtual bool ResetLineDev();
    virtual bool ModifyCall();

    // 3PCC mode
private:
    bool StartMedia();
    bool StopMedia();
    bool EnableIpmlEvents();
    bool GetLocalMediaInfo(eIPM_MEDIA_TYPE type, IPM_PORT_INFO * pInfo);
    void RetrieveIpData(METAEVENT *metaeventp);
    bool SelectCoder();
	bool MakeSdpMessage(int sdp_type);
//------------------
// ReserveDevice
    bool ReserveResource();
    bool UnReserveResource();


private:
    IPM_CODER_INFO selected_coder;
    void OnReceiveAlarmEvent(IPM_QOS_ALARM_DATA *alarm_data);



    void DumpMediaInfo(IPM_MEDIA_INFO *pMediaInfo);
    void DumpMediaData(IPM_MEDIA *pMediaData);
    void DumpPortInfo(IPM_PORT_INFO *pPortInfo);
    void DumpAudioCoderInfo(IPM_AUDIO_CODER_INFO *pCoder);

public:
    void Dump();
    virtual bool OnNewCall();
    virtual bool OnInitComplete();

	virtual bool Is3PCCMode(){
		return m_pCommonParams->Is3PCCMode();
	}

    virtual RESERVE_RESOURCE_TYPE GetReserveResourceType() {
		  return m_pCommonParams->GetReserveResourceType();
	}


private:
    virtual bool DoAcceptCall(){
		 return m_pIptParams->m_accept_call;
	}

	//
    void dump_parm(GC_PARM_DATA_EXT *parm);
    bool SetCoders();

    bool Set3PCCCoders();
    bool Set1PCCCoders();

    bool SetDtmfTransfer();
    bool EnableEchoCancel();
    bool GetMediaResourceHandle();

	bool OpenIpml();			 // 3PCC mode only

private:
	CnfDemoResourceList dev_resource_list;
//-------------------------

private:
    const char *m_ipm_name;
    PIptParams m_pIptParams;
	CSdpParser *m_pSdpParser;	 // parce SDP responce in 3PCC mode
    IPM_PORT_INFO m_LocalRtpPort;
    IPM_PORT_INFO m_LocalRtcpPort;

    bool m_ipm_started;

}; // class IptDevice

#endif // !defined(AFX_IPTDEVICE_H__8F5693B3_2FB3_4FE9_9CF9_9E9C8C004378__INCLUDED_)
