/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// StateMachine.h: interface for the CStateMachine class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_STATEMACHINE_H__848F0D9A_8E4B_46C8_B757_C4F9CC427E90__INCLUDED_)
#define AFX_STATEMACHINE_H__848F0D9A_8E4B_46C8_B757_C4F9CC427E90__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//------------------------------
// Pre - defined states, events and actions

// Any event
#define EVENT_ANY (-1)          // indicates any event

// Common States
#define S_END         (-1)      // marker for end
#define S_FINAL       (-2)      // Final state
#define S_ANY         (-3)      // indicates any state
#define S_SAME        (-4)      // indicates no changes
#define S_BEGIN       (-5)      // Initial state 
#define S_OPEN        (-6)      // Waiting event XXX_OPEN
#define S_OPEN_EXIT   (-7)      // Exiting while waiting event XXX_OPEN
#define S_RELAX       (-8)      // Wait calls
#define S_RELAXCNF    (-9)      // Inside conference
#define S_WAIT_SUBDEV (-10)     // wait sub devices to close

// Common Actions
#define A_NONE        (-1)        // do nothing, ignore exit request
#define A_RELAX       (-2)        // relax (outside conference, ex. wait a call)
#define A_RELAXCNF    (-3)        // relax (in conference)
#define A_CLOSE       (-4)        // close this device
#define A_ERROR       (-5)        // Indicate state machine error
#define A_EXIT        (-6)        // Exit 
#define A_GIVEUP      (-7)        // Do nothing and advance to the final state

// Begin search 
#define BEGIN_SEARCH (-1)

//----------------------------------------------------------
// 
typedef struct {
// Key to search
  int current_state;       // indicates current state, STATE_ANY for any
  int action;              // indicates action to execute

// what to do if action pass
  int state_if_pass;       // indicates next state if action passed

// what to do if action failed
  int action_if_fail;      // recover action to perform in case 'action' failed  

}ACTION_STRU, *PACTION_STRU;

//----------------------------------------------------------
typedef struct {
// Key to search
    int current_state;   // indicates current state, STATE_ANY for any
    int event;           // indicates possible event

// What to do
    int action;          // indicates action to execute

}EVENT_STRU, *PEVENT_STRU;


// return name for given state(action)
extern const char *common_state_name(int state);
extern const char *common_action_name(int action);

// where program can spend unlimited time (waiting call, in conference)
extern bool is_relaxed_state(int state);

// State machine description
typedef class CStateMachine *PStateMachine;

class CStateMachine {
  friend class CSrlDevice;
  public:
	 CStateMachine(EVENT_STRU * pEventStru, ACTION_STRU *pActionStru) {
        m_pEventStru = pEventStru;
        m_pActionStru = pActionStru;
        m_current_state = S_BEGIN;
        return;
     } 

     virtual ~CStateMachine(){
     };

     // returns matched line
     bool FindInStates (int state, int event,  PEVENT_STRU  *ppNewStateLine);
     bool FindInActions(int state, int action, PACTION_STRU *ppNewActionLine);

     // sets current state
     void SetCurrentState(int state){
          if (    (state != S_SAME) 
               && (m_current_state != S_FINAL) ) {
             m_current_state = state;
          }
     };

     // Returns current state
     int GetCurrentState(void){
         return m_current_state;
     };

     // Enumerator for possible events that can advance state machine at this moment
     bool EnumMissingEvents(int *missing_event, int *handle);


     // Validate state machine
     bool Validate(class CSrlDevice *pDev);

  private:
     PEVENT_STRU  m_pEventStru;  // array with state transitions
     PACTION_STRU m_pActionStru; // array with action transitions
     int m_current_state;
};

#endif // !defined(AFX_STATEMACHINE_H__848F0D9A_8E4B_46C8_B757_C4F9CC427E90__INCLUDED_)
