/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2006-2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//***********************************************************************
//***********************************************************************
// pdl.h: include common header files & declarations
//
//////////////////////////////////////////////////////////////////////

#ifndef PDL_HEADER
#define PDL_HEADER



// Utilities
#include "utils.h"

// Dialogic
#include "dialogic.h"

// Version adjust
#include "product_versions.h"

// Parameters
#include "CnfDemoPrm.h"



// Application exit codes
typedef enum {
  EXIT_OK,      // 0 normal
  EXIT_CFG,     // 1 configuration file error
  EXIT_INIT,    // 2 initialization (resource, dcm started? )
  EXIT_LOG,     // 3 log file
  EXIT_START,   // 4 fatal failure while open/initial procedures
  EXIT_VALIDATE,// 5 validate state machine
  EXIT_FAIL     // 6 fatal failure while running
} EXIT_CODE;

// -------------------------------------------------------------------------
// A small object that can set exit code
typedef class HasExitCode *PHasExitCode;
class HasExitCode {
    public:
        HasExitCode(){
            m_exit_code= EXIT_OK;
        }
    virtual ~HasExitCode(){ };

private:
    EXIT_CODE m_exit_code;

protected:
    void SetExitCode(EXIT_CODE code){
        m_exit_code = code;
    }
public:
    EXIT_CODE GetExitCode(){
        return m_exit_code;
    }
}; // class HasExitCode



// Global Log
#define GLBLOGOBJ glb_pAppLog
#define GLBLOG GLBLOGOBJ->Log
extern class CGenLog     * glb_pAppLog;       // Application log

// Detect configuration
#include "DetectCfg.h"
extern class CDetectCfg  * glb_pDetectCfg;    // Detected configuration


// gc_wrapper
extern bool process_gc_error(const char *name);
extern void gc_dump(GC_START_STRUCT *pStart, MSG_TYPE Msg, CGenLog *pLog, const char *name);
extern void gc_dump(CCLIB_START_STRUCT *pStart, MSG_TYPE Msg, CGenLog *pLog, const char *name);
extern void gc_dump(GC_INFO *pInfo, MSG_TYPE Msg, CGenLog *pLog, const char *name);


extern bool gc_start_wrapper(CnfDemoPrm  * pAppParams);
extern bool gc_stop_wrapper();

#define MAX_SDP_MESSAGE	1024	// length of SDP message

// Constants
#define SRL_TMO 10     // milliseconds

#define BOARD_TMO  10000    // board timeout
#define CONF_TMO   8000     // conference timeout
#define NTWK_TMO   5000     // device  timeout

#define VOICE_TMO  20000    // playfile / getdigits timeout



#define APP_TMO 15000         // Default timeout: 15 sec to complete next action
#define APP_TMO_SHORT 5000    // Default short timeout: 3 sec to complete next action



// User defined events
#define EVENT_USER	0x2710	// Starting point 10000 = 0x2710
enum {
     USREV_EXIT_REQUEST = EVENT_USER,   // Exit request
     USREV_TIMEOUT,                     // Timed out waiting for event
     USREV_CNF_TIMEOUT,                 // Conference timed out
     USREV_CHECK_PASS,                  // Conference with given passwd found
     USREV_CHECK_FAIL,                  // Conference with given passwd not found - drop the call
     USREV_CHECK_RETRY,                 // Conference with given passwd not found - retry

     USREV_CNF_OPEN,                    // A signal from Conference to its parent board
     USREV_PARTY_REMOVED,               // A signal from Device to its conference


     USREV_LEAVE_CNF,                   // Leave conference ( signal from conference to party )
     USREV_BEEP_OUT,                    // indicate leave 
     USREV_BEEP_IN,                     // indicate join
     USREV_BEEP_END,                    // indicate end
     USREV_SKIP_VOICE,                  // skip voice party for conference
     USREV_SKIP_ACCEPT,                 // skip AcceptCall and proceed with answer

     USREV_IPML_LISTEN,                 // skip AcceptCall and proceed with answer

     USREV_LAST
};


// Srl & devices
#include "StateMachine.h"

#include "SrlDevice.h"
#include "SrlDeviceContainer.h"
#include "SrlThread.h"

#include "CnfConference.h"
#include "CnfBoard.h"

#include "NtwkDevice.h"
#include "PstnDevice.h"
#include "IptDevice.h"


// Global container conferences
extern ConferencePool *glb_pConferencePool; // Container for all conference boards




#endif //PDL_HEADER

