//***********************************************************************
// Copyright  2005, Intel Corporation. 
// All rights reserved All names, products, and services mentioned  
// herein are the trademarks or registered trademarks of their respective 
// organizations and are the sole property of their respective owners
//***********************************************************************

// AppLog.cpp: implementation of the CAppLog class.
//
//////////////////////////////////////////////////////////////////////
#if defined(_WIN32)
#include <windows.h>
#else
#include <unistd.h>
#endif
#include "pdl.h"
#include "AppLog.h"
#include <time.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

//*****************************************************************************
// 
// Function	: 
//    CAppLog::CAppLog()
// Purpose	: 
//    Constructor
// Parameters:	
// Return type:	
//    none
//*****************************************************************************
CAppLog::CAppLog()
	: m_logFileHandle(NULL)
	, m_logMaxSize(100000) // max lines in the file
	, m_currentSize(0) // currently lines in the file
{
	strcpy(m_logFileName, "HmpDcbDemo.log");
}

CAppLog::~CAppLog()
{
	closeLogFile();
}

//////////////////////////////////////////////////////////////////////
// Public methods
//////////////////////////////////////////////////////////////////////


//*****************************************************************************
// Function	: 
//    CAppLog::initLog()
// Purpose	: 
//    Creating the log file that will be used by the application to log
//    information
// Parameters:	
//    Parm1 <char * fileName><in>
//    Parm2 <long maxSize><in>
// Return type:	
//    none
//*****************************************************************************
void CAppLog::initLog(const char * fileName, int maxSize)
{
	strcpy(m_logFileName, fileName);
	m_logMaxSize = maxSize;	
	if(openLogFile() == -1) {
		printf( "Cannot open Log file %s\n", m_logFileName);
	}
}

//*****************************************************************************
// Function	: 
//    CAppLog::addToLog()
// Purpose	: 
//    Add the information to the log file that is being passed by the 
//	  application.
// Parameters:	
//    Parm1 <int verbosity><in>
//    Parm2 <char * type><in>
//    Parm3 <char * source><in>
//    Parm4 <char * info><in>
// Return type:	
//    none
//*****************************************************************************
void CAppLog::addToLog(int type, const char * source, const char * info) 
{
	if(m_logFileHandle == NULL)
	{
		if(openLogFile() == -1)
		{
			printf( "Cannot open Log file %s\n", m_logFileName);
			return;
		}
	}
	unsigned long bytesWritten = 0;
	const char *sysTime = getSystemTime();
	int currPos = 15; 

	memset(m_logFileBuffer, ' ', currPos + 8);
	strncpy(m_logFileBuffer, sysTime, strlen(sysTime));
	switch(type)
	{
		case APP: 
			strncpy(&m_logFileBuffer[currPos], "APP", 3); 
			break;
		case INFO:
			strncpy(&m_logFileBuffer[currPos], "INFO", 4); 
			break;
		case EVT:
			strncpy(&m_logFileBuffer[currPos], "EVT", 3); 
			break;
		case WARN:
			strncpy(&m_logFileBuffer[currPos], "WARN", 4); 
			break;
		case ERR1:
			strncpy(&m_logFileBuffer[currPos], "ERR1", 4); 
			break;
		case ERR2:
			strncpy(&m_logFileBuffer[currPos], "ERR2", 4); 
			break;
	}
	
	sprintf(&m_logFileBuffer[currPos + 8], "%s\t\t%s\r\n",source, info);
	fwrite(m_logFileBuffer,1,strlen(m_logFileBuffer),m_logFileHandle);
	m_currentSize++;
	if(m_currentSize >= m_logMaxSize)
	{
		// rewind the file to the beginning and start overwriting an old info
		m_currentSize = 0;
		rewind(m_logFileHandle);
	}
	fflush(m_logFileHandle);
}


//////////////////////////////////////////////////////////////////////
// Private methods
//////////////////////////////////////////////////////////////////////

//*****************************************************************************
// Function	: 
//    CAppLog::openLogFile()
// Purpose	: 
//    opening a file that will be used by the applicatio to log information
// Parameters:	
//    none
// Return type:	
//    int
//*****************************************************************************

int CAppLog::openLogFile()
{
	if(m_logFileHandle == NULL) {
		m_logFileHandle = fopen(m_logFileName,"w");
	}
	if(m_logFileHandle == NULL) {
		return -1;
	}
	return 0;
}

//*****************************************************************************
// Function	: 
//    CAppLog::closeLogFile()
// Purpose	: 
//    closing the file that the applicatio used for logging
// Parameters:	
//    none
// Return type:	
//    int
//*****************************************************************************
int CAppLog::closeLogFile()
{
	if(m_logFileHandle == NULL) {
		return -1;
	}

	fclose(m_logFileHandle);
#if defined(_WIN32)
	Sleep(5000);
#else
	sleep(5);
#endif
	m_logFileHandle = NULL;
	return 0;
}

//////////////////////////////////////////////////////////////////////
// End of AppLog.cpp
//////////////////////////////////////////////////////////////////////
