/*****************************************************************************
 * Copyright (c) 2002 Intel Corporation
 * All Rights Reserved.  All names, products, and services mentioned herein
 * are the trademarks or registered trademarks of their respective organizations
 * and are the sole property of their respective owners
 **************************************************************************/

/*****************************************************************************
 * Filename:                 newscrn.h
 ****************************************************************************/
#ifndef NEWSCRN_H
#define NEWSCRN_H

#include <curses.h>

typedef void* myWINDOW;

myWINDOW scrn_makewin(int height, int width, int y, int x);
void     scrn_box(myWINDOW win);
myWINDOW scrn_initscr(void);
int      scrn_wrefresh(myWINDOW win);
int      scrn_wclear(myWINDOW win);
int      scrn_waddstr(myWINDOW win, int y, int x, const char *str);
int      scrn_halfdelay(int tenths);
int      scrn_refresh(void);
int      scrn_init_pair(short pair, short fg, short bg);
int      scrn_wcolor_set(myWINDOW win, short color, void *opts);
int      scrn_start_color(void);
int      scrn_wmove(myWINDOW win, int y, int x);
int      scrn_delwin(myWINDOW win);
int      scrn_endwin(void);

#endif	// NEWSCRN_H
