//***********************************************************************
// Copyright  2005, Intel Corporation. 
// All rights reserved All names, products, and services mentioned  
// herein are the trademarks or registered trademarks of their respective 
// organizations and are the sole property of their respective owners
//***********************************************************************

#ifndef PDL_HEADER
#define PDL_HEADER


#include <fcntl.h>
#include <vector>
#include <list>
#include <signal.h>


#define PLAY_COMPLETE       0x201
#define RECORD_COMPLETE     0x202
#define EVENT_FAILURE       0x203
#define GETDIG_COMPLETE     0x204
#define SENDDIG_COMPLETE    0x205

enum { INFO = 0, APP, EVT, WARN, ERR1, ERR2 }; 

#define CONF_CONFIG_FILE	"conf_demo.cfg"



/* Utilities for parsing Config file */
char * ReadConfigFile(const char *configFileName);
char * SkipComments(char * buf);
char * GetNextLine(char * buf);
char * SkipSpace(char * buf);

class CAppLog;
extern CAppLog * appLog;

const char *  getSystemTime();

#ifndef O_BINARY
#define O_BINARY 0x0000
#endif
#ifndef O_TEXT
#define O_TEXT 0x0000
#endif
#define GH_FILE_OPEN_FLAG_PLAY          (O_RDONLY | O_BINARY)
#define GH_FILE_OPEN_FLAG_REC           (O_RDWR | O_CREAT | O_BINARY | O_TRUNC)

#if defined(WIN32)
// read/write permissions
#define GH_FILE_OPEN_PERMISSION_REC     (S_IWRITE | S_IREAD)
#else
// read/write permissions for owner and group, read-only permissopns for others
#define GH_FILE_OPEN_PERMISSION_REC     (S_IWUSR | S_IRUSR | S_IWGRP | S_IRGRP           | S_IROTH)
#endif

#if !defined(_WIN32)

#ifdef __cplusplus
extern "C" {
#endif

int dx_fileopen(const char * filep, int flags, ...);
int dx_fileread(int handle, void * buffer, unsigned int count);
int dx_filewrite(int handle, void * buffer, unsigned int count);
int dx_fileclose(int handle);
long dx_fileseek(int handle, long offset, int origin);
long dx_filefilelength(int handle);

#ifdef __cplusplus
}
#endif

#endif	/* #if !defined(_WIN32) */

#endif	/* #ifndef PDL_HEADER */
