/**
* @file ccparse.cpp
* @brief Multimedia demo config parsing
* @date Feb 16, 2007
*
* DIALOGIC CONFIDENTIAL 
* Copyright © 2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/



#include "stdafx.h"
#include <string.h>

// Utility routines to parse ISDN gateway to 3G-SIP gateway and ISDN gateway to MM demo commands
//
// Commands are of the form "C dtiB1T1 111222333:4445556666"
// We need to extract network device name, calling number (last string before colon) 
// and called number (last string after colon)

void ParseCmd(char * cmdString, char *cmd, char *device, char *calledNumber, char *callingNumber)
{

    char delim[] = " ";
    char *result = NULL;

    result = strtok( cmdString, delim);
    int tokCnt = 1;
    while ( result != NULL ) {
        printf( "result is \"%s\"\n", result);
        switch (tokCnt) {
        case 1:
            strcpy(cmd, result);
            break;
        case 2:
            strcpy(device, result);
            break;
        case 3:
            {
                // Parse this out into two pieces using a : for a token
                char newDelim[] = ":";
                char *newResult = NULL;
                newResult = strtok( result, newDelim);
                int tokCnt2 = 1;
                while (newResult != NULL ) {
                    printf( "result is \"%s\"\n", newResult);
                    switch (tokCnt2) {
                    case 1:
                        strcpy(calledNumber, newResult);
                        break;
                    case 2:
                        strcpy(callingNumber, newResult);
                        break;
                    }
                    newResult = strtok( NULL, newDelim);
                    tokCnt2++;
                }
            }
            break;
        }
        result = strtok( NULL, delim);
        tokCnt++;
    }  

}

int main(int argc, char* argv[])
{
    char cmdString[] = "C dtiB1T1 111222333:4445556666";
    printf("Parsing command %s\n", cmdString);

    char cmd[8];
    char device[64];
    char calledNumber[64];
    char callingNumber[64];

    ParseCmd(cmdString, cmd, device, calledNumber, callingNumber);

    printf("command = %s	device = %s	calledNumber = %s	callingNumber = %s\n",
           cmd, device ,calledNumber, callingNumber);

    return 0;
}

