/**
* @file mmstream.h
* @brief Multimedia demo media streaming header
* @date Jan. 24, 2007
*
* DIALOGIC CONFIDENTIAL 
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef _mmstream_h
#define _mmstream_h

// Application Level Include Files
#include "miscellaneous.h"

#ifdef TDM_AUDIO
/* OS Socket API Headers */
    #include <unistd.h>
    #include <netdb.h>
    #include <sys/socket.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <errno.h>

    #define APP_CMD_PORT          40125             // cmd port used by ISDN gateway
    #define REMOTE_ISDN_HOST      "146.152.80.84"   // address of ISDN Gateway
#endif

#ifdef USE_RTSP
    #include "CRTSPClient.h"
#endif

// Global Variables
enum menu_e {
    menu_greeting 			= 0,
    menu_vportal  			= 1,
    menu_vmail    			= 2,
    menu_thankyou 			= 3,
    clip_entertainment 	                = 4,
    clip_sports   			= 5,
    clip_news     			= 6, 
    menu_message 			= 7,
    menu_image 				= 8,
    while_recording_message 		= 9,
    menu_none     			= 10
};

// STL vector to hold play lists
typedef vector<menu_e> PLAY_LIST;

struct audioCodecInfo_
{
   char  m_cCodecName[11];
   bool	 m_bVadEnabled;
   int   m_nMinFrameSize;
   int   m_nMaxFrameSize;
   int   m_nFPP;
   int   m_nAudioCodec;
   int   m_nDTMFCodec;
   eIPM_CODER_TYPE       m_nCoderType;
   eIPM_CODER_FRAMESIZE	 m_nAudioFrameSize;
   unsigned int          m_nAmrOption;
   int   m_nAmrModeSet;
   bool  m_bAmrOctetAlign;
};
typedef audioCodecInfo_ audioCodecInfo;

struct videoCodecInfo_
{
   char m_cCodecName[11];
   int  m_nVideoCodec;
   int  m_nProfileLevelID;
   int  m_nResolution;
   unsigned char *m_SdpDciValue;
   int  m_SdpDciLen;
   char m_SdpDciStrValue[128];
   eIPM_CODER_TYPE      m_nCoderType;
   eVIDEO_FRAMESPERSEC  m_nFrameRate;
   eVIDEO_BITRATE       m_nBitRate;
};
typedef videoCodecInfo_ videoCodecInfo;

#ifdef USE_RTSP
typedef std::queue<char> DTMF_QUEUE;
#endif

class CMMStream {
public:
#ifdef TDM_AUDIO
   CMMStream(const char *pMMDevName, 
             const char *pIpmDevName,
             const char *pVoxDevName,
             const char *pDtiDevName);
#else
   CMMStream(const char *pMMDevName, 
             const char *pIpmCCDevName,  // JS
             const char *pIpmRTSPDevName,  // JS
             const char *pVoxDevName);
#endif
   ~CMMStream(){}

#ifdef TDM_AUDIO
   void ParseISDNGWCmd(char * cmdString, char *cmd, char *device, char *calledNumber, 
                       char *callingNumber);

   void SaveISDNGwCmd(char * SIPHeader);
#endif
   bool Init(void);
   bool Shutdown(void);
   void StartStream(void);
   void StopStream(void *pData);

   void ConnectDevices(void);
   void DisconnectMM(void);
   void DisconnectIPM(void);

#ifdef USE_MTK_API
   void BuildOverlay();
   void ApplyOverlay();
   void RemoveOverlay();
   void DestroyOverlay();
#endif

   void ResetVariables();
   void PausePlay(bool bCaptureImage);
   void ResumePlay(void);
   void CaptureImage(void);
   void ForwardRewindPlay(int nOffset);
   int SetupAudioMediaInfo(eIPM_MEDIA_TYPE mediaType,int mediaCtr);
   int SetupVideoMediaInfo(eIPM_MEDIA_TYPE mediaType,int mediaCtr);


   void GetMMStreamInfo(void);
   void Play(menu_e menuItem);
   void Record(void);
   void StopPlay(menu_e menuItem);
   void StopRecord();
   void StopPlayRecord(menu_e menuItem);
   void Getdigits(void);
   void SetIpmParms(void);
   void GetIpmParms(void);
   void SetupCCRemoteMediaInfo(void);
   void SetupExtraVideoCoderInfo(int mediaCtr);
#ifdef USE_RTSP
   void SetupRTSPRemoteMediaInfo2(); // JS
   void QueueNextVideo(char dtmf);
   void PlayVideoFile(char dtmf);
#endif
   bool SendIFrameRequest(void);
   bool SetDtmfMode(dtmfMode_e eMode);
   sdpSessionDescription *PopulateAnswerSdp();
   void PopulateOfferSdp(char *sdpOffer);
   int ParseOfferSdp(sdpSessionDescription *a_pSDP);
   bool ParseAndStoreAudioAttributes(sdpMediaDescription *pMD);
   bool ParseAndStoreVideoAttributes(sdpMediaDescription *pMD);
   void PrintRemoteLocalInfo();
   void SetupPlayRecordSettings();
   unsigned int GetUnCoding(int pt);
   const char* GetAudioCodecStr(int audioCodec);
   const char* GetVideoCodecStr(int videoCodec);

   bool ProcessDtmf(char cDtmf); 
   void StopMedia();

   bool RecordingNow () {return m_bRecordDone == false;};
   bool WaitingNow () {return m_bWaiting == true;};
   
   static void ProcessEvent(METAEVENT &metaevt, CMMStream *pChan);
   
   // states
   enum state_t {
      state_initial         = 0,
      state_idle            = 1,
      state_connected       = 2,
      state_playMainMenu    = 3,
      state_playVPortalMenu = 4,
      state_playVMailMenu   = 5,
      state_recordMsg       = 6,
      state_disconnected    = 7,
      state_appStopping     = 8
   };

   typedef unsigned long EVENT;
   typedef void (CMMStream:: *APPHANDLER)(void *pData);

   struct stateTransition {
      EVENT        st_event;
      APPHANDLER  st_action;
      state_t      st_next;
      char        st_name[30];
   };

   void SetState(state_t nextState);
   int GetState();
   static stateTransition s_initialTable[];
   static stateTransition s_idleTable[];
   static stateTransition s_connectedTable[];
   static stateTransition s_playMainMenuTable[];
   static stateTransition s_playVPortalMenuTable[];
   static stateTransition s_playVMailMenuTable[];
   static stateTransition s_recordMsgTable[];
   static stateTransition s_disconnectedTable[];
   static stateTransition s_appStoppingTable[];

   static stateTransition *s_ipCallTable[]; // Call state table.

public: // variables
   long                 m_gcDev;
   CRN                  m_gcCurrentCrn;
   char                 m_devName[DEV_NAME];
   // CTBus Talk Timeslots
   long                 m_ipmTalkTs;
   char                 m_cAudioVideoIp[16];
   int                  m_nAudioRtpPort;
   int                  m_nVideoRtpPort;
   char                 m_cRTSPAudioVideoIp[16]; // JS
   int                  m_nRTSPAudioRtpPort; // JS
   int                  m_nRTSPVideoRtpPort; // JS
   int                  m_nRfc2833PayloadType;

   audioCodecInfo	m_stRemoteEPAudioCodec;
   videoCodecInfo	m_stRemoteEPVideoCodec;
//  audioCodecInfo	m_stLocalEPAudioCodec;
//  videoCodecInfo	m_stLocalEPVideoCodec;
   unsigned char        *m_SdpDciValue;
   int                  m_SdpDciLen;
   char                 m_SdpDciStrValue[128];
		
   MM_VIDEO_CODEC       m_mmVideoCodecPlay;
   MM_VIDEO_CODEC       m_mmVideoCodecRecord;
   MM_AUDIO_CODEC       m_mmAudioCodecPlay;
   MM_AUDIO_CODEC       m_mmAudioCodecRecord;

   MTK_HANDLE           m_hDMFAudFile;
   MTK_HANDLE           m_hDMFVidFile;
   MTK_HANDLE           m_h3GPFile;

private:
   long                 m_ipmCCH;  // JS
   long                 m_ipmRTSPH;  // JS
   long                 m_mmH;
   long                 m_voxH;

#ifdef TDM_AUDIO
   long                 m_dtiH;
   char                 m_dtiDevName[DEV_NAME];  // format: ":N_dtiB2T1:P_CC", 
   void                 Connect2G();
   void                 Disconnect2G ();
   void                 SendCmdToISDNGW(char* cmd);
   char                 m_gwCmd[8];
   char                 m_3GChannelTag[64];
   char                 m_ISDNCalledNumber[64];
   char                 m_ISDNCallingNumber[64];
   bool                 m_b2gIsBridged;
   int                  m_recFileH;
#endif
   // device names
   char                 m_mmDevName[DEV_NAME];
   char                 m_ipmCCDevName[DEV_NAME];  // JS
   char                 m_ipmRTSPDevName[DEV_NAME];  // JS
   char                 m_voxDevName[DEV_NAME];
   const char           *m_state_name;      // name of the current state
   static device_type   s_eType;
   state_t              m_eState;
   state_t              m_eCurrentState;

   PLAY_LIST            m_playList;
   bool                 m_bSetState;
   bool                 m_bPlayDone;
   bool                 m_bUserStop;
   bool                 m_bRecordDone;
   bool                 m_bWaiting;
   bool                 m_bMMStopping;
   bool                 m_bMMPlayStarting;
   bool                 m_bMMRecordStarting;
   bool                 m_bCCStreamingRtp;
   bool                 m_bRTSPStreamingRtp;
   bool                 m_bVideoCall;
   bool                 m_bIsGetDigitPending;
   DEV_RESOURCE_LIST    m_ResourceList;
   IPM_MEDIA_INFO       m_CCipmLocalMedia; // JS
   IPM_MEDIA_INFO       m_RTSPipmLocalMedia; // JS
   IPM_MEDIA_INFO       m_RTSPipmRemoteMedia; // JS
   MM_OPEN_INFO         m_openInfo;
   MM_CLOSE_INFO        m_closeInfo;
   MM_MEDIA_ITEM_LIST   m_audioMediaList;
   MM_MEDIA_ITEM_LIST   m_videoMediaList;
   MM_MEDIA_ITEM_LIST   m_imageMediaList;
   IPM_MEDIA_INFO       m_ccIpmMediaInfo;

   MM_PLAY_RECORD_LIST  m_playRecordList[2];
   MM_PLAY_INFO         m_playInfo;
   MM_RECORD_INFO       m_recordInfo;
   DV_TPT               m_tpt[2];
   DV_DIGIT             m_digits;

// SKS Image Overlay
   MTK_HANDLE           hMtkImageTemplate;
   MTK_HANDLE           hMtkMediaFileTemplate;
   MTK_FRAME_HANDLE     hMtkFrameTemplate;

//  This handle to the shapshot can be used to change the properties 
//  of the frame (hMtkFrameTemplate) associated with the overlay 
//	without changing the original template (hObImageOverlayTemplate)
   MTK_FRAME_HANDLE     hObOverlayBoundingFrame;
   OB_OVERLAY_HANDLE    hObImageOverlayTemplate;
	  
   bool                 m_bHaveMMTxPort ;
   bool                 m_bHaveCCIPMTxPort ;
   bool                 m_bHaveRTSPIPMTxPort ;
   bool                 m_bHaveMMRxPort ;
   bool                 m_bHaveCCIPMRxPort ;
   bool                 m_bHaveRTSPIPMRxPort ;

   DM_PORT_INFO_LIST    m_Ipm_CC_RxPortList;
   DM_PORT_INFO_LIST    m_Ipm_CC_TxPortList;
   DM_PORT_INFO_LIST    m_Ipm_RTSP_RxPortList;
   DM_PORT_INFO_LIST    m_Ipm_RTSP_TxPortList;
   DM_PORT_INFO_LIST    m_Mm_RxPortList;
   DM_PORT_INFO_LIST    m_Mm_TxPortList;
   DM_PORT_CONNECT_INFO_LIST mmCnctList;
   DM_PORT_CONNECT_INFO_LIST CCipmCnctList;
   DM_PORT_CONNECT_INFO_LIST RTSPipmCnctList;
   IPM_VIDEO_CODER_INFO_EX   m_extraVidInfoLocal;
   IPM_VIDEO_CODER_INFO_EX   m_extraVidInfoRemote;
   IPM_VIDEO_CODER_INFO_EX   m_mpegInfo;
#ifdef USE_RTSP
   CRTSPClient*              m_pRTSPClient;
#endif

   eIPM_CODER_TYPE GetAmrwbCoderType(int modeset);

   std::string               m_cRecordingMsgAudioFile;
   std::string               m_cRecordingMsgVideoFile;
   bool                      m_bIsRecordPending;
    
   IPM_VIDEO_CODER_INFO_EX   m_RemoteVideoCodecInfoEx;
   IPM_VIDEO_CODER_INFO_EX   m_LocalVideoCodecInfoEx;

   // index into IPM_MEDIA_INFO for RTP port information
   unsigned int              m_unLocalCCIPMAudioRtpPortIndex;
   unsigned int              m_unLocalCCIPMVideoRtpPortIndex;
   unsigned int              m_unLocalRTSPIPMAudioRtpPortIndex;
   unsigned int              m_unLocalRTSPIPMVideoRtpPortIndex;

   sdpSessionDescription     m_LocalSDP;
   sdpSessionDescription     *m_pRemoteSDP;    

   std::string               m_cImageFileName;

   std::string               m_c3GPFileName;
   std::string               m_cAudioRecordFile;
   std::string               m_cVideoRecordFile;
   std::string               m_cMainMenuAudio;
   std::string               m_cMainMenuVideo;
   std::string               m_cVmailMenuAudio;
   std::string               m_cVmailMenuVideo;
   std::string               m_cVportalMenuAudio;
   std::string               m_cVportalMenuVideo;
   std::string               m_cClip1Audio;
   std::string               m_cClip1Video;
   std::string               m_cClip2Audio;
   std::string               m_cClip2Video;
   std::string               m_cClip3Audio;
   std::string               m_cClip3Video;

#ifdef USE_RTSP
   DTMF_QUEUE                m_qDtmf;
#endif

private:
   // these are the handlers for events
   void OnDoNothing(void *pData);

   void OnMMOpen(void *pData);
   void OnMMReset(void *pData);
   void OnMMGetStreamInfo(void);
   void OnMMPlayAck(void *pData);
   void OnMMPlayDone(void *pData);
   void OnMMRecordAck(void *pData);
   void OnMMRecordAckFail(void *pData);
   void OnMMRecordFail(void *pData);
   void OnMMVideoStarted(void *pData);
   void OnMMRecordDone(void *pData);
   void OnMMUndeclared(void *pData);
   void OnMMError(void *pData);
   void OnMMStopAck(void *pData);
   void OnMMPlayAckFail(void* pData);
   void OnMMPlayFail(void* pData);
   const char* MMErrorStr(unsigned int emm_err);
   const char* MMPlayRecCmpltStr(unsigned int eValue);
   const char* MMPlayRecCmpltReasonStr(unsigned int eValue);
   const char* MMPlayRecCmpltStatusStr(unsigned int eValue);
   const char* MMStopItemStr(unsigned int eValue);

   void OnMMPause(void* pData); 
   void OnMMCapture(void* pData); 
   void OnMMResume(void* pData); 
   void OnMMSeek(void* pData); 
   void SetPlayRecordFileName(char extention[12]);
   void SetDciValue();
   void SetH264DciValue();
   void SetPlayRecordVideoCodec();
   void SetPlayRecordAudioCodec();

   void OnIpmOpenEx(void *pData);
   void OnGetRxPortInfo(void* pData);
   void OnGetTxPortInfo(void* pData);
   int RouteIPM_MM_Ports() ;
   int RouteIPM_IPM_Ports(int transcodeOption) ;
   const char *get_transcode_str(int transcodeflag);
   int getportindex(DM_PORT_INFO_LIST portlist, DM_PORT_MEDIA_TYPE porttype);
   const char *get_portmediatype_str(DM_PORT_MEDIA_TYPE port_type);
   void PrintPortInfo(const char* device, const char* fcn, DM_PORT_INFO_LIST* pPortList);
   int  MPIToFPS(int MPI);
   int  FPSToMPI(eVIDEO_FRAMESPERSEC fps);
   void OnReserveResourceEx(void *pData);
   void OnIpmGetLocalInfo(void *pData);
   void OnIpmStartMedia(void *pData);
   void OnIpmStopped(void *pData);
   void OnIpmGetparm(void *pData);
   void OnIpmUndeclared(void *pData);
   void OnIpmRfcEvent(void *pData);
   void OnIpmError(void *pData);


// SKS
   void convertTo3GP(void *pData);
   void outputLastMTKError();
   void destroyMTKResources(void *pData);
   void OnAddOverlay(void *pData);
   void OnRemoveOverlay(void *pData);
   void OnAddOverlayFail(void *pData);
   void OnRemoveOverlayFail(void *pData);
   void OnRemoveAllOverlays(void *pData);
   void OnRemoveAllOverlaysFail(void *pData);

   void OnDevConnect(void *pData);
   void OnDevPortConnect(void *pData);
   void OnMMDevDisconnect(void *pData);
   void OnIPMDevDisconnect(void *pData);
   void OnVoxDigitRcvd(void *pData);
   void OnIFrameReqRcvd(void *pData);
   void OnAppWaitTimeoutRcvd(void *pData);
#if TDM_AUDIO
    void OnDXRecordDone(void *pData);
#endif
};

#endif
