/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/


#include "BoardDevice.h"


BoardDevice::BoardDevice()
{
	Print(LOG_DEBUG,"+ BoardDevice::BoardDevice");
	Print(LOG_DEBUG,"- BoardDevice::BoardDevice");
}

BoardDevice::~BoardDevice()
{
	Print(LOG_DEBUG,"+ BoardDevice::~BoardDevice");
	if (m_DeviceHandle)
	{
		Print(LOG_INFO,"\tClosing SIP device %s", m_DeviceName);
		gc_Close(m_DeviceHandle);
		m_DeviceHandle = 0;
	}
	Print(LOG_DEBUG,"- BoardDevice::~BoardDevice");
}

int BoardDevice::Open(const char* a_BoardDevName)
{
	Print(LOG_DEBUG,"+ BoardDevice::Open");
	int rc = 0;
	strcpy(m_DeviceName,a_BoardDevName);
	Print(LOG_INFO,"\tOpening IP Board device %s", a_BoardDevName);
	if (rc = gc_OpenEx(&m_DeviceHandle, (char*)a_BoardDevName, EV_ASYNC, &m_DeviceHandle) != GC_SUCCESS) 
	{
		Print(LOG_ERROR,"\tgc_OpenEx(devicename=%s, mode=EV_ASYNC) Failed", a_BoardDevName);
	}
	else
	{
		Print(LOG_INFO,"\tdevicename=%s successfully opened.  Handle = %d", a_BoardDevName, m_DeviceHandle);
	}
	Print(LOG_INFO,"\n");

	Print(LOG_DEBUG,"- BoardDevice::Open");
	return rc;
}

int BoardDevice::Close()
{
	Print(LOG_DEBUG,"+ BoardDevice::Close");
	int rc = 0;

	if (m_DeviceHandle)
	{
		Print(LOG_INFO,"\tClosing IP Board device %s", m_DeviceName);
		gc_Close(m_DeviceHandle);
		m_DeviceHandle = 0;
	}

	Print(LOG_DEBUG,"- BoardDevice::Close");
	return rc;
}







void BoardDevice::OnBoardOpen(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ BoardDevice::OnBoardOpen");

	Print(LOG_INFO,"\t\tRegistering to receive SIP headers");

	GC_PARM_BLKP parmblkp = NULL;
	GC_PARM_BLKP retblkp = NULL;

	Print(LOG_INFO,"\t\tRegistering for Call-ID header");
	gc_util_insert_parm_ref(&parmblkp,
							IPSET_CONFIG,
							IPPARM_REGISTER_SIP_HEADER,
							(unsigned char)strlen("Call-ID") + 1,
							(void*)"Call-ID");
	Print(LOG_INFO,"\t\tRegistering for To header");
	gc_util_insert_parm_ref(&parmblkp,
							IPSET_CONFIG,
							IPPARM_REGISTER_SIP_HEADER,
							(unsigned char)strlen("To") + 1,
							(void*)"To");
	Print(LOG_INFO,"\t\tRegistering for From header");
	gc_util_insert_parm_ref(&parmblkp,
							IPSET_CONFIG,
							IPPARM_REGISTER_SIP_HEADER,
							(unsigned char)strlen("From") + 1,
							(void*)"From");

	long request_id = 0;
	if (gc_SetConfigData(	GCTGT_CCLIB_NETIF, 
							m_DeviceHandle, 
							parmblkp, 
							0, 
							GCUPDATE_IMMEDIATE, 
							&request_id, 
							EV_ASYNC) != GC_SUCCESS)
	{
		Print(LOG_ERROR,"Registration for SIP headers has failed");
	}
	gc_util_delete_parm_blk(parmblkp);

	Print(LOG_DEBUG,"- BoardDevice::OnBoardOpen");
}

void BoardDevice::OnBoardSetConfigData(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ BoardDevice::OnBoardSetConfigData");
	Print(LOG_INFO,"\t\tSIP header registration complete");
	Print(LOG_DEBUG,"- BoardDevice::OnBoardSetConfigData");
}

