/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/


#include "EventMgr.h"


EventMgr::EventMgr(NetworkConnectionMgr* a_pNetworkConnectionMgr)
{
	Print(LOG_DEBUG,"+ EventMgr::EventMgr");
	m_pNetworkConnectionMgr = a_pNetworkConnectionMgr;
	Print(LOG_DEBUG,"- EventMgr::EventMgr");
}

EventMgr::~EventMgr()
{
	Print(LOG_DEBUG,"+ EventMgr::~EventMgr");
	Print(LOG_DEBUG,"- EventMgr::~EventMgr");
}

void EventMgr::ProcessEvent()
{
	Print(LOG_DEBUG,"+ EventMgr::ProcessEvent");

	METAEVENT metaevent;
	bool bBoardEvent = false;

	BoardDevice* pBoardDevice = NULL;
	char DeviceName[64];
	NetworkConnection* pNetworkConnection = m_pNetworkConnectionMgr->FindNetworkConnectionByHandle(sr_getevtdev(),DeviceName);
	if (pNetworkConnection == 0)
	{
		pBoardDevice = (BoardDevice*)m_pNetworkConnectionMgr->FindDeviceByHandle(sr_getevtdev(),DeviceName);
		if (pBoardDevice == 0)
		{
			Print(LOG_ERROR,"\tEvent received for unknown device");
			Print(LOG_DEBUG,"- EventMgr::ProcessEvent");
			return;
		}
		bBoardEvent = true;
	}

	if(gc_GetMetaEvent(&metaevent) != GC_SUCCESS)
	{
		Print(LOG_ERROR,"\tgc_GetMetaEvent() failed");
		Print(LOG_DEBUG,"- EventMgr::ProcessEvent");
		return;
	}

	Print(LOG_INFO,"\n");

	switch (metaevent.evttype) 
	{
		case IPMEV_OPEN:
			Print(LOG_INFO,"\t---> IPMEV_OPEN Message\t\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnMediaOpen();
			break;

		case IPMEV_STARTMEDIA:
			Print(LOG_INFO,"\t---> IPMEV_STARTMEDIA Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnMediaStart();
			break;

		case IPMEV_STOPPED:
			Print(LOG_INFO,"\t---> IPMEV_STOPPED Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnMediaStop();
			break;

		case IPMEV_UNLISTEN:
			Print(LOG_INFO,"\t---> IPMEV_LISTEN Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnMediaUnListen();
			break;

		case IPMEV_LISTEN:
			Print(LOG_INFO,"\t---> IPMEV_LISTEN Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnMediaListen();
			break;

		case IPMEV_ERROR:
			Print(LOG_INFO,"\t---> IPMEV_ERROR Message\t\t\t\t- Device = %s",DeviceName);
			break;






		case GCEV_UNBLOCKED:
			Print(LOG_INFO,"\t---> GCEV_UNBLOCKED Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_OPENEX:
			Print(LOG_INFO,"\t---> GCEV_OPENEX Message\t\t\t\t- Device = %s",DeviceName);
			if (bBoardEvent == true)
			{
				pBoardDevice->OnBoardOpen(&metaevent);
			}
			else
			{
				pNetworkConnection->OnSipOpen(&metaevent);
			}
			break;

		case GCEV_SETCONFIGDATA:
			Print(LOG_INFO,"\t---> GCEV_SETCONFIGDATA Message\t\t\t\t- Device = %s",DeviceName);
			if (bBoardEvent == true)
			{
				pBoardDevice->OnBoardSetConfigData(&metaevent);
			}
			else
			{
				pNetworkConnection->OnSipSetConfigData(&metaevent);
			}
			break;




		case GCEV_LISTEN:
			Print(LOG_INFO,"\t---> GCEV_LISTEN Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_UNLISTEN:
			Print(LOG_INFO,"\t---> GCEV_UNLISTEN Message\t\t\t\t- Device = %s",DeviceName);
			break;




		case GCEV_OPENEX_FAIL:
			Print(LOG_INFO,"\t---> GCEV_OPENEX_FAIL Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_FATALERROR:
			Print(LOG_INFO,"\t---> GCEV_FATALERROR Message\t\t\t\t- Device = %s",DeviceName);
			break;				

		case GCEV_TASKFAIL:
			Print(LOG_INFO,"\t---> GCEV_TASKFAIL Message\t\t\t\t- Device = %s",DeviceName);
			break;




		case GCEV_OFFERED:
			Print(LOG_INFO,"\t---> GCEV_OFFERED Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnSipOffered(&metaevent);
			break;

		case GCEV_ACCEPT:
			Print(LOG_INFO,"\t---> GCEV_ACCEPT Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnSipAccept(&metaevent);
			break;

		case GCEV_DIALING:
			Print(LOG_INFO,"\t---> GCEV_DIALING Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_ALERTING:
			Print(LOG_INFO,"\t---> GCEV_ALERTING Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_ANSWERED:
			Print(LOG_INFO,"\t---> GCEV_ANSWERED Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnSipAnswered(&metaevent);
			break;

		case GCEV_PROCEEDING:
			Print(LOG_INFO,"\t---> GCEV_PROCEEDING Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_CONNECTED:
			Print(LOG_INFO,"\t---> GCEV_CONNECTED Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_DISCONNECTED:
			Print(LOG_INFO,"\t---> GCEV_DISCONNECTED Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnSipDisconnected(&metaevent);
			break;

		case GCEV_DROPCALL:
			Print(LOG_INFO,"\t---> GCEV_DROPCALL Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnSipDropCall(&metaevent);
			break;

		case GCEV_RELEASECALL:
			Print(LOG_INFO,"\t---> GCEV_RELEASECALL Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnSipReleaseCall(&metaevent);
			break;
 
		case GCEV_CALLINFO:
			Print(LOG_INFO,"\t---> GCEV_CALLINFO Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_EXTENSION:
			Print(LOG_INFO,"\t---> GCEV_EXTENSION Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_EXTENSIONCMPLT:
			Print(LOG_INFO,"\t---> GCEV_EXTENSIONCMPLT Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_SIP_ACK:
			Print(LOG_INFO,"\t---> GCEV_SIP_ACK Message\t\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnSipAck(&metaevent);
			break;

		case GCEV_SIP_200OK:
			Print(LOG_INFO,"\t---> GCEV_SIP_200OK Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_SIP_ACK_OK:
			Print(LOG_INFO,"\t---> GCEV_SIP_ACK_OK Message\t\t\t\t- Device = %s",DeviceName);
			break;

		case GCEV_REQ_MODIFY_CALL:
			Print(LOG_INFO,"\t---> GCEV_REQ_MODIFY_CALL Message\t\t\t- Device = %s",DeviceName);
			pNetworkConnection->OnSipReqModifyCall(&metaevent);
			break;

		case GCEV_REJECT_MODIFY_CALL:
			Print(LOG_INFO,"\t---> GCEV_REJECT_MODIFY_CALL Message\t\t\t- Device = %s",DeviceName);
			break;
	
		default:
			Print(LOG_ERROR,"Unprocessed Event %d Decimal - 0x%x Hex", metaevent.evttype, metaevent.evttype);
			break;
	}

	Print(LOG_DEBUG,"- EventMgr::ProcessEvent");
}



