/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/


#include "GlobalCallMgr.h"



GlobalCallMgr::GlobalCallMgr()
{
	Print(LOG_DEBUG,"+ GlobalCallMgr::GlobalCallMgr");

	m_ccLibStart[0].cclib_name = "GC_H3R_LIB";
	m_ccLibStart[0].cclib_data = &m_libData;

	memset(m_virtBoard,0,sizeof(IP_VIRTBOARD) * 1);
	INIT_IP_VIRTBOARD(m_virtBoard);

	m_libData.version = 0x201;
	m_libData.delimiter = ',';
	m_libData.num_boards = 1; 
	m_libData.max_parm_data_size = 255;
	m_libData.media_operational_mode = MEDIA_OPERATIONAL_MODE_3PCC;

	m_virtBoard[0].version = 0x105;
	m_virtBoard[0].total_max_calls = 2;
	m_virtBoard[0].h323_max_calls = 0;
	m_virtBoard[0].sip_max_calls = 2;
	m_virtBoard[0].localIP.ip_ver = IPVER4;
	m_virtBoard[0].localIP.u_ipaddr.ipv4 = 0;
	m_virtBoard[0].h323_signaling_port = 1720;
	m_virtBoard[0].sip_signaling_port = 5060;
	m_virtBoard[0].sip_msginfo_mask = IP_SIP_MIME_ENABLE | IP_SIP_MSGINFO_ENABLE;

	m_libData.board_list = m_virtBoard;

	m_gcLibStart.cclib_list = m_ccLibStart;
	m_gcLibStart.num_cclibs = 1;
	Print(LOG_DEBUG,"- GlobalCallMgr::GlobalCallMgr");
}

GlobalCallMgr::~GlobalCallMgr()
{
	Print(LOG_DEBUG,"+ GlobalCallMgr::~GlobalCallMgr");
	Print(LOG_INFO,"\tStopping Global Call - Please Wait ..");
	gc_Stop();
	Print(LOG_DEBUG,"- GlobalCallMgr::~GlobalCallMgr");
}

int GlobalCallMgr::Initialize()
{
	Print(LOG_DEBUG,"+ GlobalCallMgr::Initialize");
	int rc = 0;

	/* Give control to Event Handler */ 
#ifdef _WIN32
	signal(SIGINT, (void (__cdecl*)(int)) InterruptHdlr);
	signal(SIGTERM, (void (__cdecl*)(int)) InterruptHdlr);
#else
	signal(SIGHUP, (void (*)(int)) InterruptHdlr);
	signal(SIGQUIT, (void (*)(int)) InterruptHdlr);
	signal(SIGINT, (void (*)(int)) InterruptHdlr);
	signal(SIGTERM, (void (*)(int)) InterruptHdlr);
#endif
	rc = InitSRLMode();
	if (rc == 0)
	{
		// Start GlobalCall 
		Print(LOG_INFO,"\n\tInitialing Global Call");
		rc = gc_Start(&m_gcLibStart);
		if (rc != GC_SUCCESS) 
		{ 
			Print(LOG_ERROR,"\tgc_Start() Failed");
		}
		else
		{
			Print(LOG_INFO,"\tGlobal Call Started Successfully");
		}
		Print(LOG_INFO,"\n");
	}

	Print(LOG_DEBUG,"- GlobalCallMgr::Initialize");
	return rc;
}

int GlobalCallMgr::InitSRLMode(void)
{
	Print(LOG_DEBUG,"+ GlobalCallMgr::InitSRLMode");
	int rc = 0;
/* 
SRL MODEL TYPE - Single Threaded Async, event handler will be called in the Main thread 
*/
#ifdef _WIN32
	int	mode = SR_STASYNC | SR_POLLMODE; 
#else
	int	mode = SR_POLLMODE;
#endif
	

	/* Set SRL mode */
#ifdef _WIN32
	if (rc = sr_setparm(SRL_DEVICE, SR_MODELTYPE, &mode) == -1) 
	{
		Print(LOG_ERROR,"\tUnable to set to SR_STASYNC | SR_POLLMODE");
	}
	Print(LOG_INFO,"\tSRL Model Set to SR_STASYNC | SR_POLLMODE");
#else
	if (rc = sr_setparm(SRL_DEVICE, SR_MODEID, &mode) == -1) 
	{
		Print(LOG_ERROR,"\tUnable to set mode ID to SR_POLLMODE");
	}
	Print(LOG_INFO,"\tSRL mode ID set to SR_POLLMODE");
#endif
	Print(LOG_DEBUG,"- GlobalCallMgr::InitSRLMode");
	return rc;
}



