/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/

#ifdef WIN32
#include <afx.h>
#endif

#include "GlobalCallMgr.h"
#include "EventMgr.h"
#include "NetworkConnection.h"
#include "NetworkConnectionMgr.h"
#include "ConnectionMgr.h"


bool DebugMode = false;
bool Interrupted = false;


//********************************************************************************
//
//
//********************************************************************************
int main(int argc, char* argv[])
{

#ifdef WIN32
#ifdef _DEBUG
	CMemoryState oldMemState, newMemState, diffMemState;
	oldMemState.Checkpoint();
#endif
#endif

	int ret;

	if (argc > 1)
	{
		if (!strcmp(argv[1],"debug"))
		{
			printf("Setting debug mode to true\n\n\n");
			DebugMode = true;
		}
		else
		{
			printf("Unknown parameter\n");
			printf("syntax = SDPAPI_Demo [debug]\n\n\n");
			return -1;
		}
	}

	printf("*****************************************************************************\n");
	printf("****\n");
	printf("**** This sample application demonstrates the use of SIP 3PCC and the SDP API.\n");
	printf("****\n");
	printf("**** The application opens two SIP line devices and two IPM devices.  The control\n");
	printf("**** and management of SIP call control is totally independent of the RTP media control.\n");
	printf("**** The IPM device and SIP line device are associated, but only in the context of \n");
	printf("**** the application.  It manages call signaling and media control separately.\n");
	printf("****\n");
	printf("**** When an inbound call is received on a SIP line device, the SDP API is utilized\n");
	printf("**** to decode the inbound SDP.  This information is used to configure one of the \n");
	printf("**** IPM devices remote capabilities.  The local capabilities and port information\n");
	printf("**** of the associated IPM device are retrieved and used by the SDP API to create a\n");
	printf("**** response SDP for the inbound call.  This will be the SDP answer to the calling party.\n");
	printf("****\n");
	printf("**** Once the first call is connected, the application waits for another inbound call\n");
	printf("**** using the second IPM and SIP devices.  The second call will be handled in the \n");
	printf("**** same manner described above. \n");
	printf("****\n");
	printf("**** The two IPM devices in use will be \"listening\" to each.  So once both calls are\n");
	printf("**** connected, the two remote SIP user agents will have full duplex media flow.\n");
	printf("****\n");
	printf("****\n\
****                ___________                          ___________\n\
****                                                                \n\
****                | SIP UA  |                          | SIP UA  |\n\
****                ___________                          ___________\n\
****                 |      |                             |      |\n\
****                 |      |                             |      |\n\
****                 |      |                             |      |\n\
****                 |      | RTP                     RTP |      |\n\
****                 |      |                             |      |\n\
****                 |      |                             |      |\n\
****       SIGNALING |     _|_____                   _____|_     | SIGNALING\n\
****                 |                                           |\n\
****                 |     | IPM | <-- Connected --> | IPM |     |\n\
****                 |     _______                   _______     |\n\
****                 |                                           |\n\
****                 |        |                         |        |\n\
****                 |        |                         |        |\n\
****             ____|__      |                         |    ____|__\n\
****                          |                         |\n\
****             | SIP |      |                         |    | SIP |\n\
****             _______      |                         |    _______\n\
****                          |                         |\n\
****                |         |                         |       |\n\
****                |         |                         |       |\n\
****             ___________________________________________________\n\
****\n\
****             |                                                  |\n\
****             |                    Application                   |\n\
****             |                                                  |\n\
****             ___________________________________________________\n");
	printf("****\n");
	printf("****\n");
	printf("**** Starting ..    SDP API Demo Application\n");
	printf("****\n");
	printf("****\n");
	printf("*****************************************************************************\n");

	GlobalCallMgr* pGCMgr = new GlobalCallMgr;
	if (pGCMgr->Initialize() != 0)
	{
		exit(1);
	}

	NetworkConnectionMgr* pNetConnMgr = new NetworkConnectionMgr;
	EventMgr* pEvtMgr = new EventMgr(pNetConnMgr);

	pNetConnMgr->Initialize(":N_iptB1:P_IP");

	NetworkConnection* pNetConn1 = pNetConnMgr->Allocate(":N_iptB1T1:P_SIP","ipmB1C1");
	if (pNetConn1 == NULL)
	{
		return -1;
	}

	NetworkConnection* pNetConn2 = pNetConnMgr->Allocate(":N_iptB1T2:P_SIP","ipmB1C2");
	if (pNetConn2 == NULL)
	{
		return -1;
	}

	ConnectionMgr* pConnMgr = new ConnectionMgr;

	bool bDevicesConnected = false;
	for (;;) 
	{
		ret = sr_waitevt(500);
		if (bDevicesConnected == false)
		{
			if ( pNetConn1->IsOpen() && pNetConn2->IsOpen() )
			{
				printf("\n\n\tAll devices are now open.  Connecting IPM devices\n\n");
				pConnMgr->Connect(pNetConn1,pNetConn2);
				bDevicesConnected = true;
			}
		}

		if (ret != -1) 
		{
			pEvtMgr->ProcessEvent();
		}

		if (Interrupted == false)
		{
		} 
		else 
		{
			if (bDevicesConnected == true)
			{
				pConnMgr->Disconnect(pNetConn1,pNetConn2);
				bDevicesConnected = false;
			}

			pNetConnMgr->Deallocate(pNetConn1);
			pNetConnMgr->Deallocate(pNetConn2);
			delete pConnMgr;
			delete pEvtMgr;
			delete pNetConnMgr;

			ret = 0;
			while (ret != -1)
			{
				ret = sr_waitevt(2000);
				if (ret != -1) 
				{
				}
			}
			
			delete pGCMgr;

#ifdef WIN32
#ifdef _DEBUG
			newMemState.Checkpoint();
			if( diffMemState.Difference( oldMemState, newMemState ) )
			{
				TRACE( "Memory leaked!\n" );
				diffMemState.DumpStatistics();
				printf("\n\n***********************************************************\n");
				printf("***********************************************************\n");
				printf("**********     Memory Leaks Detected !!! ******************\n");
				printf("***********************************************************\n");
				printf("***********************************************************\n");
			}
#endif
#endif

			exit(1);
		}

	}
	return 0;
}


void InterruptHdlr(int)
{
	if (Interrupted == false) 
	{
		printf("\n\n\t******* Received User Interrupt Signal *******\n");
		printf("\t******* Cleaning up and Exiting Application *******\n\n\n");
		Interrupted = true;
	}
}
