#!/bin/bash
#INTEL_DIALOGIC_DIR=/usr/dialogic

echo "Programming Damascus(TVL2) SBC D61369-006/D76014-001 with FRU & SDR 

#service ipmi start
SN=`ipmitool fru | grep "Board Serial" | awk '{ print $4 }'`	
BPN=`ipmitool fru | grep "Board Part Number" | awk '{ print $5 }'` 
PN=`ipmitool fru | grep "Product Name" | awk '{ print $4 }'`	
PPN=`ipmitool fru | grep "Product Part Number" | awk '{ print $5 }'`

export SN_NUM=$SN	#must use export so sbcupdate can see the SN_NUM
export BP_NUM=$BPN	#must use export so sbcupdate can see the BP_NUM
export P_NUM=$PN	#must use export so sbcupdate can see the P_NUM
export PP_NUM=$PPN	#must use export so sbcupdate can see the PP_NUM


# ------------------ program_sbc_all.sh ------------------

sbcupdate -V >/dev/null
RET=$?
if [ $RET = 0 ]; then
  echo "Updating IPMC, please wait..."
else
  echo "sbcupdate not installed, install sbcutils and then proceed"
  return $RET
fi

sbcupdate -M direct --force-fw-update ${INTEL_DIALOGIC_DIR}/data/MPCBL0040_FW_1133.hex
sleep 15

sbcupdate -M direct --force-fru-update --force-id ${INTEL_DIALOGIC_DIR}/data/MPCBL0040_019.fru
sleep 15

sbcupdate -M direct --force-sdr-update ${INTEL_DIALOGIC_DIR}/data/MPCBL0040_112.sdr
sleep 15

sbcupdate ${INTEL_DIALOGIC_DIR}/data/sbc_fru.cfg

ipmitool raw 0x30 9 9 0 1 6
ipmitool raw 0x30 9 9 0 2 120
ipmitool raw 0x30 9 9 0 3 30

sbcupdate -Minfo

# ------------------end  program_sbc_all.sh ------------------

status=$?
#if [ $status != 0 ]
if [ $status -ne 0 ]; then
FAILMSG='SDR programming failed'
FAIL="yes"
fi

if [ "$FAIL" = "no" ]; then
sleep 30
sbcupdate -Minfo
sbcupdate -Minfo |grep 6.6.B
status = $?
#if [ $status ! = 0 ]
if [ $status -ne 0 ]; then
FAILMSG='SDR version is not 6.6.B'
$FAIL = "yes"
fi

fi

echo $'\a'		#beep

if [ "$FAIL" = "yes" ]; then
echo ''
echo $FAILMSG
echo '**********************************************************'
echo '*                                                        *'
echo '*            FRU/PN-SN/SDR Programming Failed !!!        *'
echo '*            FRU/PN-SN/SDR Programming Failed !!!        *'
echo '*            FRU/PN-SN/SDR Programming Failed !!!        *'
echo '*                                                        *'
echo '**********************************************************'
echo " error code is $status "
#exit 1

else


echo '**********************************************************'
echo '*                                                        *'
echo '*            FRU/PN-SN/SDR Programming Passed            *'
echo '*                                                        *'
echo '**********************************************************'
#exit 0
fi

