/**
 * @file  KMBC_low.h
 * @brief Defines the IOCTL interface to the KMBC_low Linux Driver.
 * @date  June 9, 2006
 *
 * INTEL CONFIDENTIAL	
 * Copyright 2013 Dialogic Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to 
 * the source code ("Material") are owned by Intel Corporation or its suppliers
 * or licensors.  Title to the Material remains with Intel Corporation or its 
 * suppliers and licensors.  The Material contains trade secrets and proprietary
 * and confidential information of Intel or its suppliers and licensors.  The
 * Material is protected by worldwide copyright and trade secret laws and treaty
 * provisions.  No part of the Material may be used, copied, reproduced, 
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Intel's prior express written permission.
 * 
 * No license under any patent, copyright, trade secret or other intellectual 
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise.  Any license under such intellectual property rights must be
 * express and approved by Intel in writing.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Intel or Intel's 
 * suppliers or licensors in any way.
 */


#ifndef __KMBC_LOW_H__
#define __KMBC_LOW_H__


#include <linux/version.h>
#include "KMBC_target.h"




/* Header Files */
#if defined( KMBC_USER_MODE )
#include <sys/ioctl.h>
#else
#ifdef CONFIG_COMPAT
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,15)
#include <linux/ioctl32.h>
#endif
#include <linux/compat.h>
#else
#include <linux/ioctl.h>
#endif
#endif
#include "hsi_interface.h"


/* Magic Numbers */
#define KMBCLOW_FILE_DEVICE                 ( 0x56 )




/* Define the IOCTLs available to the UMBC */
#define KMBC_LOW_INIT                       ( 0x0 )
#define KMBC_LOW_SHUTDOWN                   ( 0x1 )
#define KMBC_LOW_GET_BUFFER                 ( 0x2 )
#define KMBC_LOW_GET_INFO                   ( 0xF )

#define KMBC_LOW_INIT_IOCTL                 _IOWR( KMBCLOW_FILE_DEVICE, KMBC_LOW_INIT, int )
#define KMBC_LOW_SHUTDOWN_IOCTL             _IO(   KMBCLOW_FILE_DEVICE, KMBC_LOW_SHUTDOWN )
#define KMBC_LOW_GET_BUFFER_IOCTL           _IOWR( KMBCLOW_FILE_DEVICE, KMBC_LOW_GET_BUFFER, int )
#define KMBC_LOW_GET_INFO_IOCTL             _IOWR( KMBCLOW_FILE_DEVICE, KMBC_LOW_GET_INFO, int )




/* Data Structures used for passing data in and out of the KMBC_low driver */
typedef struct _tagKMBC_LOW_INIT_STRUCT
{
  int   BufferSize;    /* INPUT  - specifies the size of each HSI buffer           */
  int   NumBuffers;    /* INPUT  - specifies the number of HSI buffers to allocate */
  void  *CallbackAddr;  /* OUTPUT - will contain pointer to the ISR callback func   */
}
KMBC_LOW_INIT_STRUCT, *PKMBC_LOW_INIT_STRUCT;

typedef struct _tagKMBC_LOW_INIT_STRUCT32
{
  int   BufferSize;    /* INPUT  - specifies the size of each HSI buffer           */
  int   NumBuffers;    /* INPUT  - specifies the number of HSI buffers to allocate */
  unsigned int CallbackAddr;  /* OUTPUT - will contain pointer to the ISR callback func   */
}
KMBC_LOW_INIT_STRUCT32, *PKMBC_LOW_INIT_STRUCT32;

typedef struct _tagKMBC_LOW_GET_INFO_STRUCT
{
    void *CallbackAddr;
    void *hostToBoardBuffers;
    void *boardToHostBuffers;
}
KMBC_LOW_GET_INFO_STRUCT, *PKMBC_LOW_GET_INFO_STRUCT;


typedef struct _tagKMBC_LOW_GET_BUFFER_STRUCT
{
  void *VirtAddr;  /* INPUT  - specifies the virtual address returned from mmap()  */
  void *PhysAddr;  /* OUTPUT - will contain physical address of mapped region      */
}
KMBC_LOW_GET_BUFFER_STRUCT, *PKMBC_LOW_GET_BUFFER_STRUCT;

typedef struct _tagKMBC_LOW_GET_BUFFER_STRUCT32
{
  unsigned int VirtAddr;  /* INPUT  - specifies the virtual address returned from mmap()  */
  unsigned int PhysAddr;  /* OUTPUT - will contain physical address of mapped region      */
}
KMBC_LOW_GET_BUFFER_STRUCT32, *PKMBC_LOW_GET_BUFFER_STRUCT32;

typedef struct _kmbc_ts {
   unsigned int bridge;
   unsigned int rx;
   unsigned int tx;
   unsigned int enable;
} kmbc_ts;

#endif
