/**
 * @file  mma_sync.h
 * @brief Defines the lookup tables for the synchronization of the MMA board.
 * @date  November 14, 2007
 *
 * DIALOGIC CONFIDENTIAL	
 * Copyright 2007 Dialogic Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to 
 * the source code ("Material") are owned by Dialogic Corporation or its suppliers
 * or licensors.  Title to the Material remains with Dialogic Corporation or its 
 * suppliers and licensors.  The Material contains trade secrets and proprietary
 * and confidential information of Dialogic or its suppliers and licensors.  The
 * Material is protected by worldwide copyright and trade secret laws and treaty
 * provisions.  No part of the Material may be used, copied, reproduced, 
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Dialogic's prior express written permission.
 * 
 * No license under any patent, copyright, trade secret or other intellectual 
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise.  Any license under such intellectual property rights must be
 * express and approved by Dialogic in writing.
 * 
 * Unless otherwise agreed by Dialogic in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Dialogic or Dialogic's 
 * suppliers or licensors in any way.
 *
 * HISTORY 
 * Date       Who   Description  
 * 11-Nov-07  BMN   Created
 */


#ifndef __MMA_SYNC_H__
#define __MMA_SYNC_H__


unsigned int MMA_SLOWDOWN_LUT[31] = 
{	
	0x0A00, /* 1.000000: D1=16384, D1%=100, D2=N/A, D2%=N/A  */
	0x0911, /* 1.000005: D1=16384, D1%=90, D2=16385, D2%=10  */
	0x0812, /* 1.000010: D1=16384, D1%=80, D2=16385, D2%=20  */
	0x0812, /* 1.000015: D1=16384, D1%=80, D2=16385, D2%=20  */
	0x0713, /* 1.000020: D1=16384, D1%=70, D2=16385, D2%=30  */
	0x0614, /* 1.000025: D1=16384, D1%=60, D2=16385, D2%=40  */
	0x0515, /* 1.000030: D1=16384, D1%=50, D2=16385, D2%=50  */
	0x0416, /* 1.000035: D1=16384, D1%=40, D2=16385, D2%=60  */
	0x0317, /* 1.000040: D1=16384, D1%=30, D2=16385, D2%=70  */
	0x0317, /* 1.000045: D1=16384, D1%=30, D2=16385, D2%=70  */
	0x0218, /* 1.000050: D1=16384, D1%=20, D2=16385, D2%=80  */
	0x0119, /* 1.000055: D1=16384, D1%=10, D2=16385, D2%=90  */
	0x001A, /* 1.000060: D1=16384, D1%=00, D2=16385, D2%=100 */
	0x1921, /* 1.000065: D1=16385, D1%=90, D2=16386, D2%=10  */
	0x1921, /* 1.000070: D1=16385, D1%=90, D2=16386, D2%=10  */
	0x1822, /* 1.000075: D1=16385, D1%=80, D2=16386, D2%=20  */
	0x1723, /* 1.000080: D1=16385, D1%=70, D2=16386, D2%=30  */
	0x1624, /* 1.000085: D1=16385, D1%=60, D2=16386, D2%=40  */
	0x1525, /* 1.000090: D1=16385, D1%=50, D2=16386, D2%=50  */
	0x1426, /* 1.000095: D1=16385, D1%=40, D2=16386, D2%=60  */
	0x1426, /* 1.000100: D1=16385, D1%=40, D2=16386, D2%=60  */
	0x1327, /* 1.000105: D1=16385, D1%=30, D2=16386, D2%=70  */
	0x1228, /* 1.000110: D1=16385, D1%=20, D2=16386, D2%=80  */
	0x1129, /* 1.000115: D1=16385, D1%=10, D2=16386, D2%=90  */
	0x102A, /* 1.000120: D1=16385, D1%=00, D2=16386, D2%=100 */
	0x102A, /* 1.000125: D1=16385, D1%=00, D2=16386, D2%=100 */
	0x2931, /* 1.000130: D1=16386, D1%=90, D2=16387, D2%=10  */
	0x2832, /* 1.000135: D1=16386, D1%=80, D2=16387, D2%=20  */
	0x2733, /* 1.000140: D1=16386, D1%=70, D2=16387, D2%=30  */
	0x2634, /* 1.000145: D1=16386, D1%=60, D2=16387, D2%=40  */
	0x2535  /* 1.000150: D1=16386, D1%=50, D2=16387, D2%=50  */
};


unsigned int MMA_SPEEDUP_LUT[31] = 
{
	0x0A00, /* 1.000000: D1=16384, D1%=100, D2=N/A, D2%=N/A  */
	0x0951, /* 0.999995: D1=16384, D1%=90, D2=16383, D2%=10  */
	0x0852, /* 0.999990: D1=16384, D1%=80, D2=16383, D2%=20  */
	0x0852, /* 0.999985: D1=16384, D1%=80, D2=16383, D2%=20  */
	0x0753, /* 0.999980: D1=16384, D1%=70, D2=16383, D2%=30  */
	0x0654, /* 0.999975: D1=16384, D1%=60, D2=16383, D2%=40  */
	0x0555, /* 0.999970: D1=16384, D1%=50, D2=16383, D2%=50  */
	0x0456, /* 0.999965: D1=16384, D1%=40, D2=16383, D2%=60  */
	0x0357, /* 0.999960: D1=16384, D1%=30, D2=16383, D2%=70  */
	0x0357, /* 0.999955: D1=16384, D1%=30, D2=16383, D2%=70  */
	0x0258, /* 0.999950: D1=16384, D1%=20, D2=16383, D2%=80  */
	0x0159, /* 0.999945: D1=16384, D1%=10, D2=16383, D2%=90  */
	0x005A, /* 0.999940: D1=16384, D1%=00, D2=16383, D2%=100 */
	0x5961, /* 0.999935: D1=16383, D1%=90, D2=16382, D2%=10  */
	0x5961, /* 0.999930: D1=16383, D1%=90, D2=16382, D2%=10  */
	0x5862, /* 0.999925: D1=16383, D1%=80, D2=16382, D2%=20  */
	0x5763, /* 0.999920: D1=16383, D1%=70, D2=16382, D2%=30  */
	0x5664, /* 0.999915: D1=16383, D1%=60, D2=16382, D2%=40  */
	0x5565, /* 0.999910: D1=16383, D1%=50, D2=16382, D2%=50  */
	0x5466, /* 0.999905: D1=16383, D1%=40, D2=16382, D2%=60  */
	0x5466, /* 0.999900: D1=16383, D1%=40, D2=16382, D2%=60  */
	0x5367, /* 0.999895: D1=16383, D1%=30, D2=16382, D2%=70  */
	0x5268, /* 0.999890: D1=16383, D1%=20, D2=16382, D2%=80  */
	0x5169, /* 0.999885: D1=16383, D1%=10, D2=16382, D2%=90  */
	0x506A, /* 0.999880: D1=16383, D1%=00, D2=16382, D2%=100 */
	0x506A, /* 0.999875: D1=16383, D1%=00, D2=16382, D2%=100 */
	0x6971, /* 0.999870: D1=16382, D1%=90, D2=16381, D2%=10  */
	0x6872, /* 0.999865: D1=16382, D1%=80, D2=16381, D2%=20  */
	0x6773, /* 0.999860: D1=16382, D1%=70, D2=16381, D2%=30  */
	0x6674, /* 0.999855: D1=16382, D1%=60, D2=16381, D2%=40  */
	0x6575  /* 0.999850: D1=16382, D1%=50, D2=16381, D2%=50  */
};

#endif
