/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : debug.h
 * Description                  : debug definitions
 *
 *
 **********************************************************************/

#include <stdarg.h>

#ifdef DEBUGPRT

/* Externs needed for calls to drv_printf() */

extern  int DebugLevel;


/* Prototype */
int DebugPrintf(char *,...);


/* 
 * Dprintf guidelines
 *
 * Use:
 * dprintf  - for any error that you want to log always
 * dprintf1 - simple
 * dprintf2 - moderate 
 * dprintf3 - lots of logging
 * dprintf4 - for any logging in Interrupt routines (potentially expensive)
 * dprintf5 - for really obnoxious uneeded logging (e.g. "Entering Init function")
 */

#define  dprintf        DebugPrintf
#define  dprintf1       if ((DebugLevel >=1 )) DebugPrintf
#define  dprintf2       if ((DebugLevel >=2 )) DebugPrintf
#define  dprintf3       if ((DebugLevel >=3 )) DebugPrintf
#define  dprintf4       if ((DebugLevel >=4 )) DebugPrintf
#define  dprintf5       if ((DebugLevel >=5 )) DebugPrintf


#endif /* DEBUGPRT*/
