/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : mcdHsi.h
 * Description                  : Defines some new data types that are 
 *				   used to support the Host Streaming 
 *
 *
 **********************************************************************/

#ifndef __MCD_HSI__
#define __MCD_HSI__

#include "hsi_interface.h"
#include "msdtypes.h"


//#define PMMB struct STRM_MSG*
typedef STRM_MSG* PMMB;

//#define MMB struct STRM_MSG
typedef STRM_MSG MMB;


////
//  HSI Data Types
////
typedef struct
{
   PMMB               pMMB;          // MMB for message
   UCHAR              boardIndex;    // Store the Board ID
   PVOID              pSystemBuffer; // Stores the original system buffer
   unsigned int       startType;     // Hang on to this for BufferInitComplete
   unsigned long long TimeStamp;     // Used to track latency in sending async messages
}
HSI_MSG_CONTEXT, *PHSI_MSG_CONTEXT;


typedef struct
{
    void  *pBuffer;
    ULONG  BufferLen;
}
HSI_SYNC_CONTEXT, *PHSI_SYNC_CONTEXT;


#define KMBCLOW_FILE_DEVICE                 ( 0x56 )
#define KMBC_LOW_GET_INFO                   ( 0xF )
#define KMBC_LOW_GET_INFO_IOCTL             _IOWR( KMBCLOW_FILE_DEVICE, KMBC_LOW_GET_INFO, int )
typedef struct _tagKMBC_LOW_GET_INFO_STRUCT
{
    void *CallbackAddr;
    void *hostToBoardBuffers;
    void *boardToHostBuffers;
}
KMBC_LOW_GET_INFO_STRUCT, *PKMBC_LOW_GET_INFO_STRUCT;


#ifdef _MERCD_HSI_C
          int mercd_ww_generic_hsi_intr_processing(merc_ulong_t Context1);

          HSI_ISR_CALLBACK g_hsi_isr_callback;


#else
   extern int mercd_ww_generic_hsi_intr_processing(merc_ulong_t Context1);

   extern HSI_ISR_CALLBACK g_hsi_isr_callback;
#endif /* _MERCD_HSI_C */

////
//  Utility Macros
////
#define HSI_REG_WRITE( address, value ) \
   if( address ) { \
      writel( value, address ); \
   };

#define HSI_REG_READ( address ) \
   address && readl( address )


#endif	// __MCD_HSI__

