/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : mercd_osal.h
 * Description                  : OS abstraction layer definitions
 *
 *
 **********************************************************************/

#define MERCD_OSAL_DPC_REGISTER			0x0001
#define MERCD_OSAL_DPC_DEREGISTER		0x0002
#define MERCD_OSAL_INTR_REGISTER		0x0003
#define MERCD_OSAL_INTR_DEREGISTER		0x0004
#define MERCD_OSAL_MEM_PHYS_VIRT		0x0005
#define MERCD_OSAL_MEM_VIRT_FREE		0x0006
#define MERCD_OSAL_TIMEOUT_START		0x0007
#define MERCD_OSAL_TIMEOUT_STOP			0x0008


typedef struct _mercd_osal_mem_phys_virt{
	mercd_dev_info_T *dip;
	mercd_dev_acc_handle_T *DevAccHandlePtr;
	merc_int_t	RegSet;
	merc_uint_t	PhysAddr;
	merc_uint_t	ByteCount;
	merc_int_t	ConfigId;
	pmerc_void_t	ret;
}mercd_osal_mem_phys_virt_sT, *pmercd_osal_mem_phys_virt_sT;


typedef struct _mercd_osal_mem_virt_free{
	mercd_dev_acc_handle_T	*DevAccHandlePtr;
	size_t                  VirtAddr; /* Was merc_uint_t VirtAddr; */
	merc_uint_t             ByteCount;
	md_status_t             ret;
}mercd_osal_mem_virt_free_sT, *pmercd_osal_mem_virt_free_sT;

typedef struct _mercd_osal_timeout_start{
	PMD_FUNCTION	Function;
	pmerc_void_t	Context;
#ifdef LiS
	ssize_t		*Handle; /* Was -> INT32 *  Handle;  */
#else
	struct timer_list *Handle;
#endif /* LiS */
	merc_uint_t	Interval;
	md_status_t	ret;
}mercd_osal_timeout_start_sT, *pmercd_osal_timeout_start_sT;

typedef struct _mercd_osal_timeout_stop{
#ifdef LiS
	ssize_t		Handle;	/* Was -> merc_uint_t Handle; */
#else
	struct timer_list *Handle;
#endif /* LiS */
	md_status_t	ret;
}mercd_osal_timeout_stop_sT, *pmercd_osal_timeout_stop_sT;


typedef struct _mercd_osal_intr_register{
/* Why are we using all these; these are all defined in hw_info structure */
	mercd_dev_info_T   *dip;
	pmercd_hw_info_sT  phw_info;
	PMSD_FUNCTION      Isr;
	size_t             IsrArg;     /* Was -> ULONG   IsrArg; */
	size_t             *IsrHandle; /* Was -> PULONG  IsrHandle; */
	merc_uint_t        Level;
	merc_uint_t        IntrVector;
	merc_int_t         ConfigId;
	md_status_t        ret;
}mercd_osal_intr_register_sT, *pmercd_osal_intr_register_sT;

typedef struct _mercd_osal_intr_deregister{
	mercd_dev_info_T    *dip;  /* ASA */
	pmercd_hw_info_sT   phw_info;
	size_t              IsrArg;        /* Added for Linux  */
	size_t              IsrHandle;     /* Was -> ULONG IsrHandle; */
	merc_int_t          ConfigId;
	md_status_t         ret;
}mercd_osal_intr_deregister_sT, *pmercd_osal_intr_deregister_sT;

typedef struct _mercd_osal_dpc_register{
	PMD_FUNCTION        Function;
	pmercd_hw_info_sT   phw_info;
	pmerc_void_t        Context;
	size_t              *DpcHandle;	/* Was -> PULONG DpcHandle; */
	merc_uint_t         ConfigId;
	md_status_t         ret;
}mercd_osal_dpc_register_sT, *pmercd_osal_dpc_register_sT;


typedef struct _mercd_osal_dpc_deregister{
	size_t		DpcHandle;	/* Was -> merc_uint_t DpcHandle; */
	merc_uint_t	ConfigId;
	md_status_t	ret;
}mercd_osal_dpc_deregister_sT, *pmercd_osal_dpc_deregister_sT;

