/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : msddbg.h
 * Description                  : driver debug structure definitions
 *
 *
 **********************************************************************/

#ifndef _MSDDBG_
#define _MSDDBG_

// Mercury Driver Statistics Block (Driver Level)
typedef struct _MSD_STATISTICS_BLOCK {		// CD_STATS_BLOCK
	merc_uint_t TotalBlocksSent;
	merc_uint_t TotalBlocksReceived;
	merc_uint_t TotalBlocksDiscarded;
	merc_uint_t TotalMercuryMsgsSent;
	merc_uint_t TotalMercuryMsgsReceived;
} MSD_STATISTICS_BLOCK, *PMSD_STATISTICS_BLOCK;

// Mercury Driver Statistics Block (Driver Level)
typedef struct _MSD_DEBUG_BLOCK {
	merc_uint_t		MsdDebugAreaFlag;		// Specifies area
	merc_uint_t		MsdDebugPrintLevel;		// MsgLevel (Kaw) specifies level for prn
	merc_uint_t		MsdDebugTraceLevel;		// Specifies trace buff info level
} MSD_DEBUG_BLOCK, *PMSD_DEBUG_BLOCK;

// Defines for MdDebugArea
#define MSD_NO_DEBUG			0x00000000
#define MSD_STREAM_ENTIRE_AREA		0x00000001
#define MSD_STREAM_CONNECT_AREA		0x00000002
#define MSD_STREAM_CANTAKE_AREA		0x00000003
#define MSD_MESSAGE_ENTIRE_AREA		0x00000004
#define MSD_MESSAGE_BIGMSG_AREA		0x00000005

// Defines for MdDebugPrintLevel
#define MSD_NO_PRINT			-1
#define MSD_ALWAYS_PRINT		0x00000000
#define MSD_WARNING_PRINT		0x00004000
#define MSD_ERROR_PRINT			0x00008000
#define MSD_PANIC_PRINT			0x10000000
#define MSD_PRINT_LEVEL1		0x00000001
#define MSD_PRINT_LEVEL2		0x00000002
#define MSD_PRINT_LEVEL3		0x00000003

// Defines for MdDebugTareceLevel
#define MSD_NO_TRACE			0x00000000
#define MSD_TRACE_LEVEL1		0x00000001
#define MSD_TRACE_LEVEL2		0x00000002
#define MSD_TRACE_LEVEL3		0x00000003

#define NO_PARAMETERS			0
#define ONE_PARAMETER			1
#define TWO_PARAMETERS			2
#define THREE_PARAMETERS		3
#define FOUR_PARAMETERS			4
#define FIVE_PARAMETERS			5
#define SIX_PARAMETERS			6


// #define DEBUG_ENABLED 1

#ifdef DEBUG_ENABLED

#define MSD_FUNCTION_TRACE      i_printmsg
#define MSD_FUNCTION_TRACE_EX   printk
#define MSD_LEVEL1_TRACE        printk   //dbg_level1_trace
#define MSD_LEVEL2_TRACE        printk   //dbg_level2_trace
#define MSD_LEVEL3_TRACE        printk   //dbg_level3_trace

// Print defines
#define MSD_PRINT               printk   //dbg_always_print
#define MSD_LEVEL1_DBGPRINT     printk   //dbg_level1_print
#define MSD_LEVEL2_DBGPRINT     printk   //dbg_level2_print
#define MSD_LEVEL3_DBGPRINT     printk   //dbg_level3_print
#define MSD_WARN_DBGPRINT       printk   //dbg_warn_print
#define MSD_ERR_DBGPRINT        printk   //dbg_error_print
#define MSD_PANIC_DBGPRINT      printk   //dbg_panic_print

#else

#define MSD_FUNCTION_TRACE(args...)
#define MSD_FUNCTION_TRACE_EX(args...)
#define MSD_LEVEL1_TRACE(args...)
#define MSD_LEVEL2_TRACE(args...)
#define MSD_LEVEL3_TRACE(args...)

// Print defines
#define MSD_PRINT(args...)
#define MSD_LEVEL1_DBGPRINT(args...)
#define MSD_LEVEL2_DBGPRINT(args...)
#define MSD_LEVEL3_DBGPRINT(args...)
#define MSD_WARN_DBGPRINT(args...)
#define MSD_ERR_DBGPRINT                printk
#define MSD_PANIC_DBGPRINT(args...)

#endif

#define assert(assert)                                   \
do {                                                     \
   if (!(assert)) {                                      \
       printk (KERN_EMERG                                \
         "Assertion failure in %s() at %s:%d: \"%s\"\n", \
         __FUNCTION__, __FILE__, __LINE__, # assert);    \
   }                                                     \
} while (0)

#define MSD_ASSERT(x)           assert(x)
#define ASSERT(x)               assert(x)

#endif // _MSDDBG_
