/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : msdqueue.h
 * Description                  : queue data structure definitions
 *
 *
 **********************************************************************/

#ifndef _MSDQUEUE_
#define _MSDQUEUE_

// Generic MSD Message struct used by the MD queue functions
// It maps to any message block that has a Next pointer
// as the first field.

typedef struct _MSD_GEN_MSG {
	struct _MSD_GEN_MSG  *Next;
} MSD_GEN_MSG, *PMSD_GEN_MSG;

typedef struct _MSD_GEN_TWIN_LINK_MSG {
	struct _MSD_GEN_TWIN_LINK_MSG  *Next;
	struct _MSD_GEN_TWIN_LINK_MSG  *SecondNext;
} MSD_GEN_TWIN_LINK_MSG, *PMSD_GEN_TWIN_LINK_MSG;


// MSD_QUEUE definition
// Description: queue control struct
#ifdef LiS
typedef struct _MSD_QUEUE {
	pmerc_void_t	QueueHead;	/* pointer to head of queue*/
	pmerc_void_t	QueueTail;	/* pointer to head of queue*/
	merc_uint_t	HighWater;	/* high water mark*/
	merc_uint_t	LowWater;	/* low water mark*/
} MSD_QUEUE, *PMSD_QUEUE;
#else
#define WAITQUEUE_T wait_queue_head_t
#define ATOMIC_T atomic_t
#define TRUE 1
#define FALSE 0

typedef struct _MSD_QUEUE {
	pmerc_void_t       QueueHead;      /* pointer to head of queue*/
	pmerc_void_t       QueueTail;      /* pointer to head of queue*/
	merc_uint_t        HighWater;      /* high water mark*/
	merc_uint_t        LowWater;       /* low water mark*/
	mercd_mutex_T      readMutex;
	mercd_mutex_T      writeMutex;
	WAITQUEUE_T        readers;
	merc_uint_t        numberOfBlocks;
	ATOMIC_T           msgCapacity;
	ATOMIC_T           wrapAround;
} MSD_QUEUE, *PMSD_QUEUE;

typedef MSD_QUEUE      queue_t;
typedef MSD_QUEUE      *pmercd_strm_queue_sT;
#endif

#define MSD_QUEUE_EMPTY(Q)	((Q)->QueueHead==NULL)

#endif // _MSDQUEUE_
