/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : msdthread.h
 * Description                  : threading interface
 *
 *
 **********************************************************************/

#if ! defined( __MSDTHREAD_H__ )
#	define __MSDTHREAD_H__

#ifdef __USE_PTHREAD__
#	include	<pthread.h>

#	define	THR_BOUND    0
#	define	THR_NEW_LWP  0
#	define	THR_DETACHED 0
#	define	THR_SUSPEND  0
#	define	THR_DAEMON   0

#else
#	include	<thread.h>
#	include	<synch.h>
#endif 

#ifdef __USE_PTHREAD__

/* Posix Thread interface */

typedef pthread_t         msd_thread_t;
typedef	pthread_mutex_t   msd_mutex_t;
typedef	pthread_key_t     msd_thread_key_t;

#define msd_thread_join( _tid_, _param_ )  pthread_join(_tid_, (void **)&(_param_).status)  

#define msd_mutex_lock( _mutex_ )    pthread_mutex_lock(_mutex_)  
#define msd_mutex_unlock( _mutex_ )  pthread_mutex_unlock(_mutex_)  

#define msd_mutex_init( _mutex_, _attr_ )  pthread_mutex_init(_mutex_, _attr_)  

#define msd_thread_setspecific( _key_, _ret_)  pthread_setspecific((_key_), (void *) (_ret_)) 
#define msd_thread_getspecific( _key_, _ret_ )  _ret_ = pthread_getspecific( _key_ ) 

#define msd_thread_key_create(_key_, _dtor_, _ret_)  _ret_ = pthread_key_create((_key_), (_dtor_)) 

#define msd_thread_create(_tid_, _param_, _ThreadFunc_, _ThreadArg_) \
pthread_create(_tid_, (pthread_attr_t *) _param_.threadattr, _ThreadFunc_, _ThreadArg_)  

#else   /* USL Thread interface */

typedef	mutex_t        msd_mutex_t;
typedef thread_t       msd_thread_t;
typedef	thread_key_t   msd_thread_key_t;

#define msd_thread_join(_tid_, _param_)  thr_join(_tid_, (_param_).departedTid, (void **)&(_param_).status)  

#define msd_mutex_lock(_mutex_)       mutex_lock(_mutex_)  
#define msd_mutex_unlock(_mutex_)     mutex_unlock(_mutex_)  

#define msd_thread_setspecific(_key_, _ret_)  thr_setspecific((_key_), (void *)(_ret_)) 
#define msd_thread_getspecific(_key_, _ret_)  thr_getspecific((_key_), (void **)&(_ret_)) 

/* 
 * There is a caveat here, suppose we want to init a shared mutex between processes then we
 * need to set USYNC_PROCESS. 
 */
#define msd_mutex_init(_mutex_, _attr_)  mutex_init(_mutex_, USYNC_THREAD, _attr_) 

#define msd_thread_key_create(_key_, _dtor_, _retCode_) \
  _retCode_ = thr_keycreate((_key_), (_dtor_))

#define msd_thread_create(_tid_, _param_, _ThreadFunc_, _ThreadArg_) \
  thr_create(_param_.stackBase, _param_.stackSize, _ThreadFunc_, _ThreadArg_, _param_.flags, _tid_)  

#endif

/* 
 * Structure needed by both pthread_create() or thr_create() to make the
 * interface generic to both USL and POSIX.
 */
typedef struct {
    long    flags;          /* For USL thread */
    size_t  stackSize;      /* For USL thread */
    void*   stackBase;      /* For USL thread */
    void*   threadattr;     /* For Posix thread pthread_attr_t */
} msd_thread_create_param;

/* 
 * Structure needed by both pthread_join() or thr_join() to make the
 * interface generic to both USL and POSIX.
 */
typedef struct {
	msd_thread_t* departedTid;  /* For USL thread */
	void*        status;       /* For both Posix and USL threads */
} msd_thread_join_param;

#endif	/* __MSDTHREAD_H__ */
