/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2011 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : qhosttypes.h
 * Description                  : host type definitions
 *
 *
 **********************************************************************/

#ifndef __QHOSTTYPES_H__
#define __QHOSTTYPES_H__

//////////////////////////////////////////////////////////////
#include "qoscommon.h"
#ifdef QCPU
#undef QCPU		// redefining below
#endif
#define QLITTLEENDIAN
#ifndef QBIGENDIAN
#define QCPU QHOST_LITTLE_ENDIAN
#else
#define QCPU QHOST_BIG_ENDIAN
#endif
/////////////////////////////////////////////////////////////

#include "qtypes.h"

/* 16BIT Support */
#ifdef BITS8
  #define _8_BIT_INSTANCE
  #define QINST_WIDTH 8
#else
   #define QINST_WIDTH 16
#endif

/* Library types */
#ifdef _8_BIT_INSTANCE
typedef UInt16  QBindHandle;
#else
typedef UInt32  QBindHandle;
#endif

typedef int    QHandle;



/* Standard Mercury Function Returns */
typedef enum {QSTATUS_DONE, QSTATUS_PENDING, QSTATUS_ERROR, QSTATUS_NOERROR} 
	QStatus;


/*
 *  Operating system and CPU specific information - This drives 
 *  information in qcpu.h
 */

#ifdef __sparc   /* Sun sparc machine */

   /* Smallest accessable data type */
   #define QCHAR_BIT    8
   #define QCHAR_BYTE   1        /* Number of bytes per character(word) */


#ifdef SPARCPCI
   #define PCI
#endif /* UltraSparc PCI */

   /* Bus type of machine */
   #define VME

   /* Type of file handle for operating system */
   typedef int OSHandle;

   #define MERCD_SOFTINT_TYPE DDI_SOFTINT_LOW
#endif /* Sun sparc */

#if defined(__i386) || defined(i386) || defined(x86_64) || defined(__x86_64__)

   /* Smallest accessable data type */
   #define QCHAR_BIT    8
   #define QCHAR_BYTE   1        /* Number of bytes per character(word) */

   //#define MERCD_DATATYPE_INTEL /* Intel Data Type */ // defined in  Makefile

   /* Bus type of machine */
   #define PCI

   /* Type of file handle for operating system */
   typedef UInt32 OSHandle;

#ifdef sun
   #define MERCD_SOFTINT_TYPE DDI_SOFTINT_HIGH
#endif 
   #endif /* Solaris Intel */

/* AFTERMEETING */
/* Complex Mercury Types */
#ifdef AAAAAA
typedef  struct {
   Uint24 buf[3];
} QStreamRef;
#endif
/* AFTERMEETING */

#endif 

