/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2012 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : msdstrmmgr.c
 * Description                  : HSI driver interface
 *
 *
 **********************************************************************/

#define _MERCD_HSI_C
#include "mercd_hsi.h"
#undef  _MERCD_HSI_C

#ifdef SUPPORT_HSI

////
//  Header Files
////
#include <linux/version.h>
#include "msd.h"
#include "msdtypes.h"
#include "msdextern.h"
#include "hsi_interface.h"
#include "aspen.h"
#include "mercd_hsi.h"
#include "qtypes.h"
#include "qdrverr.h"
#include "msdpciif.h"

#include "hsidefs.h"

#ifdef SUPPORT_HEB
#   include "heb_interface.h"
#endif // SUPPORT_HEB

#include "qcomplib.h"

///////////////////////////////////////////////////////////////////////////////
// The following #defines and #undefs are needed for confdefs.h to compile.
///////////////////////////////////////////////////////////////////////////////
#define UInt32 UINT32
#define UInt24 UINT32
#define UInt16 UINT32
#define UInt8  UINT32
#define QCompDesc UINT32

#include "confdefs.h"

#undef UInt32
#undef UInt24
#undef UInt16
#undef UInt8
#undef QCompDesc
///////////////////////////////////////////////////////////////////////////////

typedef struct
{
    int                    Connect;
    HSI_BRIDGE_ROUTE_INPUT Data;    // It doesn't matter which is used, the structures are identical.
} HSI_SET_TS_CONTROL_BITS_INPUT, *PHSI_SET_TS_CONTROL_BITS_INPUT;

////
//  Magic Numbers
////
#define MAX_TIMESLOTS        256
#define ASPEN_TS_CONTROL_OFFSET  256*4

void        DumpBufferInitParms         (/*IN*/ PHSI_BRIDGE_INIT_INPUT pParms           ); // From this file.
int         mid_strmmgr_hsi_config_aspen(pmercd_adapter_block_sT padapter               ); // From this file.
md_status_t strm_ww_Q_snd_msg           (PSTRM_MSG Msg, pmercd_adapter_block_sT padapter); // From msdwwstrmutl.c

/***************************************************************************
 * Function Name       : mid_strmmgr_hsi_buffer_init
 * Function Type       : manager function
 * Inputs              : MsdOpenBlock
 *                       argp
 * Outputs             : none
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
int mid_strmmgr_hsi_buffer_init(pmercd_open_block_sT MsdOpenBlock, void *argp)
{
   HSI_BRIDGE_INIT_INPUT           hsiBridgeInitInput;
   PHSI_BRIDGE_INIT_INPUT          phsiBridgeInitInput           = &hsiBridgeInitInput;
   PHSI_BRIDGE_INIT_INPUT32        phsiBridgeInitInput32         = NULL;
   pmercd_adapter_block_sT         padapter                      = NULL;
   QKerHSIBufferInit_t            *pqKerHsiBufferInit            = NULL;
   QKerHSIBufferInit_BufferBase_t *pqKerHsiBufferInit_BufferBase = NULL;
   PMERC_HOSTIF_MSG                MercMsg                       = NULL;
   PSTRM_MSG                       NewMsg                        = NULL;
   PSTRM_MSG                       DataMsg                       = NULL;
   merc_uint_t                     ErrorCode                     = MD_OK;
   merc_uint_t                     ReturnValue                   = 0;
   merc_uint_t                     AdjustOffset                  = 0;
   merc_uint_t                     Result                        = 0;
   merc_uint_t                     AdapterNumber                 = 0;
   merc_uchar_t                    Flag                          = 0;
   int                             unlock                        = 0;
   merc_ushort_t                   commandSize                   = 0;
   merc_uint_t                     bufferIndex                   = 0;
   unsigned char                  *pBaseAddr                     = NULL;
#ifdef CONFIG_COMPAT
   struct file                    *kmbcfd                        = NULL;
   long lTmp=0;
   KMBC_LOW_GET_INFO_STRUCT        kmbcst;
#endif
   int compat = FALSE;

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_buffer_init(): Entering.\n");
   
#if defined(__x86_64__)
   /* check to see if 32/64bit task */
   if(is_compat_task()) {
      compat = TRUE;
   }
#endif

#ifdef CONFIG_COMPAT
   // 64bit - get information from KMBC directly
   MSD_EXIT_CONTROL_BLOCK_MUTEX_BH();
   kmbcfd = filp_open("/dev/kmbclow", O_RDWR, 0);
   kmbcst.CallbackAddr = &lTmp;
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,36)
   if ((kmbcfd > 0) && (kmbcfd->f_op->unlocked_ioctl(kmbcfd,KMBC_LOW_GET_INFO_IOCTL, &kmbcst) == 0)) {
#else
   if ((kmbcfd > 0) && (kmbcfd->f_op->ioctl(kmbcfd->f_dentry->d_inode,kmbcfd,KMBC_LOW_GET_INFO_IOCTL, &kmbcst) == 0)) {
#endif
       kmbcfd->f_op->release(kmbcfd,NULL);
       filp_close(kmbcfd,NULL);
   } else {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): Unable to retreive KMBC's ISR.\n");
       ErrorCode = CD_ERR_BAD_BOARD_STATE;
       ReturnValue = phsiBridgeInitInput->logicalId;
       MSD_ENTER_CONTROL_BLOCK_MUTEX_BH();
       goto out2;
   }
   MSD_ENTER_CONTROL_BLOCK_MUTEX_BH();
#endif

   if (argp == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): Null input data pointer.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = -1;
       goto out2;
   }

   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;

   if(compat) {
      phsiBridgeInitInput32 = (PHSI_BRIDGE_INIT_INPUT32) argp;
	  
      phsiBridgeInitInput->logicalId = phsiBridgeInitInput32->logicalId;
      phsiBridgeInitInput->bridgeId = phsiBridgeInitInput32->bridgeId;
      phsiBridgeInitInput->numTotalPorts = phsiBridgeInitInput32->numTotalPorts;
      phsiBridgeInitInput->numVoicePorts = phsiBridgeInitInput32->numVoicePorts;
      phsiBridgeInitInput->numDataPorts = phsiBridgeInitInput32->numDataPorts;
      phsiBridgeInitInput->portAllocCode = phsiBridgeInitInput32->portAllocCode;
      phsiBridgeInitInput->numHsiBuffers = phsiBridgeInitInput32->numHsiBuffers;
      phsiBridgeInitInput->tickRate = phsiBridgeInitInput32->tickRate;
      phsiBridgeInitInput->startType = phsiBridgeInitInput32->startType;
      phsiBridgeInitInput->busType = phsiBridgeInitInput32->busType;
      phsiBridgeInitInput->lawIdlePattern = phsiBridgeInitInput32->lawIdlePattern;
      phsiBridgeInitInput->syncTimeslot = phsiBridgeInitInput32->syncTimeslot;
      memcpy(phsiBridgeInitInput->syncPattern, &phsiBridgeInitInput32->syncPattern, 4 * sizeof( char ));
      phsiBridgeInitInput->hmpIsrFunc = phsiBridgeInitInput32->hmpIsrFunc;
      phsiBridgeInitInput->hmpSyncComplete = phsiBridgeInitInput32->hmpSyncComplete;
      for( bufferIndex = 0; bufferIndex < phsiBridgeInitInput32->numHsiBuffers; bufferIndex++ )
      {
         phsiBridgeInitInput->hostToBoardBuffers[bufferIndex] = phsiBridgeInitInput32->hostToBoardBuffers[bufferIndex];
         phsiBridgeInitInput->boardToHostBuffers[bufferIndex] = phsiBridgeInitInput32->boardToHostBuffers[bufferIndex];
	  }
   } else {
      phsiBridgeInitInput = (PHSI_BRIDGE_INIT_INPUT) argp;
   }

   if (phsiBridgeInitInput->hmpIsrFunc == NULL) {
      MSD_ERR_DBGPRINT( "mid_strmmgr_hsi_buffer_init(): NULL Interrupt handler pointer (hmpIsrFunc = 0x00000000).\n");
      ErrorCode = CD_ERR_BAD_PARAMETER;
      ReturnValue = phsiBridgeInitInput->logicalId;
      goto out2;
   }

   if (phsiBridgeInitInput->logicalId >= MSD_MAX_BOARD_ID_COUNT) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): Invalid LogicalId %d\n", phsiBridgeInitInput->logicalId);
      ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
      ReturnValue = phsiBridgeInitInput->logicalId;
      goto out2;
   }

   // The caller can supply a number of fall behind buffers, but we need to make
   // sure that the number provided does not exceed the maximum number, which
   // is used to size the arrays in the input structure.  If a number is provided
   // which would exceed this maximum, log the error and fail the request.
   if( phsiBridgeInitInput->numHsiBuffers > HSI_MAX_BUFFERS )
   {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): Too many fall behind buffers (%d > %d).\n",
             phsiBridgeInitInput->numHsiBuffers, HSI_MAX_BUFFERS);
      ErrorCode = CD_ERR_BAD_PARAMETER;
      ReturnValue = phsiBridgeInitInput->logicalId;
      goto out2;
   }

   // The last bit of parameter validation is a check to ensure that the transmit
   // and receive buffer arrays have been loaded with valid data.  We need to make
   // sure that none of the valid entries contain NULL pointers.  If we find even
   // a single invalid entry, log the error and fail the request.
   for( bufferIndex = 0; bufferIndex < phsiBridgeInitInput->numHsiBuffers; bufferIndex++ )
   {
      if ( ( phsiBridgeInitInput->hostToBoardBuffers[bufferIndex] == 0 ) ||
           ( phsiBridgeInitInput->boardToHostBuffers[bufferIndex] == 0 )   )
      {
         MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): Invalid tx/rx buffers (0x%lx, 0x%lx) at index %d.\n",
                phsiBridgeInitInput->hostToBoardBuffers[bufferIndex],
                phsiBridgeInitInput->boardToHostBuffers[bufferIndex],
                bufferIndex );
          ErrorCode = CD_ERR_BAD_PARAMETER;
          ReturnValue = phsiBridgeInitInput->logicalId;
          goto out2;
      }
   }

   AdapterNumber = mercd_adapter_log_to_phy_map_table[phsiBridgeInitInput->logicalId];

   if (AdapterNumber == 0xFF) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): Unable to Map LogicalId %d\n", phsiBridgeInitInput->logicalId);
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = phsiBridgeInitInput->logicalId;
       goto out2;
   }

   padapter = MsdControlBlock->padapter_block_list[AdapterNumber];

   if (padapter == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): No Adapter %d at Id %d\n", AdapterNumber, phsiBridgeInitInput->logicalId);
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = phsiBridgeInitInput->logicalId;
       goto out2;
   }

   MSD_ENTER_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   pBaseAddr = (unsigned char *)(padapter->phw_info->virt_map_q[MERCD_PCI_SRAM_MAP]->virt_addr);

   padapter->hsiRegClearMsgReadyInterrupt = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_CLEAR_MSGRDY_INTR);
   padapter->hsiRegClearRateInterrupt     = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_CLEAR_RATE_INTR);
   padapter->hsiRegTdmResourceSelect      = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_RESOURCE_SELECT);
   padapter->hsiRegTdmEnable              = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_TDM_ENABLE);
   padapter->hsiRegClockingMode           = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_CLOCKING_MODE);
   padapter->hsiRegInterruptRate          = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_INTERRUPT_RATE);
   padapter->hsiRegInterruptEnable        = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_INTERRUPT_ENABLE);
   padapter->hsiRegALawIdlePattern        = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_ALAW_IDLE_PATTERN);
   padapter->hsiRegMuLawIdlePattern       = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_MULAW_IDLE_PATTERN);
   padapter->hsiReg8BitTransPattern       = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_8BIT_TRANS_IDLE_PATTERN);
   padapter->hsiReg16BitTransPattern      = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_16BIT_TRANS_IDLE_PATTERN);
   padapter->hsiRegPingPongControl        = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_PING_PONG_CONTROL);
   padapter->hsiRegSyncPattern            = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_SYNC_PATTERN);
   padapter->hsiRegDataPacking            = (pmerc_uint_t)(pBaseAddr + REG_OFFSET_DATA_PACKING);
   padapter->hsiRegTsControlBitsBase      = (pmerc_uint_t)(pBaseAddr + REG_TIMESLOT_CONTROL_BASE);

#ifdef CONFIG_COMPAT
   padapter->hsi_isr_callback = (HSI_ISR_CALLBACK) kmbcst.CallbackAddr;
#else
   padapter->hsi_isr_callback = (HSI_ISR_CALLBACK) phsiBridgeInitInput->hmpIsrFunc;
#endif

   padapter->hsiMsdOpenBlock = MsdOpenBlock;

   /* Check for STARTED instead of READY dm3stderr   */
   if ((padapter->state != MERCD_ADAPTER_STATE_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_CP_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_DOWNLOADED)) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): Adapter State not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = phsiBridgeInitInput->logicalId;
      goto out;
   }

   /* Check for STARTED instead of READY dm3stderr   */
   if ((!(padapter->flags.WWFlags & MERCD_ADAPTER_WW_I20_MESSAGING_READY) ||
       !(padapter->pww_info->state == MERCD_ADAPTER_WW_SUCCEDED)) &&
       (padapter->phw_info->pciSubSysId != PCI_SUBDEVICE_ID_GEM)) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): Werewolf interface is not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = phsiBridgeInitInput->logicalId;
      goto out;
   }

   padapter->hsiTdmResSelect                  = TDM_RESOURCE_DEFAULT_CONFIG       ;
   padapter->hsiInterruptRate                 = TDM_INTERRUPT_RATE_2MS            ;
   padapter->hsiClockingMode                  = CLOCKING_MODE_DEFAULT_CONFIG      ;
   padapter->hsiTransparent16bitIdlePattern   = 0x0000                            ;
   padapter->hsiTransparent8bitIdlePattern    = 0x00                              ;
   padapter->hsiDataPacking                   = PACKING_MODE_16BIT                ;
   padapter->hsiStartType                     = phsiBridgeInitInput->startType    ;
   padapter->hsiBridgeId                      = phsiBridgeInitInput->bridgeId     ;
   padapter->hsiNumVoicePorts                 = phsiBridgeInitInput->numVoicePorts;
   padapter->hsiNumDataPorts                  = phsiBridgeInitInput->numDataPorts ;
   padapter->hsiPortAllocCode                 = phsiBridgeInitInput->portAllocCode;

   if (padapter->hsiStartType == HSI_START_ON_SYNC) {
      padapter->hsiStartOnSync = 1;
   } else {
      padapter->hsiStartOnSync = 0;
   }

   memcpy((void*)&(padapter->hsiSyncPattern), phsiBridgeInitInput->syncPattern, 4 * sizeof( char ));

   // Set all timeslots to IDLE
   padapter->hsiLawType = phsiBridgeInitInput->busType;

   switch( padapter->hsiLawType )
   {
   case( HSI_BUS_TYPE_TRANSPARENT ):
      padapter->hsiIdlePattern   = 0x0;
      padapter->hsiTsControlBits = TS_CONTROL_TRANSPARENT_DEFAULT;
      break;

   case( HSI_BUS_TYPE_ALAW ):
      padapter->hsiIdlePattern   = phsiBridgeInitInput->lawIdlePattern;
      padapter->hsiTsControlBits = TS_CONTROL_ALAW_DEFAULT;
	  break;

   case( HSI_BUS_TYPE_MULAW ):
      padapter->hsiIdlePattern   = phsiBridgeInitInput->lawIdlePattern;
      padapter->hsiTsControlBits = TS_CONTROL_MULAW_DEFAULT;
	  break;

   default:
	   break;
   }

   // Gemini: no FW running - driver will setup HSI
   if (padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_GEM) {
       mid_strmmgr_hsi_gemini(padapter, MSD_GEM_INIT, (pmerc_void_t) phsiBridgeInitInput);    
       MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);
       MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_buffer_init(): Exiting.\n");
       return 0;
   }

   // Clear the Mailbox 3 so board interrupt immediately upon processing the BRIDGE_INIT message.
   MsdWWPlxWriteToPlxRegister(MERCD_WW_PLX_MAILBOX_3_REG, 0);

   // get a new message block
   NewMsg = supp_alloc_buf(sizeof(MDRV_MSG),GFP_ATOMIC);
   if (NewMsg == NULL) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): Msg allocbuf failed\n");
      ErrorCode = PAM_ERR_NO_MEMORY;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   commandSize = QKerHSIBufferInit_Size + (phsiBridgeInitInput->numHsiBuffers * QKerHSIBufferInit_BufferBase_Size);

   DataMsg = supp_alloc_buf(sizeof(MERC_HOSTIF_MSG) + commandSize, GFP_ATOMIC);
   if (DataMsg == NULL) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): Cannot alloc Data buffer\n");
      ErrorCode = PAM_ERR_NO_MEMORY;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   MD_SET_MSG_TYPE(DataMsg, M_DATA);
   ////////////////////////////////////////////////////////////////////////////////////////////////////
   // Design Notes:                                                                                  //
   // -------------                                                                                  //
   // Stream Message will consist of two messages that are linked in the following order:            //
   //    1) NewMsg                                                                                   //
   //    2) DataMsg                                                                                  //
   //                                                                                                //
   // NewMsg will represent the complete message.  The following is NewMsg's structure.              //
   //   NewMsg (of type PSTRM_MSG (aka msgb_t* aka m_blk_t*))                                        //
   //      Note: It is sometimes named as Msg or SendMsg.                                            //
   //      It points to a Driver Header Block of type MDRV_MSG, which is usually named MdMsg.        //
   //      It points to DataMsg (also of type PSTRM_MSG (aka msgb_t* aka m_blk_t*))                  //
   //      DataMsg points to a Host Interface Block (of type MERC_HOSTIF_MSG (aka MERCURY_MESSAGE),  //
   //         which is usually named MercMsg).                                                       //
   //                                                                                                //
   //   The following is the mapping of pointers to sub-structures.                                  //
   //      NewMsg->b_rptr         = MdMsg   (type MDRV_MSG       )                                   //
   //      NewMsg->b_cont         = DataMsg (type PSTRM_MSG      )                                   //
   //      NewMsg->b_cont->b_rptr = MercMsg (type MERC_HOSTIF_MSG)                                   //
   //         Notes:                                                                                 //
   //            1) b_rptr represents a read pointer.  There is a b_wptr that represents a write     //
   //                  pointer.                                                                      //
   //            2) b_cont resprents a continue pointer.  This is used to link the NewMsg with the   //
   //                  DataMsg.                                                                      //
   //            3) There are b_next and b_prev pointers which allow NewMsgs to be kept in a         //
   //                  doubly-linked list.                                                           //
   //            4) There is a pointer called b_datap that points to a datab_t (aka dblk_t), which   //
   //                  contains location and size information about the NewMsg.                      //
   //                                                                                                //
   //   NewMsg can have a payload, but it is usually not used.                                       //
   //      You can use the macro MD_GET_MDMSG_PAYLOAD(NewMsg) to get a pointer to the payload.       //
   //         If this message is from/to the Firmware, the payload will be defined in the kernel     //
   //             header file hsidefs.h for HSI Messages.  Many other Kernel Messages are defined in //
   //             confdefs.h (for configuration messages) and mercdefs.h.                            //
   //         If this messages is from/to the Host, the payload will be defined in hsi_interface.h   //
   //            for HSI Messages, heb_interface.h for HEB messages.  Many other messages will be    //
   //            defined in the following header files: qstream.h, qaccess.h, and qinit.h.           //
   //   DataMsg usually has a payload.                                                               //
   //     You can use the macro MERCURY_BODY_START(DataMsg) to get a pointer to the payload.         //
   ////////////////////////////////////////////////////////////////////////////////////////////////////
   MSD_LINK_MESSAGE(NewMsg, DataMsg);

   MercMsg = (PMERC_HOSTIF_MSG)DataMsg->b_rptr;
   MERCURY_SET_BODY_SIZE(MercMsg, commandSize);

   Flag = MERCURY_FLAG_32_ALIGNMENT|MERCURY_FLAG_NULL_BUFFER;
   MERCURY_SET_MESSAGE_FLAG(MercMsg, Flag);
   MERCURY_SET_MESSAGE_CLASS(MercMsg, MERCURY_CLASS_SYSTEM);
   MERCURY_SET_MESSAGE_TYPE(MercMsg, QKerHSIBufferInit);

   MERCURY_SET_TRANSACTION_ID(MercMsg,padapter->TransactionId);
   padapter->TransactionId= ((padapter->TransactionId + 1)%0xFFFF);

   // Transation id may overflow in next 1-2 quarters.
   // Better solution will be provided. If the transation
   // id is  wrapped around, and that id is already in open,
   // we have a possible problem.
   if (padapter->TransactionId == 0xFFFFFFFF)
      MSD_ERR_DBGPRINT("Transaction ID overflow   \n");

   MERCURY_SET_DEST_NODE(MercMsg, DEFAULT_DEST_NODE);
   MERCURY_SET_DEST_PROC(MercMsg, QCOMP_P_CP);
   MERCURY_SET_DEST_COMP(MercMsg, QCOMP_C_SYS_SERVICE);
   MERCURY_SET_DEST_INST(MercMsg, QCOMP_I_HSIMGR);
   MERCURY_SET_SOURCE_PROC(MercMsg, DEFAULT_SOURCE_PROC);

   pqKerHsiBufferInit             = (QKerHSIBufferInit_t*)MERCURY_BODY_START(MercMsg);
   pqKerHsiBufferInit->revision   = QHSI_PROTOCOL_VERSION_1;
   pqKerHsiBufferInit->bridgeSize = phsiBridgeInitInput->numTotalPorts;
   pqKerHsiBufferInit->tickRate   = phsiBridgeInitInput->tickRate;
   pqKerHsiBufferInit->startType  = phsiBridgeInitInput->startType;
   pqKerHsiBufferInit->numBufs    = phsiBridgeInitInput->numHsiBuffers;
   pqKerHsiBufferInit->rxSyncTs   = phsiBridgeInitInput->syncTimeslot;

   pqKerHsiBufferInit_BufferBase = (QKerHSIBufferInit_BufferBase_t *)(((PUCHAR)pqKerHsiBufferInit) + QKerHSIBufferInit_Size);
   padapter->hsiBuffers = phsiBridgeInitInput->numHsiBuffers;

   for( bufferIndex = 0; bufferIndex < phsiBridgeInitInput->numHsiBuffers; bufferIndex++ )
   {
      pqKerHsiBufferInit_BufferBase[bufferIndex].txHigh = 0; // phsiBridgeInitInput->hostToBoardBuffers[bufferIndex].HighPart;
      pqKerHsiBufferInit_BufferBase[bufferIndex].txLow  = (int) phsiBridgeInitInput->hostToBoardBuffers[bufferIndex];
      pqKerHsiBufferInit_BufferBase[bufferIndex].rxHigh = 0; // phsiBridgeInitInput->boardToHostBuffers[bufferIndex].HighPart;
      pqKerHsiBufferInit_BufferBase[bufferIndex].rxLow  = (int) phsiBridgeInitInput->boardToHostBuffers[bufferIndex];
      padapter->H2B[bufferIndex] = phsiBridgeInitInput->hostToBoardBuffers[bufferIndex];
      padapter->B2H[bufferIndex] = phsiBridgeInitInput->boardToHostBuffers[bufferIndex];
      MSD_LEVEL1_DBGPRINT("pqKerHsiBufferInit_BufferBase[bufferIndex].txLow : 0x%08x\n", pqKerHsiBufferInit_BufferBase[bufferIndex].txLow);
      MSD_LEVEL1_DBGPRINT("pqKerHsiBufferInit_BufferBase[bufferIndex].rxLow : 0x%08x\n", pqKerHsiBufferInit_BufferBase[bufferIndex].rxLow);
   }
   MSD_LEVEL1_DBGPRINT("mid_strmmgr_hsi_buffer_init(): phsiBridgeInitInput->numTotalPorts: 0x%08x\n", phsiBridgeInitInput->numTotalPorts);

            ///////////////////////////////////////
   Result = strm_ww_Q_snd_msg(NewMsg, padapter); //
            ///////////////////////////////////////

   if (Result != MD_SUCCESS) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init: strm_ww_Q_snd_msg failed.\n");
      ErrorCode = Result;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_buffer_init(): Exiting.\n");
   return 0;

///////
out: //
///////
   unlock=1;

////////
out2: //
////////
   // Only Errors are handled here
   MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_init(): ErrorCode=%d  ReturnValue=%d\n", ErrorCode, ReturnValue);

   mercd_streams_free(NewMsg, MERCD_STREAMS_BUFFER , MERCD_FORCE);

   if (unlock)
      MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);
   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_buffer_init(): Exiting.\n");
   return -EFAULT;
}


/***************************************************************************
 * Function Name       : mid_strmmgr_hsi_buffer_stop
 * Function Type       : manager function
 * Inputs              : MsdOpenBlock
 *                       argp
 * Outputs             : none
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
int mid_strmmgr_hsi_buffer_stop(pmercd_open_block_sT MsdOpenBlock, void *argp)
{
   pmerc_uint_t                    pLogicalId                    = NULL;
   pmercd_adapter_block_sT         padapter                      = NULL;
   PMERC_HOSTIF_MSG                MercMsg                       = NULL;
   PSTRM_MSG                       NewMsg                        = NULL;
   PSTRM_MSG                       DataMsg                       = NULL;
   merc_uint_t                     ErrorCode                     = MD_OK;
   merc_uint_t                     ReturnValue                   = 0;
   merc_uint_t                     Result                        = 0;
   merc_uint_t                     AdapterNumber                 = 0;
   merc_uchar_t                    Flag                          = 0;
   int                             unlock                        = 0;
   merc_ushort_t                   commandSize                   = 0;
   int                             i                             = 0;

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_buffer_stop(): Entering.\n");

   if (argp == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): Null input data pointer.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = -1;
       goto out2;
   }

   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;
   pLogicalId = (pmerc_uint_t) argp;

   if (*pLogicalId >= MSD_MAX_BOARD_ID_COUNT) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = *pLogicalId;
       goto out2;
   }

   AdapterNumber = mercd_adapter_log_to_phy_map_table[*pLogicalId];

   if (AdapterNumber == 0xFF) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = *pLogicalId;
       goto out2;
   }

   padapter = MsdControlBlock->padapter_block_list[AdapterNumber];

   if (padapter == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = *pLogicalId;
       goto out2;
   }

   MSD_ENTER_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   padapter->hsiMsdOpenBlock = MsdOpenBlock;

   /* Check for STARTED instead of READY dm3stderr   */
   if ((padapter->state != MERCD_ADAPTER_STATE_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_CP_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_DOWNLOADED)) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): Adapter State not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = *pLogicalId;
      goto out;
   }

   // Gemini: no FW running - driver will setup HSI
   if (padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_GEM) {
       mid_strmmgr_hsi_gemini(padapter, MSD_GEM_STOP, padapter);
       MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);
       MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_buffer_stop(): Exiting.\n");
       return 0;
   }

   /* Check for STARTED instead of READY dm3stderr   */
   if (!(padapter->flags.WWFlags & MERCD_ADAPTER_WW_I20_MESSAGING_READY) ||
       !(padapter->pww_info->state == MERCD_ADAPTER_WW_SUCCEDED        )   ) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): Werewolf interface is not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = *pLogicalId;
      goto out;
   }

   // get a new messgae block
   NewMsg = supp_alloc_buf(sizeof(MDRV_MSG),GFP_ATOMIC);
   if (NewMsg == NULL) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): Msg allocbuf failed\n");
      ErrorCode = PAM_ERR_NO_MEMORY;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   commandSize = QKerHSIBufferStop_Size;

   DataMsg = supp_alloc_buf(sizeof(MERC_HOSTIF_MSG) + commandSize, GFP_ATOMIC);
   if (DataMsg == NULL) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): Cannot alloc Data buffer\n");
      ErrorCode = PAM_ERR_NO_MEMORY;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   MD_SET_MSG_TYPE(DataMsg, M_DATA);
   MSD_LINK_MESSAGE(NewMsg, DataMsg);

   MercMsg = (PMERC_HOSTIF_MSG)DataMsg->b_rptr;
   MERCURY_SET_BODY_SIZE(MercMsg, commandSize);

   Flag = MERCURY_FLAG_32_ALIGNMENT|MERCURY_FLAG_NULL_BUFFER;
   MERCURY_SET_MESSAGE_FLAG(MercMsg, Flag);
   MERCURY_SET_MESSAGE_CLASS(MercMsg, MERCURY_CLASS_SYSTEM);
   MERCURY_SET_MESSAGE_TYPE(MercMsg, QKerHSIBufferStop);

   MERCURY_SET_TRANSACTION_ID(MercMsg,padapter->TransactionId);
   padapter->TransactionId= ((padapter->TransactionId + 1)%0xFFFF);

   // Transation id may overflow in next 1-2 quarters.
   // Better solution will be provided. If the transation
   // id is  wrapped around, and that id is already in open,
   // we have a possible problem.
   if (padapter->TransactionId == 0xFFFFFFFF)
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): Transaction ID overflow   \n");

   MERCURY_SET_DEST_NODE(MercMsg, DEFAULT_DEST_NODE);
   MERCURY_SET_DEST_PROC(MercMsg, QCOMP_P_CP);
   MERCURY_SET_DEST_COMP(MercMsg, QCOMP_C_SYS_SERVICE);
   MERCURY_SET_DEST_INST(MercMsg, QCOMP_I_HSIMGR);
   MERCURY_SET_SOURCE_PROC(MercMsg, DEFAULT_SOURCE_PROC);

            ///////////////////////////////////////
   Result = strm_ww_Q_snd_msg(NewMsg, padapter); //
            ///////////////////////////////////////

   if (Result != MD_SUCCESS) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): strm_ww_Q_snd_msg failed.\n");
      ErrorCode = Result;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   if (g_pAllocatedMemoryIndex > 0) {
      for (i = 0; i < K_MAX_HSI_BLOCKS; i++) {
         if (g_pAllocatedMemory[i] != NULL) {
            MSD_FREE_KERNEL_MEMORY((PVOID)g_pAllocatedMemory[i], K_HSI_BLOCK_SIZE);
            g_pAllocatedMemory[i] = 0;
         }
      }
      g_pAllocatedMemoryIndex = 0;
   }

   MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_buffer_stop(): Exiting.\n");
   return 0;

///////
out: //
///////
   unlock=1;

////////
out2: //
////////
   // Only Errors are handled here
   MSD_ERR_DBGPRINT("mid_strmmgr_hsi_buffer_stop(): ErrorCode=%d  ReturnValue=%d\n", ErrorCode, ReturnValue);

   mercd_streams_free(NewMsg, MERCD_STREAMS_BUFFER , MERCD_FORCE);

   if (unlock)
      MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_buffer_stop(): Exiting.\n");
   return -EFAULT;
}


/***************************************************************************
 * Function Name       : mid_strmmgr_hsi_rate_interrupt_enable
 * Function Type       : manager function
 * Inputs              : MsdOpenBlock
 *                       argp
 * Outputs             : none
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
int mid_strmmgr_hsi_rate_interrupt_enable(pmercd_open_block_sT MsdOpenBlock, void *argp)
{
   pmerc_uint_t                   pLogicalId                    = NULL;
   pmercd_adapter_block_sT        padapter                      = NULL;
   PMDRV_MSG                       NewMdMsg                      = NULL;
   PSTRM_MSG                       NewMsg                        = NULL;
   merc_uint_t                     ErrorCode                     = MD_OK;
   merc_uint_t                     ReturnValue                   = 0;
   merc_uint_t                     AdapterNumber                 = 0;
   int                             unlock                        = 0;
   PHSI_BRIDGE_INTR_ENABLE_OUTPUT  phsiIntrRateEnableOutput      = NULL;
   merc_uint_t                     payloadSize                   = 0;
   volatile pmerc_uint_t          regAddress;


   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_rate_interrupt_enable(): Entering.\n");

   if (argp == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_enable(): Null input data pointer.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = -1;
       goto out2;
   }

   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;
   pLogicalId = (pmerc_uint_t) argp;

   if (*pLogicalId >= MSD_MAX_BOARD_ID_COUNT) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_enable(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = *pLogicalId;
       goto out2;
   }

   AdapterNumber = mercd_adapter_log_to_phy_map_table[*pLogicalId];

   if (AdapterNumber == 0xFF) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_enable(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = *pLogicalId;
       goto out2;
   }

   padapter = MsdControlBlock->padapter_block_list[AdapterNumber];

   if (padapter == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_enable(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = *pLogicalId;
       goto out2;
   }

   MSD_ENTER_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   /* Check for STARTED instead of READY dm3stderr   */
   if ((padapter->state != MERCD_ADAPTER_STATE_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_CP_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_DOWNLOADED)) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_enable(): Adapter State not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = *pLogicalId;
      goto out;
   }

   // Gemini: no FW running - driver will setup HSI
   if (padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_GEM) {
       mid_strmmgr_hsi_gemini(padapter, MSD_GEM_TDM_ON, NULL);
       MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);
       goto End;
   }

   /* Check for STARTED instead of READY dm3stderr   */
   if (!(padapter->flags.WWFlags & MERCD_ADAPTER_WW_I20_MESSAGING_READY) ||
       !(padapter->pww_info->state == MERCD_ADAPTER_WW_SUCCEDED        )   ) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_enable(): Werewolf interface is not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = *pLogicalId;
      goto out;
   }

   // Enable the HSI Rate Interrupt by writing a 1 to the PLX Mailbox 3 Register.
   /////////////////////////////////////////////////////////////
   MsdWWPlxWriteToPlxRegister(MERCD_WW_PLX_MAILBOX_3_REG, 1); //
   /////////////////////////////////////////////////////////////

   if( padapter->hsiStartOnSync == FALSE )
	{
	   regAddress = (volatile pmerc_uint_t)((pmerc_uchar_t)padapter->hsiRegTdmEnable);
		*regAddress = TDM_ENABLE_ON_FRAME_SYNC;
	}


   MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

End:
   payloadSize = sizeof(HSI_BRIDGE_INTR_ENABLE_OUTPUT);
   NewMsg = supp_alloc_buf(sizeof(MDRV_MSG) + payloadSize, GFP_ATOMIC);
   if(NewMsg == NULL) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_enable(): Cannot alloc Msg buffer\n");
      return(-EFAULT);
   }
   MD_SET_MSG_TYPE(NewMsg, M_DATA);

   NewMdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(NewMsg);
   MD_SET_MSG_WRITE_PTR(NewMsg,
                       (MD_GET_MSG_READ_PTR(NewMsg)+sizeof(MDRV_MSG)+payloadSize));

   phsiIntrRateEnableOutput           = (PHSI_BRIDGE_INTR_ENABLE_OUTPUT) MD_GET_MDMSG_PAYLOAD(NewMdMsg);
   phsiIntrRateEnableOutput->type     = HSI_BRIDGE_INTR_ENABLE_COMPLETION;
   phsiIntrRateEnableOutput->bridgeId = padapter->hsiBridgeId;

   //////////////////////////////////////////////
   supp_process_receive(MsdOpenBlock, NewMsg); //
   //////////////////////////////////////////////

   return 0;

///////
out: //
///////
   unlock=1;

////////
out2: //
////////
   // Only Errors are handled here
   MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_enable: ErrorCode=%d  ReturnValue=%d\n", ErrorCode, ReturnValue);

   if (unlock)
      MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_rate_interrupt_enable(): Exiting\n");
   return -EFAULT;
}


/***************************************************************************
 * Function Name       : mid_strmmgr_hsi_rate_interrupt_disable
 * Function Type       : manager function
 * Inputs              : MsdOpenBlock
 *                       argp
 * Outputs             : none
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
int mid_strmmgr_hsi_rate_interrupt_disable(pmercd_open_block_sT MsdOpenBlock, void *argp)
{
   pmerc_uint_t                   pLogicalId                    = NULL;
   pmercd_adapter_block_sT        padapter                      = NULL;
   PMDRV_MSG                       NewMdMsg                      = NULL;
   PSTRM_MSG                       NewMsg                        = NULL;
   merc_uint_t                     ErrorCode                     = MD_OK;
   merc_uint_t                     ReturnValue                   = 0;
   merc_uint_t                     AdapterNumber                 = 0;
   int                             unlock                        = 0;
   PHSI_BRIDGE_INTR_DISABLE_OUTPUT phsiIntrRateDisableOutput     = NULL;
   merc_uint_t                     payloadSize                   = 0;
   volatile pmerc_uint_t          regAddress;

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_rate_interrupt_disable(): Entering\n");

   if (argp == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_disable(): Null input data pointer.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = -1;
       goto out2;
   }

   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;
   pLogicalId = (pmerc_uint_t) argp;

   if (*pLogicalId >= MSD_MAX_BOARD_ID_COUNT) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_disable(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = *pLogicalId;
       goto out2;
   }

   AdapterNumber = mercd_adapter_log_to_phy_map_table[*pLogicalId];

   if (AdapterNumber == 0xFF) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_disable(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = *pLogicalId;
       goto out2;
   }

   padapter = MsdControlBlock->padapter_block_list[AdapterNumber];

   if (padapter == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_disable(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = *pLogicalId;
       goto out2;
   }

   MSD_ENTER_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   /* Check for STARTED instead of READY dm3stderr   */
   if ((padapter->state != MERCD_ADAPTER_STATE_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_CP_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_DOWNLOADED)) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_disable(): Adapter State not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = *pLogicalId;
      goto out;
   }

   // Gemini: no FW running - driver will setup HSI
   if (padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_GEM) {
       mid_strmmgr_hsi_gemini(padapter, MSD_GEM_TDM_OFF, NULL);
       MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);
       goto End;
   }

   /* Check for STARTED instead of READY dm3stderr   */
   if (!(padapter->flags.WWFlags & MERCD_ADAPTER_WW_I20_MESSAGING_READY) ||
       !(padapter->pww_info->state == MERCD_ADAPTER_WW_SUCCEDED        )   ) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_disable(): Werewolf interface is not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = *pLogicalId;
      goto out;
   }

   // Disable the HSI Rate Interrupt by writing a 0 to the PLX Mailbox 3 Register.
   /////////////////////////////////////////////////////////////
   MsdWWPlxWriteToPlxRegister(MERCD_WW_PLX_MAILBOX_3_REG, 0); //
   /////////////////////////////////////////////////////////////

   if( padapter->hsiStartOnSync == FALSE )
	{
	   regAddress = (volatile pmerc_uint_t)((pmerc_uchar_t)padapter->hsiRegTdmEnable);
		*regAddress = TDM_ENABLE_ON_FRAME_SYNC;
	}

   MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

End:
   payloadSize = sizeof(HSI_BRIDGE_INTR_DISABLE_OUTPUT);
   NewMsg = supp_alloc_buf(sizeof(MDRV_MSG) + payloadSize, GFP_ATOMIC);
   if(NewMsg == NULL) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_disable(): Cannot alloc Msg buffer\n");
      return(-EFAULT);
   }
   MD_SET_MSG_TYPE(NewMsg, M_DATA);

   NewMdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(NewMsg);
   MD_SET_MSG_WRITE_PTR(NewMsg,
                       (MD_GET_MSG_READ_PTR(NewMsg)+sizeof(MDRV_MSG)+payloadSize));

   phsiIntrRateDisableOutput           = (PHSI_BRIDGE_INTR_DISABLE_OUTPUT) MD_GET_MDMSG_PAYLOAD(NewMdMsg);
   phsiIntrRateDisableOutput->type     = HSI_BRIDGE_INTR_DISABLE_COMPLETION;
   phsiIntrRateDisableOutput->bridgeId = padapter->hsiBridgeId;

   //////////////////////////////////////////////
   supp_process_receive(MsdOpenBlock, NewMsg); //
   //////////////////////////////////////////////
   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_rate_interrupt_disable(): Exiting.\n");
   return 0;

///////
out: //
///////
   unlock=1;

////////
out2: //
////////
   // Only Errors are handled here
   MSD_ERR_DBGPRINT("mid_strmmgr_hsi_rate_interrupt_disable(): ErrorCode=%d  ReturnValue=%d\n", ErrorCode, ReturnValue);

   if (unlock)
      MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_rate_interrupt_disable(): Exiting.\n");
   return -EFAULT;
}


/***************************************************************************
 * Function Name       : mid_strmmgr_hsi_bridge_connect
 * Function Type       : manager function
 * Inputs              : MsdOpenBlock
 *                       argp
 * Outputs             : none
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
int mid_strmmgr_hsi_bridge_connect(pmercd_open_block_sT MsdOpenBlock, void *argp)
{
   PHSI_BRIDGE_ROUTE_INPUT          phsiBridgeRouteInput           = NULL;
   pmercd_adapter_block_sT          padapter                       = NULL;
   QKerHSIBridgeRoute_t            *pqKerHsiBridgeRoute            = NULL;
   QKerHSIBridgeRoute_BridgeInfo_t *pqKerHsiBridgeRoute_BridgeInfo = NULL;
   PMERC_HOSTIF_MSG                 MercMsg                        = NULL;
   PSTRM_MSG                        NewMsg                         = NULL;
   PSTRM_MSG                        DataMsg                        = NULL;
   merc_uint_t                      ErrorCode                      = MD_OK;
   merc_uint_t                      ReturnValue                    = 0;
   merc_uint_t                      Result                         = 0;
   merc_uint_t                      AdapterNumber                  = 0;
   merc_uchar_t                     Flag                           = 0;
   int                              unlock                         = 0;
   merc_ushort_t                    commandSize                    = 0;
   merc_uint_t                      connIndex                      = 0;

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_bridge_connect(): Entering.\n");

   if (argp == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_bridge_connect(): Null input data pointer.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = -1;
       goto out2;
   }

   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;

   phsiBridgeRouteInput = (PHSI_BRIDGE_ROUTE_INPUT) argp;

   if (phsiBridgeRouteInput->logicalId >= MSD_MAX_BOARD_ID_COUNT) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_bridge_connect(): bad board number.\n");
      ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
      ReturnValue = phsiBridgeRouteInput->logicalId;
      goto out2;
   }

   AdapterNumber = mercd_adapter_log_to_phy_map_table[phsiBridgeRouteInput->logicalId];

   if (AdapterNumber == 0xFF) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_bridge_connect(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = phsiBridgeRouteInput->logicalId;
       goto out2;
   }

   padapter = MsdControlBlock->padapter_block_list[AdapterNumber];

   if (padapter == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_bridge_connect(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = phsiBridgeRouteInput->logicalId;
       goto out2;
   }

   MSD_ENTER_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   padapter->hsiRouteMsdOpenBlock = MsdOpenBlock;

   /* Check for STARTED instead of READY dm3stderr   */
   if ((padapter->state != MERCD_ADAPTER_STATE_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_CP_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_DOWNLOADED)) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_bridge_connect(): Adapter State not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = phsiBridgeRouteInput->logicalId;
      goto out;
   }

   // Gemini: no FW running - driver will setup HSI
   if (padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_GEM) {
       mid_strmmgr_hsi_gemini(padapter, MSD_GEM_CONNECT, phsiBridgeRouteInput);
       MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);
       MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_bridge_connect(): Exiting\n");
       return 0;
   }

   /* Check for STARTED instead of READY dm3stderr   */
   if (!(padapter->flags.WWFlags & MERCD_ADAPTER_WW_I20_MESSAGING_READY) ||
       !(padapter->pww_info->state == MERCD_ADAPTER_WW_SUCCEDED        )   ) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_bridge_connect(): Werewolf interface is not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = phsiBridgeRouteInput->logicalId;
      goto out;
   }

   // get a new messgae block
   NewMsg = supp_alloc_buf(sizeof(MDRV_MSG),GFP_ATOMIC);
   if (NewMsg == NULL) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_bridge_connect(): Msg allocbuf failed\n");
      ErrorCode = PAM_ERR_NO_MEMORY;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   commandSize = QKerHSIBridgeRoute_Size + (phsiBridgeRouteInput->numRoutes * QKerHSIBridgeRoute_BridgeInfo_Size);

   DataMsg = supp_alloc_buf(sizeof(MERC_HOSTIF_MSG) + commandSize, GFP_ATOMIC);
   if (DataMsg == NULL) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_bridge_connect(): Cannot alloc Data buffer\n");
      ErrorCode = PAM_ERR_NO_MEMORY;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   MD_SET_MSG_TYPE(DataMsg, M_DATA);
   MSD_LINK_MESSAGE(NewMsg, DataMsg);

   MercMsg = (PMERC_HOSTIF_MSG)DataMsg->b_rptr;
   MERCURY_SET_BODY_SIZE(MercMsg, commandSize);

   Flag = MERCURY_FLAG_32_ALIGNMENT|MERCURY_FLAG_NULL_BUFFER;
   MERCURY_SET_MESSAGE_FLAG(MercMsg, Flag);
   MERCURY_SET_MESSAGE_CLASS(MercMsg, MERCURY_CLASS_SYSTEM);
   MERCURY_SET_MESSAGE_TYPE(MercMsg, QKerHSIBridgeRoute);

   MERCURY_SET_TRANSACTION_ID(MercMsg,padapter->TransactionId);
   padapter->TransactionId= ((padapter->TransactionId + 1)%0xFFFF);

   // Transation id may overflow in next 1-2 quarters.
   // Better solution will be provided. If the transation
   // id is  wrapped around, and that id is already in open,
   // we have a possible problem.
   if (padapter->TransactionId == 0xFFFFFFFF)
      MSD_ERR_DBGPRINT("Transaction ID overflow   \n");

   MERCURY_SET_DEST_NODE(MercMsg, DEFAULT_DEST_NODE);
   MERCURY_SET_DEST_PROC(MercMsg, QCOMP_P_CP);
   MERCURY_SET_DEST_COMP(MercMsg, QCOMP_C_SYS_SERVICE);
   MERCURY_SET_DEST_INST(MercMsg, QCOMP_I_HSIMGR);
   MERCURY_SET_SOURCE_PROC(MercMsg, DEFAULT_SOURCE_PROC);

   pqKerHsiBridgeRoute             = (QKerHSIBridgeRoute_t*)MERCURY_BODY_START(MercMsg);

   pqKerHsiBridgeRoute->numBridges = phsiBridgeRouteInput->numRoutes;

   pqKerHsiBridgeRoute_BridgeInfo = (QKerHSIBridgeRoute_BridgeInfo_t *)(((PUCHAR)pqKerHsiBridgeRoute) + QKerHSIBridgeRoute_Size);

   for (connIndex = 0; connIndex < phsiBridgeRouteInput->numRoutes; connIndex++ )
   {
      memcpy(&(pqKerHsiBridgeRoute_BridgeInfo[connIndex]),
             &phsiBridgeRouteInput->routes[connIndex]    ,
             sizeof( QKerHSIBridgeRoute_BridgeInfo_t )    );
   }

            ///////////////////////////////////////
   Result = strm_ww_Q_snd_msg(NewMsg, padapter); //
            ///////////////////////////////////////

   if (Result != MD_SUCCESS) {
      MSD_ERR_DBGPRINT("mid_strmmgr_hsi_bridge_connect(): strm_ww_Q_snd_msg failed.\n");
      ErrorCode = Result;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);
   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_bridge_connect(): Exiting\n");
   return 0;

///////
out: //
///////
   unlock=1;

////////
out2: //
////////
   // Only Errors are handled here
   MSD_ERR_DBGPRINT("mid_strmmgr_hsi_bridge_connect: ErrorCode=%d  ReturnValue=%d\n", ErrorCode, ReturnValue);

   mercd_streams_free(NewMsg, MERCD_STREAMS_BUFFER , MERCD_FORCE);

   if (unlock)
      MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);
   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_bridge_connect(): Exiting\n");
   return -EFAULT;
}


/***************************************************************************
 * Function Name       : mid_strmmgr_heb_get_dongle_id
 * Function Type       : manager function
 * Inputs              : MsdOpenBlock
 *                       argp
 * Outputs             : none
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
int mid_strmmgr_heb_get_dongle_id(pmercd_open_block_sT MsdOpenBlock, void *argp)
{
   PHEB_GET_DONGLE_ID_INPUT         phebGetDongleIdInput           = NULL;
   pmercd_adapter_block_sT          padapter                       = NULL;
   QKerLicenseKeyGet_t             *pqKerLicenseKeyGet             = NULL;
   PMERC_HOSTIF_MSG                 MercMsg                        = NULL;
   PSTRM_MSG                        NewMsg                         = NULL;
   PSTRM_MSG                        DataMsg                        = NULL;
   merc_uint_t                      ErrorCode                      = MD_OK;
   merc_uint_t                      ReturnValue                    = 0;
   merc_uint_t                      Result                         = 0;
   merc_uint_t                      AdapterNumber                  = 0;
   merc_uchar_t                     Flag                           = 0;
   int                              unlock                         = 0;
   merc_ushort_t                    commandSize                    = 0;

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_heb_get_dongle_id(): Entering\n");

   if (argp == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id(): Null input data pointer.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = -1;
       goto out2;
   }

   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;
   phebGetDongleIdInput = (PHEB_GET_DONGLE_ID_INPUT) argp;

   if (phebGetDongleIdInput->logicalId >= MSD_MAX_BOARD_ID_COUNT) {
      MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id(): bad board number.\n");
      ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
      ReturnValue = phebGetDongleIdInput->logicalId;
      goto out2;
   }

   AdapterNumber = mercd_adapter_log_to_phy_map_table[phebGetDongleIdInput->logicalId];

   if (AdapterNumber == 0xFF) {
       MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = phebGetDongleIdInput->logicalId;
       goto out2;
   }

   padapter = MsdControlBlock->padapter_block_list[AdapterNumber];

   if (padapter == NULL) {
       MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id(): bad board number.\n");
       ErrorCode = CD_ERR_BAD_BOARD_NUMBER;
       ReturnValue = phebGetDongleIdInput->logicalId;
       goto out2;
   }

   MSD_ENTER_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   padapter->hsiDongleMsdOpenBlock = MsdOpenBlock;

   /* Check for STARTED instead of READY dm3stderr   */
   if ((padapter->state != MERCD_ADAPTER_STATE_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_CP_STARTED) &&
       (padapter->state != MERCD_ADAPTER_STATE_DOWNLOADED)) {
      MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id(): Adapter State not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = phebGetDongleIdInput->logicalId;
      goto out;
   }

   /* Check for STARTED instead of READY dm3stderr   */
   if ((!(padapter->flags.WWFlags & MERCD_ADAPTER_WW_I20_MESSAGING_READY) ||
       !(padapter->pww_info->state == MERCD_ADAPTER_WW_SUCCEDED)) && 
       (padapter->phw_info->pciSubSysId != PCI_SUBDEVICE_ID_GEM)) {
      MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id(): Werewolf interface is not ready.\n");
      ErrorCode = CD_ERR_BAD_BOARD_STATE;
      ReturnValue = phebGetDongleIdInput->logicalId;
      goto out;
   }

   // get a new message block
   NewMsg = supp_alloc_buf(sizeof(MDRV_MSG),GFP_ATOMIC);
   if (NewMsg == NULL) {
      MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id(): Msg allocbuf failed\n");
      ErrorCode = PAM_ERR_NO_MEMORY;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   commandSize = QKerLicenseKeyGet_Size;

   DataMsg = supp_alloc_buf(sizeof(MERC_HOSTIF_MSG) + commandSize, GFP_ATOMIC);
   if (DataMsg == NULL) {
      MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id(): Cannot alloc Data buffer\n");
      ErrorCode = PAM_ERR_NO_MEMORY;
      ReturnValue = padapter->adapternumber;
      goto out;
   }

   MD_SET_MSG_TYPE(DataMsg, M_DATA);
   MSD_LINK_MESSAGE(NewMsg, DataMsg);

   MercMsg = (PMERC_HOSTIF_MSG)DataMsg->b_rptr;
   MERCURY_SET_BODY_SIZE(MercMsg, commandSize);

   Flag = MERCURY_FLAG_32_ALIGNMENT|MERCURY_FLAG_NULL_BUFFER;
   MERCURY_SET_MESSAGE_FLAG(MercMsg, Flag);
   MERCURY_SET_MESSAGE_CLASS(MercMsg, MERCURY_CLASS_SYSTEM);
   MERCURY_SET_MESSAGE_TYPE(MercMsg, QKerLicenseKeyGet);

   MERCURY_SET_TRANSACTION_ID(MercMsg,padapter->TransactionId);
   padapter->TransactionId= ((padapter->TransactionId + 1)%0xFFFF);

   // Transation id may overflow in next 1-2 quarters.
   // Better solution will be provided. If the transation
   // id is  wrapped around, and that id is already in open,
   // we have a possible problem.
   if (padapter->TransactionId == 0xFFFFFFFF)
      MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id(): Transaction ID overflow   \n");

   MERCURY_SET_DEST_PROC(MercMsg, QCOMP_P_CP);
   MERCURY_SET_DEST_COMP(MercMsg, QCOMP_C_SYS_SERVICE);
   MERCURY_SET_SOURCE_PROC(MercMsg, DEFAULT_SOURCE_PROC);

   pqKerLicenseKeyGet       = (QKerLicenseKeyGet_t*)MERCURY_BODY_START(MercMsg);
   pqKerLicenseKeyGet->time = phebGetDongleIdInput->time;

   if (padapter->rtkMode == 1) {
      // Component Descriptors use 16 bit instances
      MERCURY_SET_DEST_NODE(MercMsg, DEFAULT_DEST_NODE);
      MERCURY_SET_DEST_INST(MercMsg, QCOMP_I_QAGENT);
   } else {
      // Component Descriptors use 8 bit instances. Swap Node with Instance.
      MERCURY_SET_DEST_NODE(MercMsg, QCOMP_I_QAGENT);
      MERCURY_SET_DEST_INST(MercMsg, DEFAULT_DEST_NODE);
   }

   if (padapter->flags.WWFlags & MERCD_ADAPTER_WW_I20_MESSAGING_READY) {
               ///////////////////////////////////////
      Result = strm_ww_Q_snd_msg(NewMsg, padapter); //
               ///////////////////////////////////////
   } else {
               ////////////////////////////////////
      Result = strm_Q_snd_msg(NewMsg, padapter); //
               ////////////////////////////////////
   }

   if (Result != MD_SUCCESS) {
      MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id: strm_ww_Q_snd_msg failed.\n");
      ErrorCode = Result;
      ReturnValue = padapter->adapternumber;
      MSD_FUNCTION_TRACE_EX("mid_strmmgr_heb_get_dongle_id(): Exiting\n");
      goto out;
   }

   MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   return 0;

///////
out: //
///////
   unlock=1;

////////
out2: //
////////
   // Only Errors are handled here
   MSD_ERR_DBGPRINT("mid_strmmgr_heb_get_dongle_id: ErrorCode=%d  ReturnValue=%d\n", ErrorCode, ReturnValue);

   mercd_streams_free(NewMsg, MERCD_STREAMS_BUFFER , MERCD_FORCE);

   if (unlock)
      MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_heb_get_dongle_id(): Exiting\n");
   return -EFAULT;
}


/***************************************************************************
 * Function Name       : DumpBufferInitParms
 * Function Type       : utility function
 * Inputs              : phsiBridgeInitInput
 * Outputs             : none
 * Calling functions   :
 * Description         : Utility function that dumps all of the parameters to
 *                          the HSI_BUFFER_INIT request to a debugger.
 * Additional comments :
 ****************************************************************************/
void DumpBufferInitParms(/*IN*/ PHSI_BRIDGE_INIT_INPUT phsiBridgeInitInput)
{
   int i, NumLoops;

   if (phsiBridgeInitInput != NULL)
   {
      MSD_LEVEL1_TRACE( "Contents of HSI_BUFFER_INIT_INPUT:" );
      MSD_LEVEL1_TRACE( "    boardInstanceNumber = %d.", phsiBridgeInitInput->logicalId );
      MSD_LEVEL1_TRACE( "    bridgeId            = %d.", phsiBridgeInitInput->bridgeId );
      MSD_LEVEL1_TRACE( "    bridgeSize          = %d.", phsiBridgeInitInput->numTotalPorts );
      MSD_LEVEL1_TRACE( "    tickRate            = %d.", phsiBridgeInitInput->tickRate );
      MSD_LEVEL1_TRACE( "    startType           = %d.", phsiBridgeInitInput->startType );
      MSD_LEVEL1_TRACE( "    numFallBehind       = %d.", phsiBridgeInitInput->numHsiBuffers);
      MSD_LEVEL1_TRACE( "    hmpIsrFunc          = 0x%lx.", (ULONG)phsiBridgeInitInput->hmpIsrFunc );


      if( phsiBridgeInitInput->numHsiBuffers > HSI_MAX_BUFFERS )
      {
         NumLoops = HSI_MAX_BUFFERS;
      }
      else
      {
         NumLoops = phsiBridgeInitInput->numHsiBuffers;
      }

      for( i = 0;  i < NumLoops;  i++ )
      {
         MSD_LEVEL1_TRACE( "    txBuffer[%d]                = 0x%lx.", i, phsiBridgeInitInput->hostToBoardBuffers[i]);
         MSD_LEVEL1_TRACE( "    txBuffer[%d]                = 0x%lx.", i, phsiBridgeInitInput->hostToBoardBuffers[i]);
         MSD_LEVEL1_TRACE( "    rxBuffer[%d]                = 0x%lx.", i, phsiBridgeInitInput->boardToHostBuffers[i]);
         MSD_LEVEL1_TRACE( "    rxBuffer[%d]        t       = 0x%lx.", i, phsiBridgeInitInput->boardToHostBuffers[i]);
      }
   }
}


/***************************************************************************
 * Function Name       : msdfwmgr_heb_license_key_rsp
 * Function Type       : manager function
 * Inputs              : padapter
 *                       FwMessage
 * Outputs             : none
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
void msdfwmgr_heb_license_key_rsp(pmercd_adapter_block_sT padapter, PMERC_HOSTIF_MSG FwMessage) {
   PHEB_GET_DONGLE_ID_OUTPUT phebGetDongleIdOutputToHost;
   QKerLicenseKeyResult_t   *phebGetDongleIdOutputFromFw;
   PSTRM_MSG                 StrmMsg                    ;
   PMDRV_MSG                 MdMsg                      ;
   int                       i                          ;

   MSD_FUNCTION_TRACE_EX("msdfwmgr_heb_license_key_rsp(): Entering\n");

   // The body size in the message just needs to be less than or equal to the size
   // defined by the Kernel for this type of message.
   if (MERCURY_GET_BODY_SIZE(FwMessage) >= QKerLicenseKeyResult_Size) {
      MSD_ERR_DBGPRINT("HIF_SUCCESS: Bad body size=%d, should be %d\n",
                       MERCURY_GET_BODY_SIZE(FwMessage),
                       QKerLicenseKeyResult_Size);
   }

   if (padapter->hsiDongleMsdOpenBlock) {
      MSD_LEVEL1_DBGPRINT("msdfwmgr_heb_license_key_rsp(): padapter->hsiDongleMsdOpenBlock: 0x%08x\n", padapter->hsiDongleMsdOpenBlock);
   } else {
      MSD_ERR_DBGPRINT("msdfwmgr_heb_license_key_rsp(): ERROR: padapter->hsiDongleMsdOpenBlock: is NULL.\n");
      return;
   }

   phebGetDongleIdOutputFromFw = (QKerLicenseKeyResult_t*) MERCURY_BODY_START(FwMessage);
   if (!phebGetDongleIdOutputFromFw) {
      MSD_ERR_DBGPRINT("msdfwmgr_heb_license_key_rsp(): ERROR: phebGetDongleIdOutputFromFw: is NULL.\n");
      return;
   }

   StrmMsg = supp_alloc_buf(sizeof(MDRV_MSG)+sizeof(HEB_GET_DONGLE_ID_OUTPUT), GFP_ATOMIC);
   if(StrmMsg == NULL) {
      MSD_ERR_DBGPRINT("msdfwmgr_heb_license_key_rsp(): ERROR: Cannot alloc Msg buffer\n");
      return;
   }
   MD_SET_MSG_TYPE(StrmMsg, M_DATA);

   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg);

   MD_SET_MSG_WRITE_PTR(StrmMsg, (MD_GET_MSG_READ_PTR(StrmMsg)+sizeof(MDRV_MSG)+sizeof(HEB_GET_DONGLE_ID_OUTPUT)));

   phebGetDongleIdOutputToHost                = (PHEB_GET_DONGLE_ID_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
   phebGetDongleIdOutputToHost->blockSize     = phebGetDongleIdOutputFromFw->blocksize;
   for (i=0; i < phebGetDongleIdOutputFromFw->blocksize; i++) {
      phebGetDongleIdOutputToHost->key[i]     = phebGetDongleIdOutputFromFw->key[i];
   }

   MSD_LEVEL1_DBGPRINT("msdfwmgr_heb_license_key_rsp(): phebGetDongleIdOutputToHost->blockSize: %d\n", phebGetDongleIdOutputToHost->blockSize);

   if (padapter->hsiDongleMsdOpenBlock != NULL) {
      //////////////////////////////////////////////////////////////////
      supp_process_receive(padapter->hsiDongleMsdOpenBlock, StrmMsg); //
      //////////////////////////////////////////////////////////////////
   }
   //Disassociate the open block from this adapter
   padapter->hsiDongleMsdOpenBlock = NULL;
   MSD_FUNCTION_TRACE_EX("msdfwmgr_heb_license_key_rsp(): Exiting\n");
}


/***************************************************************************
 * Function Name       : mid_strmmgr_hsi_buffer_init_rsp
 * Function Type       : manager function
 * Inputs              : MsdOpenBlock
 *                       FwMessage
 * Outputs             : none
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
void msdfwmgr_hsi_buffer_init_rsp(pmercd_adapter_block_sT padapter, PMERC_HOSTIF_MSG FwMessage) {
   PHSI_BRIDGE_INIT_OUTPUT  phsiBridgeInitOutputToHost;
   QKerHSIBufferInitAck_t  *phsiBridgeInitOutputFromFw;
   PSTRM_MSG                StrmMsg                   ;
   PMDRV_MSG                MdMsg                     ;
   int                      returnCode                ;

   MSD_FUNCTION_TRACE_EX("msdfwmgr_hsi_buffer_init_rsp(): Entering\n");

   if (MERCURY_GET_BODY_SIZE(FwMessage) != QKerHSIBufferInitAck_Size) {
      MSD_ERR_DBGPRINT("HIF_SUCCESS: Bad body size=%d, should be %d\n",
                       MERCURY_GET_BODY_SIZE(FwMessage),
                       QKerHSIBufferInitAck_Size);
   }

   if (padapter->hsiMsdOpenBlock) {
      MSD_LEVEL1_DBGPRINT("msdfwmgr_hsi_buffer_init_rsp(): padapter->hsiMsdOpenBlock: 0x%08x\n", padapter->hsiMsdOpenBlock);
   } else {
      MSD_ERR_DBGPRINT("msdfwmgr_hsi_buffer_init_rsp(): ERROR: padapter->hsiMsdOpenBlock: is NULL.\n");
      return;
   }

   phsiBridgeInitOutputFromFw = (QKerHSIBufferInitAck_t*) MERCURY_BODY_START(FwMessage);
   if (!phsiBridgeInitOutputFromFw) {
      MSD_ERR_DBGPRINT("msdfwmgr_hsi_buffer_init_rsp(): ERROR: phsiBridgeInitOutputFromFw: is NULL.\n");
      return;
   }
                //////////////////////////////////////////
   returnCode = mid_strmmgr_hsi_config_aspen(padapter); //
                //////////////////////////////////////////

   if (returnCode) {
      MSD_ERR_DBGPRINT(
         "msdfwmgr_hsi_buffer_init_rsp: Call to mid_strmmgr_hsi_config_aspen() returned an error code of %d\n",
         returnCode);
   }

   StrmMsg = supp_alloc_buf(sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_INIT_OUTPUT), GFP_ATOMIC);
   if(StrmMsg == NULL) {
      MSD_ERR_DBGPRINT("msdfwmgr_hsi_buffer_init_rsp: ERROR: Cannot alloc Msg buffer\n");
      return;
   }
   MD_SET_MSG_TYPE(StrmMsg, M_DATA);

   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg);

   MD_SET_MSG_WRITE_PTR(StrmMsg, (MD_GET_MSG_READ_PTR(StrmMsg)+sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_INIT_OUTPUT)));

   phsiBridgeInitOutputToHost              = (PHSI_BRIDGE_INIT_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
   phsiBridgeInitOutputToHost->type        = HSI_BRIDGE_INIT_COMPLETION;
   phsiBridgeInitOutputToHost->bridgeId    = padapter->hsiBridgeId;
   phsiBridgeInitOutputToHost->txDelay     = phsiBridgeInitOutputFromFw->txDelay;
   phsiBridgeInitOutputToHost->rxDelay     = phsiBridgeInitOutputFromFw->rxDelay;
   phsiBridgeInitOutputToHost->txSyncDelay = phsiBridgeInitOutputFromFw->txSyncDelay;
   phsiBridgeInitOutputToHost->rxSyncDelay = phsiBridgeInitOutputFromFw->rxSyncDelay;

   if (padapter->hsiMsdOpenBlock != NULL) {
      ////////////////////////////////////////////////////////////
      supp_process_receive(padapter->hsiMsdOpenBlock, StrmMsg); //
      ////////////////////////////////////////////////////////////
   }
   //Disassociate the open block from this adapter
   padapter->hsiMsdOpenBlock = NULL;
   MSD_FUNCTION_TRACE_EX("msdfwmgr_hsi_buffer_init_rsp(): Exiting.\n");
}


/***************************************************************************
 * Function Name       : mid_strmmgr_hsi_buffer_stop_rsp
 * Function Type       : manager function
 * Inputs              : padapter
 *                       FwMessage
 * Outputs             : none
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
void msdfwmgr_hsi_buffer_stop_rsp(pmercd_adapter_block_sT padapter, PMERC_HOSTIF_MSG FwMessage) {
   PHSI_BRIDGE_STOP_OUTPUT phsiBridgeStopOutputToHost;
   QKerHSIBufferStopAck_t *phsiBridgeStopOutputFromFw;
   PSTRM_MSG               StrmMsg                   ;
   PMDRV_MSG               MdMsg                     ;

   MSD_FUNCTION_TRACE_EX("msdfwmgr_hsi_buffer_stop_rsp(): Entering.\n");

   if (MERCURY_GET_BODY_SIZE(FwMessage) != QKerHSIBufferStopAck_Size) {
      MSD_ERR_DBGPRINT("HIF_SUCCESS: Bad body size=%d, should be %d\n",
                       MERCURY_GET_BODY_SIZE(FwMessage),
                       QKerHSIBufferStopAck_Size);
   }

   if (padapter->hsiMsdOpenBlock) {
      MSD_LEVEL1_DBGPRINT("msdfwmgr_hsi_buffer_stop_rsp(): padapter->hsiMsdOpenBlock: 0x%08x\n", padapter->hsiMsdOpenBlock);
   } else {
      MSD_ERR_DBGPRINT("msdfwmgr_hsi_buffer_stop_rsp(): ERROR: padapter->hsiMsdOpenBlock: is NULL.\n");
      return;
   }

   phsiBridgeStopOutputFromFw = (QKerHSIBufferStopAck_t*) MERCURY_BODY_START(FwMessage);
   if (!phsiBridgeStopOutputFromFw) {
      MSD_ERR_DBGPRINT("msdfwmgr_hsi_buffer_stop_rsp(): ERROR: phsiBridgeInitOutputFromFw: is NULL.\n");
      return;
   }

   StrmMsg = supp_alloc_buf(sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_STOP_OUTPUT), GFP_ATOMIC);
   if(StrmMsg == NULL) {
      MSD_ERR_DBGPRINT("msdfwmgr_hsi_buffer_stop_rsp(): ERROR: Cannot alloc Msg buffer\n");
      return;
   }
   MD_SET_MSG_TYPE(StrmMsg, M_DATA);

   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg);

   MD_SET_MSG_WRITE_PTR(StrmMsg, (MD_GET_MSG_READ_PTR(StrmMsg)+sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_STOP_OUTPUT)));

   phsiBridgeStopOutputToHost           = (PHSI_BRIDGE_STOP_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
   phsiBridgeStopOutputToHost->type     = HSI_BRIDGE_STOP_COMPLETION;
   phsiBridgeStopOutputToHost->bridgeId = padapter->hsiBridgeId;

   MSD_LEVEL1_DBGPRINT("msdfwmgr_hsi_buffer_stop_rsp(): *phsiBridgeStopOutputToHost aka status: %d\n", *phsiBridgeStopOutputToHost);

   if (padapter->hsiMsdOpenBlock != NULL) {
      ////////////////////////////////////////////////////////////
      supp_process_receive(padapter->hsiMsdOpenBlock, StrmMsg); //
      ////////////////////////////////////////////////////////////
   }
   //Disassociate the open block from this adapter
   padapter->hsiMsdOpenBlock = NULL;
   MSD_FUNCTION_TRACE_EX("msdfwmgr_hsi_buffer_stop_rsp(): Exiting.\n");
}


/***************************************************************************
 * Function Name       : msdfwmgr_hsi_buffer_route_rsp
 * Function Type       : manager function
 * Inputs              : padapter
 *                       FwMessage
 * Outputs             : none
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
void msdfwmgr_hsi_buffer_route_rsp(pmercd_adapter_block_sT padapter, PMERC_HOSTIF_MSG FwMessage) {
   PHSI_BRIDGE_ROUTE_OUTPUT  phsiBridgeRouteOutputToHost;
   QKerHSIBridgeRouteAck_t  *phsiBridgeRouteOutputFromFw;
   PSTRM_MSG                 StrmMsg                    ;
   PMDRV_MSG                 MdMsg                      ;

   MSD_FUNCTION_TRACE_EX("msdfwmgr_hsi_buffer_route_rsp(): Entering.\n");

   if (MERCURY_GET_BODY_SIZE(FwMessage) != QKerHSIBridgeRouteAck_Size) {
      MSD_ERR_DBGPRINT("HIF_SUCCESS: Bad body size=%d, should be %d\n",
                       MERCURY_GET_BODY_SIZE(FwMessage),
                       QKerHSIBridgeRouteAck_Size);
   }

   if (padapter->hsiRouteMsdOpenBlock) {
      MSD_LEVEL2_DBGPRINT("msdfwmgr_hsi_buffer_route_rsp(): padapter->hsiRouteMsdOpenBlock: 0x%08x\n", padapter->hsiRouteMsdOpenBlock);
   } else {
      MSD_ERR_DBGPRINT("msdfwmgr_hsi_buffer_route_rsp(): ERROR: padapter->hsiRouteMsdOpenBlock: is NULL.\n");
      return;
   }

   phsiBridgeRouteOutputFromFw = (QKerHSIBridgeRouteAck_t*) MERCURY_BODY_START(FwMessage);
   if (!phsiBridgeRouteOutputFromFw) {
      MSD_ERR_DBGPRINT("msdfwmgr_hsi_buffer_route_rsp(): ERROR: phsiBridgeRouteOutputFromFw: is NULL.\n");
      return;
   }

   StrmMsg = supp_alloc_buf(sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_ROUTE_OUTPUT), GFP_ATOMIC);
   if(StrmMsg == NULL) {
      MSD_ERR_DBGPRINT("msdfwmgr_hsi_buffer_route_rsp(): ERROR: Cannot alloc Msg buffer\n");
      return;
   }
   MD_SET_MSG_TYPE(StrmMsg, M_DATA);

   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg);

   MD_SET_MSG_WRITE_PTR(StrmMsg, (MD_GET_MSG_READ_PTR(StrmMsg)+sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_ROUTE_OUTPUT)));

   phsiBridgeRouteOutputToHost           = (PHSI_BRIDGE_ROUTE_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
   phsiBridgeRouteOutputToHost->type     = HSI_BRIDGE_ROUTE_COMPLETION;
   phsiBridgeRouteOutputToHost->bridgeId = padapter->hsiBridgeId;

   if (phsiBridgeRouteOutputFromFw->status == QHSI_STATUS_SUCCESS){
      phsiBridgeRouteOutputToHost->numFailures                = 0;
      phsiBridgeRouteOutputToHost->failedRoutes[0].bridgePort = 0;
      phsiBridgeRouteOutputToHost->failedRoutes[0].hardBusTS  = 0;
      phsiBridgeRouteOutputToHost->failedRoutes[0].flags      = 0;
   } else {
      // TBD: Need to implement error processing here for individual route failures.
      phsiBridgeRouteOutputToHost->numFailures                = 1;
      phsiBridgeRouteOutputToHost->failedRoutes[0].bridgePort = phsiBridgeRouteOutputFromFw->status;
      phsiBridgeRouteOutputToHost->failedRoutes[0].hardBusTS  = 0;
      phsiBridgeRouteOutputToHost->failedRoutes[0].flags      = 0;
   }
   MSD_LEVEL1_DBGPRINT("msdfwmgr_hsi_buffer_route_rsp: *phsiBridgeRouteOutputToHost aka status: %d\n", *phsiBridgeRouteOutputToHost);

   if (padapter->hsiRouteMsdOpenBlock != NULL) {
      /////////////////////////////////////////////////////////////////
      supp_process_receive(padapter->hsiRouteMsdOpenBlock, StrmMsg); //
      /////////////////////////////////////////////////////////////////
   }
   //Disassociate the open block from this adapter
   padapter->hsiRouteMsdOpenBlock = NULL;
   MSD_FUNCTION_TRACE_EX("msdfwmgr_hsi_buffer_route_rsp(): Exiting.\n");
}


/***************************************************************************
 * Function Name       : mid_strmmgr_hsi_config_aspen
 * Function Type       : manager function
 * Inputs              : padapter - pointer to the adapter
 * Outputs             : none
 * Returns             : 0        if successful
 *                       Non-zero otherwise
 * Calling functions   :
 * Description         :
 * Additional comments :
 ****************************************************************************/
int mid_strmmgr_hsi_config_aspen(pmercd_adapter_block_sT padapter) {
   int                      retStatus    ;
   volatile pmerc_uint_t   regAddress   ;
   merc_ulong_t             index        ;
	merc_ulong_t             voiceStart   ;
	merc_ulong_t             voiceEnd     ;
	merc_ulong_t             dataStart    ;
	merc_ulong_t             dataEnd      ;
	merc_ulong_t             TsControlBits;
	merc_ulong_t             register_base_offset = 0;


   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_config_aspen(): Entering.\n");

   // GCR: TBD: KeAcquireSpinLock( &pDevExt->HsiLock, &OldIrql );
   //MSD_ENTER_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   MSD_LEVEL1_DBGPRINT("(unsigned char *)(padapter->phw_info->virt_map_q   [MERCD_PCI_SRAM_MAP  ]->virt_addr): 0x%08x\n",
           (unsigned char *)(padapter->phw_info->virt_map_q   [MERCD_PCI_SRAM_MAP  ]->virt_addr)           );
   MSD_LEVEL1_DBGPRINT("(unsigned char *)(padapter->phw_info->virt_map_q   [MERCD_PCI_SRAM_MAP  ]->phys_addr): 0x%08x\n\n",
           (unsigned char *)(padapter->phw_info->virt_map_q   [MERCD_PCI_SRAM_MAP  ]->phys_addr)           );

   MSD_LEVEL1_DBGPRINT("(unsigned char *)(padapter->phw_info->virt_map_q   [MERCD_PCI_BRIDGE_MAP]->virt_addr): 0x%08x\n",
           (unsigned char *)(padapter->phw_info->virt_map_q   [MERCD_PCI_BRIDGE_MAP]->virt_addr)           );
   MSD_LEVEL1_DBGPRINT("(unsigned char *)(padapter->phw_info->virt_map_q   [MERCD_PCI_BRIDGE_MAP]->phys_addr): 0x%08x\n\n",
           (unsigned char *)(padapter->phw_info->virt_map_q   [MERCD_PCI_BRIDGE_MAP]->phys_addr)           );


   MSD_LEVEL1_DBGPRINT("(unsigned char *)(padapter->phw_info->virt_ww_map_q[MERCD_PCI_SRAM_MAP  ]->virt_addr): 0x%08x\n",
           (unsigned char *)(padapter->phw_info->virt_ww_map_q[MERCD_PCI_SRAM_MAP  ]->virt_addr)           );
   MSD_LEVEL1_DBGPRINT("(unsigned char *)(padapter->phw_info->virt_ww_map_q[MERCD_PCI_SRAM_MAP  ]->phys_addr): 0x%08x\n\n",
           (unsigned char *)(padapter->phw_info->virt_ww_map_q[MERCD_PCI_SRAM_MAP  ]->phys_addr)           );

   MSD_LEVEL1_DBGPRINT("(unsigned char *)(padapter->phw_info->virt_ww_map_q[MERCD_PCI_BRIDGE_MAP]->virt_addr): 0x%08x\n",
           (unsigned char *)(padapter->phw_info->virt_ww_map_q[MERCD_PCI_BRIDGE_MAP]->virt_addr)           );
   MSD_LEVEL1_DBGPRINT("(unsigned char *)(padapter->phw_info->virt_ww_map_q[MERCD_PCI_BRIDGE_MAP]->phys_addr): 0x%08x\n",
           (unsigned char *)(padapter->phw_info->virt_ww_map_q[MERCD_PCI_BRIDGE_MAP]->phys_addr)           );

   if (padapter->hsi_isr_callback) {

        // These register writes need to be written in a way that adjacent
        // registers are not accessed one after the other.  This will avoid
        // having the registers accessed in burst mode, which is not supported.
#if 0 // GCR
        HSI_REG_WRITE( padapter->hsiRegTdmResourceSelect, padapter->hsiTdmResSelect );
        HSI_REG_WRITE( padapter->hsiRegInterruptRate,     padapter->hsiInterruptRate );
        HSI_REG_WRITE( padapter->hsiRegClockingMode,      padapter->hsiClockingMode );
        HSI_REG_WRITE( padapter->hsiRegMuLawIdlePattern,  padapter->hsiMulawIdlePattern );
        HSI_REG_WRITE( padapter->hsiRegALawIdlePattern,   padapter->hsiAlawIdlePattern );
        HSI_REG_WRITE( padapter->hsiReg16BitTransPattern, padapter->hsiTransparent16bitIdlePattern );
        HSI_REG_WRITE( padapter->hsiReg8BitTransPattern,  padapter->hsiTransparent8bitIdlePattern );
        HSI_REG_WRITE( padapter->hsiRegDataPacking,       padapter->hsiDataPacking );
        HSI_REG_WRITE( padapter->hsiRegSyncPattern,       padapter->hsiSyncPattern );
#else
        *((unsigned int*)(padapter->hsiRegTdmResourceSelect)) = padapter->hsiTdmResSelect               ;
	if ( padapter->phw_info->seaville_chip ) {
	   // Seaville record issue workaround
           *((unsigned int*)(padapter->hsiRegInterruptRate))  = padapter->hsiInterruptRate|0x4 		;
	} else {
           *((unsigned int*)(padapter->hsiRegInterruptRate))  = padapter->hsiInterruptRate		;
	}
        *((unsigned int*)(padapter->hsiRegClockingMode))      = padapter->hsiClockingMode               ;
        *((unsigned int*)(padapter->hsiRegMuLawIdlePattern))  = padapter->hsiMuLawIdlePattern           ;
        *((unsigned int*)(padapter->hsiRegALawIdlePattern))   = padapter->hsiALawIdlePattern            ;
        *((unsigned int*)(padapter->hsiReg16BitTransPattern)) = padapter->hsiTransparent16bitIdlePattern;
        *((unsigned int*)(padapter->hsiReg8BitTransPattern))  = padapter->hsiTransparent8bitIdlePattern ;
        *((unsigned int*)(padapter->hsiRegDataPacking))       = padapter->hsiDataPacking                ;
        *((unsigned int*)(padapter->hsiRegSyncPattern))       = padapter->hsiSyncPattern                ;
#endif
	
		  // Use the port allocation code to determine how we must arrange the timeslots
		  // within the bridge device 
		  switch( padapter->hsiPortAllocCode )
		  {
		  case( 0 ):  // Totowa-1 Allocation Scheme - avoid ASPEN bug
			  {
				  if( padapter->hsiNumVoicePorts > 0 )
				  {
					  // There are voice ports, so we need to apply law conversion to Bridge Port
					  // 1 through Bridge Port 'hsiNumVoicePorts + 2'
					  voiceStart = 1;
					  voiceEnd   = padapter->hsiNumVoicePorts + 2; // Adding additional law converted stream to correct for actual ASPEN bug

					  if( padapter->hsiNumDataPorts > 0 )
					  {
							dataStart = voiceEnd + 1;
							dataEnd   = dataStart + padapter->hsiNumDataPorts;
					  }
				  }
				  else
				  {
					  // There are no voice ports, so the entire bridge should be
					  // configured for transparent mode operation (data-mode).
					  voiceStart = 0;
					  voiceEnd   = 0;

					  if( padapter->hsiNumDataPorts > 0 )
					  {
						  dataStart = 1;
						  dataEnd   = padapter->hsiNumDataPorts;
					  }
				  }

				  break;
			  }

		  case( 1 ):  // Totowa-2 Allocation Scheme - Uses SEAVILLE, no bug
			  {
				  if( padapter->hsiNumVoicePorts > 0 )
				  {
					  // There are voice ports, so we need to apply law conversion to Bridge Port
					  // 1 through Bridge Port 'hsiNumVoicePorts'
					  voiceStart = 1;
					  voiceEnd   = padapter->hsiNumVoicePorts;

					  if( padapter->hsiNumDataPorts > 0 )
					  {
							dataStart = voiceEnd + 1;
							dataEnd   = voiceEnd + padapter->hsiNumDataPorts;
					  }
				  }
				  else
				  {
					  // There are no voice ports, so the entire bridge should be
					  // configured for transparent mode operation (data-mode).
					  voiceStart = 0;
					  voiceEnd   = 0;

					  if( padapter->hsiNumDataPorts > 0 )
					  {
						  dataStart = 1;
						  dataEnd   = padapter->hsiNumDataPorts;
					  }
				  }

				  break;
			  }

		  case( 2 ):  // Dynamic Allocation Mode - not supported yet
		  default:
			  {
				  voiceStart = 0;
				  voiceEnd   = 0;
				  dataStart  = 0;
				  dataEnd    = 0;
				  break;
			  }
		  }	

			// There are three possible groupings of channels that we need to configure.
			// We program the registers from the last to the first to prevent the PCI bridge
			// from doing copies in Burst mode, which is not supported in the ASPEN registers.

			// If there are data ports to configure, configure them now
			if (!padapter->phw_info->seaville_chip) {
                            register_base_offset = ASPEN_TS_CONTROL_OFFSET;
                        }

			if( padapter->hsiNumDataPorts > 0 )
			{
				TsControlBits = TS_CONTROL_TRANSPARENT_DEFAULT;

				for( index = dataEnd; index >= dataStart; index-- )
				{
					regAddress = (volatile pmerc_uint_t)((pmerc_uchar_t)padapter->hsiRegTsControlBitsBase +
									 register_base_offset + REG_OFFSET_TIMESLOT_CONTROL_BITS( index ));

					if( regAddress )
					{
						*regAddress = TsControlBits;
					}
				}
			}

			// If there are voice ports to configure, configure them now using the law conversion
			// selected by the user.
			if( padapter->hsiNumVoicePorts > 0 )
			{
				TsControlBits = padapter->hsiTsControlBits;

				for( index = voiceEnd; index >= voiceStart; index-- )
				{
					regAddress = (volatile pmerc_uint_t)((pmerc_uchar_t)padapter->hsiRegTsControlBitsBase +
									 register_base_offset + REG_OFFSET_TIMESLOT_CONTROL_BITS( index ));

					if( regAddress )
					{
						*regAddress = TsControlBits;
					}
				}
			}

			// Bridge Port 0 is always configured to be transparent as it's used for the Bridge
			// Synchronization pattern which should not be altered by law conversion
			regAddress = (volatile pmerc_uint_t)((pmerc_uchar_t)padapter->hsiRegTsControlBitsBase +
							 register_base_offset + REG_OFFSET_TIMESLOT_CONTROL_BITS( 0 ));

			if( regAddress )
			{
				TsControlBits = TS_CONTROL_TRANSPARENT_DEFAULT;

				*regAddress = TsControlBits;
			}

#if( 0 )
      //  This loop counts down to stop the PCI bridge from doing copies in Burst
      //  mode, which is not supported on the ASPEN registers.
      for (index = (MAX_TIMESLOTS-1); index >= 1; index-- ) {
         regAddress = (volatile pmerc_uint_t)((pmerc_uchar_t)padapter->hsiRegTsControlBitsBase +
                      register_base_offset + REG_OFFSET_TIMESLOT_CONTROL_BITS(index));
         if(regAddress )
         {
            // GCR: HSI_REG_WRITE( (pmerc_ulong_t)regAddress, padapter->hsiTsControlBits );
            *regAddress = padapter->hsiTsControlBits;
         }
      }

      // Set Bridge Port 0 to operate in transparent mode so that the sync pattern
      // is not altered by the law conversion
      regAddress = (volatile pmerc_uint_t)((pmerc_uchar_t)padapter->hsiRegTsControlBitsBase +
                    register_base_offset + REG_OFFSET_TIMESLOT_CONTROL_BITS( 0 ));

      if(regAddress ) {
         // HSI_REG_WRITE((pmerc_ulong_t)regAddress, padapter->hsiTsControlBits & ~TS_CONTROL_SET_ENABLE_TX_LAW_CONVERSION);
         *regAddress = padapter->hsiTsControlBits & ~TS_CONTROL_SET_ENABLE_TX_LAW_CONVERSION;
      }
#endif

      if( padapter->hsiStartOnSync == TRUE)
		{
         // HSI_REG_WRITE( padapter->hsiRegInterruptEnable, DISABLE_RATE_INTERRUPT    ); // GCR
         regAddress = (volatile pmerc_uint_t)((pmerc_uchar_t)padapter->hsiRegInterruptEnable);
         *regAddress = DISABLE_RATE_INTERRUPT;
         // HSI_REG_WRITE( padapter->hsiRegTdmEnable      , TDM_ENABLE_ON_SYNC_PATTERN); // GCR
         regAddress = (volatile pmerc_uint_t)((pmerc_uchar_t)padapter->hsiRegTdmEnable);
         *regAddress = TDM_ENABLE_ON_SYNC_PATTERN;
      }

      retStatus = 0;

   } else {
      //DebugInfo( pDevExt->instanceNumber, "mpdHsiConfigAspen : Bridge Not Configured!" );
      retStatus = -1;
   }

   // GCR: KeReleaseSpinLock( &padapter->HsiLock, OldIrql );
   //MSD_EXIT_MUTEX_IRQ(&padapter->phw_info->intr_info->intr_mutex);

   MSD_FUNCTION_TRACE_EX("mid_strmmgr_hsi_config_aspen(): Exiting.\n");
   return 0;
}


/***************************************************************************
 * Function Name       : mercd_ww_generic_hsi_intr_processing
 * Function Type       : manager function
 * Inputs              : Context1 - Index into padapter_block_list array aka
 *                                     the slot number aka the Physical Id.
 * Outputs             : none
 * Returns             : 0        if successful
 *                       Non-zero otherwise
 * Calling functions   :
 * Description         : HSI DPC Task.
 * Additional comments :
 ****************************************************************************/
int mercd_ww_generic_hsi_intr_processing(merc_ulong_t Context1) {
   pmercd_adapter_block_sT    padapter;
   merc_uchar_t               physicalId;
   merc_uint_t                interruptType;
   int                        nbrOfTimesProcessingInterruptsThisCall = 0;

   MSD_FUNCTION_TRACE_EX("mercd_ww_generic_hsi_intr_processing(): Entering.\n");
   ////////////////////////////////////////////////
   // MSD_ENTER_MUTEX_IRQ(&padapter->hsiIntrMutex); // // GCR
   ////////////////////////////////////////////////

   physicalId = *(merc_ulong_t * )Context1;

   padapter = MsdControlBlock->padapter_block_list[physicalId];

   if (!padapter) {
      return(MERCD_INTR_UNCLAIMED);
   }

   interruptType                          = padapter->hsiIntrReason;
   padapter->hsiIntrReason                = 0;
   nbrOfTimesProcessingInterruptsThisCall = 0;

   do {
      nbrOfTimesProcessingInterruptsThisCall++;
      switch(interruptType) {
         case MSD_PCI_INTR_HSI_RATE_INTERRUPT_FROM_PLX:
            ////////////////////////////////////////////////////////////////////////////////
            padapter->hsi_isr_callback(padapter->hsiBridgeId, padapter->hsiRateIntrData); //
            ////////////////////////////////////////////////////////////////////////////////
            interruptType &= MSD_PCI_INTR_HSI_RATE_INTERRUPT_FROM_PLX;
            break;
         default:
            MSD_ERR_DBGPRINT("mercd_ww_generic_hsi_intr_processing(): Unknown HSI Interrupt received. hsiIntrReason: %d\n",
                   padapter->hsiIntrReason);
      }

      interruptType = padapter->hsiIntrReason;
      if (nbrOfTimesProcessingInterruptsThisCall == 5000) {
         MSD_ERR_DBGPRINT("mercd_ww_generic_hsi_intr_processing(): Stuck in procedure.  Breaking out.\n"
                "   padapter->hsiIntrReason is always non-zero.  interruptType: %d  adapternumber:%d.\n",
                interruptType, padapter->adapternumber);
         interruptType           = 0;
         padapter->hsiIntrReason = 0;
      }
   } while (interruptType > 0);

////////
// out2: //
////////
   ///////////////////////////////////////////////
   // MSD_EXIT_MUTEX_IRQ(&padapter->hsiIntrMutex); // // GCR
   ///////////////////////////////////////////////

   MSD_FUNCTION_TRACE_EX("mercd_ww_generic_hsi_intr_processing(): Exiting.\n");
   return(MERCD_INTR_CLAIMED);
}


/***************************************************************************
 * Function Name       : mid_strmmgr_hsi_gemini
 * Function Type       : manager function
 * Inputs              : padapter, type, info
 * Outputs             : none
 * Returns             : none
 * Calling functions   : all HSI ioctls
 * Description         : HSI configuration for Gemini boards - 
 *                        there is not HSI Manager running on the board
 ****************************************************************************/
void mid_strmmgr_hsi_gemini(pmercd_adapter_block_sT padapter, merc_uchar_t type, pmerc_void_t info)
{
   pmerc_uchar_t BaseAddr = 0;
   pmerc_uchar_t MemAddr = 0;
   merc_uchar_t  ucTmp = 0;
   merc_uint_t  ulTmp = 0;
   merc_ushort_t usTmp = 0;
   pmerc_void_t  H2B;
   pmerc_void_t  B2H;
   merc_ulong_t  PhysAddr = 0;
   PSTRM_MSG     StrmMsg;
   PMDRV_MSG     MdMsg;

  
   BaseAddr =(pmerc_uchar_t)(padapter->phw_info->bar[3].virt_addr);

   switch (type) {
      case MSD_GEM_INIT:
      {
          merc_uint_t ulTmpAlaw = 0xD5;
          merc_uint_t ulTmpMlaw = 0x7F;
          merc_uint_t ulTmpTlaw = 0x00;
           PHSI_BRIDGE_INIT_INPUT phsiBridgeInitInput = (PHSI_BRIDGE_INIT_INPUT) info;
           PHSI_BRIDGE_INIT_OUTPUT  phsiBridgeInitOutputToHost;

           //printk("MSD_GEM_INIT BridgeId=%d\n", padapter->hsiBridgeId);

           ulTmp = (merc_uint_t) phsiBridgeInitInput->numHsiBuffers - 1;
           MemAddr = BaseAddr + MSD_GEM_INDX_BUFSZ;
           writel(ulTmp, MemAddr);

	   // Gemini Tick Rate is different than Aspen's definition
	   switch (padapter->hsiInterruptRate) {
	      case TDM_INTERRUPT_RATE_2MS: padapter->hsiInterruptRate = MSD_GEM_TDM_RATE_2MS; break;
	      case TDM_INTERRUPT_RATE_4MS: padapter->hsiInterruptRate = MSD_GEM_TDM_RATE_4MS; break;
	      default: padapter->hsiInterruptRate = MSD_GEM_TDM_RATE_2MS; break;   
	   }
           ulTmp = (merc_uint_t) padapter->hsiInterruptRate;
           MemAddr = BaseAddr + MSD_GEM_TDM_RATE_SELECT;
           writel(ulTmp, MemAddr);

           ulTmpTlaw = (merc_uint_t) phsiBridgeInitInput->lawIdlePattern;
	   switch (padapter->hsiLawType) {
	      case HSI_BUS_TYPE_TRANSPARENT: ulTmpTlaw = (merc_uint_t) phsiBridgeInitInput->lawIdlePattern; break;
	      case HSI_BUS_TYPE_MULAW: ulTmpMlaw = (merc_uint_t) phsiBridgeInitInput->lawIdlePattern; break;
	      case HSI_BUS_TYPE_ALAW: ulTmpAlaw = (merc_uint_t) phsiBridgeInitInput->lawIdlePattern; break;
           }

           MemAddr = BaseAddr + MSD_GEM_TRANS_IDLE_PATTERN;
           writel(ulTmpTlaw, MemAddr);

           MemAddr = BaseAddr + MSD_GEM_MULAW_IDLE_PATTERN;
           writel(ulTmpMlaw, MemAddr);

           MemAddr = BaseAddr + MSD_GEM_ALAW_IDLE_PATTERN;
           writel(ulTmpAlaw, MemAddr);

           memcpy(&ulTmp, phsiBridgeInitInput->syncPattern, 4 * sizeof(merc_char_t));
	   MemAddr = BaseAddr + MSD_GEM_TDM_SYNC_PATTERN;
	   writel(ulTmp, MemAddr);

           ulTmp = (merc_uint_t) (padapter->hsiNumVoicePorts + padapter->hsiNumDataPorts);
	   MemAddr = BaseAddr + MSD_GEM_BRIDGE_SIZE;
	   writel(ulTmp, MemAddr);

           ulTmp = (merc_uint_t) padapter->hsiInterruptRate;
	   MemAddr = BaseAddr + MSD_GEM_TICK_RATE;
	   writel(ulTmp, MemAddr);

           ulTmp = (merc_uint_t) phsiBridgeInitInput->numHsiBuffers;
	   MemAddr = BaseAddr + MSD_GEM_NUM_BUFFERS;
	   writel(ulTmp, MemAddr);

           ulTmp = (merc_uint_t) phsiBridgeInitInput->syncTimeslot;
	   MemAddr = BaseAddr + MSD_GEM_RX_SYNC_TS;
	   writel(ulTmp, MemAddr);

	   H2B = &phsiBridgeInitInput->hostToBoardBuffers;
           B2H = &phsiBridgeInitInput->boardToHostBuffers;

    	   MemAddr = BaseAddr + MSD_GEM_TXRX_BUF_BASE;
           for (ucTmp = 0; ucTmp < phsiBridgeInitInput->numHsiBuffers; ucTmp++) {
		// Write Tx LowPart
	        ulTmp = (merc_uint_t) phsiBridgeInitInput->hostToBoardBuffers[ucTmp];
	        padapter->H2B[ucTmp] = ulTmp;
	        writel(ulTmp, MemAddr);

		// Write Tx HighPart
	        ulTmp = 0;
	        MemAddr += sizeof(merc_uint_t);
	        writel(ulTmp, MemAddr);

	        // Write Rx LowPart
		ulTmp = (merc_uint_t) phsiBridgeInitInput->boardToHostBuffers[ucTmp];
	        padapter->B2H[ucTmp] = ulTmp;
		MemAddr += sizeof(merc_uint_t);
	        writel(ulTmp, MemAddr);

		// Write Rx HighPart
	        ulTmp = 0;
	        MemAddr += sizeof(merc_uint_t);
	        writel(ulTmp, MemAddr);

	        MemAddr += sizeof(merc_uint_t);
           }
	   padapter->hsiBuffers = phsiBridgeInitInput->numHsiBuffers;

	   // Configure sync transmission
           ulTmp = padapter->hsiStartOnSync;
           MemAddr = BaseAddr + MSD_GEM_START_TYPE;
           writel(ulTmp, MemAddr);
           
           // Enable TDM Streaming
	   ulTmp = MSD_TDM_ENABLE;
           MemAddr = BaseAddr + MSD_GEM_TDM_ENABLE;
           writel(ulTmp, MemAddr);

	   // Send reply to host
           StrmMsg = supp_alloc_buf(sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_INIT_OUTPUT), GFP_ATOMIC);
  	   if (StrmMsg == NULL) {
      	       MSD_ERR_DBGPRINT("mid_strmmgr_hsi_gemini: ERROR: Cannot alloc Msg buffer\n");
               break;
           }
   	   MD_SET_MSG_TYPE(StrmMsg, M_DATA);
   	   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg);
   	   MD_SET_MSG_WRITE_PTR(StrmMsg, (MD_GET_MSG_READ_PTR(StrmMsg)+sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_INIT_OUTPUT)));

   	   phsiBridgeInitOutputToHost              = (PHSI_BRIDGE_INIT_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
           phsiBridgeInitOutputToHost->type        = HSI_BRIDGE_INIT_COMPLETION;
           phsiBridgeInitOutputToHost->bridgeId    = padapter->hsiBridgeId;
           phsiBridgeInitOutputToHost->txDelay     = 0x8;
           phsiBridgeInitOutputToHost->rxDelay     = 0x11;
           phsiBridgeInitOutputToHost->txSyncDelay = 0x8;
           phsiBridgeInitOutputToHost->rxSyncDelay = 0x11;

           supp_process_receive(padapter->hsiMsdOpenBlock, StrmMsg);

           break;
      }
      case MSD_GEM_STOP:
      {
	   PHSI_BRIDGE_STOP_OUTPUT phsiBridgeStopOutputToHost;
           //printk("MSD_GEM_STOP BridgeId=%d\n", padapter->hsiBridgeId);

           padapter->hsiBuffers = 0;

           // Configure all Timeslots to idle
           MemAddr = BaseAddr + MSD_GEM_TS_CONTROL_BASE;
           ulTmp = TS_CONTROL_SET_TIMESLOT_IDLE;
           for (usTmp = 0; usTmp < MSD_MAX_GEM_TS; usTmp++, MemAddr+=4) {
                writel(ulTmp, MemAddr);
           }

	   // Disable Streamming on next frame sync
	   ulTmp = MSD_TDM_DISABLE;
           MemAddr = BaseAddr + MSD_GEM_TDM_ENABLE;
           writel(ulTmp, MemAddr);

	   // Disable the MSI interrupt for TDM to Host
           MemAddr = BaseAddr + MSD_GEM_FPGA_IMR;
	   ulTmp = readl(MemAddr);
	   ulTmp |= MSD_MSI_MASK_OFF;
	   writel(ulTmp, MemAddr);

	   // Clear Init locations (0x20004-0x2002C & 0x22000-0x2207C)
	   ucTmp = 0;
	   MemAddr = BaseAddr + MSD_GEM_TDM_ENABLE;
	   ulTmp = MSD_GEM_TDM_SYNC_PATTERN - MSD_GEM_TDM_ENABLE;
	   memset_io(MemAddr, ucTmp, ulTmp);
	   MemAddr = BaseAddr + MSD_GEM_BRIDGE_SIZE;
	   ulTmp = MSD_GEM_SYNC_CHAR - MSD_GEM_BRIDGE_SIZE;
	   memset_io(MemAddr, ucTmp, ulTmp);
	
           // Check if internal - no need for reply
           if (!info) {
	       break;
           }

	   // Send reply to host
	   StrmMsg = supp_alloc_buf(sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_STOP_OUTPUT), GFP_ATOMIC);
           if (StrmMsg == NULL) {
               MSD_ERR_DBGPRINT("mid_strmmgr_hsi_gemini(): ERROR: Cannot alloc Msg buffer\n");
               break;
           }
           MD_SET_MSG_TYPE(StrmMsg, M_DATA);
           MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg);
           MD_SET_MSG_WRITE_PTR(StrmMsg, (MD_GET_MSG_READ_PTR(StrmMsg)+sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_STOP_OUTPUT)));

           phsiBridgeStopOutputToHost           = (PHSI_BRIDGE_STOP_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
           phsiBridgeStopOutputToHost->type     = HSI_BRIDGE_STOP_COMPLETION;
           phsiBridgeStopOutputToHost->bridgeId = padapter->hsiBridgeId;

           supp_process_receive(padapter->hsiMsdOpenBlock, StrmMsg);

           break;
      }
      case MSD_GEM_TDM_ON:
      {
           //printk("MSD_GEM_TDM_ON BridgeId=%d\n", padapter->hsiBridgeId);
	   // Enable the MSI interrupt for TDM to Host
           MemAddr = BaseAddr + MSD_GEM_FPGA_IMR;
	   ulTmp = readl(MemAddr);
	   ulTmp &= MSD_MSI_MASK_ON;
	   writel(ulTmp, MemAddr);

           break;
      }
      case MSD_GEM_TDM_OFF:
      {
           //printk("mid_strmmgr_hsi_gemini(): MSD_GEM_TDM_OFF BridgeId=%d\n", padapter->hsiBridgeId);
	   // Disable the MSI interrupt for TDM to Host
           MemAddr = BaseAddr + MSD_GEM_FPGA_IMR;
	   ulTmp = readl(MemAddr);
	   ulTmp |= MSD_MSI_MASK_OFF;
	   writel(ulTmp, MemAddr);

           break;
      }
      case MSD_GEM_CONNECT:
      {
           PHSI_BRIDGE_ROUTE_INPUT phsiBridgeRouteInput = (PHSI_BRIDGE_ROUTE_INPUT) info;
	   PHSI_BRIDGE_ROUTE_OUTPUT  phsiBridgeRouteOutputToHost;

           for (usTmp=0; usTmp<phsiBridgeRouteInput->numRoutes; usTmp++) {
                MemAddr = BaseAddr + MSD_GEM_TS_CONTROL_BASE;
	        MemAddr += (phsiBridgeRouteInput->routes[usTmp].bridgePort * 4);

                if ((phsiBridgeRouteInput->routes[usTmp].flags & HSI_FLAGS_ROUTING_MASK) == HSI_FLAGS_ROUTE) {
                    // Disable idle transfer
                    ulTmp = readl(MemAddr);
                    ulTmp &= ~TS_CONTROL_SET_TIMESLOT_IDLE;
                    writel(ulTmp, MemAddr);
                    //printk("MSD_GEM_CONNECT: Port=%d BridgeId=%d\n", phsiBridgeRouteInput->routes[usTmp].bridgePort, padapter->hsiBridgeId);
                } else {
                    // Enable idle transfer
                    ulTmp = readl(MemAddr);
                    ulTmp |= TS_CONTROL_SET_TIMESLOT_IDLE;
                    writel(ulTmp, MemAddr);
                    //printk("MSD_GEM_DISCONNECT: Port=%d BridgeId=%d\n", phsiBridgeRouteInput->routes[usTmp].bridgePort, padapter->hsiBridgeId);
                }
           }

           // Check if internal - no need for reply
           if (padapter->state == MERCD_ADAPTER_STATE_INIT) {
	       break;
           }

           // Send reply to host
	   StrmMsg = supp_alloc_buf(sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_ROUTE_OUTPUT), GFP_ATOMIC);
           if (StrmMsg == NULL) {
               MSD_ERR_DBGPRINT("mid_strmmgr_hsi_gemini(): ERROR: Cannot alloc Msg buffer\n");
               break;
           }
           MD_SET_MSG_TYPE(StrmMsg, M_DATA);
           MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg);
           MD_SET_MSG_WRITE_PTR(StrmMsg, (MD_GET_MSG_READ_PTR(StrmMsg)+sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_ROUTE_OUTPUT)));

           phsiBridgeRouteOutputToHost           = (PHSI_BRIDGE_ROUTE_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
           phsiBridgeRouteOutputToHost->type     = HSI_BRIDGE_ROUTE_COMPLETION;
           phsiBridgeRouteOutputToHost->bridgeId = padapter->hsiBridgeId;

           phsiBridgeRouteOutputToHost->numFailures                = 0;
           phsiBridgeRouteOutputToHost->failedRoutes[0].bridgePort = 0;
           phsiBridgeRouteOutputToHost->failedRoutes[0].hardBusTS  = 0;
           phsiBridgeRouteOutputToHost->failedRoutes[0].flags      = 0;

           supp_process_receive(padapter->hsiMsdOpenBlock, StrmMsg);

           break;
      }
      default:
      {
           // For future
           break;
      }
   }
}

#endif // SUPPORT_HSI

