/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name 			: msdbrdutl.c
 * Description			: Support for Board Manager functions
 *
 *
 ***********************************************************************/

#include "msd.h"
#include "msdpciif.h"
#define _MSDBRDUTL_C_
#include "msdextern.h"
#undef _MSDBRDUTL_C_

merc_uint_t vstartbd = 0xffff;



/***************************************************************************
 * Function Name		: start_brd
 * Function Type		: Common Hardware function
 * Inputs			:
 * Outputs			:
 * Calling functions		:
 * Description			: Streams Driver StartBoard Routine. This
 *				  routine starts a Mercury board
 * Additional comments		:
 ****************************************************************************/
md_status_t start_brd(PMSD_OPEN_BLOCK MsdOpenBlock, pmercd_adapter_block_sT padapter, PSTRM_MSG Msg)
{
	pmercd_reg_block_sT 	RegBlock;
	merc_uint_t             WaitCount;
	merc_uchar_t            InUchar;
	merc_uchar_t           	DebugVal;
	mercd_dhal_mem_copy_sT 	meminfo = { 0 };
    merc_uint_t             slotn;
	pmerc_uchar_t	   	MemAddr = 0;

	MSD_FUNCTION_TRACE("start_brd", ONE_PARAMETER, (size_t)padapter);

	// Enable interrupt - done after ISR registration
	// For SRAM 1.9 board users ......

    if ((padapter->phw_info->boardFamilyType != THIRD_ROCK_FAMILY) &&
	(padapter->phw_info->pciSubSysId != PCI_SUBDEVICE_ID_GEM) ) {

	RegBlock = &padapter->phost_info->reg_block;

	// Request the host ram without asking for interrupt
	MERC_GET_SRAM_NO_INTR_LOCK(RegBlock, InUchar);

	WaitCount = 0;

	while(!(InUchar & MERC_HOST_RAM_GRANT_R)) {


		MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);

		if (((++WaitCount)*MERC_BOARD_RESET_WAIT_INTERVAL) > MERC_BOARD_RESET_TIMEOUT){

			MSD_ERR_DBGPRINT( "start_brd: ERR: HostRam Time Out\n");

			return(CD_ERR_HOST_RAM_TIMEOUT);

		}

		MERC_GET_SRAM_NO_INTR_LOCK(RegBlock, InUchar);
	}



	// Check the State of Debug port values, if they are not Result SUCC
	// from Kernel, return error saying board not ready.

	MERC_CHECK_DEBUG_ONE(RegBlock, DebugVal);

	// DMV-B
	if ((DebugVal != FIRST_DEBUG_VALID_RESULT) &&
            ((padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_DM3) ||
	     (padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_DISI))) {
		// Release the SRAM
		MERC_FREE_SRAM_LOCK(RegBlock);

		// Return this error since the downloader will try again if it
		// is this error. Originally was returning MD_FAILUER

		return(CD_ERR_INVALID_DEBUG_PORT);

	}

	MERC_CHECK_DEBUG_TWO((&padapter->phost_info->reg_block), DebugVal);

	// DMV-B
	if ((DebugVal != SECOND_DEBUG_VALID_RESULT) &&
	    ((padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_DM3) ||
	     (padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_DISI))) {
		// Release the SRAM

		MERC_FREE_SRAM_LOCK(RegBlock);

		// Return this error since the downloader will try again if it
		// is this error. Originally was returning MD_FAILUER

		return(CD_ERR_INVALID_DEBUG_PORT);
	}

    }  /* THIRD_ROCK_FAMILY */
      else
      {
        //There is no SRAM grant for THIRD_ROCK_FAMILY
      }

        vstartbd = 0xfff6;
          /* transfer the config block to host ram
           Common macro for device copy the last 2 fields will be
           skipped for VME
           The MSD_DEVICE_COPY -> vme_device_copy for VME platforms
                                  pci_device_copy for PCI platforms*/

        meminfo.src = (pmerc_char_t)&padapter->phost_info->host_config;
	if (padapter->phw_info->boardFamilyType != THIRD_ROCK_FAMILY) {
            meminfo.dest = (pmerc_char_t)padapter->phost_info->reg_block.HostRamStart;
	} else {
	   // please define 512 in a header file and use here
	   meminfo.dest = (pmerc_char_t)padapter->phost_info->reg_block.HostRamStart + 512;
    	}
        meminfo.size = sizeof(MERCURY_HOST_IF_CONFIG);

	memcpy(meminfo.dest, meminfo.src, meminfo.size);


        MSD_ENTER_MUTEX(&padapter->adapter_block_mutex);
        padapter->flags.HostifConfigSent |=MERC_ADAPTER_FLAG_HOSTIF_CONFIG_SENT;
        MSD_EXIT_MUTEX(&padapter->adapter_block_mutex);

        //For 3rd Rock we should just return. No need to send any intr.
        //For SRAM boards:  don't really want to set CD adapter state here
        // but it makes things easier for now
        // indicate we're waiting for a config ack from fw
        //SRAM DM3 Boards ARE NOT 3rd ROCK. Hence falls through the
        //following branch.
	if (padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_GEM) {
	    MemAddr = padapter->phw_info->virt_map_q[MERCD_PCI_BRIDGE_MAP]->virt_addr + MSD_MPC_PEX_IMBCR;
            WaitCount =  readl(MemAddr);
            WaitCount = 1;
            writel(WaitCount, MemAddr);
	    return(MD_SUCCESS);
	}

        if (padapter->phw_info->boardFamilyType != THIRD_ROCK_FAMILY)
         {
            if ((padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_DM3) ||
		(padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_DISI)) {
                MERC_INTR_ADAPTER(RegBlock);
                //////////////////SRAMDMA BEGIN/////////////////////////////////
                slotn = mercd_adapter_map[padapter->adapternumber];

	        // SAVE the sram address on the local bus,
	        // it will be used for DMA ......
	        padapter->phw_info->pdma_info->dma_base_offset =
		   (MsdPlxGetPlxLocalBaseAddr(slotn)) + MSD_CONFIG_ROM_MAX_SIZE;

	        // Chan 0
                if (padapter->phw_info->pdma_info->total_merc_tx_dma_chains)
                {
                  MsdPlxDmaEnableSctr_Mode_Chn0(slotn);
                  MsdPlxDmaEnable_Chn0(slotn);
                }
                //Chan 1
                if (padapter->phw_info->pdma_info->total_merc_rx_dma_chains)
                {
                  MsdPlxDmaEnableSctr_Mode_Chn1(slotn);
                  MsdPlxDmaEnable_Chn1(slotn);
                }
                //////////////////SRAMDMA END/////////////////////////////////
            } else { // DMV-B and DMV-C
		MERC_FREE_SRAM_LOCK(RegBlock);
		mid_wwmgr_configure_brd_to_ww(MsdOpenBlock, padapter, Msg);
                return(MD_SUCCESS);
            }

         }


        return(MD_SUCCESS);
}

/***************************************************************************
 * Function Name		: reset_adapter
 * Function Type		: Common Hardware function
 * Inputs			:
 * Outputs			:
 * Calling functions		:
 * Description			: Streams Driver ResetAdapter Routine. This
 *				  routine Resets the Mercury controller
 * Additional comments		:
 ****************************************************************************/
void reset_adapter(pmercd_adapter_block_sT  padapter)
{
  merc_uint_t  data;
  pmerc_ulong_t loc;
  merc_uchar_t ucTmp;
  mercd_dev_info_T *Dip;


  if (padapter->phw_info->boardFamilyType != THIRD_ROCK_FAMILY) {
      if (padapter->phost_info->reg_block.SetBoardReset == NULL) {
          MSD_ERR_DBGPRINT("reset_adapter: RegisterBlock NULL\n");
          return;
      }

      if (padapter->phw_info->pciSubSysId != PCI_SUBDEVICE_ID_GEM) {
          MERC_SET_BOARD_RESET((&padapter->phost_info->reg_block));
          MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);
          MERC_CLEAR_BOARD_RESET((&padapter->phost_info->reg_block));
      } else {
          // Disable TDM Streaming on Gemini
          mid_strmmgr_hsi_gemini(padapter, MSD_GEM_TDM_OFF, NULL);
          mid_strmmgr_hsi_gemini(padapter, MSD_GEM_STOP, NULL);

          // Enable Bus Master if devices were disabled 
          pci_read_config_byte(padapter->pdevi, PCI_CONFIG_COMMAND, &ucTmp);
          if (ucTmp != 6) {
              ucTmp = 6;
              pci_write_config_byte(padapter->pdevi, PCI_CONFIG_COMMAND, ucTmp);
          }
      }
  } else {
      //3rd Rock Family
      //21554: The reset register is in the PCI configuration space it self.
      //Not on any of those two spaces we mapped earlier @ virt_map_q[0]
      //virt_map_q[1]
      switch(padapter->phw_info->pciSubSysId) {
          case SUBSYSID_21554:
          case SUBSYSID_ROZETTA_21554:

               //Set the reset Interrupt
               data = 0x01;
               Dip = padapter->pdevi;
               MsdWW21554WriteToResetReg(data);
               MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);

               //Add a New Functionality of clearing the post location during the reset time
               mid_wwmgr_clear_3rdrock_postlocation(padapter);
               MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);

               //Clear the Reset Interrupt
               data = 0x00;
               MsdWW21554WriteToResetReg(data);
               MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);
               break;

          case SUBSYSID_80321:
               break;

          default:
               break;
      } /* switch */
  } /*THIRD_ROCK_FAMILY*/
}

/***************************************************************************
 * Function Name		: reset_gemini_fpga
 * Function Type		: Common Hardware function
 * Inputs               :
 * Outputs              :
 * Calling functions    :
 * Description          : Soft reset on Gemini cards
 * Additional comments  : 
 ****************************************************************************/
void reset_gemini_fpga(pmercd_adapter_block_sT padapter)
{
   pmerc_uchar_t ImmrAddr = 0;
   pmerc_uchar_t FpgaAddr = 0;
   merc_uint_t   ulTmp = 0;

   /* Get pointer to QUICC IMMR and FPGA region */
   ImmrAddr = (pmerc_uchar_t)(padapter->phw_info->bar[0].virt_addr);
   FpgaAddr = (pmerc_uchar_t)(padapter->phw_info->bar[3].virt_addr);

   /* Remove the CPU from the arbiter (BE) */
   rmw_bel(ImmrAddr + 0x00800, 0, 1 << 24);

   /* Move IRQ5/SRESET to SRESET */
   rmw_bel(ImmrAddr + 0x00114, (3 << 23) | 1, 1 << 23);

   /* Use the FPGA to activate the SRESET line */
   rmwl(FpgaAddr + 0x23038, 1 << 3, 1 << 2);

   MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL/2);

   /* Use the FPGA to deactivate SRESET */
   rmwl(FpgaAddr + 0x23038, 1 << 2, 1 << 3);

   /* Put IRQ5/RESET to IRQ5 */
   rmw_bel(ImmrAddr + 0x00114, (3 << 23), 0 << 23);

   /* Use the FPGA to reset itself (self clears) */
   rmwl(FpgaAddr + 0x23038, 0, 1);

   MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);
   pci_read_config_dword(padapter->pdevi_gem, 0x00, &ulTmp);

   ulTmp = readl(padapter->phw_info->bar[3].virt_addr + MSD_GEM_DEBUG2);
   if (ulTmp) {
       printk("Gemini: FPGA locked in reset %#x\n", ulTmp);
   }
}

/***************************************************************************
 * Function Name		: reset_gemini_gpio
 * Function Type		: Common Hardware function
 * Inputs               :
 * Outputs              :
 * Calling functions    :
 * Description          : Power off reset on Gemini cards
 * Additional comments  : 
 ****************************************************************************/
void reset_gemini_gpio(pmercd_adapter_block_sT padapter, pmercd_dev_info_T sw_dev, pmercd_dev_info_T bd_bridge, pmercd_dev_info_T fg_bridge)
{
   merc_uint_t   ulTmp = 0;
   merc_uchar_t  ucTmp = 0;

   merc_uint_t gpio_d_cntrl;
   merc_uint_t gpio_data;

   /* Perform a board RESET by writing to the PCIe bridge GPIO port 16 (CP) and 15 (FPGA)
      GPIO D Control Register (PCI Offset 0xc2): bits 5:0 <-- 001001
      GPIO Data Register (PCI Offset 0xc4): bit 16:15 <-- 11 (delay)
      GPIO Data Register (PCI Offset 0xc4): bit 16:15 <-- 00
      GPIO D Control Register (PCI Offset 0xc2): bits 5:0 <-- 000000
   */

   /* Read the current GPIO C/D control and status bits
      Update GPIO D Control to configure GPIO 16 as General Output
      Update GPIO DATA to

      32          16 15           0
      -----------------------------
      | GPIO D CTRL | GPIO C CTRL | (offset 0xc0)
      -----------------------------
      |         GPIO DATA         | (offset 0xc4)
      -----------------------------
   */
   pci_read_config_dword(sw_dev, GEMINI_PCIE_GPIO_C_CTL_OFFSET, &gpio_d_cntrl);
   pci_read_config_dword(sw_dev, GEMINI_PCIE_GPIO_DATA_OFFSET, &gpio_data);

   ulTmp = MSD_GEM_DO_RESET;
   writel(ulTmp, padapter->phw_info->bar[3].virt_addr + MSD_GEM_DEBUG2);

   // Modify current values for board RESET
   // GPIO D Control Register (PCI Offset 0xc2): bits 5:0 <-- 001001
   // GPIO Data Register (PCI Offset 0xc4): bit 16:15 <-- 11
   gpio_d_cntrl &= ~GEMINI_PCIE_GPIO16_15_CTL_MASK;
   gpio_d_cntrl |= (GEMINI_PCIE_GPIO16_CTL_OUTPUT | GEMINI_PCIE_GPIO15_CTL_OUTPUT);
   gpio_data &= ~(GEMINI_PCIE_GPIO16_DATA | GEMINI_PCIE_GPIO15_DATA);

   // Write to perform RESET
   pci_write_config_dword(sw_dev, GEMINI_PCIE_GPIO_C_CTL_OFFSET, gpio_d_cntrl);
   pci_write_config_dword(sw_dev, GEMINI_PCIE_GPIO_DATA_OFFSET, gpio_data);
   MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL/2);

   // Clear Downstream port from Reset state
   ucTmp = 0;
   pci_write_config_byte(bd_bridge, GEMINI_PCIE_SRST_OFFSET, ucTmp);
   pci_write_config_byte(fg_bridge, GEMINI_PCIE_SRST_OFFSET, ucTmp);

   // Write to clear the FPGA RESET
   gpio_data |= GEMINI_PCIE_GPIO15_DATA;
   pci_write_config_dword(sw_dev, GEMINI_PCIE_GPIO_DATA_OFFSET, gpio_data);
   MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL/2);

   // Write to clear the MPC RESET
   gpio_data |= GEMINI_PCIE_GPIO16_DATA;
   pci_write_config_dword(sw_dev, GEMINI_PCIE_GPIO_DATA_OFFSET, gpio_data);

   // Put GPIO pins to input mode
   gpio_d_cntrl &= ~GEMINI_PCIE_GPIO16_15_CTL_MASK;

   pci_write_config_dword(sw_dev, GEMINI_PCIE_GPIO_C_CTL_OFFSET, gpio_d_cntrl);
   MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);
}

/***************************************************************************
 * Function Name		: reset_gemini
 * Function Type		: Common Hardware function
 * Inputs			:
 * Outputs			:
 * Calling functions		:
 * Description			: Streams Driver ResetAdapter Routine. This
 *				  routine Resets the Gemini controllers
 * Additional comments		: 
 ****************************************************************************/
void reset_gemini(pmercd_adapter_block_sT  padapter)
{
   mercd_dhal_intr_enable_sT intrinfo = {0};
   mercd_dhal_intr_disable_sT intrdis = {0};
   pmercd_dev_info_T sw_dev;
   pmercd_dev_info_T bd_dev;
   pmercd_dev_info_T fg_dev;
   pmercd_dev_info_T bd_bridge;
   pmercd_dev_info_T fg_bridge;
   merc_int_t reg_offset, i, c;
   merc_int_t status = 0;
   pmerc_uchar_t BaseAddr = 0;
   pmerc_uchar_t MemAddr = 0;
   merc_uchar_t  ucTmp = 0;
   merc_uint_t   ulTmp = 0;

   /* Perform a board RESET by writing to the PCIe bridge GPIO port 16 (CP) and 15 (FPGA)
      GPIO D Control Register (PCI Offset 0xc2): bits 5:0 <-- 001001
      GPIO Data Register (PCI Offset 0xc4): bit 16:15 <-- 11 (delay)
      GPIO Data Register (PCI Offset 0xc4): bit 16:15 <-- 00
      GPIO D Control Register (PCI Offset 0xc2): bits 5:0 <-- 000000
   */

   bd_dev = padapter->pdevi;
   fg_dev = padapter->pdevi_gem;
   sw_dev = padapter->pdevi_gem_sw;
   if (!sw_dev) {
       return;
   }

   // Readback the QUICC registers here to avoid problems where the OS has
   // changed them since we last read them
   for (i=0, reg_offset=0; reg_offset < 0x80; reg_offset+=4, i++) {
        pci_read_config_dword(bd_dev, reg_offset, &ulTmp);
        if (ulTmp != padapter->gem_mpc[i]) {
            padapter->gem_mpc[i] = ulTmp;
        }
   }

   // Get the Parent Bridge Vendor=0x104C Device=0x8233
   bd_bridge = bd_dev->bus->self;
   fg_bridge = fg_dev->bus->self;

   // Disable Interrupt
   intrdis.ConfigId = padapter->adapternumber;
   linux_pci_intr_disable(&intrdis);

   // Delay to ensure DPC cannot occur
   MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL/2);

   // Pause timer/dpc from accessing the board
   padapter->flags.SramOurs = MERC_ADAPTER_FLAG_WAIT_INTR;

   // Enable Bus Master if devices were disabled 
   pci_read_config_byte(bd_dev, PCI_CONFIG_COMMAND, &ucTmp);
   if (ucTmp != 6) {
       ucTmp = 6;
       pci_write_config_byte(bd_dev, PCI_CONFIG_COMMAND, ucTmp);
       pci_write_config_byte(fg_dev, PCI_CONFIG_COMMAND, ucTmp);
   }

   // Disable TDM Streaming
   mid_strmmgr_hsi_gemini(padapter, MSD_GEM_TDM_OFF, NULL);
   mid_strmmgr_hsi_gemini(padapter, MSD_GEM_STOP, NULL);

   // Disable Error Reporting
   pci_read_config_dword(sw_dev, GEMINI_PCIE_ERROR_REPORT_OFFSET, &ulTmp); 
   ulTmp &= 0xFFFFFFF8;   
   pci_write_config_dword(sw_dev, GEMINI_PCIE_ERROR_REPORT_OFFSET, ulTmp);

   // Determine if we have a FPGA capable of resetting the QUICC
   ulTmp = readl((pmerc_uchar_t)(padapter->phw_info->bar[3].virt_addr) + 0x23000);

   // Reset types depends on FPGA version and run-time options.
   if ( (ulTmp >= 0x1d14) && (padapter->force_gpio_reset == 0) ) {
       reset_gemini_fpga(padapter);
       goto soft_exit;
   } else {
      // Put each Downstream port in Reset state
      ucTmp = 0x40;
      pci_write_config_byte(bd_bridge, GEMINI_PCIE_SRST_OFFSET, ucTmp);
      pci_write_config_byte(fg_bridge, GEMINI_PCIE_SRST_OFFSET, ucTmp);

      reset_gemini_gpio(padapter, sw_dev, bd_bridge, fg_bridge);
   }

   // Clear any error
   ulTmp=1;
   pci_write_config_dword(sw_dev, 0x110, ulTmp);
   pci_write_config_dword(sw_dev, 0x10c, ulTmp);
   pci_write_config_dword(sw_dev, 0x104, ulTmp);

   // Write-back the PCI Compatible Switch and Device-Specific Configuration Space Registers 
   // Make sure we write the CMD register last
   for (i=0, reg_offset=0; reg_offset < 0x80; reg_offset+=4, i++) {
        if (reg_offset == 0x04) continue;
        status |= pci_write_config_dword(bd_dev, reg_offset, padapter->gem_mpc[i]);
        status |= pci_write_config_dword(fg_dev, reg_offset, padapter->gem_fpga[i]);
        status |= pci_write_config_dword(sw_dev, reg_offset, padapter->gem_sw[i]);
        status |= pci_write_config_dword(bd_bridge, reg_offset, padapter->gem_mpc_br[i]);
        status |= pci_write_config_dword(fg_bridge, reg_offset, padapter->gem_fpga_br[i]);
   }
   status |= pci_write_config_dword(bd_dev, 0x04, padapter->gem_mpc[1]);
   status |= pci_write_config_dword(fg_dev, 0x04, padapter->gem_fpga[1]);
   status |= pci_write_config_dword(sw_dev, 0x04, padapter->gem_sw[1]);
   status |= pci_write_config_dword(bd_bridge, 0x04, padapter->gem_mpc_br[1]);
   status |= pci_write_config_dword(fg_bridge, 0x04, padapter->gem_fpga_br[1]);

   // Update the DDR2 timing values
   BaseAddr = (pmerc_uchar_t)(padapter->phw_info->bar[0].virt_addr);
   MemAddr = BaseAddr + 0x2110;
   ulTmp = 0x00000843;
   writel(ulTmp, MemAddr);
   MsdBusyDelayMilliSec(1);

   MemAddr = BaseAddr + 0x2108;
   ulTmp = 0x22633537;
   writel(ulTmp, MemAddr);

   MemAddr = BaseAddr + 0x2118;
   ulTmp = 0x32044844;
   writel(ulTmp, MemAddr);
   MsdBusyDelayMilliSec(1);

   MemAddr = BaseAddr + 0x2110;
   ulTmp = 0x000008C3;
   writel(ulTmp, MemAddr);
   MsdBusyDelayMilliSec(10);

soft_exit:
   // Enable Interrupt
   intrinfo.ConfigId = padapter->adapternumber;
   intrinfo.phw_info = padapter->phw_info;
   linux_pci_intr_enable(&intrinfo);

   ulTmp = readl(padapter->phw_info->bar[3].virt_addr + MSD_GEM_DEBUG2);
   if (ulTmp) {
       printk("Gemini: FPGA locked in reset %#x\n", ulTmp);
   }

   padapter->force_gpio_reset = 0;

   return;
}


/***************************************************************************
 * Function Name		: shutdown_adapter
 * Function Type		: Common Hardware function
 * Inputs			:
 * Outputs			:
 * Calling functions		:
 * Description			: Streams Driver ShutDown Routine. This
 *				  routine shutdowns a Mercury board
 * Additional comments		:
 ****************************************************************************/
md_status_t shutdown_adapter(PSTRM_MSG Msg, pmercd_adapter_block_sT padapter)
{
   mercd_osal_timeout_stop_sT   timeoutinfo = { 0 };
   pmercd_ww_dev_info_sT        pwwDev;
   md_status_t                  status = MD_SUCCESS;

   mid_save_brd_params(padapter);

   //WW support
   if (padapter->flags.WWFlags & MERCD_ADAPTER_WW_I20_MESSAGING_READY) {
       //WW specific shutdown
       pwwDev = (pmercd_ww_dev_info_sT)padapter->pww_info;

       if (pwwDev == NULL) {
           printk("MercShutdownBoard: Unusual State...\n");
           printk("MercShutdownBoard: I20 Ready But No WW struct.\n");
           MSD_ENTER_MUTEX(&padapter->adapter_block_mutex);
           padapter->state = MERCD_ADAPTER_STATE_OUT_OF_SERVICE;
           MSD_EXIT_MUTEX(&padapter->adapter_block_mutex);
           return(MD_FAILURE);
       }

       padapter->state = MERCD_ADAPTER_STATE_SHUTDOWN_PROGRESS;

       if (pwwDev->state == MERCD_ADAPTER_WW_SUCCEDED ) {
	   //We are Running in WW mode
           //Do the garbage in WW mode. Dealloc all the resources
           //for WW mode. We leave the pwwDev as it is.
	   if (padapter->state == MERCD_ADAPTER_STATE_OUT_OF_SERVICE) {
	       reset_adapter(padapter);
	   } else {
	       status = mid_wwmgr_shutdown_adapter(pwwDev, 0);
	   }

           //WWPENDING: we are leaving the state of padapter->flags.WWFlags
           //as MERCD_ADAPTER_WW_MODE_NOTENABLED and pwwDev->state to
           //MERCD_ADAPTER_WW_NOTREADY. But it should still have the
           //MERCD_ADAPTER_WW_I20_MESSAGING_READY bit set. We check this
           //at the time of detach and clear it after unmapping and freeing
           //the mappings
       }  else {
	   mid_save_brd_params(padapter);

       //DMVB and DMVC - shutdown the board in order to handle Cntrl-C
       if ((padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_DMVB) ||
 	   (padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_SEAV) ||
           (padapter->phw_info->pciSubSysId == PCI_SUBDEVICE_ID_DMVC)) {
           status = mid_wwmgr_shutdown_adapter(pwwDev, 0);
       } else {
           reset_adapter(padapter);
       }

	   if (padapter->phw_info->boardFamilyType == THIRD_ROCK_FAMILY) {
	      //release BH lock since we are using schedule_timeout in 3rdrock_running
	      MSD_EXIT_CONTROL_BLOCK_MUTEX_BH();
	      mid_wwmgr_check_3rdrock_running(padapter, MERCD_WW_BOOT_KERNEL);
	      MSD_ENTER_CONTROL_BLOCK_MUTEX_BH();
	   }
       }
   } else {
       //Perform the reset here for non-WW boards only
       padapter->state = MERCD_ADAPTER_STATE_SHUTDOWN_PROGRESS;
       mid_save_brd_params(padapter);
       reset_adapter(padapter);

       if (padapter->phw_info->boardFamilyType == THIRD_ROCK_FAMILY) {
 	   //release BH lock since we are using schedule_timeout in 3rdrock_running
           MSD_EXIT_CONTROL_BLOCK_MUTEX_BH();
       	   mid_wwmgr_check_3rdrock_running(padapter, MERCD_WW_BOOT_KERNEL);
	   MSD_ENTER_CONTROL_BLOCK_MUTEX_BH();
       } else if (padapter->phw_info->pciSubSysId != PCI_SUBDEVICE_ID_GEM) {
	   mid_sram_check_kernel_running(padapter);
       }
   }

   if (status == MD_SUCCESS) {
       padapter->rtkMode = 0;

       MSD_ENTER_MUTEX(&padapter->phw_info->timer_info->timer_flag_mutex );

      if (padapter->flags.SendTimeoutPending & MERC_ADAPTER_FLAG_SEND_TIMEOUT_PEND) {
          MSD_EXIT_MUTEX(&padapter->phw_info->timer_info->timer_flag_mutex);
#ifdef LiS
  	  timeoutinfo.Handle = padapter->phw_info->timer_info->timeout_id;
#else
	  timeoutinfo.Handle = (struct timer_list *)&padapter->phw_info->timer_info->timeout_id;
#endif /* LiS */
          (*mercd_osal_func[MERCD_OSAL_TIMEOUT_STOP])((void *)&timeoutinfo);

	  padapter->flags.SendTimeoutPending = 0;

          if (timeoutinfo.ret != MD_SUCCESS) {
            MSD_ERR_DBGPRINT("MercShutdownBoard: Untimeout failed.\n");
          }

      } else {
          MSD_EXIT_MUTEX(&padapter->phw_info->timer_info->timer_flag_mutex);
      }
   } else if (status == MD_PENDING) {
      //////////////////////////////////////////////////////////////////////////////////////////////
      // The following code was removed, because of a race condition with the
      // WW_CANCEL_REQUEST_INTERRUPT_ACK coming from the board.
      //
      // Here is the race condition:
      //    While time_ww_chk_snd_timer() is running, it sets the
      //       MERC_ADAPTER_FLAG_SEND_TIMEOUT_PEND flag in padapter->flags.SendTimeoutPending.
      //       Before it is able to queue the timer, the WW_CANCEL_REQUEST_INTERRUPT_ACK occurs.
      //    The interrupt DPC function checks padapter->flags.SendTimeoutPending and sees that the
      //       MERC_ADAPTER_FLAG_SEND_TIMEOUT_PEND flag is set.  The interrupt DPC function tries
      //       delete the timer function, even though it has not been queued yet.  This freezes
      //       the machine.
      //////////////////////////////////////////////////////////////////////////////////////////////
         // Kick off the timer to wait for the response. Currently status is
         // PENDING only for the WW based boards
         if ((padapter->phw_info->pciSubSysId != PCI_SUBDEVICE_ID_DM3) &&
	     (padapter->phw_info->pciSubSysId != PCI_SUBDEVICE_ID_DISI)) {

             time_ww_chk_snd_timer(padapter);
         }
   }

   return(status);
}

/***************************************************************************
 * Function Name		: fill_attr
 * Function Type		: Common Hardware function
 * Inputs			:
 * Outputs			:
 * Calling functions		:
 * Description			: Streams Driver FillBoardAttr Routine. This
 *				  routine fills the physical attributes like
 *				  bus, slot, sram addr, length, irq, vector,
 *				  etc. for all the boards found in the system.
 * Additional comments		:
 ****************************************************************************/
void fill_attr(PCFG_GET_PHYS_BOARD_ATTR_ACK AckPtr)
{
	merc_int_t i;
	PMD_PHYS_BOARD_ATTR BrdAttr;
	pmercd_adapter_block_sT padapter;

	MSD_FUNCTION_TRACE("fill_brd_attr", ONE_PARAMETER, (size_t)AckPtr);

	AckPtr->BoardCount = MsdControlBlock->adapter_count;

	BrdAttr = (PMD_PHYS_BOARD_ATTR)(AckPtr + 1);

	for (i = 0; i < AckPtr->BoardCount && i < MSD_MAX_BOARD_ID_COUNT;
				 i++, BrdAttr++) {
		if ( mercd_adapter_map[i] == 0xFF ) /* listboards panic */
		    continue;

		// zero out unused variables to begin with
		MSD_ZERO_MEMORY((pmerc_char_t)BrdAttr, sizeof(MD_PHYS_BOARD_ATTR));

		padapter = MsdControlBlock->padapter_block_list[mercd_adapter_map[i]];

		if( padapter == NULL )
			continue;

		BrdAttr->ConfigId = i;
		BrdAttr->BusType = padapter->phw_info->bus_type;
		BrdAttr->BusId = padapter->phw_info->bus_number;
		BrdAttr->SlotNumber = padapter->phw_info->slot_number;
		BrdAttr->PhysSramAddr = padapter->phw_info->virt_map_q[MERCD_PCI_SRAM_MAP]->phys_addr;
		BrdAttr->PhysSramSize = padapter->phw_info->virt_map_q[MERCD_PCI_SRAM_MAP]->byte_count;
		BrdAttr->InterruptLevel = padapter->phw_info->intr_info->level;
		BrdAttr->InterruptVector = padapter->phw_info->intr_info->intr_vec;
		BrdAttr->InterruptSharable = 1;	// yes, sharable
		BrdAttr->DmaChannel = MD_CFG_DMA_DISABLE; // not used
                //PCI Slot Number for listboards
                BrdAttr->pciSlotNumber = padapter->phw_info->pci_slot_number;
	}

}
// ************************************************************
// Post Changes .......
// ************************************************************
md_status_t mid_sram_read_post_location( pmercd_adapter_block_sT padapter )
{
	merc_uchar_t            DebugVal, DebugVal2;
	merc_uint_t             regValue;
	merc_uint_t             WaitCount;
	merc_uchar_t            InUchar;
	pmercd_reg_block_sT     RegBlock;

	 RegBlock = &padapter->phost_info->reg_block;

	 MERC_CHECK_DEBUG_ONE((&padapter->phost_info->reg_block), DebugVal);

	 MERC_CHECK_DEBUG_TWO((&padapter->phost_info->reg_block), DebugVal2);

	 if (DebugVal !=  FIRST_DEBUG_VALID_RESULT)
        return(MERCD_WW_POST_IN_PROGRESS);
     else {}

	 MERC_CHECK_DEBUG_TWO((&padapter->phost_info->reg_block), DebugVal);

	 if (DebugVal != SECOND_DEBUG_VALID_RESULT)
		return(MERCD_WW_POST_IN_PROGRESS);
	 else
		return(MD_SUCCESS);

}
// ***************************************************************************
md_status_t mid_sram_check_kernel_running( pmercd_adapter_block_sT padapter )
{
	md_status_t             Status;
	merc_ulong_t            wcount = 0;
	merc_uint_t				wait_time;
	merc_uchar_t            DebugVal;
	merc_uint_t             regValue;
	merc_uint_t             WaitCount;
    merc_uchar_t            InUchar;
    pmercd_reg_block_sT     RegBlock;

    if (padapter->flags.PostFlags == MD_MIN_POST_ENABLE)  {
		 wait_time = 10000;
		 MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);
	 } else {
		 printk("Waiting now .... \n");
		 wait_time = 80000;
		 MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);
		 MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);
		 MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);
		 MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);
		 MsdBusyDelayMilliSec(MERC_BOARD_RESET_WAIT_INTERVAL);
	}
	Status = MD_FAILURE;

	do {
		Status = mid_sram_read_post_location(padapter);

		if (Status != MD_SUCCESS) {
			if(Status == MERCD_WW_POST_IN_PROGRESS) {
				if (++wcount > wait_time ){
					return(Status);
				 }
			 // cannot use schedule_timeout in bh level
			 MsdBusyDelayMilliSec(20);
		} else {
			  return (Status);
		}
	   } /* !MD_SUCCESS */
	 } while (Status != MD_SUCCESS);

	 return(MD_SUCCESS);
}
// ***************************************************************************
