# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#ConcatInputStream a class for reading from Concats

#don't source the script more then once
if [info exists ConcatInputStream] {
    return
}


#this line helps the auto loader find this class
proc ConcatInputStream {} {}

catch {class new -Name ConcatInputStream -init {-Extends InputStream}}


#error description

ConcatInputStream method init {args} {
    array set check [CheckParms -Proc "ConcatInputStream_init parm" -Provided $args \
			 -Required {-InputStreams}]

    array set parms $check(Flags)

    set streams $parms(-InputStreams)

    #create the stream
    $this public QStreamRef StreamList
    global QSTREAM_OPENREAD

    set StreamList $streams

    #prepare list of input stream refs
    set stream_ref_list {}
    foreach stream $streams {
	$stream attach
	lappend stream_ref_list [$stream set QStreamRef]
    }

    set QStreamRef [eval QS_PRIM_StreamCreate 3 $QSTREAM_OPENREAD $stream_ref_list]

    #call parent constructor
    $this super init

};#endof ConcatInputStream_init



ConcatInputStream method destroy {} {

    $this public StreamList

    foreach stream $StreamList {
	$stream detach
    }

    #call parent class destructor
    $this super destroy
}










