# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#FileInputStream a class for reading from files

#don't source the script more then once
if [info exists FileInputStream] {
    return
}


#this line helps the auto loader find this class
proc FileInputStream {} {}

catch {class new -Name FileInputStream -init {-Extends InputStream}}


#error description
set QS_ErrorCode_Descriptions(FileStream_FileNotFound) {File not Found}
set QS_ErrorCode_Descriptions(FileStream_FileNotReadable) {File not Readable}

FileInputStream method init {args} {
    array set check [CheckParms -Proc "FileInputStream_init parm" -Provided $args \
			 -Required {-FileName}]

    array set parms $check(Flags)

    set filename $parms(-FileName)

    #make sure file exists
    if ![file exists $filename] {
	QS_Error -Error FileStream_FileNotFound -Data [list FileName $filename]
    }
    #make sure file is readable
    if ![file readable $filename] {
	QS_Error -Error FileStream_FileNotReadable -Data [list FileName $filename]
    }

    #create the stream
    $this public QStreamRef
    global QSTREAM_OPENREAD

    set QStreamRef [QS_PRIM_StreamCreate 0 $QSTREAM_OPENREAD $filename]

    #call parent constructor
    $this super init

};#endof FileInputStream_init


#FileInputStream_seek - moves read head
#***Inputs***
#offset - number of bytes to move 
FileInputStream method seek {offset} {

    $this public QStreamRef
    #seek from current position=2
    return [QS_PRIM_FileStreamSeek $QStreamRef $offset 2]
    
};#endof back

#FileInputStream_rewind - moves read head to start of file
#***Inputs***
FileInputStream method rewind {} {

    $this public QStreamRef
    #seek from orgin =1
    return [QS_PRIM_FileStreamSeek $QStreamRef 0 1]
    
};#endof rewind


