# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists MsgQueue] {
    return
}
#this line helps the auto loader find this class
proc MsgQueue {} {}


#Error Descriptions
set QS_ErrorCode_Descriptions(TIMEOUT) {A timeout occured while waiting for a response message}

set QS_GlobalValues(TransactionIdCounter) 0xFF;#initial transId


catch {class new -Name MsgQueue}



#MsgQueue_init - init a new msgQueue
#***Inputs***
#-Desc
#[-MsgSize] - the maximum msg size to receive
#[-Depth] - the maximum number of messages to receive at a time
#***Outputs***
#***Exceptions***
MsgQueue method init {args} {
    array set check [CheckParms -Proc MsgQueue_init \
			 -Provided $args \
			 -Required {-Desc} -Optional {-MsgSize -Depth}]
		       
    
    array set parms $check(Flags)
    global QS_GlobalValues env

    set odesc $parms(-Desc)

    if [catch {set msgSize $parms(-MsgSize)} result] {
	set msgSize $QS_GlobalValues(MsgQueue_MaxMsgSize)
    }

    if [catch {set depth $parms(-Depth)} result] {
	set depth $QS_GlobalValues(MsgQueue_Depth)
    }

    $this super init
    $this public MsgQueueRef CompDesc ResponseTimeout ErrorWaitTime

 
    array set msgQueueRef [QS_PRIM_MsgQueueCreate $odesc $msgSize $depth \
			       $QS_GlobalValues(HOST)]
 
    set MsgQueueRef $msgQueueRef(MsgQueueRef)
    array set desc [QS_PRIM_MsgQueueGetDesc $msgQueueRef(MsgQueueRef)]
    set CompDesc $desc(Desc)
    set ResponseTimeout $QS_GlobalValues(ResponseTimeout)
    set ErrorWaitTime $QS_GlobalValues(ErrorWaitTime)    
};#endof MsgQueue_init



#MsgQueue_destroy - close and unbind a queue
#***Inputs***
#msgQ
#***Outputs***
#***Exceptions***
MsgQueue method destroy {} {

    $this public MsgQueueRef

    #free the queue
    QS_PRIM_MsgQueueDestroy $MsgQueueRef
    
    #call parent class destrcutor
    $this super destroy
};#endof MsgQueue_Destroy


#MsgQueue_request - issues a msg request on a msg queue
#***Inputs***
#MsgQueue - the msgQueue to use
#-Msg - the msg to send
#-DestDesc - the descriptor to send the msg to
#-MsgType - the type of the msg
#[-TransactionId] - transId to use
#[-ResponseMsgType] - the expected type for the response msg
#[-Timeout] - timeout in miliseconds to wait for response msg, 0 = forever
#***Switches***
#[-IgnoreSource] - Ignore source address in routing
#***Outputs***
#Msg - the response msg
#***Exceptions***
#TIMEOUT - no response message arrived, within timeout period
#StdMsgError - a StdMsgError was returned when not expected
#QResultError - a QResultError was returned when not expected
MsgQueue method request {args} {

    array set check [CheckParms -Proc MsgQueue_request \
			 -Provided $args \
			 -Required {-Msg -MsgType -DestDesc} \
			 -Optional {-ResponseMsgType -TransactionId -Timeout} \
			 -Switches {-IgnoreSource}]
		       
    
    array set parms $check(Flags)

    set expect_response 1
    set errorsonly 0

    #handle required arguments
    set dest_desc $parms(-DestDesc)
    set type $parms(-MsgType)
    set msg $parms(-Msg)


    #set optional arguments
    if {[catch {set rettype $parms(-ResponseMsgType)} result]} {
	#not set this means were not expecting a response
	set rettype 0
	set expect_response 0
    }

    if [catch {set transid $parms(-TransactionId)} result] {
	#not set, generate a unique one
	global QS_GlobalValues
	set transid [incr QS_GlobalValues(TransactionIdCounter)]
    }


    if {[catch {set timeout $parms(-Timeout)} result]} {
	if {$expect_response} {
	    set timeout [$this set ResponseTimeout]
	} else {
	    set timeout [$this set ErrorWaitTime]
	}
    }


    #switches
    if {[lsearch -exact $check(Switches) "-IgnoreSource"]==-1} {
	set ignoresrc 0
    } else {
	set ignoresrc 1
    }

    #get the references
    $msg public MsgRef
    
    $this public MsgQueueRef
    set msgref $MsgRef


    #destroy the message
    unset MsgRef
    $msg destroy


    #send the message and get response
    array set msgrefin [QS_PRIM_MsgQueueRequest $MsgQueueRef $msgref $dest_desc $type \
		   $rettype $transid $timeout $ignoresrc]

    #check to see if we got a message
    if {!$msgrefin(MsgRef)&&!$expect_response} {
	#we weren't expecting a response so this is ok
	return
    } elseif {!$msgrefin(MsgRef)} {
	#we were expecting a response, this is a TIMEOUT!
	QS_Error -Error TIMEOUT
    }

    #we got a message    

    set msgref $msgrefin(MsgRef)
    array set head [QS_MsgRefGetHead $msgref]

    #build msg object
    set msg [Msg new]

    $msg public MsgRef Head

    set Head [array get head]
    set MsgRef $msgref

    unset msgref

    #check type
    global Std_MsgError QResultError
    if {$head(Type)==$Std_MsgError} {
	#an error was returned
	
	#check to see if we were expecting an error
	if {$expect_response&&$rettype==$Std_MsgError} {
	    #we were expecting an error, everything is ok
	} else {
	    #weren't expecting an error response, report the error
	    QS_Error -Error StdMsgError -Data [list Msg $msg]
	}
	
    }
    if {$head(Type)==$QResultError} {
	#an QResultError was returned

	#check to see if we were expecting an error
	if {$expect_response&&$rettype==$QResultError} {
	    #we were expecting an error, everything is ok
	} else {
	    #weren't expecting an error response, report the error
	    QS_Error -Error QResultError -Data [list Msg $msg]
	}
    }

    #return the Msg to the caller

    return $msg
};#endof MsgQueue_request







#**********************************************************************
# METHOD:      MsgQueue_send 
# DESCRIPTION: Sends a message on a message queue used for async 
#              programming model
# INPUTS:      -MsgQueue - the msgQueue to use
#              -Msg - the msg to send
#              -DestDesc - the descriptor to send the msg to
#              -MsgType - the type of the msg
#              [-TransactionId] - transId to use
# SWITCHES:
#              [-IgnoreSource] - Ignore source address in routing
# OUTPUTS:
#              Msg - the response msg
# EXCEPTIONS:
#              TIMEOUT - no response message arrived, within timeout period
#              StdMsgError - a StdMsgError was returned when not expected
#              QResultError - a QResultError was returned when not expected
#**********************************************************************
MsgQueue method send {args} {

    array set check [CheckParms -Proc MsgQueue_request \
			 -Provided $args \
			 -Required {-Msg -MsgType -DestDesc} \
			 -Optional {-TransactionId} \
			 -Switches {-IgnoreSource}]
		       
    array set parms $check(Flags)

    set expect_response 1
    set errorsonly 0

    #handle required arguments
    set dest_desc $parms(-DestDesc)
    set type $parms(-MsgType)
    set msg $parms(-Msg)


    set rettype 0
    set expect_response 0

    if [catch {set transid $parms(-TransactionId)} result] {
	#not set, generate a unique one
	global QS_GlobalValues
	set transid [incr QS_GlobalValues(TransactionIdCounter)]
    }

    #switches
    if {[lsearch -exact $check(Switches) "-IgnoreSource"]==-1} {
	set ignoresrc 0
    } else {
	set ignoresrc 1
    }

    #get the references
    $msg public MsgRef
    
    $this public MsgQueueRef
    set msgref $MsgRef


    #destroy the message
    unset MsgRef
    $msg destroy


    #send the message and get response
    array set msgrefin [QS_PRIM_MsgQueueRequest $MsgQueueRef $msgref $dest_desc $type \
		   $rettype $transid $timeout $ignoresrc]

    #check to see if we got a message
    if {!$msgrefin(MsgRef)&&!$expect_response} {
	#we weren't expecting a response so this is ok
	return
    } elseif {!$msgrefin(MsgRef)} {
	#we were expecting a response, this is a TIMEOUT!
	QS_Error -Error TIMEOUT
    }

    #we got a message    

    set msgref $msgrefin(MsgRef)
    array set head [QS_MsgRefGetHead $msgref]

    #build msg object
    set msg [Msg new]

    $msg public MsgRef Head

    set Head [array get head]
    set MsgRef $msgref

    unset msgref

    #check type
    global Std_MsgError QResultError
    if {$head(Type)==$Std_MsgError} {
	#an error was returned
	
	#check to see if we were expecting an error
	if {$expect_response&&$rettype==$Std_MsgError} {
	    #we were expecting an error, everything is ok
	} else {
	    #weren't expecting an error response, report the error
	    QS_Error -Error StdMsgError -Data [list Msg $msg]
	}
	
    }
    if {$head(Type)==$QResultError} {
	#an QResultError was returned

	#check to see if we were expecting an error
	if {$expect_response&&$rettype==$QResultError} {
	    #we were expecting an error, everything is ok
	} else {
	    #weren't expecting an error response, report the error
	    QS_Error -Error QResultError -Data [list Msg $msg]
	}
    }

    #return the Msg to the caller

    return $msg
};#endof MsgQueue_request








