# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#some global definitions
#Error Descriptions
set QS_ErrorCode_Descriptions(MsgAllocateSizeError) {The requested size was not obtained}
set QS_ErrorCode_Descriptions(UnsupportedDataType) {This DataType currently unsupported}
set QS_ErrorCode_Descriptions(MsgAccessOutOfBounds) {The requested field is out of the message block}



set QS_GlobalValues(QT_Sizes) [list $QT_CHAR $QT_CHAR_SIZE \
				   $QT_INT8 $QT_INT8_SIZE \
				   $QT_INT16 $QT_INT16_SIZE \
				   $QT_INT24 $QT_INT24_SIZE \
				   $QT_INT32 $QT_INT32_SIZE \
				   $QT_UINT8 $QT_UINT8_SIZE \
				   $QT_UINT16 $QT_UINT16_SIZE \
				   $QT_UINT24 $QT_UINT24_SIZE \
				   $QT_UINT32 $QT_UINT32_SIZE \
				   $QT_PARM $QT_PARM_SIZE]




#****************************************************************
#The following are MsgRef functions and not meant for general use
#****************************************************************



#QS_MsgRefCopy - copies a msg
#***Inputs***
#msgref - the msg to copy
#***Outputs***
#MsgRef - a reference to the new msg
#***Exceptions***
proc QS_MsgRefCopy {msgref} {    

    set newmsgref [QS_PRIM_MsgCopy $msgref]

    return $newmsgref
};#endof QS_MsgRefCopy


#QS_MsgRefGetHead - Gets the header info from a message
#***Inputs***
#msg
#***Outputs***
#the Header info
#***Exceptions***
proc QS_MsgRefGetHead {msgref} {

    set data [QS_PRIM_MsgGetHead $msgref]

    return $data
};#endof QS_MsgRefGetHead

#QS_MsgRefAllocate - Allocates a new Msg
#***Inputs***
#[-Size] - the size of the new message, defaults to 0
#***Outputs***
#MsgRef - a reference to the new msg
#***Exceptions***
proc QS_MsgRefAllocate {args} {
    array set check [CheckParms -Proc QS_MsgRefAllocate -Provided $args \
		   -Optional {-Size}]
    
    array set parms $check(Flags)

    if [catch {set size $parms(-Size)} result] {
	set size 0
    }

    set msgref [QS_PRIM_MsgAllocate $size]

    array set msg $msgref
    if [expr $msg(MsgRef) == 0] {
	#allocation error
	QS_Error -Error MsgAllocateSizeError -Data [list MsgRef $msg(MsgRef)]
    }

    return $msgref
};#endof QS_MsgRefAllocate


#QS_MsgRefReallocate - Allocates a new Msg
#***Inputs***
#msgref - msg to resize
#-Size - the size of the new message
#***Switches**
#[-Incr] - size means size to increase current msg by
#***Outputs***
#MsgRef - a reference to the new msg
#***Exceptions***
#Invalid_MsgRef - is thrown if MsgRef is not valid
#MsgAllocateSizeError - requested size was not obtained
proc QS_MsgRefReallocate {msgref args} {
    array set check [CheckParms -Proc "QS_MsgRefReallocate MsgRef" \
			 -Provided $args \
			 -Required {-Size} -Switches {-Incr}]

    array set parms $check(Flags)
    set switches $check(Switches)

    set do_incr 0

    if {[lsearch -exact $switches -Incr]!=-1} {
	set do_incr 1
    }


    #get the current size
    array set head [QS_MsgRefGetHead $msgref]

    if {$do_incr} {
	set size [expr $head(Size) + $parms(-Size)]
    } else {
	set size $parms(-Size)
    }

    #dont' allow negative sizes
    if {$size < 0} {
	set size 0
    }


    if {$size==$head(Size)} {
	#no size change, return current msgref
	return [list MsgRef $msgref]
    }

    array set msg [QS_PRIM_MsgReallocate $size $msgref]


    #check to make sure correct size was obtained
    unset head
    array set head [QS_MsgRefGetHead $msg(MsgRef)]
    if {$head(Size) < $size} {
	QS_Error -Error MsgAllocateSizeError -Data [list MsgRef $msg(MsgRef)]
    }

    return [list MsgRef $msg(MsgRef)]
};#endof QS_MsgRefReallocate



proc QS_FieldDefSet {args} {
    array set check [CheckParms -Proc "QS_FieldDefSet" \
			 -Provided $args \
			 -Required {-DataType} \
			 -Optional {-Count -Offset -After}]

    array set parms $check(Flags)

    #required fields
    set datatype $parms(-DataType)

    #optional
    if [catch {set count $parms(-Count)} result] {
	set count 1;#default it to one
    } 
    incr count -1

    if [catch {set offset $parms(-Offset)} result] {
	set offset 0;#default it to zero
    }

    if [info exists parms(-After)] {
	#this is fielddef which this one follows
	#this will overide any supplied offset
	set fd $parms(-After)
	array set after_fd [QS_FieldDefGet $fd]
	set offset $after_fd(Offset)
	incr offset [expr $after_fd(Count) * [QS_DataTypeGetSize $after_fd(DataType)]]
    }

    global QFIELDDEF_OFFSET QFIELDDEF_COUNT QFIELDDEF_DATATYPE
    set fielddef [expr ($offset << $QFIELDDEF_OFFSET) | \
		      ($count << $QFIELDDEF_COUNT) | \
		      ($datatype << $QFIELDDEF_DATATYPE)]
    return [format 0x%x $fielddef]

};#endof QS_FieldDefSet

#QS_FieldDefGet - Gets the values in a FieldDef
#***Inputs***
#FieldDef - the FieldDef to query
#[PreviousValues] - values from earlier msg body
#***Outputs***
#the fiedldef info
#***Exceptions***
proc QS_FieldDefGet {FieldDef {PreviousValues NONE}} {

    if {[llength $FieldDef]>1} {
	#a QSFieldDef was sent in just return it
	
	if [catch {array set afd $FieldDef} result] {
	    error "$FieldDef not a valid fielddef, prevVals = $PreviousValues"
	}

	if [info exists afd(-Switch)] {
	    #conditional fielddef encountered
	    if {$PreviousValues == "NONE"} {
		error "Field Definiton contains a conditional, PreviousValues needed: $FieldDef"
	    }

	    array set prev $PreviousValues

	    
	    if [catch {set key $prev($afd(-Switch))} result] {
		#key not found
		error "Key $afd(-Switch) not found in: $PreviousValues"

	    }


	    array set cases $afd(-Cases)

	    if [info exists cases($key)] {
		set fd $cases($key)
	    } else {
		#key not found, use default
		if [catch {set fd $cases(default)} result] {
		    #no default
		    error "No case $key or default in: [array get cases]"
		}
	    }

	    return [QS_FieldDefGet $fd $PreviousValues]
	}
	
	if [catch {set temp_fd(Offset) $afd(-Offset)} result] {
	    set temp_fd(Offset) Auto
	}
	if [catch {set temp_fd(Count) $afd(-Count)} result] {
	    set temp_fd(Count) 1
	}
	if [catch {set temp_fd(Term) $afd(-Term)} result] {
	}
	if [catch {set temp_fd(DataType) $afd(-DataType)} result] {
	    QS_Error -Error InvalidFieldDef -Data [list FieldDef $FieldDef]
	}	
	set fd [array get temp_fd]
    } else {
	if [catch {expr $FieldDef} result] {
	    #not a number, must be a refernce
	    array set prev $PreviousValues
	    set FieldDef $prev($FieldDef)
	}
	set fd [QS_PRIM_FieldDefGet $FieldDef]
    }
    return $fd
};#endof QS_FieldDefGet


#QS_DataTypeGetSize - gets byte size of a QT DataType
#***Inputs***
#datatype
#***Exceptions***
#UnsupportedDataType - speficied datatype not supported
proc QS_DataTypeGetSize {QType} {
    global QS_GlobalValues
    array set sizes $QS_GlobalValues(QT_Sizes)
    #verify that dataType is supported
    if [catch {set size $sizes($QType)} result] {
	QS_Error -Error UnsupportedDataType -Data [list DataType $QType]
    }
    return $size
};#endof QS_DataTypeGetSize



#QS_MsgRefVarFieldPut - puts a data into a field in a msg
#***Inputs***
#msgref - the message to put data into
#-DataType - describes the data
#-Data - the data to put in field
#-Offset - Offset into msg, if left out
#[-Count] - number of elment to write, defaults to 1
#[-Term] - write untill this element is encountered
#****Switches***
#[-Allocate] - Allocate more memory if needed
#***Outputs***
#Offset - end of written segment
#MsgRef - may be new if more memory was allocated
#***Exceptions***
#Invalid_MsgRef - is thrown if MsgRef is not valid
#UnsupportedDataType - speficied datatype not supported
#MsgAccessOutOfBounds - request out of msg block
proc QS_MsgRefVarFieldPut {msgref args} {
    array set check [CheckParms -Proc "QS_MsgRefVarFieldPut MsgRef" \
			 -Provided $args \
			 -Required {-DataType -Data -Offset} \
			 -Optional {-Count -Term} -Switches {-Allocate}]
    
    array set parms $check(Flags)

    #required fields
    set data $parms(-Data)
    set offset $parms(-Offset)
    set dtype $parms(-DataType)

    #optional
    if [catch {set count $parms(-Count)} result] {
	set count 1;#default it to one
    }

    if ![catch {set term $parms(-Term)} result] {
	set count 0
    } else {
	set term {}
    }

    set Allocate 0
    if {[lsearch -exact $check(Switches) "-Allocate"]!=-1} {
	set Allocate 1
    }

    


    array set retval [QS_MsgRefVarFieldPutPrep $msgref $dtype $data $offset $count $term]

    set parms $retval(Pairs)
    set offset $retval(Offset)
    set size $retval(Size)
 

    #check that offset is not > msg_size
    if {[expr ($offset) > $head(Size)]} {
	if {$Allocate && $offset >= 0} {
	    
	    set more_msg_size [expr $offset-$head(Size)]
	    #increase msg size if needed
	    array set newmsg [QS_MsgRefReallocate $msgref -Size $more_msg_size -Incr]
	    set msgref $newmsg(MsgRef)
	} else {
	    QS_Error -Error MsgAccessOutOfBounds -Data [list \
							    MsgRef $msgref \
							    MsgSize $head(Size) \
							    Offset $offset \
							    DataType $dtype \
							    Count $count]
	}					
    };#endof size check


    #write the data
    if [catch {
	eval QS_PRIM_MsgVarFieldPut $msgref [expr $offset - $size] $count $pairs
    } result ] {
	QS_Error -Error $result -Data [list DataType $dtype]
    }
  
    #output new offset
    return [list Offset $offset MsgRef $msgref]
};#endof QS_MsgRefVarFieldPut


#QS_MsgRefVarFieldPutPrep - preps data to be put into a msg
#***Inputs***
#msgref - the message to put data into
#DataType - describes the data
#Data - the data to put in field
#Offset - Offset into msg, if left out
#Count - number of elment to write
#Term - write untill this element is encountered (only valid if count is 0)
#***Outputs***
#Offset - end of written segment
#MsgRef - may be new if more memory was allocated
#***Exceptions***
#Invalid_MsgRef - is thrown if MsgRef is not valid
#UnsupportedDataType - speficied datatype not supported
#MsgAccessOutOfBounds - request out of msg block
proc QS_MsgRefVarFieldPutPrep {msgref dtype data offset count term} {
    

    global QT_CHAR
    #find a term if necessary
    if {[expr $count == 0]} {
	#term set, find it in the list
	if {$dtype==$QT_CHAR} {
	    set count [string first $term $data]
	} else {
	    set count [lsearch -exact $data $term]
	}
	incr count
    }


    set size [QS_DataTypeGetSize $dtype]
    set block_size [expr $size * $count]



    #prep the data
   
    set pairs {}
    if {$dtype==$QT_CHAR} {
	#strings of chars must be seperated
	for {set j 0} {[expr $j < $count]} {incr j} {
	    lappend pairs $dtype [string index $data $j]
	}
    } else {
	for {set j 0} {[expr $j < $count]} {incr j} {
	    lappend pairs $dtype [lindex $data $j]
	}
    }

    incr offset $block_size

   
    #return the prepared data
    return [list Size $block_size Pairs $pairs Offset $offset]

};#endof QS_MsgRefVarFieldPutPrep


#check to see if poss is the terminator
#term is the value or partial value were checking for
proc QS_termCompare {term poss} {

    if {[llength $term] == 1} {
	#single element
	if {$term == $poss} {
	    return 1
	}
	return 0
    } else {
	array set t $term
	array set p $poss
	#multi element, check one level deep
	foreach elm [array names t] {
	    if ![info exists p($elm)] {
		#doesn't even exist ???
		return 0
	    }
	    
	    if {$t($elm) != $p($elm)} {
		#not equal
		return 0
	    }
	}
	return 1
    }
    return 0
}


#QS_MsgRefVarFieldGet - gets data from a msg
#***Inputs***
#msgref - the message to put data into
#-DataType - describes the data
#-Offset - Offset into msg, if left out
#[-Count] - negative means read till end of msg
#[-Term]
#***Exceptions***
#Invalid_MsgRef - is thrown if MsgRef is not valid
#UnsupportedDataType - speficied datatype not supported
#MsgAccessOutOfBounds - request out of msg block
proc QS_MsgRefVarFieldGet {msgref args} {
    array set check [CheckParms -Proc "QS_MsgRefVarFieldGet MsgRef" \
			 -Provided $args \
			 -Required {-DataType -Offset} -Optional {-Count -Term}]

    array set parms $check(Flags)
    
    set offset $parms(-Offset)
    set dtype $parms(-DataType)

    array set head [QS_MsgRefGetHead $msgref]

    set size [QS_DataTypeGetSize $parms(-DataType)]


    #optional
    if [catch {set count $parms(-Count)} result] {
	set count 1;#default it to one
    } else {
	#if count <0 then read till end of message
	if {$count < 0} {
	    set count [expr ($head(Size) - $offset) / $size ]
	}
    }


    if ![catch {set term $parms(-Term)} result] {
	#term set, watch for it
    }
   

    #check to make sure we don't work outside of message body

    #check that offset+data_size is not > msg_size
    if {[expr ($offset+($size*$count)) > $head(Size)]||[expr $offset < 0]} {
	QS_Error -Error MsgAccessOutOfBounds -Data [list \
							MsgRef $msgref \
							MsgSize $head(Size) \
							Offset $offset \
							DataType $dtype \
							Count $count]
							
    }

    global QT_CHAR
    set data {}

    #read the data
    if [catch {
	if [info exists term] {
	    set read_till_term 1
	} else {
	    set read_till_term 0
	}
	for {set j 0} {[expr ($j < $count) || $read_till_term]} {incr j} {
	    set retval [QS_PRIM_MsgVarFieldGet $msgref $offset 1 $dtype]
	    incr offset $size

	    if {$dtype==$QT_CHAR} {
		set data ${data}$retval
		if {$retval == "{}"} {
		    set retval "\0"
		}
	    } else {
		lappend data $retval
	    }

	    #check to see if this is the terminator
	    if {[info exists term] && [QS_termCompare $term $retval] } {
		incr j
		break
	    }
	    
	}    
    } result ] {
	QS_Error -Error $result -Data [list DataType $dtype]
    }
  
    #output new offset and data
    return [list Offset $offset Value $data Count $j]
};#endof QS_MsgRefVarFieldGet


#QS_MsgRefRead - reads a bunch of data from a message
#read_data in a list {dtype dtype dtype ...}
proc QS_MsgRefRead {msgref start_offset read_data} {
    set size 0
    global QS_GlobalValues
    array set sizes $QS_GlobalValues(QT_Sizes)


    foreach dtype $read_data {
	incr size $sizes($dtype)
    }

    array set head [QS_MsgRefGetHead $msgref]

	
    #check that offset+data_size is not > msg_size
    if {[expr ($start_offset+$size) > $head(Size)]||[expr $start_offset < 0]} {
	QS_Error -Error MsgAccessOutOfBounds -Data [list \
							MsgRef $msgref \
							MsgSize $head(Size) \
							Offset $start_offset \
							DataList $read_data]
							
    }

   

    set retlist [eval QS_PRIM_MsgVarFieldGet $msgref $start_offset [llength $read_data] $read_data]


};#endof QS_MsgRefRead


#QS_MsgRefWrite - writes a bunch of data to a message
#write data is a list of pairs {datatype value datatype value ...}
proc QS_MsgRefWrite {msgref start_offset blockSize write_data} {
    #allocate needed space
	array set head [QS_MsgRefGetHead $msgref]
	if {[expr $head(Size) < ($blockSize + $start_offset)]} {
		array set retval [QS_MsgRefReallocate $msgref -Incr -Size $blockSize]
		set msgref $retval(MsgRef)
	}

    #write the data into the message
    if [catch {
	set count [expr [llength $write_data] /2]
	eval QS_PRIM_MsgVarFieldPut $msgref $start_offset $count $write_data
    } result ] {
	QS_Error -Error $result -Data [list WriteData $write_data]
    }

    return [list Offset [expr $start_offset + $blockSize] MsgRef $msgref]
};#endof QS_MsgRefWrite

#QS_MsgRefPack - Converts tcl string data to a binary DM3 message
#***Inputs***
#-Data - the tcl data string to be packed
#-TypeDef - the type definition to use to pack the data
#[-MsgRef] - append to existing msg
#[-Offset] - offset to start at, defaults to end of msgref if given or 0
#***Switches***
#-Prep - prepare a write list
#***Outputs***
#MsgRef - a reference to the packed msg
#Offset - next position in msg
#***Exceptions***
#Invalid_MsgRef - is thrown if MsgRef is not valid
#UnsupportedDataType - speficied datatype not supported
#MsgAccessOutOfBounds - request out of msg block

#FieldDef Notes
# - Defaults -Offset 0 -Count 1
# - Currently offset in fielddef is not used
# - DataType field is required, no default value supplied
# - Term and Count should not be used in same fieldDef, Term will overide count
# - Count can reference an earlier field in the definition, if the field was
#   supplied, its value will be used, if not supplied, it will be created and equal
#   the length of the list
#   QT_CHAR don't get seperated by white space
proc QS_MsgRefPack {args} {
    array set check [CheckParms -Proc QS_MsgRefPack -Provided $args \
			 -Required {-Data -TypeDef} \
			 -Optional {-MsgRef -Offset} -Switches {-Prep}]


    array set parms $check(Flags)
    #handle required arguments
    array set data $parms(-Data)
    array set typedef $parms(-TypeDef)

    #handle optional arguments
    if [catch {set msgref $parms(-MsgRef)} result] {
	#don't do anything
	array set newmsg [QS_MsgRefAllocate -Size 0]
	set msgref $newmsg(MsgRef)
    }

   
    set prep 0
    if {[lsearch -exact $check(Switches) "-Prep"]!=-1} {
	set prep 1
    }

    array set head [QS_MsgRefGetHead $msgref]
    set msgsize $head(Size)

    if [catch {set offset $parms(-Offset)} result] {
	set offset $msgsize;#set to end of current msg
    }


    

    set typedef_fieldNames {}
    #build a ORDERED list which contains all fieldnames on current typedef level
    set i 0
    foreach field $parms(-TypeDef) {
	if ![expr $i % 2] {
	    #only insert field names
	    lappend typedef_fieldNames $field
	}
	incr i
    }

    set fd {}

    global QT_CHAR QS_GlobalValues

    array set sizes $QS_GlobalValues(QT_Sizes)

    foreach field $typedef_fieldNames {
	#NOTE: this must be done in a separate loop, other wise the refrenced field won't be filled in properly
	#go through and fill in missing count field if its missing	
	#test to see if count is a number
	unset fd
	array set fd [QS_FieldDefGet $typedef($field) [array get data]]


	set count $fd(Count)


	if [catch {expr $count} result] {
	    set count_holder $count
	    #not a number, this means it refers to a field which holds the count
	    if [catch {expr [set count $data($count_holder)]}] {
		#the reference field doen't exist, or is alpha create it and fill it
		#with the number of elements in the list
		if {$fd(DataType)==$QT_CHAR} {
		    set data($count_holder) [string length $data($field)]
		} else {
		    set data($count_holder) [llength $data($field)]
		}
		
	    }
	}
    }


    set start_offset $offset
    set blockSize 0
    set write_data {}
    #go through list of fields in the type definition
    foreach field $typedef_fieldNames {

	
	#get fieldDef info
	unset fd
	#get the fieldef
	set fielddef $typedef($field)


	#make sure we have a numerical value
	if [catch {expr $fielddef} result] {
	    #it wasn't a number
	    if {[llength $fielddef] == 1} {
		#it's only one word, it must be the name of a field
		#containing the actuall fielddef
		set fielddef $data($fielddef)
	    }
	}


	array set fd [QS_FieldDefGet $fielddef [array get data]]


	set count $fd(Count)
	set dataType $fd(DataType)

	#go through and fill in missing count field if its missing	
	#test to see if count is a number
	if [catch {expr $count} result] {
	    set count_holder $count
	    #not a number, this means it refers to a field which holds the count
	    if [catch {expr [set count $data($count_holder)]}] {
		#the reference field doen't exist, or is alpha create it and fill it
		#with the number of elements in the list
		if {$fd(DataType)==$QT_CHAR} {
		    set data($count_holder) [string length $data($field)]
		} else {
		    set data($count_holder) [llength $data($field)]
		}
		set fd(Count) $data($count_holder)
		set count $data($count_holder)
	    }
	}


	if [catch {set data_item $data($field)} result] {
	    #data not supplied
	    set data_item {};#just make a blank
	    if [info exists fd(Term)] {
		#just term
		lappend data($field) $fd(Term)
		set data_item $data($field)
	    }
	}


	#if count is negative, set it to length of input list
	if {$count < 0} {
	    set count [llength $data($field)]
	}

	#check for list terminator
	if [catch {set term $fd(Term)} result] {
	    #unset it if it doesn't exist
	    if [info exists term] {
		unset term
	    }
	}

	#check to see if it's a complex user defined data type
	if {[llength $dataType] > 1} {
	    
	    #field is complex, i.e. fielddef is a typedef

	    #find the list terminator, if there is one
	    if [info exists term] {
		set count [expr [lsearch -exact $data_item $term] +1]
		if {$count == 0} {
		    #term not found, append it to end of list
		    lappend data_item $term
		    set count [llength $data_item]
		}
	    }

	    #if there is only one item be sure that if it has multiple fields it is enclosed in brackets

	    #not sure if this is correct
	   # if {$count==1 && [llength [lindex $data_item 1] ] ==1} {
	#	set data_item [list $data($field)]
	#	puts "enclosing list"
	#    }
	
	    if {$count==1 && [expr [llength $data_item] > 1]} {
		#wrap the itme
		set data_item [list $data_item]
	    }
	    

	    for {set j 0} {$j < $count} {incr j} {
		
		array set newmsg [QS_MsgRefPack -MsgRef $msgref -Offset $offset \
				      -TypeDef $dataType \
				      -Data [lindex $data_item $j] -Prep]
		set msgref $newmsg(MsgRef)
		set offset $newmsg(Offset)
		incr blockSize $newmsg(Size)
		set write_data [concat $write_data $newmsg(Data)]
	    }

	} else {
	    
	    #not complex type
	    
	    #start prep

	    #find a term if necessary
	    if [info exists term] {
		#term set, find it in the list
		if {$dataType==$QT_CHAR} {
		    set count [expr [string first $term $data_item] +1]

		    if {$count == 0} {
			#no term, add it
			set data_item ${data_item}$term
			set data($field) $data_item
			set count [string length $data_item]
			
		    }

		} else {
		    set count [expr [lsearch -exact $data_item $term] +1]
		    if {$count == 0} {
			#no term, add it
			lappend data_item $term
			lappend data($field) $term
			set count [llength $data_item]		    
		    }
		}
       
	    }
	    
	    
	    #prep the data
	    
	    if {$dataType==$QT_CHAR} {
		#strings of chars must be seperated
		for {set j 0} {[expr $j < $count]} {incr j} {
		    lappend write_data $dataType [string index $data_item $j]
		}
	    } else {
		for {set j 0} {[expr $j < $count]} {incr j} {
		    lappend write_data $dataType [lindex $data_item $j]
		}
	    }


	    set size $sizes($dataType)
	    incr offset [expr $size * $count]
	    incr blockSize [expr $size * $count]


	    #endof prep
         

	};#not complex

    };#foreach field

    if {$prep == 1} {
	return [list MsgRef $msgref StartOffset $start_offset \
		    Size $blockSize Data $write_data Offset $offset]
    }

    if {$write_data != {}} {
	#write any buffered data
	array set retval [QS_MsgRefWrite $msgref $start_offset $blockSize $write_data]
	set msgref $retval(MsgRef)
	set offset $retval(Offset)
    }
    return [list MsgRef $msgref Offset $offset]
};#endof QS_MsgRefPack



proc QS_WriteRawToMsg {retlist buffered_fieldNames dataName string_fields field_counterName} {
    upvar $dataName data
    upvar $field_counterName field_counter


    set index 0
    
    foreach fitem $buffered_fieldNames {
	
	if ![info exists data($fitem)] {
	    if {[lsearch -exact $string_fields $fitem]!=-1} {
		#string handle with care
		set str [lrange $retlist $index [expr $index + $field_counter($fitem) -1]]
		set string ""
		foreach char $str {
		    if {$char == ""} {
			#terminate on null
			break
		    }
		    set string ${string}$char
		}
		set data($fitem) $string
	    } else {
		#not a string just append
		set data($fitem) [lrange $retlist $index [expr $index + $field_counter($fitem) -1]]
	    }
	}
	incr index $field_counter($fitem)
    }
    return
};#endof QS_WriteRawToMsg


#QS_MsgRefUnpack - Converts binary DM3 message into tcl string data
#***Inputs***
#MsgRef - msg to unpack
#-TypeDef - the type definition to use to unpack the data
#[-Offset] - offset to start at defaults to 0
#***Switches***
#[-Swallow] - free the msg after unpacking
#***Outputs***
#Offset - next position in msg
#Data - the unpacked data
#***Exceptions***
#Invalid_MsgRef - is thrown if MsgRef is not valid
#UnsupportedDataType - speficied datatype not supported
#MsgAccessOutOfBounds - request out of msg block

proc QS_MsgRefUnpack {msgref args} {
    array set check [CheckParms -Proc "QS_MsgRefUnpack MsgRef" -Provided $args \
			 -Required {-TypeDef} \
			 -Optional {-Offset} -Switches {-Swallow}]
    
    array set parms $check(Flags)
    #handle required arguments
    array set typedef $parms(-TypeDef)

    #handle optional arguments
    if [catch {set offset $parms(-Offset)} result] {
	set offset 0
    }

    #search for switches
    #check to see if we should free the message
    if {[lsearch -exact $check(Switches) "-Swallow"]!=-1} {
	set swallow 1
    }

    set typedef_fieldNames {}
    #build a list which contains all fieldnames on current typedef level
    for {set i 0} {$i < [llength $parms(-TypeDef)]} {incr i 2} {
	lappend typedef_fieldNames [lindex $parms(-TypeDef) $i]
    }


    #initialize data
    array set data {}
    set fd {}


    global QS_GlobalValues QT_CHAR QT_UINT8
    array set sizes $QS_GlobalValues(QT_Sizes)


    set read_list {}
    set start_offset $offset
    set buffered_fieldNames {}
    array set head [QS_MsgRefGetHead $msgref]
    set string_fields {}

    #go through list of fields in the type definition
    foreach field $typedef_fieldNames {
	
	#get fieldDef info
	unset fd

	#get the fieldef
	set fielddef $typedef($field)


	#make sure we have a numerical value or fielddef string
	if [catch {expr $fielddef} result] {
	    #it wasn't a number, check for string fielddef, or fielddef reference
	    if {[llength $fielddef] == 1} {
		#it's only one word, it must be the name of a field
		#containing the actuall fielddef, copy actual value

		if ![info exists data($fielddef)] {
		    #not read in yet, read it now

		    set retlist [QS_MsgRefRead $msgref $start_offset $read_list]

		    #write this data into data array
		    QS_WriteRawToMsg $retlist $buffered_fieldNames data $string_fields field_counter
		    set start_offset $offset
		    set read_list {}
		    set buffered_fieldNames {}
		}


		set fielddef $data($fielddef)
	    } elseif {[lsearch -exact $fielddef "-Switch"] != -1} {
		#conditoinal fielddef
		array set fd $fielddef
		set key $fd(-Switch)
		unset fd
		#make sure we have already loaded the key
		if ![info exists data($key)] {
		    #not read in yet, read it now

		    set retlist [QS_MsgRefRead $msgref $start_offset $read_list]

		    #write this data into data array
		    QS_WriteRawToMsg $retlist $buffered_fieldNames data $string_fields field_counter
		    set start_offset $offset
		    set read_list {}
		    set buffered_fieldNames {}
		}		

	    }
	}

	#read the fielddef
	array set fd [QS_FieldDefGet $fielddef [array get data]]
	set typedef($field) [array get fd]
    
	set dataType $fd(DataType)

	set count $fd(Count)


	if [catch {expr $count} result] {
	    set isList 1
	} else {
	    if {[expr $count == 1]} {
		set isList 0
	    } else {
		set isList 1
	    }
	}

	#test to see if count is a number
	if [catch {expr $count} result] {
	    #not a number, this means it refers to a field which holds the count
	   

	    if ![info exists data($count)] {
		#not read in yet, read it now
		
		set retlist [QS_MsgRefRead $msgref $start_offset $read_list]

		#write this data into data array
		QS_WriteRawToMsg $retlist $buffered_fieldNames data $string_fields field_counter
		set start_offset $offset
		set read_list {}
		set buffered_fieldNames {}


	    }
	    
	    set count $data($count)
	    
	}

	#check for list terminator
	if ![catch {set term $fd(Term)} result] {
	    #the term parm is set, we must watch for it
	    set isList 1
	} else {
	    #not using terminator, unset it
	    if [info exists term] {
		unset term
	    }
	}

	#if count is negative, set it end of msg
	if {$count < 0} {
	    #handeled later
	}

	if {$count == 0} {
	    set data($field) {}
	    continue
	}
	#clear the newdata list
	set newdata {}
	
	#check to see if it's a complex user defined data type
	if {[llength $dataType] > 1} {
	    #field is complex, i.e. fielddef datatype is a typedef

		
	    for {set j 0} {$j != $count || [info exists term]} {incr j} {
		set pre_offset $offset
		if [catch {array set newmsg [QS_MsgRefUnpack $msgref \
						 -Offset $offset \
						 -TypeDef $dataType]} result] {
		    if {$count < 0} {
			#ok, we were reading till the end
			break;
		    } else {
			#rethrow error
			error $result
		    }

		}
		set offset $newmsg(Offset)

		lappend newdata $newmsg(Data)
		
		#check to see if this is the terminator
		if {[info exists term] && [QS_termCompare $term $newmsg(Data)] } {
		    incr j
		    break
		}
		


	    }
	    
	    if {$isList == 0} {
		#just one item in list, downgrade to single element like tcl does
		set newdata [lindex $newdata 0]
	    }

	    set data($field) $newdata

	    #pad read list
	    lappend buffered_fieldNames $field
	    set field_counter($field) [expr $offset - $pre_offset]
	    for {set i 0} {[expr $i < $field_counter($field)]} {incr i} {
		lappend read_list $QT_UINT8
	    }

	} else {
	    #not complex type


	    if [catch {set size $sizes($dataType)} result] {
		QS_Error -Error UnsupportedDataType -Data [list DataType $dataType]
	    }


	    if {[info exists term]} {
		#do a regular read, the read is only done to figure out length, data is not used

		array set retval [QS_MsgRefVarFieldGet $msgref -DataType $dataType -Offset $offset -Term $term]

		set count $retval(Count)
		
	    }

	    if {$count < 1} {
		#set the count to length of msg/size


		set count [expr ($head(Size) - $offset) / $size ]		

	    }

	    if [expr $count == 0] {
		#count is zero, set it to empty list
		set data($field) {}
	    }

	    #increment offset
	    incr offset [expr $size * $count]

	    #add on to read list to be used later
	    for {set i 0} {[expr $i < $count]} {incr i} {
		lappend read_list $dataType
	    }
	   
	    if {$dataType == $QT_CHAR} {
		lappend string_fields $field
	    }
 
	    set field_counter($field) $count
	    lappend buffered_fieldNames $field
	    	    
	
	};#not complex
	

    };#foreach field

    #read in any fields which haven't been read yet
    if {$read_list != {}} {
	set retlist [QS_MsgRefRead $msgref $start_offset $read_list]
    } else {
	set retlist {}
    }

    #write this data into data array
    QS_WriteRawToMsg $retlist $buffered_fieldNames data $string_fields field_counter
    set start_offset $offset
    set read_list {}
    set buffered_fieldNames {}




    #check to see if we should free the msg
    if [info exists swallow] {
	QS_PRIM_MsgFree $msgref
    }

    #remove terminators
    if [info exists fd] {
	unset fd
    }
    foreach field $typedef_fieldNames {
	if {[llength $typedef($field)] != 1} {
	    array set fd $typedef($field)
	    if {[info exists fd(-Term)] || [info exists fd(Term)]} {
		#term exists, remove last element
		if {$fd(DataType) == $QT_CHAR} {
		    set data($field) [string range $data($field) 0 [expr [string length $data($field)] -1]]
		} else {
		    set data($field) [lrange $data($field) 0 \
				      [expr [llength $data($field)] -2]]
		}
		
	    }
	    unset fd
	}
    }


    return [list Data [array get data] Offset $offset]
};#endof QS_MsgRefUnpack


