# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists ResourceMgr] {
    return
}

#this line helps the auto loader find this class
proc ResourceMgr {} {}

catch {AddressableClass new -Name ResourceMgr -init {-Extends Addressable}}



ResourceMgr set typeDefRegistry ResourceMgr_TypeDefs

#ResourceMgr_init - init a new ResourceMgr object
#***Inputs***
#-BoardNum - board on which to manage resources
#[-MsgQueue] -msg queue to use
#***Outputs***
#***Exceptions***
ResourceMgr method init {args} {

    array set check [CheckParms -Proc ResourceMgr_init -Provided $args \
			 -Required {-BoardNum} -Optional {-MsgQueue}]

    array set parms $check(Flags)
    
    set boardNum $parms(-BoardNum)

    global QCOMP_I_RESOURCEMGR
    set tgtDesc [list \
		     Node 0 \
		     Board $boardNum \
		     Processor 1 \
		     Component 0 \
		     Instance $QCOMP_I_RESOURCEMGR]
    

    #remove unwanted flags
    unset parms(-BoardNum)

    #call parent constructor
    eval $this super init -TgtDesc [list $tgtDesc] [array get parms]
};#enof ResourceMgr_init



#ResourceMgr_find - find a Component or instance by its attributes
#***Inputs***
#ResourceMgr - ResourceMgr containing Component
#[-Class] - class to create for found components, defaults to StdResource
#[-CompType] - Component type to search for, unneded if CompClass specified
#[-Processor] - processor to search on, defaults to nil
#[-InstNo] - instance number to search for, defaults to nil
#[-Attrs] - attribute list {{-key # -value #}...}
#***Outputs***
#Component
#***Exceptions***
ResourceMgr method find {args} {

    array set check [CheckParms -Proc ResourceMgr_findComp -Provided $args \
			 -Optional {-Class -CompType -Attrs -Processor -InstNo}]

    array set parms $check(Flags)

    global QCOMP_P_CP QCOMP_C_NIL QCOMP_I_NIL QCOMP_P_NIL

    #required arguments

    #optional arguments
    if [catch {set compclass $parms(-Class)} result] {
	set compclass StdResource
    }

    if [catch {set attrs $parms(-Attrs)} result] {
	set attrs {}
    }
	
    if [catch {set cpu $parms(-Processor)} result] {
	set cpu $QCOMP_P_NIL
    }

    if [catch {set instNo $parms(-InstNo)} result] {
	set instNo $QCOMP_I_NIL
    }
 

    #get attribute find info from the provided class
    set comptype [$compclass set ComponentType]
   
  

    #override comptype if given
    catch {set comptype $parms(-CompType)}


    if {$comptype} {
	#append comptype to attr search
	global Std_ComponentType
	lappend attrs [list -key $Std_ComponentType \
			   -value $comptype]
    }





    $this public TgtDesc MsgQueue
    
    array set CompStart $TgtDesc


    set CompStart(Processor) $cpu
    set CompStart(Component) $QCOMP_C_NIL
    set CompStart(Instance) $instNo


    #setup typedef for request and response msgs
    global QCompFind QComponentResult

    set typedef [ResourceMgr_TypeDefs lookup -MsgType $QCompFind]
    set rettypedef [ResourceMgr_TypeDefs lookup -MsgType $QComponentResult]

			      

    #fill in request data
    set req [list \
		 CompStart [array get CompStart] \
		 count [llength $attrs] \
		 attr $attrs \
		]

    #issue the request to the ResourceManager
    array set retval [$this request \
			  -Type $QCompFind -TypeDef $typedef -Data $req \
			  -RetTypeDef $rettypedef -RetType $QComponentResult]


    
    #returned with descriptor of resource
    #create new instance for this resource
    
    set Comp [$compclass new -init [list -MsgQueue $MsgQueue -TgtDesc $retval(desc)]]
     
    return $Comp
    
};#endof ResourceMgr_find


#ResourceMgr_allocate - allocates an instance of a component
#***Inputs***
#[-InstClass] - class to create for found components, defaults to Instance
#[-CompType] - Component type to allocate, unneded if InstClass specified
#[-Processor] - processor to search in, defaults to nil
#[-InstNo] - instance number to search for, defaults to nil
#[-Attrs] - attribute list {{-key # -value #}...}
#[-Cluster] - cluster to allocate instance into
#[-Init] -  Init parameters for instance
#***Outputs***
#Instance
#***Exceptions***
ResourceMgr method allocate {args} {

    array set check [CheckParms -Proc ResourceMgr_allocate -Provided $args \
			 -Optional {-InstClass -CompType -Processor -InstNo -Attrs -Cluster -Init}]

    array set parms $check(Flags)
    set comptype 0

    global QCOMP_P_NIL QCOMP_C_NIL QCOMP_I_NIL QS_Nil_CompDesc
    
    #optional arguments
    if [catch {set clust $parms(-Cluster)} result] {
	set clustDesc $QS_Nil_CompDesc
    } else {
	set clustDesc [$clust set TgtDesc]
    }

    if [catch {set cpu $parms(-Processor)} result] {
	set cpu $QCOMP_P_NIL
    }

    if [catch {set instclass $parms(-InstClass)} result] {
	set instclass Instance
    }

    if [catch {set instNo $parms(-InstNo)} result] {
	set instNo $QCOMP_I_NIL
    }

    if [catch {set attrs $parms(-Attrs)} result] {
	set attrs {}
    }
	
    #get comptype from the provided class
    set comptype [$instclass set ComponentType]

    #override comptype if given
    catch {set comptype $parms(-CompType)}


    if {$comptype} {
	#append comptype to attr search
	global Std_ComponentType
	lappend attrs [list -key $Std_ComponentType \
			   -value $comptype]
    }

    $this public TgtDesc MsgQueue
    
    array set CompStart $TgtDesc


    set CompStart(Processor) $cpu
    set CompStart(Component) $QCOMP_C_NIL
    set CompStart(Instance) $instNo


    #setup typedef for request and response msgs
    global QCompInstAllocate QComponentResult

    set typedef [ResourceMgr_TypeDefs lookup -MsgType $QCompInstAllocate]
    set rettypedef [ResourceMgr_TypeDefs lookup -MsgType $QComponentResult]

			      

    #fill in request data
    set req [list \
		 CompStart [array get CompStart] \
		 ClustDesc $clustDesc \
		 count [llength $attrs] \
		 attr $attrs \
		]

    #issue the request to the ResourceManager
    global QCompInstAllocate
    array set retval [$this request \
			  -Type $QCompInstAllocate -TypeDef $typedef \
			  -Data $req -RetTypeDef $rettypedef -RetType $QComponentResult]

    
    # Check for instance initialization options to use for allocate
    # or for inst new method
    if {![info exists parms(-Init)]} {
	# No parms - set an empty list for "new" method
	set parms(-Init) {}
    }

    #returned with descriptor of Component
    #create new instance for this Component
    set inst [$instclass new \
	-init [concat [list -MsgQueue $MsgQueue -TgtDesc $retval(desc)] $parms(-Init)]]

    #since we allocate we free when we destroy
    $inst set freeOnDestroy 1
     
    return $inst
    
};#endof ResourceMgr_allocate




#ResourceMgr_free - frees an instance of a component
#***Inputs***
#-Instance - the instance object to be freed
#***Outputs***
#***Exceptions***
ResourceMgr method free {args} {

    array set check [CheckParms -Proc ResourceMgr_free -Provided $args \
			 -Optional {-Instance}]

    array set parms $check(Flags)
    
    set inst $parms(-Instance)

    set compDesc [$inst set TgtDesc]

    #setup typedef for request and response msgs
    global QCompInstFree QResultComplete

    set typedef [ResourceMgr_TypeDefs lookup -MsgType $QCompInstFree]

 		      

    #fill in request data
    set req [list \
		 desc $compDesc
		]

    #issue the request to the ResourceManager
    array set retval [$this request \
			  -Type $QCompInstFree -TypeDef $typedef \
			  -Data $req -RetType $QResultComplete]

    

    return
    
};#endof ResourceMgr_free




#ResourceMgr_use - marks a resource as used
#***Inputs***
#-StdResource - Resource to mark as used
#[-Payload] - payload data to send with the use
#***Outputs***
#***Exceptions***
ResourceMgr method use {args} {
    array set check [CheckParms -Proc ResourceMgr_findComp -Provided $args \
			 -Required {-StdResource} -Optional {-Payload}]

    array set parms $check(Flags)

    #required arguments
    set std $parms(-StdResource)
    set desc [$std set TgtDesc]

    #optional arguments
    if [catch {set payload $parms(-Payload)} result] {
	set payload {}
    }
    

    #setup typedef for request and response msgs
    global QCompUse QResultComplete

    set typedef [ResourceMgr_TypeDefs lookup -MsgType $QCompUse]
			      

    #fill in request data

    set use_list [list \
		      [list desc $desc Payload $payload] \
		      ]

    set req [list \
		 Count 1 \
		 List $use_list
		]



    #!!!!!!!!!!!!!Warning!!!!!!!!!!!!!!!!!
    #If this method is changed to accept MULTIPLE instances to be used
    #there will need to be a change in the C code, a driver function call
    #is made when this message is sent, it reflects the board refered to
    #in the CompDesc(s), only the first board number is used, if later ones
    #differ they won't be used and therefore exit notification won't work on
    #those instances
    #!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


    #issue the request to the ResourceManager
    array set retval [$this request \
			  -Type $QCompUse -TypeDef $typedef -Data $req \
			  -RetType $QResultComplete]


    return
    
};#endof ResourceMgr_use




#ResourceMgr_unuse - marks a resource as used
#***Inputs***
#-Desc - Descriptor to mark as used
#***Outputs***
#***Exceptions***
ResourceMgr method unuse {args} {
    array set check [CheckParms -Proc ResourceMgr_findComp -Provided $args \
			 -Required {-Desc}]

    array set parms $check(Flags)

    #required arguments
    set desc $parms(-Desc)
        

    #setup typedef for request and response msgs
    global QCompUnuse QResultComplete

    set typedef [ResourceMgr_TypeDefs lookup -MsgType $QCompUnuse]		      

    #fill in request data

    set use_list [list \
		      [list desc $desc] \
		      ]

    set req [list \
		 Count 1 \
		 List $use_list
		]

    #issue the request to the ResourceManager

    array set retval [$this request \
			  -Type $QCompUnuse -TypeDef $typedef -Data $req \
			  -RetType $QResultComplete]


    return
    
};#endof ResourceMgr_unuse



#***ResourceMgr_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an ResourceMgr object, it also recognizes all types specified in Addressable_TypeDefs


TypeDefRegistry new -Name ResourceMgr_TypeDefs \
    -init [list -Extends [[ResourceMgr set Extends] set typeDefRegistry]]


ResourceMgr_TypeDefs define -MsgType QCompFind \
    -TypeDef [list \
		  CompStart $QS_CompDesc \
		  count $QCompFind_count \
		  attr [list -DataType $QCompAttr -Count count] \
		 ]

ResourceMgr_TypeDefs define -MsgType QResultComplete \
    -TypeDef {}

ResourceMgr_TypeDefs define -MsgType QComponentResult \
    -TypeDef [list desc $QS_CompDesc]


ResourceMgr_TypeDefs define -MsgType QCompInstAllocate \
    -TypeDef [list \
		  CompStart $QS_CompDesc \
		  ClustDesc $QS_CompDesc \
		  count $QCompInstAllocate_count \
		  attr [list -DataType $QCompAttr -Count count] \
		 ]


ResourceMgr_TypeDefs define -MsgType QCompInstFree \
    -TypeDef [list \
		  desc $QS_CompDesc \
		 ]	


ResourceMgr_TypeDefs define -MsgType QCompUse \
    -TypeDef [list \
		  Count $QCompUse_count \
		  List [list -Count Count -DataType [list \
							 desc $QS_CompDesc \
							 Payload $QCompUse_useType \
							] \
			    ] \
		 ]

ResourceMgr_TypeDefs define -MsgType QCompUnuse \
    -TypeDef [list \
		  Count $QCompUse_count \
		  List [list -Count Count -DataType [list \
							 desc $QS_CompDesc \
							] \
			    ] \
		 ]


ResourceMgr_TypeDefs define -MsgType QCompFindAll \
    -TypeDef [list \
		  startDesc $QS_CompDesc \
		  endDesc $QS_CompDesc \
		  count $QCompFindAll_count \
		  attr [list -DataType $QCompAttr -Count count] \
		 ]


ResourceMgr_TypeDefs define -MsgType QCompMultipleResult \
 	   -TypeDef [list \
				count $QCompMultipleResult_count		\
				nextComponent $QS_CompDesc			\
				comps [list -Count -1 -DataType [list \
					compDesc [list -DataType $QCompDesc]	\
					attrs [list -DataType $QCompAttr -Term [list key $QATTR_NULL]]]]]

ResourceMgr_TypeDefs define -MsgType QCompAttrInfo \
    -TypeDef [list \
		  theInstance $QS_CompDesc \
		  count $QCompAttrInfo_count \
		  attroffset $QCompAttrInfo_attroffset]

ResourceMgr_TypeDefs define -MsgType QCompAttrInfoResult \
 	   -TypeDef [list \
				theComponent $QS_CompDesc			\
				count $QCompAttrInfoResult_count		\
				attrs [list -Count count -DataType $QCompAttr]]


#autogen methods

ResourceMgr defineMsgMethod -MethodName FindAllComponents \
    -Type $QCompFindAll -TypeDef lookup \
    -RetType $QCompMultipleResult -RetTypeDef lookup

ResourceMgr defineMsgMethod -MethodName AttrInfo \
    -Type $QCompAttrInfo -TypeDef lookup \
    -RetType $QCompAttrInfoResult -RetTypeDef lookup


#ResourceMgr_DescIsValid - validate an address (comp or inst)
#***Inputs***
#ResourceMgr - ResourceMgr containing Component
#[-Desc] - Descriptor to check
#***Outputs***
#Component
#***Exceptions***
ResourceMgr method DescIsValid {args} {

	array set check [CheckParms -Proc ResourceMgr_findComp -Provided $args \
		-Required {-Desc}]

	array set parms $check(Flags)

	#setup typedef for request and response msgs
	global QCompFind QComponentResult

	set typedef [ResourceMgr_TypeDefs lookup -MsgType $QCompFind]
	set rettypedef [ResourceMgr_TypeDefs lookup -MsgType $QComponentResult]

	#fill in QCompFind data
	set req [list \
		CompStart $parms(-Desc) \
		count 0 \
		attr {} \
	]

	#issue the request to the ResourceManager
	if [ catch { array set retval [$this request \
				-Type $QCompFind -TypeDef $typedef -Data $req \
				-RetTypeDef $rettypedef -RetType $QComponentResult]} result] {
		# The address is invalid
		return 0
	} else {
		# address is valid
		return 1
	}
    
};#endof ResourceMgr_DescIsValid



